/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.widget.AbsListView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.target.BaseTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Util;
import java.util.List;
import java.util.Queue;

public class ListPreloader<T>
implements AbsListView.OnScrollListener {
    private final int maxPreload;
    private final PreloadTargetQueue preloadTargetQueue;
    private final RequestManager requestManager;
    private final PreloadModelProvider<T> preloadModelProvider;
    private final PreloadSizeProvider<T> preloadDimensionProvider;
    private int lastEnd;
    private int lastStart;
    private int lastFirstVisible = -1;
    private int totalItemCount;
    private boolean isIncreasing = true;

    public ListPreloader(@NonNull RequestManager requestManager, @NonNull PreloadModelProvider<T> preloadModelProvider, @NonNull PreloadSizeProvider<T> preloadDimensionProvider, int maxPreload) {
        this.requestManager = requestManager;
        this.preloadModelProvider = preloadModelProvider;
        this.preloadDimensionProvider = preloadDimensionProvider;
        this.maxPreload = maxPreload;
        this.preloadTargetQueue = new PreloadTargetQueue(maxPreload + 1);
    }

    public void onScrollStateChanged(AbsListView absListView, int scrollState) {
    }

    public void onScroll(AbsListView absListView, int firstVisible, int visibleCount, int totalCount) {
        this.totalItemCount = totalCount;
        if (firstVisible > this.lastFirstVisible) {
            this.preload(firstVisible + visibleCount, true);
        } else if (firstVisible < this.lastFirstVisible) {
            this.preload(firstVisible, false);
        }
        this.lastFirstVisible = firstVisible;
    }

    private void preload(int start, boolean increasing) {
        if (this.isIncreasing != increasing) {
            this.isIncreasing = increasing;
            this.cancelAll();
        }
        this.preload(start, start + (increasing ? this.maxPreload : -this.maxPreload));
    }

    private void preload(int from, int to) {
        int end;
        int start;
        if (from < to) {
            start = Math.max(this.lastEnd, from);
            end = to;
        } else {
            start = to;
            end = Math.min(this.lastStart, from);
        }
        end = Math.min(this.totalItemCount, end);
        start = Math.min(this.totalItemCount, Math.max(0, start));
        if (from < to) {
            for (int i = start; i < end; ++i) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(i), i, true);
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(i), i, false);
            }
        }
        this.lastStart = start;
        this.lastEnd = end;
    }

    private void preloadAdapterPosition(List<T> items, int position, boolean isIncreasing) {
        int numItems = items.size();
        if (isIncreasing) {
            for (int i = 0; i < numItems; ++i) {
                this.preloadItem(items.get(i), position, i);
            }
        } else {
            for (int i = numItems - 1; i >= 0; --i) {
                this.preloadItem(items.get(i), position, i);
            }
        }
    }

    private void preloadItem(@Nullable T item, int position, int perItemPosition) {
        if (item == null) {
            return;
        }
        int[] dimensions = this.preloadDimensionProvider.getPreloadSize(item, position, perItemPosition);
        if (dimensions == null) {
            return;
        }
        RequestBuilder<?> preloadRequestBuilder = this.preloadModelProvider.getPreloadRequestBuilder(item);
        if (preloadRequestBuilder == null) {
            return;
        }
        preloadRequestBuilder.into(this.preloadTargetQueue.next(dimensions[0], dimensions[1]));
    }

    private void cancelAll() {
        for (int i = 0; i < this.maxPreload; ++i) {
            this.requestManager.clear(this.preloadTargetQueue.next(0, 0));
        }
    }

    private static final class PreloadTarget
    extends BaseTarget<Object> {
        int photoHeight;
        int photoWidth;

        PreloadTarget() {
        }

        @Override
        public void onResourceReady(@NonNull Object resource, @Nullable Transition<? super Object> transition) {
        }

        @Override
        public void getSize(@NonNull SizeReadyCallback cb) {
            cb.onSizeReady(this.photoWidth, this.photoHeight);
        }

        @Override
        public void removeCallback(@NonNull SizeReadyCallback cb) {
        }
    }

    private static final class PreloadTargetQueue {
        private final Queue<PreloadTarget> queue;

        PreloadTargetQueue(int size) {
            this.queue = Util.createQueue(size);
            for (int i = 0; i < size; ++i) {
                this.queue.offer(new PreloadTarget());
            }
        }

        public PreloadTarget next(int width, int height) {
            PreloadTarget result = this.queue.poll();
            this.queue.offer(result);
            result.photoWidth = width;
            result.photoHeight = height;
            return result;
        }
    }

    public static interface PreloadSizeProvider<T> {
        @Nullable
        public int[] getPreloadSize(@NonNull T var1, int var2, int var3);
    }

    public static interface PreloadModelProvider<U> {
        @NonNull
        public List<U> getPreloadItems(int var1);

        @Nullable
        public RequestBuilder<?> getPreloadRequestBuilder(@NonNull U var1);
    }
}

