/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import android.os.Process;
import android.util.Log;
import com.yy.mobile.http.Cache;
import com.yy.mobile.http.HttpLog;
import com.yy.mobile.http.Request;
import com.yy.mobile.http.RequestProcessor;
import com.yy.mobile.http.ResponseData;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class CacheDispatcher
extends Thread {
    private final BlockingQueue<Request> mCacheQueue;
    private final BlockingQueue<Request> mNetworkQueue;
    private volatile boolean mQuit = false;
    private RequestProcessor mRequestProcessor;

    public CacheDispatcher(BlockingQueue<Request> cacheQueue, BlockingQueue<Request> networkQueue, String name, RequestProcessor requestProcessor) {
        super(name + "CacheThread");
        this.mCacheQueue = cacheQueue;
        this.mNetworkQueue = networkQueue;
        this.mRequestProcessor = requestProcessor;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            try {
                while (true) {
                    final Request request = this.mCacheQueue.take();
                    this.waitIfPaused();
                    if (request.isCanceled()) {
                        request.postCancel("Cache discard canceled");
                        continue;
                    }
                    Cache.Entry entry = request.getCache().get(request.getKey());
                    if (entry == null) {
                        HttpLog.v("Cache miss", new Object[0]);
                        this.mNetworkQueue.put(request);
                        continue;
                    }
                    if (entry.isExpired()) {
                        HttpLog.v("Cache expired", new Object[0]);
                        request.setCacheEntry(entry);
                        this.mNetworkQueue.put(request);
                        continue;
                    }
                    HttpLog.v("Cache hit", new Object[0]);
                    request.parseDataToResponse(new ResponseData(entry.data, entry.responseHeaders, request.getHost()));
                    HttpLog.v("Cache parsed", new Object[0]);
                    if (!entry.refreshNeeded()) {
                        request.postResponse();
                        continue;
                    }
                    HttpLog.v("Cache refresh needed", new Object[0]);
                    request.setCacheEntry(entry);
                    request.getResponse().intermediate = true;
                    request.postResponse(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CacheDispatcher.this.mNetworkQueue.put(request);
                            }
                            catch (InterruptedException e) {
                                Log.e((String)"CacheDispatcher", (String)"Empty Catch on run", (Throwable)e);
                            }
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            catch (Exception ee) {
                HttpLog.e(ee, "Uncatch error.", new Object[0]);
                continue;
            }
            catch (Error e) {
                HttpLog.e(e, "Unhandled error " + e.toString(), new Object[0]);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfPaused() {
        AtomicBoolean pause;
        AtomicBoolean atomicBoolean = pause = this.mRequestProcessor.getPause();
        synchronized (atomicBoolean) {
            if (pause.get()) {
                HttpLog.v("Cache Wait for pause", new Object[0]);
                try {
                    pause.wait();
                }
                catch (InterruptedException e) {
                    HttpLog.e(e, "Cache Wait for pause interrupted", new Object[0]);
                    return;
                }
                HttpLog.v("Cache Resume pause", new Object[0]);
            }
        }
    }
}

