/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper;

import android.os.Bundle;
import android.os.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.mobile.backgroundprocess.Util.AssertUtil;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.MessageDef;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.IDownloadActionHandler;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.ITaskProgressListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.ITaskStateChangeListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.MessageDispater;

public class DownloadServiceWrapper
implements IDownloadActionHandler {
    private static volatile DownloadServiceWrapper sInstance;
    private MessageDispater mMessageDispater = null;

    private DownloadServiceWrapper() {
        if (null == this.mMessageDispater) {
            this.mMessageDispater = new MessageDispater(RuntimeContext.sApplicationContext);
        }
    }

    public void setMsgsSendErroredListener(MessageDispater.IMsgsSendErroredListener msgsSendErroredListener) {
        this.mMessageDispater.setMsgsSendErroredListener(msgsSendErroredListener);
    }

    public static void cleanUpOnExit() {
        AssertUtil.assertMainThread();
        if (sInstance != null) {
            sInstance.onExit();
        }
        sInstance = null;
    }

    private void onExit() {
        this.mMessageDispater.cleanUpOnExit();
        this.mMessageDispater = null;
    }

    public static DownloadServiceWrapper instance() {
        AssertUtil.assertMainThread();
        if (sInstance == null) {
            sInstance = new DownloadServiceWrapper();
        }
        return sInstance;
    }

    @Override
    public void createTask(DownloadTask task) {
        if (task == null) {
            return;
        }
        Message message = this.createBaseMessage();
        message.what = MessageDef.ClientSendMessage.CREATE_TASK;
        message.setData(task.getBundle());
        this.mMessageDispater.sendMessage(message);
    }

    @Override
    public void pauseTask(DownloadTask task) {
        if (task == null) {
            return;
        }
        Message message = this.createBaseMessage();
        message.what = MessageDef.ClientSendMessage.PAUSE_TASK;
        message.setData(task.getBundle());
        this.mMessageDispater.sendMessage(message);
    }

    @Override
    public void deleteTask(DownloadTask task, boolean deleteFile) {
        Message message = this.createBaseMessage();
        message.what = MessageDef.ClientSendMessage.DELETE_TASK;
        message.arg2 = deleteFile ? 1 : 0;
        message.setData(task.getBundle());
        this.mMessageDispater.sendMessage(message);
    }

    @Override
    public void startTask(DownloadTask task) {
        Message message = this.createBaseMessage();
        message.what = MessageDef.ClientSendMessage.START_TASK;
        message.setData(task.getBundle());
        this.mMessageDispater.sendMessage(message);
    }

    @Override
    public void registerTaskStateChangeListener(ITaskStateChangeListener listener) {
        this.mMessageDispater.registerTaskStateChangeListener(listener);
    }

    @Override
    public void registerTaskProgressListener(ITaskProgressListener listener) {
        this.mMessageDispater.registerTaskProgressListener(listener);
    }

    public void sendMessage(int what, Bundle data) {
        Message message = this.createBaseMessage();
        message.what = what;
        message.setData(data);
        this.mMessageDispater.sendMessage(message);
    }

    public void sendMessage(int to, int messageType, Bundle data) {
        Message message = Message.obtain();
        message.arg1 = to;
        message.what = messageType;
        message.setData(data);
        this.mMessageDispater.sendMessage(message);
    }

    private Message createBaseMessage() {
        Message message = Message.obtain();
        message.arg1 = 1;
        return message;
    }
}

