/*
 * Decompiled with CFR 0.152.
 */
package downloader;

import com.yy.base.utils.StringUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import downloader.DownloadClient;
import downloader.IDownloadCallback;
import java.io.File;

public final class Downloader {
    public static final int DEFAULT_GROUP = 100;
    private DownloadTask mDownloadTask;
    private IDownloadCallback mCallback;
    public boolean mIsPatch = false;
    public int downloadType = 0;
    public boolean mIsComplete = false;

    private Downloader() {
    }

    Downloader(DownloadTask task, IDownloadCallback callback) {
        this.mDownloadTask = task;
        this.mCallback = callback;
    }

    public void start() {
        DownloadClient.instance().submitTask(this);
    }

    public void delete() {
        DownloadClient.instance().removeTask(this);
    }

    public static void deleteTask(String url) {
        DownloadClient.instance().removeTask(url);
    }

    public String getUrl() {
        return this.mDownloadTask.getString("url");
    }

    public String getFilePath() {
        return new File(this.mDownloadTask.getString("path"), this.mDownloadTask.getString("filename")).getAbsolutePath();
    }

    public String getFileParentPath() {
        return this.mDownloadTask.getString("path");
    }

    public int getPriority() {
        return this.mDownloadTask.getInt("priority");
    }

    public String getEtagCheckContent() {
        return this.mDownloadTask.getString("etagcontent");
    }

    public int getTaskGroup() {
        return this.mDownloadTask.getInt("dgroup", -1);
    }

    DownloadTask getTask() {
        return this.mDownloadTask;
    }

    public IDownloadCallback getCallback() {
        return this.mCallback;
    }

    public void setCallBack(IDownloadCallback callBack) {
        this.mCallback = callBack;
    }

    public void removeCallBack() {
        this.mCallback = null;
    }

    public static class Builder {
        private IDownloadCallback mCallback;
        private DownloadTask mDownloadTask;

        private Builder() {
        }

        public Builder(String downloadUrl, File file) {
            this.init(downloadUrl, file.getParent(), file.getName());
        }

        public Builder(String downloadUrl, String fileFullPath) {
            File file = new File(fileFullPath);
            this.init(downloadUrl, file.getParent(), file.getName());
        }

        public Builder(String downloadUrl, String fileParentPath, String fileName) {
            this.init(downloadUrl, fileParentPath, fileName);
        }

        private void init(String downloadUrl, String fileParentPath, String fileName) {
            DownloadTask downloadTask = DownloadTask.newDownloadTask(downloadUrl, fileParentPath, fileName);
            if (downloadTask == null) {
                throw new IllegalStateException("params error:please check url or filePath");
            }
            this.mDownloadTask = downloadTask;
            this.fillDefaultParams();
        }

        private void fillDefaultParams() {
            this.mDownloadTask.putInt("tgabove", 0);
            this.mDownloadTask.putInt("ctrans", 0);
            this.mDownloadTask.putInt("mrtimes", 2);
            this.mDownloadTask.putLong("ctime", System.currentTimeMillis());
            this.mDownloadTask.putInt("priority", 50);
            this.mDownloadTask.putInt("dgroup", 100);
            this.mDownloadTask.putExtendString("maxconcurrency", String.valueOf(1));
        }

        public void setCallBack(IDownloadCallback callBack) {
            this.mCallback = callBack;
        }

        public void setCheckFileByEtag(String checkType) {
            this.mDownloadTask.putString("etagkey", checkType);
        }

        public void setFileEtagCheckContent(String checkType, String checkContent) {
            if (!StringUtils.isEmpty((String)checkContent)) {
                this.mDownloadTask.putString("etagkey", checkType);
                this.mDownloadTask.putExtendString("etagcontent", checkContent);
            }
        }

        public void setTaskGroup(int group) {
            this.mDownloadTask.putInt("dgroup", group);
        }

        public int getTaskGroup() {
            return this.mDownloadTask.getInt("dgroup", -1);
        }

        public void setTaskSubGroup(String subGroup) {
            this.mDownloadTask.putExtendString("subgroup", subGroup);
        }

        public void setTaskMaxConcurrency(String maxConcurrency) {
            this.mDownloadTask.putExtendString("maxconcurrency", maxConcurrency);
        }

        public void setTaskSpeedLimitPerMicsecondValue(long value) {
            this.mDownloadTask.putExtendString("speedlimit", String.valueOf(value));
        }

        public void setDownloadType(int type) {
            this.mDownloadTask.putExtendString("download_type", type + "");
        }

        public void setProgressInterval(long value) {
            this.mDownloadTask.putExtendString("progressinterval", String.valueOf(value));
        }

        public void setMaxRetryTimes(int maxRetryTimes) {
            if (maxRetryTimes >= 0) {
                this.mDownloadTask.putInt("mrtimes", maxRetryTimes);
            }
        }

        public void setUnizipFlag(boolean unzip) {
            this.mDownloadTask.putInt("unzip", unzip ? 1 : 0);
        }

        public void setOnlyAbove3GNet(boolean onlyAbove3G) {
            this.mDownloadTask.putInt("tgabove", onlyAbove3G ? 1 : 0);
        }

        public void setPriority(int priority) {
            this.mDownloadTask.putInt("priority", priority);
        }

        public void setSupportContinueTransfer(boolean flag) {
            this.mDownloadTask.putInt("ctrans", flag ? 1 : 0);
        }

        public void putExtendString(String key, String value) {
            this.mDownloadTask.putExtendString(key, value);
        }

        public void putExtendBoolean(String key, boolean value) {
            this.mDownloadTask.putExtendBoolean(key, value);
        }

        public Downloader build() {
            return new Downloader(this.mDownloadTask, this.mCallback);
        }
    }

    public static class FileCheckType {
        public static final String SHA1 = "sha1";
        public static final String MD5 = "md5";
    }
}

