/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.http;

import com.yy.mobile.http.CacheControlable;
import java.io.File;
import java.util.List;
import java.util.Map;

public interface RequestParam
extends CacheControlable {
    public static final String DEFAULT_PARAMS_ENCODING = "UTF-8";

    public Map<String, String> getUrlParams();

    public Map<String, FileWrapper> getFileParams();

    public Map<String, List<String>> getUrlParamsWithArray();

    public Map<String, FileData> getFileDataParams();

    public String getParamsEncoding();

    public void setParamsEncoding(String var1);

    public String getParamString();

    public void put(String var1, String var2);

    public void put(String var1, FileWrapper var2);

    public void put(String var1, FileData var2);

    public void put(String var1, List<String> var2);

    public void add(String var1, String var2);

    public void remove(String var1);

    public static class FileData {
        private byte[] mFileData;
        private String mContentType;
        private String mFileName;
        private String mEncoding = "UTF-8";

        public FileData(byte[] fileData, String fileName) {
            this.mFileData = fileData;
            this.mFileName = fileName;
        }

        public FileData(byte[] fileData, String fileName, String contentType) {
            this.mFileData = fileData;
            this.mContentType = contentType;
            this.mFileName = fileName;
        }

        public FileData(byte[] fileData, String fileName, String contentType, String encoding) {
            this.mFileData = fileData;
            this.mContentType = contentType;
            this.mFileName = fileName;
            this.mEncoding = encoding;
        }

        public byte[] getFileData() {
            return this.mFileData;
        }

        public String getContentType() {
            return this.mContentType;
        }

        public String getFileName() {
            if (this.mFileName != null) {
                return this.mFileName;
            }
            return "nofilename";
        }

        public String getEncoding() {
            return this.mEncoding;
        }
    }

    public static class FileWrapper {
        private File mFile;
        private String mFileName;
        private String mContentType;
        private String mEncoding = "UTF-8";

        public FileWrapper(File file, String fileName) {
            this.mFile = file;
            this.mFileName = fileName;
        }

        public FileWrapper(File file, String fileName, String contentType) {
            this(file, fileName);
            this.mContentType = contentType;
        }

        public FileWrapper(File file, String fileName, String contentType, String encoding) {
            this(file, fileName, contentType);
            this.mEncoding = encoding;
        }

        public File getFile() {
            return this.mFile;
        }

        public String getContentType() {
            return this.mContentType;
        }

        public String getFileName() {
            if (this.mFileName != null) {
                return this.mFileName;
            }
            return "nofilename";
        }

        public String getEncoding() {
            return this.mEncoding;
        }
    }
}

