/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser;

import android.os.Message;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.MessageDef;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.IDownloadCenter;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.IDownloadProcesser;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser.IDownloadMessageSender;

public class DefaultDownloadProcesser
implements IDownloadProcesser {
    private IDownloadCenter mDownloadCenter;
    private IDownloadMessageSender mMessageSender;

    public DefaultDownloadProcesser(IDownloadCenter downloadCenter, IDownloadMessageSender messageSender) {
        this.mDownloadCenter = downloadCenter;
        this.mMessageSender = messageSender;
    }

    @Override
    public boolean createTask(DownloadTask task) {
        if (this.mDownloadCenter == null) {
            return false;
        }
        int result = this.mDownloadCenter.createTask(task);
        if (result != 0) {
            Message callBackMsg = Message.obtain();
            callBackMsg.what = MessageDef.ServiceCallMessage.ON_TASK_CREATE_RESULT;
            callBackMsg.arg1 = result;
            callBackMsg.setData(task.getBundle());
            this.sendMessageToClients(callBackMsg);
        }
        return true;
    }

    @Override
    public boolean startTask(DownloadTask task) {
        if (this.mDownloadCenter == null) {
            return false;
        }
        this.mDownloadCenter.startTask(task);
        return true;
    }

    @Override
    public boolean deleteTask(DownloadTask task, boolean isDeleteFile) {
        if (this.mDownloadCenter == null) {
            return false;
        }
        this.mDownloadCenter.deleteTask(task, isDeleteFile);
        return true;
    }

    @Override
    public boolean pauseTask(DownloadTask task) {
        if (this.mDownloadCenter == null) {
            return false;
        }
        this.mDownloadCenter.pauseTask(task);
        return true;
    }

    @Override
    public boolean handleExtraMsg(Message msg) {
        return true;
    }

    @Override
    public boolean restoreAllTasks() {
        if (this.mDownloadCenter == null) {
            return false;
        }
        this.mDownloadCenter.restoreAllTasks();
        return true;
    }

    @Override
    public boolean onTaskStateUpdated(DownloadTask task, int oldState) {
        this.notifyTaskStateUpdateEvent(oldState, task);
        return true;
    }

    @Override
    public boolean onTaskDeleted(DownloadTask task) {
        Message callBackMsg = Message.obtain();
        callBackMsg.what = MessageDef.ServiceCallMessage.ON_TASK_DELETED;
        callBackMsg.setData(task.getBundle());
        this.sendMessageToClients(callBackMsg);
        return true;
    }

    @Override
    public boolean onTaskRetry(DownloadTask task) {
        return true;
    }

    @Override
    public boolean onTaskCreated(DownloadTask task) {
        Message callBackMsg = Message.obtain();
        callBackMsg.what = MessageDef.ServiceCallMessage.ON_TASK_CREATE_RESULT;
        callBackMsg.arg1 = 0;
        callBackMsg.setData(task.getBundle());
        this.sendMessageToClients(callBackMsg);
        return true;
    }

    @Override
    public boolean onTaskProgressUpdated(DownloadTask task, long oldSize) {
        if (this.mMessageSender != null) {
            Message callBackMsg = Message.obtain();
            callBackMsg.what = MessageDef.ServiceCallMessage.ON_TASK_PROGRESS_UPDATED;
            callBackMsg.setData(task.getBundle());
            this.mMessageSender.sendMessageToClients(callBackMsg);
        }
        return true;
    }

    private void notifyTaskStateUpdateEvent(int oldState, DownloadTask task) {
        if (task == null) {
            return;
        }
        int newState = task.getInt("state", 1);
        if (newState == 5) {
            this.deleteTask(task, false);
        } else if (newState == 4) {
            this.deleteTask(task, true);
        }
        if (newState == oldState) {
            return;
        }
        if (this.mMessageSender == null) {
            return;
        }
        Message callBackMsg = Message.obtain();
        callBackMsg.what = MessageDef.ServiceCallMessage.ON_TASK_STATE_UPDATED;
        callBackMsg.arg1 = oldState;
        callBackMsg.setData(task.getBundle());
        this.mMessageSender.sendMessageToClients(callBackMsg);
    }

    private void sendMessageToClients(Message callBackMsg) {
        if (this.mMessageSender == null) {
            return;
        }
        this.mMessageSender.sendMessageToClients(callBackMsg);
    }
}

