/*
 * Decompiled with CFR 0.152.
 */
package downloader.client;

import android.os.Message;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.IDownloadProcesser;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.DownloadRequestManager;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadprocesser.plugin.DifferenceCombinationPlugin;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.RequestError;
import downloader.client.IBasicParamsProvider;
import downloader.client.IDownloadClientCallBack;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;

public class LocalDownloadClient {
    private static final boolean ENABLE_LOG = RuntimeContext.sIsDebuggable;
    private static final String TAG = "LocalDownloadClient";
    private DownloadRequestManager mRequestManager;
    private IDownloadClientCallBack mCallBack;
    private final LinkedList<IDownloadProcesser> mProcesserList = new LinkedList();
    private IDownloadProcesser defaultProcesser;

    public LocalDownloadClient() {
        this.createDownloadProcessers();
        for (IDownloadProcesser listener : this.mProcesserList) {
            if (!listener.restoreAllTasks()) continue;
            return;
        }
    }

    private void createDownloadProcessers() {
        IDownloadProcesser processer = this.getDefaultProcesser();
        this.mProcesserList.add(new DifferenceCombinationPlugin(null, null, processer));
        this.mProcesserList.add(processer);
    }

    private DownloadRequestManager getRequestManager() {
        if (this.mRequestManager != null) {
            return this.mRequestManager;
        }
        DownloadRequestManager.IDownloadListener requestManagerCallBack = new DownloadRequestManager.IDownloadListener(){

            @Override
            public void onProgress(DownloadTask task, ProgressInfo info) {
                IDownloadProcesser listener;
                if (task == null) {
                    return;
                }
                long totalSize = info.getTotal();
                long curSize = info.getProgress();
                long oldSize = task.getLong("cursize");
                task.putLong("size", totalSize);
                task.putLong("cursize", curSize);
                Iterator iterator = LocalDownloadClient.this.mProcesserList.iterator();
                while (iterator.hasNext() && !(listener = (IDownloadProcesser)iterator.next()).onTaskProgressUpdated(task, oldSize)) {
                }
            }

            @Override
            public void onError(final DownloadTask task, final Exception error) {
                if (task == null) {
                    return;
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LocalDownloadClient.this.deleteFile(task.getString("path"), task.getString("filename"));
                    }
                }, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IDownloadProcesser listener;
                        task.putInt("state", 4);
                        if (error instanceof RequestError) {
                            RequestError requestError = (RequestError)error;
                            task.putInt("httpcode", requestError.httpCode());
                            task.putInt("errno", requestError.code());
                        }
                        int oldState = task.getInt("state");
                        task.putInt("state", 4);
                        task.putString("errorinfo", error != null ? error.toString() : "");
                        Iterator iterator = LocalDownloadClient.this.mProcesserList.iterator();
                        while (iterator.hasNext() && !(listener = (IDownloadProcesser)iterator.next()).onTaskStateUpdated(task, oldState)) {
                        }
                    }
                });
            }

            @Override
            public void onSuccess(DownloadTask task) {
                IDownloadProcesser listener;
                if (task == null) {
                    return;
                }
                int oldState = task.getInt("state");
                task.putInt("state", 5);
                Iterator iterator = LocalDownloadClient.this.mProcesserList.iterator();
                while (iterator.hasNext() && !(listener = (IDownloadProcesser)iterator.next()).onTaskStateUpdated(task, oldState)) {
                }
            }

            @Override
            public void onRetry(DownloadTask task, boolean clearSize) {
                if (task == null) {
                    return;
                }
                int curRetryTimes = task.getInt("crtimes", 0);
                task.putInt("crtimes", curRetryTimes + 1);
                if (clearSize) {
                    this.onProgress(task, new ProgressInfo(0L, task.getLong("size")));
                }
                if (ENABLE_LOG && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)LocalDownloadClient.TAG, (String)("task fileName:" + task.getString("filename") + "onretry curRetryTimes:" + (curRetryTimes + 1)), (Object[])new Object[0]);
                }
            }

            @Override
            public void onPaused(DownloadTask task) {
            }

            @Override
            public void onStarted(DownloadTask task) {
                IDownloadProcesser listener;
                if (task == null) {
                    return;
                }
                if (task.getInt("state") == 3) {
                    return;
                }
                int oldState = task.getInt("state");
                task.putInt("state", 3);
                Iterator iterator = LocalDownloadClient.this.mProcesserList.iterator();
                while (iterator.hasNext() && !(listener = (IDownloadProcesser)iterator.next()).onTaskStateUpdated(task, oldState)) {
                }
            }
        };
        this.mRequestManager = new DownloadRequestManager(requestManagerCallBack);
        return this.mRequestManager;
    }

    public void setClientCallBack(IDownloadClientCallBack callBack) {
        this.mCallBack = callBack;
    }

    private boolean deleteFile(String filePath, String fileName) {
        if (StringUtils.isEmpty((String)filePath) || StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        File dir = new File(filePath);
        File fileToDelete = new File(dir, fileName);
        if (fileToDelete.exists() && fileToDelete.isFile()) {
            return fileToDelete.delete();
        }
        return true;
    }

    public void submitTask(final DownloadTask task) {
        if (task == null) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Object hasNotifyed = task.getProcessLocalInfo().get("hasnotifycreate");
                if (hasNotifyed == null || !((Boolean)hasNotifyed).booleanValue()) {
                    task.getProcessLocalInfo().put("hasnotifycreate", true);
                    if (LocalDownloadClient.this.mCallBack != null) {
                        LocalDownloadClient.this.mCallBack.onCreate(task);
                    }
                }
            }
        });
        this.getRequestManager().submitTask(task);
    }

    public void updateTask(DownloadTask oldTask, DownloadTask newTask) {
        if (oldTask == null || newTask == null) {
            return;
        }
        this.getRequestManager().updateTask(oldTask, newTask);
    }

    public void deleteTask(DownloadTask task) {
        this.getRequestManager().deleteTask(task);
        if (task != null) {
            task.putInt("state", 1);
        }
    }

    private IDownloadProcesser getDefaultProcesser() {
        IDownloadProcesser processer;
        if (this.defaultProcesser != null) {
            return this.defaultProcesser;
        }
        this.defaultProcesser = processer = new IDownloadProcesser(){

            @Override
            public boolean createTask(DownloadTask task) {
                return false;
            }

            @Override
            public boolean startTask(DownloadTask task) {
                return false;
            }

            @Override
            public boolean deleteTask(DownloadTask task, boolean isDeleteFile) {
                return false;
            }

            @Override
            public boolean pauseTask(DownloadTask task) {
                return false;
            }

            @Override
            public boolean handleExtraMsg(Message msg) {
                return false;
            }

            @Override
            public boolean restoreAllTasks() {
                return false;
            }

            @Override
            public boolean onTaskStateUpdated(DownloadTask task, int oldState) {
                int state = task.getInt("state");
                if (state == 3) {
                    Object startTime;
                    if (ENABLE_LOG && !MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)LocalDownloadClient.TAG, (String)("task:" + task.getString("url") + " onStarted!"), (Object[])new Object[0]);
                    }
                    if ((startTime = task.getProcessLocalInfo().get("downloadStartTime")) == null || (Long)startTime <= 0L) {
                        task.getProcessLocalInfo().put("downloadStartTime", System.currentTimeMillis());
                    }
                    if (LocalDownloadClient.this.mCallBack != null) {
                        LocalDownloadClient.this.mCallBack.onStart(task);
                    }
                } else if (state == 4) {
                    if (ENABLE_LOG) {
                        long startTimeL = 0L;
                        Object startTime = task.getProcessLocalInfo().get("downloadStartTime");
                        if (startTime != null && (Long)startTime > 0L) {
                            startTimeL = (Long)startTime;
                        }
                        if (startTimeL > 0L) {
                            MLog.info((Object)LocalDownloadClient.TAG, (String)"task:%s, error:%s, consumeTime:%s!", (Object[])new Object[]{task.getString("url"), task.getString("errorinfo"), String.valueOf(System.currentTimeMillis() - startTimeL)});
                        } else {
                            MLog.info((Object)LocalDownloadClient.TAG, (String)"task:%s, error:%s!", (Object[])new Object[]{task.getString("url"), task.getString("errorinfo")});
                        }
                    }
                    if (LocalDownloadClient.this.mCallBack != null) {
                        LocalDownloadClient.this.mCallBack.onError(task, 2, task.getString("errorinfo"));
                        IBasicParamsProvider basicParamsProvider = LocalDownloadClient.this.mCallBack.getBasicParamsProvider();
                        if (basicParamsProvider != null && basicParamsProvider.isDataCollecterSwitchOn()) {
                            basicParamsProvider.onErrorStat(task, basicParamsProvider.getUid(), false);
                        }
                    }
                } else if (state == 5) {
                    if (ENABLE_LOG) {
                        long startTimeL = 0L;
                        Object startTime = task.getProcessLocalInfo().get("downloadStartTime");
                        if (startTime != null && (Long)startTime > 0L) {
                            startTimeL = (Long)startTime;
                        }
                        if (startTimeL > 0L) {
                            MLog.info((Object)LocalDownloadClient.TAG, (String)"task:%s, success, consumeTime:%s!", (Object[])new Object[]{task.getString("url"), String.valueOf(System.currentTimeMillis() - startTimeL)});
                        } else {
                            MLog.info((Object)LocalDownloadClient.TAG, (String)"task:%s, success!", (Object[])new Object[]{task.getString("url")});
                        }
                    }
                    if (LocalDownloadClient.this.mCallBack != null) {
                        LocalDownloadClient.this.mCallBack.onComplete(task);
                        IBasicParamsProvider basicParamsProvider = LocalDownloadClient.this.mCallBack.getBasicParamsProvider();
                        if (basicParamsProvider != null && basicParamsProvider.isDataCollecterSwitchOn()) {
                            basicParamsProvider.onSucessStat(task, basicParamsProvider.getUid(), false);
                        }
                    }
                }
                return false;
            }

            @Override
            public boolean onTaskDeleted(DownloadTask task) {
                return false;
            }

            @Override
            public boolean onTaskRetry(DownloadTask task) {
                return false;
            }

            @Override
            public boolean onTaskCreated(DownloadTask task) {
                return false;
            }

            @Override
            public boolean onTaskProgressUpdated(DownloadTask task, long oldSize) {
                long totalSize = task.getLong("size");
                long curSize = task.getLong("cursize");
                if (ENABLE_LOG && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)LocalDownloadClient.TAG, (String)("task:" + task.getString("url") + " size:" + totalSize + " cursize:" + curSize), (Object[])new Object[0]);
                }
                if (LocalDownloadClient.this.mCallBack != null) {
                    LocalDownloadClient.this.mCallBack.onProgressChange(task, totalSize, curSize);
                }
                return false;
            }
        };
        return this.defaultProcesser;
    }
}

