/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request;

import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.request.DownloadRequest;
import java.io.File;

public class DownloadRequestBuilder {
    private static boolean isBaseDataValid(DownloadTask downloadTask) {
        if (downloadTask == null) {
            return false;
        }
        String downloadUrl = downloadTask.getString("url");
        String filePath = downloadTask.getString("path");
        String fileName = downloadTask.getString("filename");
        return !StringUtils.isEmpty((String)downloadUrl) && !StringUtils.isEmpty((String)filePath) && !StringUtils.isEmpty((String)fileName);
    }

    @Nullable
    public static DownloadRequest createRequest(DownloadTask downloadTask) {
        if (!DownloadRequestBuilder.isBaseDataValid(downloadTask)) {
            return null;
        }
        String downloadUrl = downloadTask.getString("url");
        File downFile = new File(downloadTask.getString("path"), downloadTask.getString("filename"));
        boolean continueDownloadTask = downloadTask.getInt("ctrans") == 1;
        DownloadRequest request = new DownloadRequest(downloadUrl, downFile.getPath(), continueDownloadTask);
        DownloadRequestBuilder.fillCommonParams(downloadTask, request);
        return request;
    }

    private static void fillCommonParams(DownloadTask downloadTask, DownloadRequest request) {
        String fileCheckType;
        boolean continueDownloadTask = downloadTask.getInt("ctrans") == 1;
        long curSize = downloadTask.getLong("cursize");
        if (continueDownloadTask && curSize > 0L) {
            request.setStartPos(curSize);
        }
        if (StringUtils.equal((String)(fileCheckType = downloadTask.getString("etagkey")), (String)"sha1")) {
            request.setEtagCheckType(2);
        } else if (StringUtils.equal((String)fileCheckType, (String)"md5")) {
            request.setEtagCheckType(3);
        }
        String localEtag = downloadTask.getExtendString("etagcontent");
        String referer = downloadTask.getExtendString("referer");
        String cookie = downloadTask.getExtendString("cookie");
        String userAgent = downloadTask.getExtendString("useragent");
        int group = downloadTask.getInt("dgroup");
        String maxConcurrency = downloadTask.getExtendString("maxconcurrency");
        String speedLimitValue = downloadTask.getExtendString("speedlimit");
        String downloadType = downloadTask.getExtendString("download_type");
        String progressInterval = downloadTask.getExtendString("progressinterval");
        request.setDownloadType(downloadType);
        if (!StringUtils.isEmpty((String)localEtag)) {
            request.setLocalEtagContent(localEtag);
        }
        if (!StringUtils.isEmpty((String)referer)) {
            request.getHeaders().put("Referer", referer);
        }
        if (!StringUtils.isEmpty((String)cookie)) {
            request.getHeaders().put("Cookie", cookie);
        }
        if (!StringUtils.isEmpty((String)userAgent)) {
            request.getHeaders().put("User-Agent", userAgent);
        }
        if (group > 0) {
            int maxConcurrencyInt = 1;
            if (StringUtils.isNotEmpty((String)maxConcurrency)) {
                maxConcurrencyInt = StringUtils.parseInt((String)maxConcurrency, (int)1);
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)"DownloadRequestBuilder", (String)" url:%s group:%d maxConcurrency:%d", (Object[])new Object[]{downloadTask.getString("url"), group, maxConcurrencyInt});
                }
            }
            request.setDownloadGroup(String.valueOf(group), maxConcurrencyInt);
        }
        if (StringUtils.isNotEmpty((String)progressInterval)) {
            request.setProgressInterval(StringUtils.parseInt((String)progressInterval, (int)-1));
        }
        if (StringUtils.isNotEmpty((String)speedLimitValue)) {
            request.setTaskSpeedLimitPerMicsecondValue(StringUtils.parseInt((String)speedLimitValue, (int)-1));
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)"DownloadRequestBuilder", (String)" url:%s speedLimitValue:%s", (Object[])new Object[]{downloadTask.getString("url"), speedLimitValue});
            }
        }
    }
}

