/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.mobile.backgroundprocess.ContextManager;
import com.yy.mobile.backgroundprocess.Util.sharedpref.BackgroundProcessPref;
import com.yy.mobile.http.RequestManager;
import com.yy.yylite.commonbase.crash.CrashSdk;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.io.File;
import java.util.UUID;

public class RemoteProcess {
    private static volatile boolean sInited;
    private static final String REMOTE_PROCESS_NAME = ":RemoteBackgroundProcess";

    public static void onMobileAppCreate(Application application, String processName) {
        if (RemoteProcess.isRemoteProcess(application, processName)) {
            Log.d((String)"RemoteProcess", (String)"initBaseEnv");
            RemoteProcess.initBaseEnv((Context)application);
        }
    }

    private static boolean isRemoteProcess(Application application, String processName) {
        if (application == null) {
            return false;
        }
        if (StringUtils.equal((String)REMOTE_PROCESS_NAME, (String)processName)) {
            return true;
        }
        String fullName = application.getPackageName();
        if (fullName != null) {
            fullName = fullName + REMOTE_PROCESS_NAME;
        }
        return StringUtils.equal((String)processName, (String)fullName);
    }

    static void initBaseEnv(Context context) {
        if (sInited) {
            return;
        }
        sInited = true;
        ContextManager.initialize(context);
        ContextManager.setApplicationContext(context);
        RemoteProcess.initMLog(context);
        RemoteProcess.initCrashSdk();
        RemoteProcess.initHiidoStatics();
    }

    private static void initHiidoStatics() {
    }

    private static void initMLog(Context context) {
        RequestManager.instance().init(context, "yyhigo" + File.separator + "remoteprocess/http");
    }

    private static void initCrashSdk() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                CrashSdk.INSTANCE.init(true, RemoteProcess.getUid(), HiidoUtils.getHdid());
            }
        });
    }

    private static String getUUID() {
        String uuid = BackgroundProcessPref.instance().getString("uuid", null);
        if (StringUtils.isEmpty((String)uuid) && !StringUtils.isEmpty((String)(uuid = UUID.randomUUID().toString().replace("-", "")))) {
            BackgroundProcessPref.instance().putString("uuid", uuid);
        }
        return uuid;
    }

    private static long getUid() {
        return BackgroundProcessPref.instance().getLong("uid", -1L);
    }

    private static boolean isDevVer() {
        return RuntimeContext.sIsDebuggable || BackgroundProcessPref.instance().getBoolean("devVer", false);
    }
}

