/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.commonbase.hiido;

import android.content.Context;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.OnStatisListener;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.IReportMetricSample;
import com.yy.yylite.hiido.HiidoInitParam;
import com.yy.yylite.hiido.HiidoStatisticHelper;

public enum HiidoStatisInit {
    INSTANCE;

    private static final String TAG = "HiidoStatisInit";
    public static String STATISTIC_HIIDO_TEST_SERVER_KEY;
    public static String STATISTIC_HIIDO_TEST_SERVER;
    private static String HIIDO_APP_KEY;
    private static String TEST_HIIDO_APP_KEY;
    public static final String HIIDO_STATISTIC_SETTINGS = "hiido_statistic_settings";
    private String mPushToken = "";
    private String mPushTokenToReportAfterInit = "";
    private long mUid;
    private OnStatisListener mOnStatisListener = new OnStatisListener(){

        public long getCurrentUid() {
            return HiidoStatisInit.this.mUid;
        }
    };

    public static String hiidoTestUrl() {
        String url = SettingFlags.getStringValue((String)STATISTIC_HIIDO_TEST_SERVER_KEY);
        if (TextUtils.isEmpty((CharSequence)url)) {
            return STATISTIC_HIIDO_TEST_SERVER;
        }
        return url;
    }

    public static void setHiidoTestUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            SettingFlags.setStringValue((String)STATISTIC_HIIDO_TEST_SERVER_KEY, (String)url);
        }
    }

    public void initHiidoOptions(String appId, String hagoSdkVersion) {
        HiidoInitParam param = this.buildParam(appId, hagoSdkVersion);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initCrashSdkImmediately, mPushToken: %s, HiidoInitParam: %s", (Object[])new Object[]{this.mPushToken, param});
        }
        HiidoStatisticHelper.INSTANCE.initHiidoOptions(param);
    }

    public void iniHiidoSdk(boolean immediately, String abJson, HiidoStatis.IHiidoEventInterceptor interceptor, HiidoStatis.ITrackStatEventHandler handler, IReportMetricSample reportMetricSample) {
        if (interceptor != null) {
            HiidoStatis.setInterceptor(interceptor);
        }
        if (handler != null) {
            HiidoStatis.setHandler(handler);
        }
        HiidoStatis.setReportMetricSample(reportMetricSample);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"iniHiidoSdk immediately: %s, mPushToken: %s", (Object[])new Object[]{immediately, this.mPushToken});
        }
        if (immediately) {
            this.initHiidoSdkImmediately(abJson);
            this.reportPushToken(this.mPushToken);
        }
    }

    public void onLogin(long uid) {
        if (this.mUid != uid) {
            this.mUid = uid;
            this.reportPushToken(this.mPushToken);
            HiidoStatisticHelper.INSTANCE.updateUid(uid);
            HiidoStatisticHelper.INSTANCE.reportLogin(uid);
        }
    }

    public void onUpdateAccount(long uid) {
        if (this.mUid != uid) {
            this.mUid = uid;
            this.reportPushToken(this.mPushToken);
            HiidoStatisticHelper.INSTANCE.updateUid(uid);
            HiidoStatisticHelper.INSTANCE.reportLogin(uid);
        }
    }

    public void onLogout() {
        this.mUid = 0L;
        this.reportPushToken(this.mPushToken);
    }

    public void onKickOff() {
        this.mUid = 0L;
    }

    public void reportPushToken(String pushToken) {
        if (HiidoStatisticHelper.INSTANCE.isHadInit()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"reportPushToken pushToken: %s", (Object[])new Object[]{pushToken});
            }
            this.mPushToken = pushToken;
            if (!TextUtils.isEmpty((CharSequence)pushToken)) {
                HiidoStatisticHelper.INSTANCE.reportPushToken(this.mPushToken);
            }
            this.mPushTokenToReportAfterInit = null;
        } else {
            this.mPushTokenToReportAfterInit = pushToken;
            this.mPushToken = pushToken;
        }
    }

    private void initHiidoSdkImmediately(String abJson) {
        HiidoStatisticHelper.INSTANCE.initHiidoSdk(abJson);
        if (StringUtils.isNotEmpty((String)this.mPushTokenToReportAfterInit)) {
            HiidoStatisticHelper.INSTANCE.reportPushToken(this.mPushTokenToReportAfterInit);
            this.mPushTokenToReportAfterInit = null;
        }
        HiidoStatis.onInited();
    }

    private HiidoInitParam buildParam(String appId, String hagoSdkVersion) {
        String appkey = HIIDO_APP_KEY;
        String testUri = "";
        if (this.getHiidoTestEnv()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"init hiido with test env, test-appkey: %s, test-server: %s", (Object[])new Object[]{TEST_HIIDO_APP_KEY, HiidoStatisInit.hiidoTestUrl()});
            }
            appkey = TEST_HIIDO_APP_KEY;
            testUri = HiidoStatisInit.hiidoTestUrl();
        }
        boolean isSensorMonitorEnabled = SettingFlags.getBoolean((String)"hiido_sensor_monitor", (boolean)true);
        boolean isLogEnabled = SettingFlags.getBoolean((String)"hiido_log_enable", (boolean)false);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("SensorMonitor: " + isSensorMonitorEnabled), (Object[])new Object[0]);
        }
        HiidoInitParam param = HiidoInitParam.getBuilder((Context)RuntimeContext.sApplicationContext).appkey(appkey).uid(this.mUid).appId(appId).version(hagoSdkVersion).statisListener(this.mOnStatisListener).actAdditionListener(null).isOpenCrashMonitor(true).isOpenSensorMonitor(isSensorMonitorEnabled).isOpenLog(isLogEnabled).testServer(testUri).build();
        return param;
    }

    public static String getHiidoAppkey() {
        if (TextUtils.isEmpty((CharSequence)HiidoSDK.instance().getAppKey())) {
            return HIIDO_APP_KEY;
        }
        return HiidoSDK.instance().getAppKey();
    }

    long getUid() {
        return this.mUid;
    }

    private boolean getHiidoTestEnv() {
        if (SystemUtils.isShowEnvSetting()) {
            return SettingFlags.getBoolean((String)"ENV_HIIDO_EVEN", (boolean)false);
        }
        return false;
    }

    static {
        STATISTIC_HIIDO_TEST_SERVER_KEY = "STATISTIC_HIIDO_TEST_SERVER_KEY";
        STATISTIC_HIIDO_TEST_SERVER = "http://datatest.hiido.com/c.gif";
        HIIDO_APP_KEY = "c236ef1afe5555a2c6e74d71c008b14b";
        TEST_HIIDO_APP_KEY = "b156b506d02ff7378eefad7e354b79f7";
    }
}

