/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.commonbase.hiido;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.CommonBaseTransfer;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoGroupReporter;
import com.yy.yylite.commonbase.hiido.HiidoStatisInit;
import com.yy.yylite.commonbase.hiido.IReportMetricSample;
import com.yy.yylite.hiido.HiidoStatisticHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public final class HiidoStatis {
    private static final String TAG = "HiidoStatis";
    public static final int PK_SCODE = 50071;
    public static final int APP_PERF_SCODE = 50565;
    private static volatile boolean sInited = false;
    private static volatile boolean sPauseReport = false;
    private static volatile List<HiidoEvent> sCachedEvent = new ArrayList<HiidoEvent>();
    private static final IQueueTaskExecutor sQueueExecutor = YYTaskExecutor.createAQueueExcuter();
    private static final List<StatisContent> mCachedContent = new ArrayList<StatisContent>();
    private static final List<Runnable> mCachedCommand = new ArrayList<Runnable>();
    private static JSONObject mAbTestFlag;
    private static String mLastWindowName;
    private static String mCurrentWindowName;
    private static long showTime;
    private static HashMap<String, String> sDefaultNullMap;
    @Nullable
    private static IHiidoEventInterceptor mInterceptor;
    @Nullable
    private static ITrackStatEventHandler mHandler;
    private static IReportMetricSample mIReportMetricSample;
    private static volatile boolean sReportingEnterGroup;
    private static Runnable reportEnterGroup;

    public static void setReportMetricSample(IReportMetricSample reportMetricSample) {
        if (reportMetricSample == null) {
            return;
        }
        mIReportMetricSample = reportMetricSample;
    }

    public static synchronized void setInterceptor(@NonNull IHiidoEventInterceptor interceptor) {
        mInterceptor = interceptor;
    }

    private static synchronized boolean intercept(@NonNull HiidoEvent event) {
        if (mInterceptor != null) {
            return mInterceptor.intercept(event);
        }
        return false;
    }

    private static synchronized boolean intercept(@NonNull StatisContent content) {
        if (mInterceptor != null) {
            return mInterceptor.intercept(content);
        }
        return false;
    }

    public static synchronized void setHandler(@NonNull ITrackStatEventHandler handler) {
        mHandler = handler;
    }

    private static synchronized void handleFirebaseEvent(@NonNull HiidoEvent event) {
        if (mHandler != null) {
            mHandler.handle(event);
        }
    }

    public static void onInited() {
        MLog.debug((Object)TAG, (String)"onInit", (Object[])new Object[0]);
        HiidoStatis.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                sInited = true;
                HiidoGroupReporter.INSTANCE.init();
                List list = sCachedEvent;
                synchronized (list) {
                    for (HiidoEvent event : sCachedEvent) {
                        HiidoStatis.reportEvent(event);
                    }
                    sCachedEvent.clear();
                }
                list = mCachedContent;
                synchronized (list) {
                    for (Object content : mCachedContent) {
                        HiidoStatis.reportContent((StatisContent)content);
                    }
                    mCachedContent.clear();
                }
                list = mCachedCommand;
                synchronized (list) {
                    if (mCachedCommand.size() > 0) {
                        for (Object content : mCachedCommand) {
                            if (content == null) continue;
                            content.run();
                        }
                        mCachedCommand.clear();
                    }
                }
            }
        });
    }

    public static void pauseReport(long pauseTime) {
        sPauseReport = true;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                sPauseReport = false;
                if (sInited) {
                    List list = sCachedEvent;
                    synchronized (list) {
                        for (HiidoEvent event : sCachedEvent) {
                            HiidoStatis.reportEvent(event);
                        }
                        sCachedEvent.clear();
                    }
                    list = mCachedContent;
                    synchronized (list) {
                        for (StatisContent content : mCachedContent) {
                            HiidoStatis.reportContent(content);
                        }
                        mCachedContent.clear();
                    }
                }
            }
        }, (long)pauseTime);
    }

    private static void execute(Runnable task) {
        sQueueExecutor.execute(task, 0L);
    }

    private static void execute(Runnable task, long delay) {
        sQueueExecutor.execute(task, delay);
    }

    public static void onWindowShown(String windowName) {
        if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onWindowShown windowName: %s, mCurrentWindowName: %s, mLastWindowName: %s", (Object[])new Object[]{windowName, mCurrentWindowName, mLastWindowName});
        }
        if (windowName == null) {
            windowName = "";
        }
        if (windowName.equals(mCurrentWindowName)) {
            return;
        }
        showTime = System.currentTimeMillis();
        mLastWindowName = mCurrentWindowName;
        mCurrentWindowName = windowName;
    }

    public static void putAbTestFlag(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        HiidoStatis.putAbTestFlagAsync(key, value);
    }

    public static void removeAbTestFlag(String ... key) {
        if (key == null || key.length == 0) {
            return;
        }
        HiidoStatis.removeAbTestFlgAsync(key);
    }

    private static synchronized void putAbTestFlagAsync(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        if (mAbTestFlag == null) {
            mAbTestFlag = JsonParser.obtainJSONObject();
        }
        if (!value.equals(mAbTestFlag.optString(key))) {
            try {
                mAbTestFlag.put(key, (Object)value);
                HiidoStatis.reportEnterGroupIfNeed();
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    private static void reportEnterGroupIfNeed() {
        if (!SettingFlags.hasInited() || RuntimeContext.sApplicationContext == null) {
            return;
        }
        if (!sReportingEnterGroup) {
            sReportingEnterGroup = true;
            YYTaskExecutor.removeTask((Runnable)reportEnterGroup);
            long delayMillis = 1000L;
            if (!CommonBaseTransfer.sIsAppStartFinished) {
                delayMillis = 5000L;
            }
            if (PageResponse.isNewTaskPriorityEnable()) {
                YYTaskExecutor.execute((Runnable)reportEnterGroup, (long)delayMillis, (int)12);
            } else {
                YYTaskExecutor.execute((Runnable)reportEnterGroup, (long)delayMillis);
            }
        }
    }

    private static synchronized void removeAbTestFlgAsync(String ... key) {
        if (key == null || key.length == 0) {
            return;
        }
        if (mAbTestFlag != null) {
            boolean hasChange = false;
            for (String temp : key) {
                if (StringUtils.isEmpty((String)temp) || mAbTestFlag.opt(temp) == null) continue;
                mAbTestFlag.remove(temp);
                hasChange = true;
            }
            if (hasChange) {
                HiidoStatis.reportEnterGroupIfNeed();
            }
        }
    }

    private static synchronized void reportEnterGroup() {
        HiidoEvent event = HiidoEvent.obtain().eventId("20028335").put("function_id", "enter_group");
        if (mAbTestFlag != null) {
            String abTestFlagString = mAbTestFlag.toString();
            event.put("abtest_flag", abTestFlagString);
            HiidoStatis.reportEvent(event);
            if (RuntimeContext.isInGray()) {
                MLog.debug((Object)"reportEnterGroup", (String)"%s", (Object[])new Object[]{abTestFlagString});
            }
        }
    }

    public static void reportReturnCode(String uri, long time, String returnCode) {
        HiidoStatis.reportReturnCode(uri, time, returnCode, null);
    }

    public static void reportReturnCode(final String uri, final long time, final String returnCode, final HashMap<String, String> moreInfo) {
        int delay = !HiidoStatisticHelper.INSTANCE.isHadInit() ? 5000 : 0;
        sQueueExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!HiidoStatisticHelper.INSTANCE.isHadInit()) {
                    return;
                }
                HiidoStatis.reportReturnCodeInner(50071, uri, time, returnCode, moreInfo);
            }
        }, (long)delay);
    }

    public static void reportReturnCode(int scode, String uri, long time, String returnCode) {
        HiidoStatis.reportReturnCode(scode, uri, time, returnCode, null);
    }

    public static void reportReturnCode(final int scode, final String uri, final long time, final String returnCode, final HashMap<String, String> moreInfo) {
        int delay = !HiidoStatisticHelper.INSTANCE.isHadInit() ? 5000 : 0;
        sQueueExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!HiidoStatisticHelper.INSTANCE.isHadInit()) {
                    return;
                }
                HiidoStatis.reportReturnCodeInner(scode, uri, time, returnCode, moreInfo);
            }
        }, (long)delay);
    }

    public static void reportAppMonitorReturnCode(String uri, long time, String returnCode) {
        HiidoStatis.reportAppMonitorReturnCode(uri, time, returnCode, null);
    }

    public static void reportAppMonitorReturnCode(final String uri, final long time, final String returnCode, final HashMap<String, String> moreInfo) {
        int delay;
        if (StringUtils.isEmpty((String)uri)) {
            return;
        }
        int n = delay = !HiidoStatisticHelper.INSTANCE.isHadInit() ? 5000 : 0;
        if (CommonBaseTransfer.getUid() <= 0L) {
            delay = 60000;
        }
        sQueueExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!HiidoStatisticHelper.INSTANCE.isHadInit()) {
                    return;
                }
                HiidoStatis.reportReturnCodeInner(50565, uri, time, returnCode, moreInfo);
            }
        }, (long)delay);
    }

    public static void reportAppMonitorReturnCodeNow(String uri, long time, String returnCode) {
        HiidoStatis.reportAppMonitorReturnCodeNow(uri, time, returnCode, null);
    }

    public static void reportAppMonitorReturnCodeNow(final String uri, final long time, final String returnCode, final HashMap<String, String> moreInfo) {
        int delay = !HiidoStatisticHelper.INSTANCE.isHadInit() ? 5000 : 0;
        sQueueExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!HiidoStatisticHelper.INSTANCE.isHadInit()) {
                    return;
                }
                HiidoStatis.reportReturnCodeInner(50565, uri, time, returnCode, moreInfo);
            }
        }, (long)delay);
    }

    public static void reportAppMonitorCount(final String uri, final int count) {
        int delay = !HiidoStatisticHelper.INSTANCE.isHadInit() ? 5000 : 0;
        sQueueExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!HiidoStatisticHelper.INSTANCE.isHadInit()) {
                    return;
                }
                HiidoSDK.instance().reportCount(50565, uri, "", (long)count);
            }
        }, (long)delay);
    }

    public static void reportContent(final StatisContent content) {
        if (content == null) {
            return;
        }
        if (!sInited || sPauseReport) {
            HiidoStatis.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = mCachedContent;
                    synchronized (list) {
                        mCachedContent.add(content);
                    }
                }
            });
            return;
        }
        HiidoStatis.execute(new Runnable(){

            @Override
            public void run() {
                if (CommonBaseTransfer.getUid() > 0L) {
                    content.put("uid", CommonBaseTransfer.getUid());
                }
                content.put("net", String.valueOf(NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext)));
                if (HiidoStatis.isAppTestSwitchOn() && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)HiidoStatis.TAG, (String)"reportContent :%s", (Object[])new Object[]{content.toString()});
                }
                String act = content.get("act");
                if (HiidoStatis.intercept(content)) {
                    MLog.debug((Object)HiidoStatis.TAG, (String)"reportContent fail, act: %s is intercepted", (Object[])new Object[]{act});
                    return;
                }
                HiidoSDK.instance().reportStatisticContent(act, content);
            }
        });
    }

    private static boolean sendEventToHiido(@NonNull HiidoEvent event) {
        if (TextUtils.isEmpty((CharSequence)event.getEventId())) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException("event_id can not be empty:" + event.toString() + "!");
            }
            MLog.error((Object)TAG, (String)"event_id can not be empty!", (Object[])new Object[0]);
            return false;
        }
        HiidoStatis.handleFirebaseEvent(event);
        if (HiidoStatis.intercept(event)) {
            MLog.debug((Object)TAG, (String)"sendEventToHiido fail, eventId: %s intercept", (Object[])new Object[]{event.getEventId()});
            return false;
        }
        if (RuntimeContext.isInGray()) {
            Map<String, String> property = event.getEventProperty();
            String strProperty = "";
            if (property != null) {
                strProperty = property.toString();
            }
            MLog.debug((Object)TAG, (String)"sendEventToHiido eventId:%s,label:%s,value:%s params:%s", (Object[])new Object[]{event.getEventId(), event.getLabel(), event.getEvalue() > 0.0 ? String.valueOf(event.getEvalue()) : Integer.valueOf(0), strProperty});
        }
        HiidoStatis.addPageEvent(event);
        StatisContent c = new StatisContent();
        c.put("region", 1);
        c.put("prodid", "friend");
        c.put("eventid", event.getEventId());
        c.put("type", "judge");
        c.put("value", 1);
        if (event.getEventProperty().containsKey("event_xxx_cur_user")) {
            c.put("uid", event.getEventProperty().get("event_xxx_cur_user"));
        } else if (HiidoStatisInit.INSTANCE.getUid() > 0L) {
            c.put("uid", HiidoStatisInit.INSTANCE.getUid());
        } else if (CommonBaseTransfer.getUid() > 0L) {
            c.put("uid", CommonBaseTransfer.getUid());
        }
        String pcid = CommonBaseTransfer.getPcid();
        if (StringUtils.isNotEmpty((String)pcid)) {
            c.put("pcid", pcid);
        }
        c.put("phone_type", RuntimeContext.sPhoneType);
        c.put("moreinfo", HiidoStatis.moreInfo(event.getEventProperty()));
        c.put("act", "mbsdkprotocol");
        HiidoStatis.reportContent(c);
        return true;
    }

    private static void recordEventUid(@NonNull HiidoEvent event) {
        if (null == event.getEventProperty() || !event.getEventProperty().containsKey("event_xxx_cur_user")) {
            if (HiidoStatisInit.INSTANCE.getUid() > 0L) {
                event.put("event_xxx_cur_user", HiidoStatisInit.INSTANCE.getUid() + "");
            } else if (CommonBaseTransfer.getUid() > 0L) {
                event.put("event_xxx_cur_user", CommonBaseTransfer.getUid() + "");
            }
        }
    }

    private static void addPageEvent(@NonNull HiidoEvent event) {
        if (null == event.getEventProperty() || !event.getEventProperty().containsKey("event_time")) {
            event.put("event_time", String.valueOf(showTime));
        }
        if (null == event.getEventProperty() || !event.getEventProperty().containsKey("referer")) {
            event.put("referer", mLastWindowName);
        }
        if (null == event.getEventProperty() || !event.getEventProperty().containsKey("page")) {
            event.put("page", mCurrentWindowName);
        }
    }

    private static String moreInfo(Map<String, String> property) {
        JSONObject moreinfo = JsonParser.obtainJSONObject();
        if (FP.empty(property)) {
            return moreinfo.toString();
        }
        try {
            for (Map.Entry<String, String> entry : property.entrySet()) {
                moreinfo.put(entry.getKey(), (Object)String.valueOf(entry.getValue()));
            }
            return moreinfo.toString();
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            return moreinfo.toString();
        }
    }

    private static boolean isEvalueValib(double evalue) {
        return Math.abs(evalue - -1.0) > 1.0E-4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onResume(final long uid, final Activity activity) {
        if (sInited) {
            HiidoSDK.instance().onResume(uid, activity);
        } else {
            List<Runnable> list = mCachedCommand;
            synchronized (list) {
                mCachedCommand.add(new Runnable(){

                    @Override
                    public void run() {
                        HiidoSDK.instance().onResume(uid, activity);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPause(final Activity activity, final int option) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                HiidoSDK.PageActionReportOption reportOption = HiidoSDK.PageActionReportOption.REPORT_ON_FUTURE_RESUME;
                reportOption = option == 0 ? HiidoSDK.PageActionReportOption.DO_NOT_REPORT_ON_FUTURE_RESUME : HiidoSDK.PageActionReportOption.REPORT_ON_FUTURE_RESUME;
                HiidoSDK.instance().onPause(activity, reportOption);
            }
        };
        if (sInited) {
            command.run();
        } else {
            List<Runnable> list = mCachedCommand;
            synchronized (list) {
                mCachedCommand.add(command);
            }
        }
    }

    public static void reportEvent(final HiidoEvent event) {
        if (event == null) {
            MLog.error((Object)TAG, (String)"reportEvent event is null", (Object[])new Object[0]);
            return;
        }
        if (!sInited || sPauseReport) {
            HiidoStatis.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = sCachedEvent;
                    synchronized (list) {
                        sCachedEvent.add(event);
                    }
                }
            });
            return;
        }
        long delayMillis = 0L;
        if (CommonBaseTransfer.getUid() <= 0L) {
            delayMillis = 20000L;
        } else if (!CommonBaseTransfer.sIsAppStartFinished) {
            delayMillis = 5000L;
        }
        HiidoStatis.addPageEvent(event);
        HiidoStatis.recordEventUid(event);
        HiidoStatis.execute(new Runnable(){

            @Override
            public void run() {
                HiidoStatis.sendEventToHiido(event);
                event.recycle();
            }
        }, delayMillis);
    }

    public static void reportEventNow(final HiidoEvent event) {
        if (event == null) {
            MLog.error((Object)TAG, (String)"reportEvent event is null", (Object[])new Object[0]);
            return;
        }
        if (!sInited || sPauseReport) {
            HiidoStatis.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = sCachedEvent;
                    synchronized (list) {
                        sCachedEvent.add(event);
                    }
                }
            });
            return;
        }
        HiidoStatis.execute(new Runnable(){

            @Override
            public void run() {
                HiidoStatis.sendEventToHiido(event);
                event.recycle();
            }
        });
    }

    public static void reportReturnCodeInner(int scode, String uri, long timeConsumption, String code, HashMap<String, String> moreInfo) {
        if (StringUtils.isNotEmpty((String)uri)) {
            int index = uri.indexOf("?");
            if (index > 0) {
                uri = uri.substring(0, index);
            }
        } else {
            return;
        }
        if (HiidoStatis.isAppTestSwitchOn() && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"reportReturnCodeInner uri:%s,consume:%s,code:%s", (Object[])new Object[]{uri, String.valueOf(timeConsumption), code});
        }
        if (moreInfo == null) {
            moreInfo = sDefaultNullMap;
        }
        if (StringUtils.isEmpty((String)moreInfo.get("uid"))) {
            moreInfo.put("uid", HiidoStatisInit.INSTANCE.getUid() + "");
        }
        if (mIReportMetricSample.enableReport(uri)) {
            HiidoSDK.instance().reportReturnCode(scode, uri, timeConsumption, code, moreInfo);
        }
    }

    public static boolean isAppTestSwitchOn() {
        return RuntimeContext.sIsDebuggable || TargetBuildConstant.showSetting == 1 && TargetBuildConstant.releaseApkCheck;
    }

    static {
        mLastWindowName = "";
        mCurrentWindowName = "";
        sDefaultNullMap = new HashMap();
        mIReportMetricSample = new IReportMetricSample(){

            @Override
            public boolean enableReport(@NotNull String uri) {
                return true;
            }
        };
        sReportingEnterGroup = false;
        reportEnterGroup = new Runnable(){

            @Override
            public void run() {
                sReportingEnterGroup = false;
                HiidoStatis.reportEnterGroup();
            }
        };
    }

    public static interface ITrackStatEventHandler {
        @WorkerThread
        public boolean handle(@NonNull HiidoEvent var1);
    }

    public static interface IHiidoEventInterceptor {
        @WorkerThread
        public boolean intercept(@NonNull HiidoEvent var1);

        @WorkerThread
        public boolean intercept(@NonNull StatisContent var1);
    }
}

