/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.chat.theme.services;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.extension.EasyExtensionKt;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.cbase.ChannelSettingFlag;
import com.yy.hiyo.channel.component.music.MusicHelper;
import com.yy.hiyo.channel.plugins.chat.theme.services.ChatThemeRoomNotify;
import com.yy.hiyo.channel.plugins.chat.theme.services.OnNotifyCallback;
import com.yy.hiyo.channel.service.themeroom.ChatThemeRedPoint;
import com.yy.hiyo.channel.service.themeroom.ChatThemeRoomConfig;
import com.yy.hiyo.channel.service.themeroom.ChatThemeRoomData;
import com.yy.hiyo.channel.service.themeroom.IChatThemeRoomService;
import com.yy.hiyo.channel.service.themeroom.OpenThemeNotify;
import com.yy.hiyo.channel.service.themeroom.UpgradeNotify;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.themeroom.CloseThemeReq;
import net.ihago.channel.srv.themeroom.CloseThemeRes;
import net.ihago.channel.srv.themeroom.GetRoomConfigReq;
import net.ihago.channel.srv.themeroom.GetRoomConfigRes;
import net.ihago.channel.srv.themeroom.GetRoomInfoReq;
import net.ihago.channel.srv.themeroom.GetRoomInfoRes;
import net.ihago.channel.srv.themeroom.GetThemeCntsReq;
import net.ihago.channel.srv.themeroom.GetThemeCntsRes;
import net.ihago.channel.srv.themeroom.GetThemeConfigReq;
import net.ihago.channel.srv.themeroom.GetThemeConfigRes;
import net.ihago.channel.srv.themeroom.MicType;
import net.ihago.channel.srv.themeroom.OpenThemeReq;
import net.ihago.channel.srv.themeroom.OpenThemeRes;
import net.ihago.channel.srv.themeroom.ThemeInfo;
import net.ihago.channel.srv.themeroom.ThemeLevel;
import net.ihago.channel.srv.themeroom.UpdateThemeOwnerReq;
import net.ihago.channel.srv.themeroom.UpdateThemeOwnerRes;
import net.ihago.channel.srv.themeroom.UpgradeData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J+\u0010!\u001a\u00020\u00122!\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00120\u000eH\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010$\u001a\u00020\u0006H\u0016J\b\u0010%\u001a\u00020\u0006H\u0016J\b\u0010&\u001a\u00020\u0006H\u0016JJ\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)28\u0010\"\u001a4\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(+\u0012\u0015\u0012\u0013\u0018\u00010\u001b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u00120*H\u0016J\b\u0010-\u001a\u00020\u0012H\u0016JJ\u0010.\u001a\u00020\u00122@\u0010\"\u001a<\u0012\u0015\u0012\u0013\u0018\u00010/\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020\u0012\u0018\u00010*j\u0004\u0018\u0001`1H\u0016J;\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00062)\u0010\"\u001a%\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000ej\u0004\u0018\u0001`\u0013H\u0016J3\u00104\u001a\u00020\u00122)\u0010\"\u001a%\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000ej\u0004\u0018\u0001`\u0013H\u0016JH\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u00020726\u0010\"\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u00120*H\u0016J\b\u00108\u001a\u00020\u0012H\u0016JM\u00109\u001a\u00020\u0012\"\u0012\b\u0000\u0010:*\f\u0012\u0004\u0012\u0002H:\u0012\u0002\b\u00030;\"\u0012\b\u0001\u0010<*\f\u0012\u0004\u0012\u0002H<\u0012\u0002\b\u00030;2\u0006\u0010=\u001a\u0002H:2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u0002H<\u0018\u00010>H\u0002\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\u0012H\u0016J\b\u0010A\u001a\u00020\u0012H\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\f\u001a'\u0012#\u0012!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000ej\u0002`\u00130\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/yy/hiyo/channel/plugins/chat/theme/services/ChatThemeRoomService;", "Lcom/yy/hiyo/channel/service/themeroom/IChatThemeRoomService;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;)V", "hasThemePrivilege", "", "Ljava/lang/Boolean;", "isFirstReqFlag", "isReqConfig", "mConfig", "Lcom/yy/hiyo/channel/service/themeroom/ChatThemeRoomConfig;", "mConfigReqCallbacks", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "succeed", "", "Lcom/yy/hiyo/channel/service/themeroom/OnConfigReqCallback;", "mData", "Lcom/yy/hiyo/channel/service/themeroom/ChatThemeRoomData;", "mNotify", "Lcom/yy/hiyo/channel/plugins/chat/theme/services/ChatThemeRoomNotify;", "closeThemeRoom", "data", "getChannelId", "", "getConfig", "getCurrentConfigInfo", "Lcom/yy/hiyo/channel/service/themeroom/ChatThemeRedPoint;", "getCurrentThemeLevelConfig", "Lnet/ihago/channel/srv/themeroom/ThemeLevel;", "hasPermission", "callback", "isOpen", "isMePlayingRoomThemeMusic", "isOpenedThemeRoom", "isShowThemeSpeakingAnim", "openThemeRoom", "themeId", "", "Lkotlin/Function2;", "code", "msg", "registerNotify", "reqRoomInfo", "Lnet/ihago/channel/srv/themeroom/UpgradeData;", "isNearByEnd", "Lcom/yy/hiyo/channel/service/themeroom/OnRoomInfoReqCallback;", "reqThemeConfig", "retThemeCount", "reqThemeCount", "reqUpdateThemeOwner", "uid", "", "resetData", "sendRpc", "REQ", "Lcom/squareup/wire/AndroidMessage;", "RES", "proto", "Lcom/yy/hiyo/proto/callback/IProtoCallback;", "(Lcom/squareup/wire/AndroidMessage;Lcom/yy/hiyo/proto/callback/IProtoCallback;)V", "setFirstReqFlag", "updateRedDotCache", "chat_debug"})
public final class ChatThemeRoomService
extends IChatThemeRoomService {
    private Boolean hasThemePrivilege;
    private ChatThemeRoomData mData;
    private ChatThemeRoomNotify mNotify;
    private final ChatThemeRoomConfig mConfig;
    private final List<Function1<Boolean, Unit>> mConfigReqCallbacks;
    private boolean isReqConfig;
    private boolean isFirstReqFlag;

    @NotNull
    public ChatThemeRoomData data() {
        if (this.mData == null) {
            this.mData = new ChatThemeRoomData();
        }
        ChatThemeRoomData chatThemeRoomData = this.mData;
        if (chatThemeRoomData == null) {
            Intrinsics.throwNpe();
        }
        return chatThemeRoomData;
    }

    @NotNull
    public String getChannelId() {
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        String string2 = iChannel.getChannelId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"channel.channelId");
        return string2;
    }

    public void resetData() {
        this.isFirstReqFlag = true;
        this.mData = null;
        this.hasThemePrivilege = null;
        ChatThemeRoomNotify chatThemeRoomNotify = this.mNotify;
        if (chatThemeRoomNotify != null) {
            ChatThemeRoomNotify chatThemeRoomNotify2 = chatThemeRoomNotify;
            boolean bl = false;
            boolean bl2 = false;
            ChatThemeRoomNotify it = chatThemeRoomNotify2;
            boolean bl3 = false;
            ProtoManager.getInstance().unregisterNotify((IProtoNotify)it);
            this.mNotify = null;
        }
        this.mConfig.clearMyThemeCount();
        this.mConfigReqCallbacks.clear();
    }

    public void reqThemeConfig(boolean retThemeCount, @Nullable Function1<? super Boolean, Unit> callback) {
        Function1<? super Boolean, Unit> function1 = callback;
        if (function1 != null) {
            Function1<? super Boolean, Unit> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<? super Boolean, Unit> it = function12;
            boolean bl3 = false;
            this.mConfigReqCallbacks.add(it);
        }
        if (this.isReqConfig) {
            return;
        }
        this.isReqConfig = true;
        GetThemeConfigReq req = new GetThemeConfigReq.Builder().ret_theme_cnts(Boolean.valueOf(retThemeCount)).build();
        this.sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetThemeConfigRes>(this, retThemeCount){
            final /* synthetic */ ChatThemeRoomService this$0;
            final /* synthetic */ boolean $retThemeCount;

            public void onResponse(@NotNull GetThemeConfigRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    ChatThemeRoomConfig chatThemeRoomConfig = ChatThemeRoomService.access$getMConfig$p(this.this$0);
                    List list = res.theme_infos;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"res.theme_infos");
                    chatThemeRoomConfig.addThemeList(list);
                    ChatThemeRoomConfig chatThemeRoomConfig2 = ChatThemeRoomService.access$getMConfig$p(this.this$0);
                    List list2 = res.theme_levels;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"res.theme_levels");
                    chatThemeRoomConfig2.addThemeLevelList(list2);
                    ChatThemeRoomConfig chatThemeRoomConfig3 = ChatThemeRoomService.access$getMConfig$p(this.this$0);
                    List list3 = res.theme_progresses;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"res.theme_progresses");
                    chatThemeRoomConfig3.addThemeProgressConfigList(list3);
                    if (this.$retThemeCount) {
                        ChatThemeRoomConfig chatThemeRoomConfig4 = ChatThemeRoomService.access$getMConfig$p(this.this$0);
                        List list4 = res.left_counts;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"res.left_counts");
                        chatThemeRoomConfig4.addMyThemeCountList(list4);
                        ChatThemeRoomConfig chatThemeRoomConfig5 = ChatThemeRoomService.access$getMConfig$p(this.this$0);
                        Long l = res.cnt_add_last_time;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"res.cnt_add_last_time");
                        chatThemeRoomConfig5.setUpdateTimestamp(l.longValue());
                    }
                } else {
                    MLog.error((Object)"ChatThemeRoomService", (String)"reqThemeConfig onError code: %d, reason: %s", (Object[])new Object[]{code, msgTip});
                }
                Iterable $this$forEach$iv = ChatThemeRoomService.access$getMConfigReqCallbacks$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl = false;
                    if (ProtoManager.isSuccessCode((long)code)) {
                        it.invoke((Object)true);
                        continue;
                    }
                    it.invoke((Object)ChatThemeRoomService.access$getMConfig$p(this.this$0).hasConfig());
                }
                ChatThemeRoomService.access$getMConfigReqCallbacks$p(this.this$0).clear();
                ChatThemeRoomService.access$setReqConfig$p(this.this$0, false);
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                Iterable $this$forEach$iv = ChatThemeRoomService.access$getMConfigReqCallbacks$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl = false;
                    it.invoke((Object)ChatThemeRoomService.access$getMConfig$p(this.this$0).hasConfig());
                }
                ChatThemeRoomService.access$getMConfigReqCallbacks$p(this.this$0).clear();
                ChatThemeRoomService.access$setReqConfig$p(this.this$0, false);
                MLog.error((Object)"ChatThemeRoomService", (String)"reqThemeConfig onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
            }
            {
                this.this$0 = $outer;
                this.$retThemeCount = $captured_local_variable$1;
            }
        });
    }

    public void reqRoomInfo(@Nullable Function2<? super UpgradeData, ? super Boolean, Unit> callback) {
        GetRoomInfoReq req = new GetRoomInfoReq.Builder().build();
        this.sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetRoomInfoRes>(this, callback){
            final /* synthetic */ ChatThemeRoomService this$0;
            final /* synthetic */ Function2 $callback;

            public void onResponse(@NotNull GetRoomInfoRes res, long code, @Nullable String msgTip) {
                block3: {
                    block2: {
                        int preThemeId;
                        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                        super.onResponse((AndroidMessage)res, code, msgTip);
                        if (!ProtoManager.isSuccessCode((long)code)) break block2;
                        ChatThemeRoomData chatThemeRoomData = this.this$0.data();
                        boolean bl = false;
                        boolean bl2 = false;
                        ChatThemeRoomData $this$apply = chatThemeRoomData;
                        boolean bl3 = false;
                        ChatThemeRoomData chatThemeRoomData2 = this.this$0.data();
                        Boolean bl4 = res.is_in_notify_time;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl4, (String)"res.is_in_notify_time");
                        chatThemeRoomData2.setNearByEnd(bl4.booleanValue());
                        Object object = this.this$0.data().getChatThemeData();
                        int n = object != null && (object = ((UpgradeData)object).theme_id) != null ? (Integer)object : (preThemeId = 0);
                        if (preThemeId != 0) {
                            Integer n2 = res.upgrade_data.theme_id;
                            if (n2 != null && n2 == 0) {
                                int next = this.this$0.data().getCloseNotify() + 1;
                                $this$apply.setValue("kvo_closeNotify", (Object)next);
                            }
                        }
                        $this$apply.setValue("kvo_chat_theme_data", (Object)res.upgrade_data);
                        Function2 function2 = this.$callback;
                        if (function2 == null) break block3;
                        UpgradeData upgradeData = res.upgrade_data;
                        Boolean bl5 = res.is_in_notify_time;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl5, (String)"res.is_in_notify_time");
                        Unit cfr_ignored_0 = (Unit)function2.invoke((Object)upgradeData, (Object)bl5);
                        break block3;
                    }
                    MLog.error((Object)"ChatThemeRoomService", (String)"reqRoomInfo onError code: %d, reason: %s", (Object[])new Object[]{code, msgTip});
                    Function2 function2 = this.$callback;
                    if (function2 == null) break block3;
                    Unit cfr_ignored_1 = (Unit)function2.invoke(null, (Object)false);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                Function2 function2 = this.$callback;
                if (function2 != null) {
                    Unit cfr_ignored_0 = (Unit)function2.invoke(null, (Object)false);
                }
                MLog.error((Object)"ChatThemeRoomService", (String)"reqRoomInfo onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
            }
        });
    }

    public void reqThemeCount(@Nullable Function1<? super Boolean, Unit> callback) {
        List list = this.getConfig().getThemeIdList();
        if (list.isEmpty()) {
            Function1<? super Boolean, Unit> function1 = callback;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)false);
            }
            return;
        }
        GetThemeCntsReq req = new GetThemeCntsReq.Builder().theme_ids(list).build();
        this.sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetThemeCntsRes>(this, callback){
            final /* synthetic */ ChatThemeRoomService this$0;
            final /* synthetic */ Function1 $callback;

            public void onResponse(@NotNull GetThemeCntsRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    ChatThemeRoomConfig chatThemeRoomConfig = ChatThemeRoomService.access$getMConfig$p(this.this$0);
                    List list = res.left_counts;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"res.left_counts");
                    chatThemeRoomConfig.addMyThemeCountList(list);
                    ChatThemeRoomConfig chatThemeRoomConfig2 = ChatThemeRoomService.access$getMConfig$p(this.this$0);
                    Long l = res.cnt_add_last_time;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"res.cnt_add_last_time");
                    chatThemeRoomConfig2.setUpdateTimestamp(l.longValue());
                    Function1 function1 = this.$callback;
                    if (function1 != null) {
                        Unit cfr_ignored_0 = (Unit)function1.invoke((Object)true);
                    }
                } else {
                    Function1 function1 = this.$callback;
                    if (function1 != null) {
                        Unit cfr_ignored_1 = (Unit)function1.invoke((Object)false);
                    }
                    MLog.error((Object)"ChatThemeRoomService", (String)"reqThemeCount onError code: %d, reason: %s", (Object[])new Object[]{code, msgTip});
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                Function1 function1 = this.$callback;
                if (function1 != null) {
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)false);
                }
                MLog.error((Object)"ChatThemeRoomService", (String)"reqThemeCount onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
            }
        });
    }

    public void openThemeRoom(int themeId, @NotNull Function2<? super Integer, ? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        OpenThemeReq req = new OpenThemeReq.Builder().theme_id(Integer.valueOf(themeId)).build();
        this.sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<OpenThemeRes>(this, themeId, callback){
            final /* synthetic */ ChatThemeRoomService this$0;
            final /* synthetic */ int $themeId;
            final /* synthetic */ Function2 $callback;

            public void onResponse(@NotNull OpenThemeRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)"ChatThemeRoomService", (String)"openThemeRoom", (Object[])new Object[0]);
                    if (ChatThemeRoomService.access$getMConfig$p(this.this$0).getMyThemeCountList().indexOfKey(this.$themeId) >= 0) {
                        long afterCount = ((Number)ChatThemeRoomService.access$getMConfig$p(this.this$0).getMyThemeCountList().get(this.$themeId)).longValue() - 1L;
                        if (afterCount < 0L) {
                            afterCount = 0L;
                        }
                        ChatThemeRoomService.access$getMConfig$p(this.this$0).getMyThemeCountList().put(this.$themeId, (Object)afterCount);
                        this.this$0.updateRedDotCache();
                    }
                } else {
                    MLog.error((Object)"ChatThemeRoomService", (String)"openThemeRoom onError code: %d, reason: %s", (Object[])new Object[]{code, msgTip});
                }
                this.$callback.invoke((Object)((int)code), (Object)res.result.errmsg);
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                this.$callback.invoke((Object)code, (Object)reason);
                MLog.error((Object)"ChatThemeRoomService", (String)"openThemeRoom onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
            }
            {
                this.this$0 = $outer;
                this.$themeId = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
            }
        });
    }

    public void closeThemeRoom() {
        CloseThemeReq req = new CloseThemeReq.Builder().build();
        this.sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<CloseThemeRes>(){

            public void onResponse(@NotNull CloseThemeRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)"ChatThemeRoomService", (String)"closeThemeRoom", (Object[])new Object[0]);
                } else {
                    MLog.error((Object)"ChatThemeRoomService", (String)"closeThemeRoom onError code: %d, reason: %s", (Object[])new Object[]{code, msgTip});
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)"ChatThemeRoomService", (String)"closeThemeRoom onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
            }
        });
    }

    public void reqUpdateThemeOwner(long uid, @NotNull Function2<? super Boolean, ? super Integer, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        UpdateThemeOwnerReq.Builder builder = new UpdateThemeOwnerReq.Builder();
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        UpdateThemeOwnerReq req = builder.cid(iChannel.getChannelId()).new_owner(Long.valueOf(uid)).build();
        this.sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<UpdateThemeOwnerRes>(callback){
            final /* synthetic */ Function2 $callback;

            public void onResponse(@NotNull UpdateThemeOwnerRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    this.$callback.invoke((Object)true, (Object)((int)code));
                } else {
                    this.$callback.invoke((Object)false, (Object)((int)code));
                    MLog.error((Object)"ChatThemeRoomService", (String)"reqUpdateThemeOwner onError code: %d, reason: %s", (Object[])new Object[]{code, msgTip});
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                this.$callback.invoke((Object)false, (Object)code);
                MLog.error((Object)"ChatThemeRoomService", (String)"reqUpdateThemeOwner onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public boolean isOpenedThemeRoom() {
        return this.data().isOpenedThemeRoom();
    }

    public boolean isMePlayingRoomThemeMusic() {
        UpgradeData upgradeData = this.data().getChatThemeData();
        Long l = upgradeData != null ? upgradeData.owner : null;
        long l2 = AccountUtil.getUid();
        if (l != null && l == l2) {
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            IDataService iDataService = iChannel.getDataService();
            Intrinsics.checkExpressionValueIsNotNull((Object)iDataService, (String)"channel.dataService");
            ChannelDetailInfo channelDetailInfo = iDataService.getCacheDetail();
            if (channelDetailInfo != null && (channelDetailInfo = channelDetailInfo.dynamicInfo) != null) {
                if (channelDetailInfo.mBgmPlaying) {
                    IChannel iChannel2 = this.channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel2, (String)"channel");
                    IDataService iDataService2 = iChannel2.getDataService();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iDataService2, (String)"channel.dataService");
                    ChannelDetailInfo channelDetailInfo2 = iDataService2.getCacheDetail();
                    if (channelDetailInfo2 != null && (channelDetailInfo2 = channelDetailInfo2.dynamicInfo) != null) {
                        if (channelDetailInfo2.mCurrentPlayBgUid == AccountUtil.getUid()) {
                            if (MusicHelper.getPlayingBean() != null && MusicHelper.getMusicStatus() == 1) {
                                MusicPlaylistDBBean musicPlaylistDBBean = MusicHelper.getPlayingBean();
                                Intrinsics.checkExpressionValueIsNotNull((Object)musicPlaylistDBBean, (String)"MusicHelper.getPlayingBean()");
                                if (!TextUtils.isEmpty((CharSequence)musicPlaylistDBBean.getChatThemeTag())) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ChatThemeRedPoint getCurrentConfigInfo() {
        List themeList = this.mConfig.getThemeIdList();
        int n = 0;
        List countList = new ArrayList();
        n = 0;
        int n2 = this.mConfig.getMyThemeCountList().size();
        while (n < n2) {
            void i;
            Object object = this.mConfig.getMyThemeCountList().valueAt((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mConfig.myThemeCountList.valueAt(i)");
            countList.add(object);
            ++i;
        }
        return new ChatThemeRedPoint(themeList, countList, this.mConfig.getUpdateTimestamp());
    }

    public void updateRedDotCache() {
        try {
            ChatThemeRedPoint config = this.getCurrentConfigInfo();
            String text = new Gson().toJson((Object)config);
            ChannelSettingFlag.INSTANCE.putString("key_bottom_chat_theme_room_red_dot_text", text);
        }
        catch (Exception e) {
            MLog.error((Object)"ChatThemeRoomService", (String)"updateRedDotCache: %s", (Object[])new Object[]{e.toString()});
        }
    }

    public boolean isFirstReqFlag() {
        return this.isFirstReqFlag;
    }

    public void setFirstReqFlag() {
        this.isFirstReqFlag = false;
    }

    public boolean isShowThemeSpeakingAnim() {
        UpgradeData upgradeData = this.data().getChatThemeData();
        if (upgradeData != null) {
            UpgradeData upgradeData2 = upgradeData;
            boolean bl = false;
            boolean bl2 = false;
            UpgradeData $this$apply = upgradeData2;
            boolean bl3 = false;
            if (Intrinsics.compare((int)$this$apply.theme_id, (int)0) > 0) {
                Integer n = $this$apply.theme_id;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"theme_id");
                int n2 = n;
                Integer n3 = $this$apply.cur_lv;
                Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"cur_lv");
                ThemeLevel themeLevel = this.mConfig.getThemeLevelById(n2, n3.intValue());
                if (themeLevel != null) {
                    ThemeLevel themeLevel2 = themeLevel;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    ThemeLevel it = themeLevel2;
                    boolean bl6 = false;
                    Integer n4 = it.mic_type;
                    int n5 = MicType.MIC_TYPE_LEFT_RIGHT.getValue();
                    return n4 != null && n4 == n5;
                }
            }
        }
        return false;
    }

    @Nullable
    public ThemeLevel getCurrentThemeLevelConfig() {
        UpgradeData upgradeData = this.data().getChatThemeData();
        if (upgradeData != null) {
            UpgradeData upgradeData2 = upgradeData;
            boolean bl = false;
            boolean bl2 = false;
            UpgradeData $this$apply = upgradeData2;
            boolean bl3 = false;
            if (Intrinsics.compare((int)$this$apply.theme_id, (int)0) > 0) {
                Integer n = $this$apply.theme_id;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"theme_id");
                int n2 = n;
                Integer n3 = $this$apply.cur_lv;
                Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"cur_lv");
                return this.mConfig.getThemeLevelById(n2, n3.intValue());
            }
        }
        return null;
    }

    public void hasPermission(@NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.hasThemePrivilege != null) {
            callback.invoke((Object)EasyExtensionKt.isTrue((Boolean)this.hasThemePrivilege));
            return;
        }
        GetRoomConfigReq req = new GetRoomConfigReq.Builder().build();
        this.sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetRoomConfigRes>(this, callback){
            final /* synthetic */ ChatThemeRoomService this$0;
            final /* synthetic */ Function1 $callback;

            public void onResponse(@NotNull GetRoomConfigRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    ChatThemeRoomService.access$setHasThemePrivilege$p(this.this$0, res.has_theme_privilege);
                    Boolean bl = res.has_theme_privilege;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"res.has_theme_privilege");
                    this.$callback.invoke((Object)bl);
                } else {
                    this.$callback.invoke((Object)false);
                    MLog.error((Object)"ChatThemeRoomService", (String)"hasPermission onError code: %d, reason: %s", (Object[])new Object[]{code, msgTip});
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                this.$callback.invoke((Object)false);
                MLog.error((Object)"ChatThemeRoomService", (String)"hasPermission onError code: %d, reason: %s", (Object[])new Object[]{code, reason});
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
            }
        });
    }

    private final <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendRpc(REQ proto, IProtoCallback<RES> callback) {
        ProtoManager protoManager = ProtoManager.getInstance();
        IChannel iChannel = this.channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
        protoManager.sendRpc(iChannel.getChannelId(), proto, callback);
    }

    public void registerNotify() {
        if (this.mNotify == null) {
            this.mNotify = new ChatThemeRoomNotify(new OnNotifyCallback(this){
                final /* synthetic */ ChatThemeRoomService this$0;

                public void onHandleOpenTheme(@NotNull String cid, @NotNull UpgradeData data) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    ChatThemeRoomData chatThemeRoomData = this.this$0.data();
                    boolean bl = false;
                    boolean bl2 = false;
                    ChatThemeRoomData $this$apply = chatThemeRoomData;
                    boolean bl3 = false;
                    $this$apply.setNearByEnd(false);
                    $this$apply.setValue("kvo_chat_theme_data", (Object)data);
                    if (Intrinsics.compare((int)data.theme_id, (int)0) > 0) {
                        $this$apply.setValue("kvo_openNotify", (Object)new OpenThemeNotify(cid, data, false));
                    }
                }

                public void onHandleUpgradeProgress(@NotNull String cid, @NotNull UpgradeData data) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    this.this$0.data().setValue("kvo_chat_theme_data", (Object)data);
                }

                public void onHandleUpgradeSuccess(@NotNull String cid, @NotNull UpgradeData data, long adderTime) {
                    boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    ChatThemeRoomConfig chatThemeRoomConfig = ChatThemeRoomService.access$getMConfig$p(this.this$0);
                    Integer n = data.theme_id;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"data.theme_id");
                    ThemeInfo config = chatThemeRoomConfig.getThemeById(n.intValue());
                    String bgUrl = "";
                    ThemeInfo themeInfo = config;
                    if (themeInfo != null) {
                        String string2;
                        ThemeInfo themeInfo2 = themeInfo;
                        boolean bl2 = false;
                        bl = false;
                        ThemeInfo it = themeInfo2;
                        boolean bl3 = false;
                        if (RuntimeContext.getPhoneType() <= 1 && !TextUtils.isEmpty((CharSequence)it.low_upgrade_url)) {
                            String string3 = it.low_upgrade_url;
                            string2 = string3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.low_upgrade_url");
                        } else {
                            String string4 = it.upgrade_url;
                            string2 = string4;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.upgrade_url");
                        }
                        bgUrl = string2;
                    }
                    int n2 = data.cur_lv - 1;
                    Integer n3 = data.cur_lv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"data.cur_lv");
                    UpgradeNotify notify = new UpgradeNotify(cid, n2, n3.intValue(), adderTime, bgUrl);
                    ChatThemeRoomData chatThemeRoomData = this.this$0.data();
                    bl = false;
                    boolean bl4 = false;
                    ChatThemeRoomData $this$apply = chatThemeRoomData;
                    boolean bl5 = false;
                    $this$apply.setNearByEnd(false);
                    $this$apply.setValue("kvo_upgradeNotify", (Object)notify);
                    $this$apply.setValue("kvo_chat_theme_data", (Object)data);
                }

                public void onHandleNearlyClosed(@NotNull String cid, @NotNull UpgradeData data) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    UpgradeData upgradeData = this.this$0.data().getChatThemeData();
                    if (Intrinsics.areEqual((Object)(upgradeData != null ? upgradeData.theme_id : null), (Object)data.theme_id) ^ true) {
                        return;
                    }
                    ChatThemeRoomData chatThemeRoomData = this.this$0.data();
                    boolean bl = false;
                    boolean bl2 = false;
                    ChatThemeRoomData $this$apply = chatThemeRoomData;
                    boolean bl3 = false;
                    $this$apply.setNearByEnd(true);
                    $this$apply.setValue("kvo_chat_theme_data", (Object)data);
                }

                public void onHandleCloseTheme(@NotNull String cid) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    ChatThemeRoomData chatThemeRoomData = this.this$0.data();
                    boolean bl = false;
                    boolean bl2 = false;
                    ChatThemeRoomData $this$apply = chatThemeRoomData;
                    boolean bl3 = false;
                    int next = this.this$0.data().getCloseNotify() + 1;
                    $this$apply.setNearByEnd(false);
                    $this$apply.setValue("kvo_chat_theme_data", null);
                    $this$apply.setValue("kvo_openNotify", null);
                    $this$apply.setValue("kvo_upgradeNotify", null);
                    $this$apply.setValue("kvo_changeOwnerNotify", (Object)0);
                    $this$apply.setValue("kvo_closeNotify", (Object)next);
                }

                public void onHandleChangeOwner(@NotNull String cid) {
                    Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
                    IChannel iChannel = ChatThemeRoomService.access$getChannel$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
                    if (iChannel.getRoleService().isOwnerOrMaster(AccountUtil.getUid()) && this.this$0.data().isOpenedThemeRoom()) {
                        this.this$0.data().setValue("kvo_changeOwnerNotify", (Object)(this.this$0.data().getChangeOwnerNotify() + 1));
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.mNotify);
    }

    @NotNull
    public ChatThemeRoomConfig getConfig() {
        return this.mConfig;
    }

    public ChatThemeRoomService(@NotNull IChannel channel) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(channel);
        this.mConfig = new ChatThemeRoomConfig();
        ChatThemeRoomService chatThemeRoomService = this;
        boolean bl = false;
        chatThemeRoomService.mConfigReqCallbacks = list = (List)new ArrayList();
        this.isFirstReqFlag = true;
    }

    public static final /* synthetic */ ChatThemeRoomConfig access$getMConfig$p(ChatThemeRoomService $this) {
        return $this.mConfig;
    }

    public static final /* synthetic */ List access$getMConfigReqCallbacks$p(ChatThemeRoomService $this) {
        return $this.mConfigReqCallbacks;
    }

    public static final /* synthetic */ boolean access$isReqConfig$p(ChatThemeRoomService $this) {
        return $this.isReqConfig;
    }

    public static final /* synthetic */ void access$setReqConfig$p(ChatThemeRoomService $this, boolean bl) {
        $this.isReqConfig = bl;
    }

    public static final /* synthetic */ Boolean access$getHasThemePrivilege$p(ChatThemeRoomService $this) {
        return $this.hasThemePrivilege;
    }

    public static final /* synthetic */ void access$setHasThemePrivilege$p(ChatThemeRoomService $this, Boolean bl) {
        $this.hasThemePrivilege = bl;
    }

    public static final /* synthetic */ IChannel access$getChannel$p(ChatThemeRoomService $this) {
        return $this.channel;
    }
}

