/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.chat;

import android.os.Message;
import android.view.View;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.yy.appbase.common.FacePoint;
import com.yy.framework.core.Environment;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.AbsChannelWindow;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.cbase.IAbsPageCallBack;
import com.yy.hiyo.channel.cbase.IPluginCallBack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.module.audiopk.IAudioPkModulePresenter;
import com.yy.hiyo.channel.cbase.module.audiopk.OpenAudioPkInviteParam;
import com.yy.hiyo.channel.cbase.module.chat.IChatModulePresenter;
import com.yy.hiyo.channel.component.hat.HatPresenter;
import com.yy.hiyo.channel.component.seat.SeatLocationPresenter;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.plugins.base.CommonStylePage;
import com.yy.hiyo.channel.plugins.chat.ChatRoomContext;
import com.yy.hiyo.channel.plugins.chat.ChatRoomPage;
import com.yy.hiyo.channel.plugins.chat.R;
import com.yy.hiyo.channel.plugins.chat.seat.ChatSeatPresenter;
import com.yy.hiyo.channel.plugins.chat.theme.ThemeRoomPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import com.yy.hiyo.channel.plugins.voiceroom.AbsVoiceRoomPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.RoomPageContext;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.normal.EmptyPluginPresenter;
import com.yy.hiyo.channel.service.themeroom.IChatThemeRoomService;
import com.yy.hiyo.mvp.base.MvpController;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J*\u0010\u0013\u001a$\u0012 \u0012\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00160\u00150\u0014H\u0014J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00150\u0019H\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u0016H\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0012H\u0014J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0012H\u0014J\b\u0010(\u001a\u00020\u001fH\u0016\u00a8\u0006)"}, d2={"Lcom/yy/hiyo/channel/plugins/chat/ChatRoomPlugin;", "Lcom/yy/hiyo/channel/plugins/voiceroom/AbsVoiceRoomPlugin;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "enterParam", "Lcom/yy/hiyo/channel/base/EnterParam;", "pluginData", "Lcom/yy/hiyo/channel/base/bean/plugins/ChannelPluginData;", "env", "Lcom/yy/framework/core/Environment;", "pluginCallback", "Lcom/yy/hiyo/channel/cbase/IPluginCallBack;", "(Lcom/yy/hiyo/channel/base/service/IChannel;Lcom/yy/hiyo/channel/base/EnterParam;Lcom/yy/hiyo/channel/base/bean/plugins/ChannelPluginData;Lcom/yy/framework/core/Environment;Lcom/yy/hiyo/channel/cbase/IPluginCallBack;)V", "createPage", "Lcom/yy/hiyo/channel/plugins/voiceroom/AbsRoomPage;", "window", "Lcom/yy/hiyo/channel/cbase/AbsChannelWindow;", "createPageContext", "Lcom/yy/hiyo/channel/plugins/voiceroom/RoomPageContext;", "createPresenterClassInterceptor", "Lkotlin/Function0;", "", "Ljava/lang/Class;", "Landroidx/lifecycle/ViewModel;", "getFaceLocation", "Landroidx/lifecycle/MutableLiveData;", "", "Lcom/yy/appbase/common/FacePoint;", "getPluginPresenterClass", "Lcom/yy/hiyo/channel/plugins/voiceroom/plugin/AbsPluginPresenter;", "handleMessageInner", "", "msg", "Landroid/os/Message;", "haveSelfFaceLocation", "", "initCommonPresenter", "page", "mvpContext", "initFinalPresenter", "preDestroy", "chat_debug"})
public class ChatRoomPlugin
extends AbsVoiceRoomPlugin {
    @NotNull
    protected AbsRoomPage createPage(@NotNull AbsChannelWindow window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        return new ChatRoomPage(window, (IAbsPageCallBack)this);
    }

    @NotNull
    protected RoomPageContext createPageContext(@NotNull ChannelPluginData pluginData) {
        Intrinsics.checkParameterIsNotNull((Object)pluginData, (String)"pluginData");
        return new ChatRoomContext((MvpController)this, this.getChannel(), this.getEnterParam(), pluginData);
    }

    protected void initCommonPresenter(@NotNull AbsRoomPage page, @NotNull RoomPageContext mvpContext) {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)mvpContext, (String)"mvpContext");
        super.initCommonPresenter((CommonStylePage)page, (IChannelPageContext)mvpContext);
        if (this.haveSelfFaceLocation()) {
            ((SeatLocationPresenter)mvpContext.getPresenter(SeatLocationPresenter.class)).setSeatLocationMutable(this.getFaceLocation());
        }
    }

    @NotNull
    protected Function0<Map<Class<? extends ViewModel>, Class<? extends ViewModel>>> createPresenterClassInterceptor() {
        return (Function0)new Function0<Map<Class<? extends ViewModel>, ? extends Class<? extends ViewModel>>>(this){
            final /* synthetic */ ChatRoomPlugin this$0;

            @NotNull
            public final Map<Class<? extends ViewModel>, Class<? extends ViewModel>> invoke() {
                return MapsKt.plus((Map)((Map)ChatRoomPlugin.access$createPresenterClassInterceptor$s213875078(this.this$0).invoke()), (Map)MapsKt.mapOf((Pair)TuplesKt.to(SeatPresenter.class, ChatSeatPresenter.class)));
            }
            {
                this.this$0 = chatRoomPlugin;
                super(0);
            }
        };
    }

    @NotNull
    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        MutableLiveData mutableLiveData = ((SeatPresenter)this.getMvpContext().getPresenter(SeatPresenter.class)).getRealRelSeatMapLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableLiveData, (String)"mvpContext.getPresenter(\u2026a).realRelSeatMapLocation");
        return mutableLiveData;
    }

    public boolean haveSelfFaceLocation() {
        return true;
    }

    protected void initFinalPresenter(@NotNull AbsRoomPage page, @NotNull RoomPageContext mvpContext) {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)mvpContext, (String)"mvpContext");
        super.initFinalPresenter((CommonStylePage)page, (IChannelPageContext)mvpContext);
        mvpContext.getPresenter(HatPresenter.class);
        mvpContext.getPresenter(IChatModulePresenter.class);
        ThemeRoomPresenter themeRoomPresenter = (ThemeRoomPresenter)mvpContext.getPresenter(ThemeRoomPresenter.class);
        View view = page.getPageView().findViewById(R.id.themeRoomBubbleHolder);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"page.pageView.findViewBy\u2026id.themeRoomBubbleHolder)");
        themeRoomPresenter.setContainer(view);
        ((IChatThemeRoomService)this.getChannel().getPluginService(IChatThemeRoomService.class)).registerNotify();
    }

    @NotNull
    protected Class<? extends AbsPluginPresenter> getPluginPresenterClass() {
        return EmptyPluginPresenter.class;
    }

    public void handleMessageInner(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        super.handleMessageInner(msg);
        if (msg.what == ChannelMsgDef.OPEN_AUDIO_PK_PANEL) {
            if (msg.obj instanceof OpenAudioPkInviteParam) {
                Object object = msg.obj;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.cbase.module.audiopk.OpenAudioPkInviteParam");
                }
                ((IAudioPkModulePresenter)this.getMvpContext().getPresenter(IAudioPkModulePresenter.class)).openInviteList((OpenAudioPkInviteParam)object);
            }
        } else if (msg.what == ChannelMsgDef.OPEN_AUDIO_PK_MATCH && msg.obj instanceof OpenAudioPkInviteParam) {
            Object object = msg.obj;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.cbase.module.audiopk.OpenAudioPkInviteParam");
            }
            ((IAudioPkModulePresenter)this.getMvpContext().getPresenter(IAudioPkModulePresenter.class)).startPkMatch((OpenAudioPkInviteParam)object);
        }
    }

    public void preDestroy() {
        super.preDestroy();
        ((IChatThemeRoomService)this.getChannel().getPluginService(IChatThemeRoomService.class)).resetData();
    }

    public ChatRoomPlugin(@NotNull IChannel channel, @NotNull EnterParam enterParam, @NotNull ChannelPluginData pluginData, @NotNull Environment env, @NotNull IPluginCallBack pluginCallback) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)enterParam, (String)"enterParam");
        Intrinsics.checkParameterIsNotNull((Object)pluginData, (String)"pluginData");
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)pluginCallback, (String)"pluginCallback");
        super(channel, enterParam, pluginData, env, pluginCallback);
    }

    public static final /* synthetic */ Function0 access$createPresenterClassInterceptor$s213875078(ChatRoomPlugin $this) {
        return super.createPresenterClassInterceptor();
    }
}

