/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.channellist.content.manager;

import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.utils.ChannelUtils;
import com.yy.hiyo.channel.component.channellist.ChannelDrawerContext;
import com.yy.hiyo.channel.component.channellist.IChannelDrawerListener;
import com.yy.hiyo.channel.component.channellist.content.layout.CommonContentLayout;
import com.yy.hiyo.channel.component.channellist.content.layout.LiveDataContentLayout;
import com.yy.hiyo.channel.component.channellist.content.manager.DrawerContentManager;
import com.yy.hiyo.channel.component.channellist.content.viewmodel.CommonContentViewModel;
import com.yy.hiyo.channel.component.channellist.content.viewmodel.LiveDataViewModel;
import com.yy.hiyo.channel.component.channellist.template.IDrawerTemplate;
import com.yy.hiyo.channel.module.endpage.data.LocalEndPageData;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.mgr.GetEndPageRes;
import net.ihago.money.api.anchorlevel.GetShowAnchorCurrentLiveCharmRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lcom/yy/hiyo/channel/component/channellist/content/manager/LiveDataDrawerContentManager;", "Lcom/yy/hiyo/channel/component/channellist/content/manager/DrawerContentManager;", "context", "Lcom/yy/hiyo/channel/component/channellist/ChannelDrawerContext;", "templateListener", "Lcom/yy/hiyo/channel/component/channellist/template/IDrawerTemplate;", "drawerListener", "Lcom/yy/hiyo/channel/component/channellist/IChannelDrawerListener;", "(Lcom/yy/hiyo/channel/component/channellist/ChannelDrawerContext;Lcom/yy/hiyo/channel/component/channellist/template/IDrawerTemplate;Lcom/yy/hiyo/channel/component/channellist/IChannelDrawerListener;)V", "onDrawerClosed", "", "onDrawerOpen", "requestData", "channel-subpage_release"})
public final class LiveDataDrawerContentManager
extends DrawerContentManager {
    public final void requestData() {
        if (this.getViewModel() != null) {
            CommonContentViewModel commonContentViewModel = this.getViewModel();
            if (commonContentViewModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.channellist.content.viewmodel.LiveDataViewModel");
            }
            LiveDataViewModel liveDataViewModel = (LiveDataViewModel)commonContentViewModel;
            String string2 = this.getContext().getChannel().getChannelId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.channel.channelId");
            liveDataViewModel.getLiveData(string2);
        }
    }

    public final void onDrawerOpen() {
        int videoShowTime = 0;
        Object object = this.getContext().getChannel().getDataService();
        if (object != null && (object = object.getLocalEndPageData()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object data = object2;
            boolean bl3 = false;
            if (data instanceof LocalEndPageData) {
                boolean isVideoMode;
                IPluginService iPluginService = this.getContext().getChannel().getPluginService();
                boolean bl4 = iPluginService != null && (iPluginService = iPluginService.getCurPluginData()) != null ? iPluginService.isVideoMode() : (isVideoMode = false);
                if (isVideoMode) {
                    long interval = (ChannelUtils.getCurrentTime() - ((LocalEndPageData)data).getLastTraceTime()) / (long)1000;
                    videoShowTime = ((LocalEndPageData)data).getLocalVideoShowTime() + (int)interval;
                }
            }
        }
        if (this.getLayout() != null) {
            CommonContentLayout commonContentLayout = this.getLayout();
            if (commonContentLayout == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.channellist.content.layout.LiveDataContentLayout");
            }
            ((LiveDataContentLayout)commonContentLayout).onDrawerOpen(videoShowTime);
        }
    }

    public final void onDrawerClosed() {
        if (this.getLayout() != null) {
            CommonContentLayout commonContentLayout = this.getLayout();
            if (commonContentLayout == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.channellist.content.layout.LiveDataContentLayout");
            }
            ((LiveDataContentLayout)commonContentLayout).onDrawerClosed();
        }
    }

    public LiveDataDrawerContentManager(@NotNull ChannelDrawerContext context, @NotNull IDrawerTemplate templateListener, @Nullable IChannelDrawerListener drawerListener2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)templateListener, (String)"templateListener");
        super(context, templateListener, drawerListener2);
        this.setViewModel((CommonContentViewModel)context.getViewModel(LiveDataViewModel.class));
        this.setLayout(new LiveDataContentLayout(context.getContext(), templateListener));
        this.initTopDataObserver();
        CommonContentViewModel commonContentViewModel = this.getViewModel();
        if (commonContentViewModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.channellist.content.viewmodel.LiveDataViewModel");
        }
        ((LiveDataViewModel)commonContentViewModel).getEndPageRes().observe((LifecycleOwner)context, (Observer)new Observer<GetEndPageRes>(){

            public final void onChanged(GetEndPageRes it) {
                if (this.getLayout() != null) {
                    CommonContentLayout commonContentLayout = this.getLayout();
                    if (commonContentLayout == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.channellist.content.layout.LiveDataContentLayout");
                    }
                    LiveDataContentLayout liveDataContentLayout = (LiveDataContentLayout)commonContentLayout;
                    GetEndPageRes getEndPageRes = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)getEndPageRes, (String)"it");
                    liveDataContentLayout.setEndPageRes(getEndPageRes);
                }
            }
        });
        CommonContentViewModel commonContentViewModel2 = this.getViewModel();
        if (commonContentViewModel2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.channellist.content.viewmodel.LiveDataViewModel");
        }
        ((LiveDataViewModel)commonContentViewModel2).getCurrLiveDataRes().observe((LifecycleOwner)context, (Observer)new Observer<GetShowAnchorCurrentLiveCharmRes>(){

            public final void onChanged(GetShowAnchorCurrentLiveCharmRes it) {
                if (this.getLayout() != null) {
                    CommonContentLayout commonContentLayout = this.getLayout();
                    if (commonContentLayout == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.channellist.content.layout.LiveDataContentLayout");
                    }
                    LiveDataContentLayout liveDataContentLayout = (LiveDataContentLayout)commonContentLayout;
                    GetShowAnchorCurrentLiveCharmRes getShowAnchorCurrentLiveCharmRes = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)getShowAnchorCurrentLiveCharmRes, (String)"it");
                    liveDataContentLayout.currLiveData(getShowAnchorCurrentLiveCharmRes);
                }
            }
        });
        IDataService iDataService = context.getChannel().getDataService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iDataService, (String)"context.channel.dataService");
        ChannelDetailInfo channelDetailInfo = iDataService.getCacheDetail();
        this.requestTopData((ChannelInfo)(channelDetailInfo != null ? channelDetailInfo.baseInfo : null));
        CommonContentLayout commonContentLayout = this.getLayout();
        if (commonContentLayout == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.channellist.content.layout.LiveDataContentLayout");
        }
        ((LiveDataContentLayout)commonContentLayout).setMvpContext(context);
    }
}

