/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.channellist.ui;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class ChannelGridItemDecoration
extends RecyclerView.ItemDecoration {
    private int verticalSpace;
    private int horizontalSpace;
    private int headerCount;
    private boolean showTopBottomEdge = false;
    private boolean showLeftRightEdge = false;

    public ChannelGridItemDecoration(int space) {
        this(space, space, 0);
    }

    public ChannelGridItemDecoration(int space, int headerCount) {
        this(space, space, headerCount);
    }

    public ChannelGridItemDecoration(int verticalSpace, int horizontalSpace, int headerCount) {
        this.verticalSpace = verticalSpace;
        this.horizontalSpace = horizontalSpace;
        this.headerCount = headerCount;
    }

    public void setShowTopBottomEdge(boolean show) {
        this.showTopBottomEdge = show;
    }

    public void setShowLeftRightEdge(boolean show) {
        this.showLeftRightEdge = show;
    }

    public void setHeaderCount(int headerCount) {
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildLayoutPosition(view);
        if (position < this.headerCount) {
            return;
        }
        RecyclerView.LayoutManager lm = parent.getLayoutManager();
        int spanCount = -1;
        if (lm instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)lm).getSpanCount();
        } else if (lm instanceof StaggeredGridLayoutManager) {
            spanCount = ((StaggeredGridLayoutManager)lm).getSpanCount();
        }
        if (spanCount >= 0) {
            int index = position - this.headerCount;
            int column = index % spanCount;
            if (this.showTopBottomEdge) {
                if (index < spanCount) {
                    outRect.top = this.verticalSpace;
                }
                outRect.bottom = this.verticalSpace;
            } else if (index >= spanCount) {
                outRect.top = this.verticalSpace;
            }
            if (this.showLeftRightEdge) {
                outRect.left = this.horizontalSpace - column * this.horizontalSpace / spanCount;
                outRect.right = (column + 1) * this.horizontalSpace / spanCount;
            } else {
                outRect.left = column * this.horizontalSpace / spanCount;
                outRect.right = this.horizontalSpace - (column + 1) * this.horizontalSpace / spanCount;
            }
        }
    }
}

