/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.video.play;

import android.content.Context;
import android.view.ViewGroup;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.service.video.ILiveVideo;
import com.yy.hiyo.channel.base.service.video.IVideoStatusCallback;
import com.yy.hiyo.voice.base.bean.event.OnNoMatchCodeRateCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class AbLiveVideo
implements ILiveVideo {
    protected Context mContext;
    protected IVideoCallBack mCallBack;
    protected long mMyId;
    protected int mStatus = 0;
    protected boolean mBinded;
    protected boolean mRelased;
    protected ArrayList<WeakReference<IVideoStatusCallback>> mStatusListeners;

    public AbLiveVideo(Context context, IVideoCallBack callBack, long videoId) {
        this.mContext = context;
        this.mCallBack = callBack;
        this.mMyId = videoId;
    }

    protected abstract boolean bindReal(ViewGroup var1, ViewGroup.LayoutParams var2);

    protected abstract void unbindReal(ViewGroup var1);

    protected abstract void unbindForce();

    protected abstract void stopReal();

    protected abstract boolean playReal(OnNoMatchCodeRateCallback var1);

    protected abstract String getLogTag();

    public final boolean play(OnNoMatchCodeRateCallback callback2) {
        this.checkVideoReleaseStatus();
        if (this.isReleased()) {
            return false;
        }
        if (this.isPlaying()) {
            MLog.info((Object)this.getLogTag(), (String)"play, already playing!", (Object[])new Object[0]);
            return true;
        }
        MLog.info((Object)this.getLogTag(), (String)"play!", (Object[])new Object[0]);
        this.mStatus = this.playReal(callback2) ? 1 : this.mStatus;
        return this.mStatus == 1;
    }

    public final void stop() {
        this.checkVideoReleaseStatus();
        if (this.isReleased()) {
            return;
        }
        if (this.isPlaying()) {
            MLog.info((Object)this.getLogTag(), (String)"stop!", (Object[])new Object[0]);
            this.stopReal();
            this.mStatus = 3;
            this.notifyVideoStoped();
        } else {
            MLog.info((Object)this.getLogTag(), (String)"stop, already stoped!", (Object[])new Object[0]);
        }
    }

    public final void release() {
        if (this.mStatus == 10) {
            MLog.info((Object)this.getLogTag(), (String)"Release, already released!", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)this.getLogTag(), (String)"release!", (Object[])new Object[0]);
        this.mRelased = true;
        this.stop();
        this.unbindForce();
        this.mStatus = 10;
        this.mBinded = false;
        this.mCallBack = null;
    }

    protected void onVideStarted() {
        if (this.isReleased()) {
            MLog.info((Object)this.getLogTag(), (String)"onVideStarted, but video is released!", (Object[])new Object[0]);
            return;
        }
        if (this.mStatus == 1) {
            MLog.info((Object)this.getLogTag(), (String)"onVideStarted!", (Object[])new Object[0]);
            this.mStatus = 2;
            this.notifyVideoStarted();
        } else if (this.mStatus == 2) {
            MLog.info((Object)this.getLogTag(), (String)"onVideReStarted!", (Object[])new Object[0]);
            this.notifyVideoReStarted();
        } else {
            MLog.info((Object)this.getLogTag(), (String)"onVideStarted, already started!", (Object[])new Object[0]);
        }
    }

    private void notifyVideoReStarted() {
        if (this.mStatusListeners == null || this.mStatusListeners.size() == 0) {
            return;
        }
        for (WeakReference<IVideoStatusCallback> item : this.mStatusListeners) {
            IVideoStatusCallback listener2;
            if (item == null || item.get() == null || (listener2 = (IVideoStatusCallback)item.get()) == null) continue;
            listener2.onVideoReStarted((ILiveVideo)this);
        }
    }

    protected void onVideStoped() {
        if (this.isReleased()) {
            MLog.info((Object)this.getLogTag(), (String)"onVideStoped, but video is released!", (Object[])new Object[0]);
            return;
        }
        this.stop();
    }

    public final void bind(ViewGroup cotainer, ViewGroup.LayoutParams layoutParams) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)this.getLogTag(), (String)"bind, container:%s!", (Object[])new Object[]{cotainer.toString()});
        } else {
            MLog.info((Object)this.getLogTag(), (String)"bind!", (Object[])new Object[0]);
        }
        this.checkVideoReleaseStatus();
        if (this.isReleased()) {
            return;
        }
        this.mBinded = this.bindReal(cotainer, layoutParams);
    }

    public final void unbind(ViewGroup cotainer) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)this.getLogTag(), (String)"unbind, container:%s!", (Object[])new Object[]{cotainer.toString()});
        } else {
            MLog.info((Object)this.getLogTag(), (String)"unbind!", (Object[])new Object[0]);
        }
        this.checkVideoReleaseStatus();
        if (this.isReleased()) {
            return;
        }
        if (this.mBinded) {
            this.unbindReal(cotainer);
            this.mBinded = false;
        }
        if (this.mStatusListeners != null) {
            this.mStatusListeners.clear();
            this.mStatusListeners = null;
        }
    }

    public boolean isPlaying() {
        return this.mStatus == 2 || this.mStatus == 1;
    }

    public boolean isStarted() {
        return this.mStatus == 2;
    }

    public boolean isStoped() {
        return this.mStatus == 3 || this.mStatus == 10;
    }

    public long getId() {
        return this.mMyId;
    }

    public void registerListener(IVideoStatusCallback callback2) {
        if (callback2 == null) {
            return;
        }
        if (this.mStatusListeners == null) {
            this.mStatusListeners = new ArrayList(2);
        } else {
            for (WeakReference<IVideoStatusCallback> item : this.mStatusListeners) {
                IVideoStatusCallback listenerReal;
                if (item == null || (listenerReal = (IVideoStatusCallback)item.get()) != callback2) continue;
                return;
            }
        }
        this.mStatusListeners.add(new WeakReference<IVideoStatusCallback>(callback2));
    }

    public void unregisterListener(IVideoStatusCallback callback2) {
        if (callback2 == null || this.mStatusListeners == null || this.mStatusListeners.size() <= 0) {
            return;
        }
        for (WeakReference<IVideoStatusCallback> item : this.mStatusListeners) {
            IVideoStatusCallback listenerReal;
            if (item == null || (listenerReal = (IVideoStatusCallback)item.get()) != callback2) continue;
            this.mStatusListeners.remove(item);
            return;
        }
    }

    protected void notifyVideoStarted() {
        if (this.mStatusListeners == null || this.mStatusListeners.size() == 0) {
            return;
        }
        for (WeakReference<IVideoStatusCallback> item : this.mStatusListeners) {
            IVideoStatusCallback listener2;
            if (item == null || item.get() == null || (listener2 = (IVideoStatusCallback)item.get()) == null) continue;
            listener2.onVideoStarted((ILiveVideo)this);
        }
    }

    protected void notifyVideoStoped() {
        if (this.mStatusListeners == null || this.mStatusListeners.size() == 0) {
            return;
        }
        for (WeakReference<IVideoStatusCallback> item : this.mStatusListeners) {
            IVideoStatusCallback listener2;
            if (item == null || item.get() == null || (listener2 = (IVideoStatusCallback)item.get()) == null) continue;
            listener2.onVideoStoped((ILiveVideo)this);
        }
    }

    private void checkVideoReleaseStatus() {
        if (RuntimeContext.sIsDebuggable && this.mStatus == 10) {
            throw new RuntimeException("video is released!");
        }
    }

    private boolean isReleased() {
        return this.mStatus == 10;
    }

    public static interface IVideoCallBack {
    }
}

