/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.role;

import android.os.SystemClock;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.base.bean.ChannelJoinStatus;
import com.yy.hiyo.channel.base.service.IChannelJoinStatusService;
import com.yy.hiyo.channel.service.role.ChannelJoinStatusService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.mgr.GetJoinApplyStatusReq;
import net.ihago.channel.srv.mgr.GetJoinApplyStatusRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/yy/hiyo/channel/service/role/ChannelJoinStatusService;", "Lcom/yy/hiyo/channel/base/service/IChannelJoinStatusService;", "()V", "joinStatusCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/yy/hiyo/channel/base/bean/ChannelJoinStatus;", "getJoinStatusCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "joinStatusCache$delegate", "Lkotlin/Lazy;", "lastRefreshTime", "", "getMyJoinStatus", "cid", "refreshJoinStatus", "", "setMyJoinStatus", "joinStatus", "channel-components_debug"})
public final class ChannelJoinStatusService
implements IChannelJoinStatusService {
    private final Lazy joinStatusCache$delegate = LazyKt.lazy((Function0)joinStatusCache.2.INSTANCE);
    private long lastRefreshTime;

    private final ConcurrentHashMap<String, ChannelJoinStatus> getJoinStatusCache() {
        Lazy lazy = this.joinStatusCache$delegate;
        ChannelJoinStatusService channelJoinStatusService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConcurrentHashMap)lazy.getValue();
    }

    @NotNull
    public ChannelJoinStatus getMyJoinStatus(@NotNull String cid) {
        ChannelJoinStatus channelJoinStatus;
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        if (SystemClock.elapsedRealtime() - this.lastRefreshTime > 10800000L) {
            this.refreshJoinStatus();
        }
        if ((channelJoinStatus = this.getJoinStatusCache().get(cid)) == null) {
            channelJoinStatus = ChannelJoinStatus.UNKNOWN;
        }
        return channelJoinStatus;
    }

    public void setMyJoinStatus(@NotNull String cid, @NotNull ChannelJoinStatus joinStatus) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        Intrinsics.checkParameterIsNotNull((Object)joinStatus, (String)"joinStatus");
        ((Map)this.getJoinStatusCache()).put(cid, joinStatus);
    }

    private final void refreshJoinStatus() {
        this.lastRefreshTime = SystemClock.elapsedRealtime();
        GetJoinApplyStatusReq reqBase = new GetJoinApplyStatusReq.Builder().return_base(Boolean.valueOf(true)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)reqBase, (IProtoCallback)new SimpleProtoCallback<GetJoinApplyStatusRes>(this){
            final /* synthetic */ ChannelJoinStatusService this$0;

            public void onResponse(@NotNull GetJoinApplyStatusRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)"ChannelJoinStatusService", (String)("applying cids:" + res.apply_cids.size()), (Object[])new Object[0]);
                    List list2 = res.apply_cids;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"res.apply_cids");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        Map map = ChannelJoinStatusService.access$getJoinStatusCache$p(this.this$0);
                        String string2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                        map.put(string2, ChannelJoinStatus.VERIFYING);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        GetJoinApplyStatusReq reqFamily = new GetJoinApplyStatusReq.Builder().return_base(Boolean.valueOf(false)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)reqFamily, (IProtoCallback)new SimpleProtoCallback<GetJoinApplyStatusRes>(this){
            final /* synthetic */ ChannelJoinStatusService this$0;

            public void onResponse(@NotNull GetJoinApplyStatusRes res, long code, @Nullable String msgTip) {
                Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
                super.onResponse((AndroidMessage)res, code, msgTip);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)"ChannelJoinStatusService", (String)("applying family cids:" + res.apply_cids.size()), (Object[])new Object[0]);
                    List list2 = res.apply_cids;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"res.apply_cids");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        Map map = ChannelJoinStatusService.access$getJoinStatusCache$p(this.this$0);
                        String string2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                        map.put(string2, ChannelJoinStatus.VERIFYING);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public ChannelJoinStatusService() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, new INotify(){

            public void notify(@Nullable Notification notification) {
                lastRefreshTime = 0L;
                this.getJoinStatusCache().clear();
            }
        });
    }

    public static final /* synthetic */ long access$getLastRefreshTime$p(ChannelJoinStatusService $this) {
        return $this.lastRefreshTime;
    }
}

