/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.request;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.recommend.bean.GroupChatTab;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.unifyconfig.config.GroupChatClassificationData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelInfoSelector;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.ChannelPermissionData;
import com.yy.hiyo.channel.base.bean.FamilyGateInfo;
import com.yy.hiyo.channel.base.bean.JoinApproveData;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.NoticeResp;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.module.notice.ChannelMessageCreator;
import com.yy.hiyo.channel.service.notify.ChannelNotifyHandler;
import com.yy.hiyo.channel.service.request.cinfo.CInfoRequestManager;
import com.yy.hiyo.channel.service.request.cinfo.GroupCategoryRequestManager;
import com.yy.hiyo.channel.service.request.config.ChannelPermissionRequestManager;
import com.yy.hiyo.channel.service.request.config.ConfigRequestManager;
import com.yy.hiyo.channel.service.request.discovery.DiscoveryGroupRequestManager;
import com.yy.hiyo.channel.service.request.join.JoinRequestManager;
import com.yy.hiyo.channel.service.request.listentogether.ListenTogetherRequestManager;
import com.yy.hiyo.channel.service.request.msg.MsgRequestManager;
import com.yy.hiyo.channel.service.request.role.RoleRequestManager;
import com.yy.hiyo.im.base.ChannelNoticeMessage;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ihago.channel.srv.mgr.GetNoticeReq;
import net.ihago.channel.srv.mgr.GetNoticeRes;
import net.ihago.channel.srv.mgr.NoticeItem;
import net.ihago.channel.srv.mgr.Notify;
import net.ihago.channel.srv.mgr.ReportBlockChannelReq;
import net.ihago.channel.srv.mgr.ReportBlockChannelRes;
import net.ihago.money.api.family.GetFamilyProfileRes;
import org.jetbrains.annotations.NotNull;

public class ChannelRequestManager
extends BaseRequestManager {
    private static final String TAG = "ChannelRequest";
    private JoinRequestManager joinRequestManager = new JoinRequestManager();
    private RoleRequestManager roleRequestManager = new RoleRequestManager();
    private CInfoRequestManager cInfoRequestManager = new CInfoRequestManager();
    private ConfigRequestManager configRequestManager = new ConfigRequestManager();
    private MsgRequestManager msgRequestManager = new MsgRequestManager();
    private ChannelPermissionRequestManager channelPermissionRequestManager = new ChannelPermissionRequestManager();
    private DiscoveryGroupRequestManager discoveryGroupRequestManager = new DiscoveryGroupRequestManager();
    private GroupCategoryRequestManager groupCategoryRequestManager = new GroupCategoryRequestManager();
    private final ListenTogetherRequestManager listenTogetherRequestManager = new ListenTogetherRequestManager();

    public void getChannelPermission(boolean isFromGroup, ICommonCallback<ChannelPermissionData> callback2) {
        this.channelPermissionRequestManager.getPermission(callback2, isFromGroup);
    }

    public void getMyJoinedGroups(IChannelCenterService.IGetMyJoinedChannelsCallBack callBack) {
        this.joinRequestManager.getMyJoinedGroups(callBack);
    }

    public void getUserJoinedGroups(long uid, IChannelCenterService.QueryJoinChannelConfig config2, IChannelCenterService.IGetMyJoinedChannelsCallBack callBack) {
        this.joinRequestManager.getUserJoinedGroups(uid, config2, callBack);
    }

    public void getUnreadMsgNum(ArrayList<MsgRequestManager.UnreadMsgRequestItem> requestItems, MsgRequestManager.IUnreadMsgRequestCallBack callBack) {
        this.msgRequestManager.getUnreadMsgNum(requestItems, callBack);
    }

    public void getControlConfig(IChannelCenterService.IGetControlConfigCallBack callBack) {
        this.configRequestManager.getControlConfig(callBack);
    }

    public void getFamilyPermit(ICommonCallback<Boolean> callback2) {
        this.configRequestManager.getFamilyPermit(callback2);
    }

    public void getChannelAB(String cid, String key, long ownerId, IChannelCenterService.IGetChannelABCallback callBack) {
        this.configRequestManager.getChannelAB(cid, key, ownerId, callBack);
    }

    public void getAllGroupTab(ICommonCallback<List<GroupChatTab>> callback2) {
        this.discoveryGroupRequestManager.getAllGroupTab(callback2);
    }

    public void getGroupTab(long tabId, Page page, ICommonCallback<GroupChatTab> callback2) {
        this.discoveryGroupRequestManager.getGroupTab(tabId, page, callback2);
    }

    public void getGroupCategory(int groupCategoryId, ICommonCallback<GroupChatClassificationData> callback2) {
        this.groupCategoryRequestManager.getGroupCategory(groupCategoryId, callback2);
    }

    public void getAllGroupCategory(ICommonCallback<List<GroupChatClassificationData>> callback2) {
        this.groupCategoryRequestManager.getAllGroupCategory(callback2);
    }

    @Nullable
    public GroupChatClassificationData getGroupCategoryFromCache(int groupCategoryID) {
        return this.groupCategoryRequestManager.getGroupCategoryFromCache(groupCategoryID);
    }

    @Nullable
    public List<GroupChatClassificationData> getAllGroupCategoryFromCache() {
        return this.groupCategoryRequestManager.getAllGroupCategoryFromCache();
    }

    public void switchLbs(String cid, boolean open, double longitude, double latitude, ICommonCallback<Boolean> callBack) {
        this.cInfoRequestManager.switchLbs(cid, open, longitude, latitude, callBack);
    }

    public void createSubGroup(String parentCID, CreateChannelParams params, IChannel.ICreateCallBack callBack) {
        CInfoRequestManager.createChannel(parentCID, params, callBack);
    }

    public void kickOff(String gid, long uid, IChannel.IKickOffCallBack callBack) {
        this.roleRequestManager.kickOff(gid, uid, callBack);
    }

    public void disbandSubGroup(String groupId, IChannel.IDisbandCallBack callBack) {
        this.cInfoRequestManager.disbandSubGroup(groupId, callBack);
    }

    public static void leaveGroup(String gid, IChannel.ILeaveCallBack callBack) {
        JoinRequestManager.leaveGroup(gid, callBack, false);
    }

    public void getTopAndSubGroupInfos(String pid, String cid, long ver, BaseRequestManager.IGetTopAndSubGroupInfosCallBack callBack, boolean justBaseInfo) {
        this.cInfoRequestManager.getTopAndSubGroupInfos(pid, cid, ver, callBack, justBaseInfo);
    }

    public void getTopAndSubGroupInfos(String cid, long ver, BaseRequestManager.IGetTopAndSubGroupInfosCallBack callBack, boolean justBaseInfo) {
        this.cInfoRequestManager.getTopAndSubGroupInfos("", cid, ver, callBack, justBaseInfo);
    }

    public void getChannelInfo(String cid, ChannelInfoSelector infoSelector, BaseRequestManager.IGetChannelInfoCallBack callBack) {
        this.cInfoRequestManager.getChannelInfo(cid, infoSelector, callBack);
    }

    public void getAllMembers(String gid, long ver, BaseRequestManager.IGetAllMembersCallBack callBack) {
        this.roleRequestManager.getAllMembers(gid, ver, callBack);
    }

    public void setName(String gid, String name, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.setName(gid, name, callBack);
    }

    public void updateCategory(String gid, int firstType, int secondType, boolean updateToIndieGameSourceIfCategoryIsGame, BaseRequestManager.IRequestCallBack callback2) {
        this.cInfoRequestManager.updateCategory(gid, firstType, secondType, updateToIndieGameSourceIfCategoryIsGame, callback2);
    }

    public void setChannelAvatar(String gid, String url, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.setChannelAvatar(gid, url, callBack);
    }

    public void setAnnouncement(String gid, String announcement, boolean withPush, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.setAnnouncement(gid, announcement, withPush, callBack);
    }

    public void changeFamilyGate(String gid, FamilyGateInfo gateInfo, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.changeFamilyGateInfo(gid, gateInfo, callBack);
    }

    public void setEnterMode(String gid, int enterMode, String password, int lockEnterMode, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.setEnterMode(gid, enterMode, password, lockEnterMode, callBack);
    }

    public void setOpenPartyPermission(String gid, boolean forbidMember, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.setOpenPartyPermission(gid, forbidMember, callBack);
    }

    public void setSpeakMode(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.setSpeakMode(gid, mode, callBack);
    }

    public void setVoiceEnterMode(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.setVoiceEnterMode(gid, mode, callBack);
    }

    public void updateChannelPostPermission(String gid, int content, int role, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.updateChannelPostPermission(gid, content, role, callBack);
    }

    public void updateChannelPostPermission(String gid, int content, int role, int topPerm, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.updateChannelPostPermission(gid, content, role, topPerm, callBack);
    }

    public void setGuestSpeakLimit(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.setGuestSpeakLimit(gid, mode, callBack);
    }

    public void updatePrivacyMode(String gid, boolean privatePrivacy, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.updatePrivacyMode(gid, privatePrivacy, callBack);
    }

    public void updateRoleJoinMode(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.updateRoleJoinMode(gid, mode, callBack);
    }

    public void updateLightEffect(String gid, String lightEffect, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.updateLightEffect(gid, lightEffect, callBack);
    }

    public void updateTag(String gid, ArrayList<String> tagIds, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.updateTag(gid, tagIds, callBack);
    }

    public void updateOpenVoiceChatMode(String gid, int mode, BaseRequestManager.IRequestCallBack callBack) {
        this.cInfoRequestManager.updateOpenVoiceChatMode(gid, mode, callBack);
    }

    public void setBanned(String gid, long uid, long banTime, BaseRequestManager.IRequestCallBack callBack) {
        this.roleRequestManager.setBanned(gid, uid, banTime, callBack);
    }

    public void getChannelOnlineUserList(String gid, ProtoManager.Page page, BaseRequestManager.IGetUserListWithTotalCallBack callBack) {
        this.roleRequestManager.getChannelOnlineUserList(gid, page, callBack);
    }

    public void getOnlineUserList(String gid, ProtoManager.Page page, BaseRequestManager.IGetUserListWithTotalCallBack callBack) {
        this.roleRequestManager.getOnlineUserList(gid, page, false, callBack);
    }

    public void getPotentialOnlineUserList(String gid, ProtoManager.Page page, BaseRequestManager.IGetUserListWithTotalCallBack callBack) {
        this.roleRequestManager.getOnlineUserList(gid, page, true, callBack);
    }

    public void getChannelOnlineUserWithStatusList(String gid, ProtoManager.Page page, BaseRequestManager.IGetUserListWithWithStatusCallBack callBack) {
        this.roleRequestManager.getChannelOnlineUserWithStatusList(gid, page, callBack);
    }

    public void getRoleList(String gid, int roleType, int num, int offset, BaseRequestManager.IGetUserListWithTotalCallBack callBack) {
    }

    public void queryUserInWhereChannel(boolean includePrivate, boolean onlyMember, boolean restOnline, List<Long> uids, IRoleService.IQueryUsersInChannelCallBack callBack) {
        RoleRequestManager.getCurrentChannels(includePrivate, onlyMember, restOnline, uids, callBack);
    }

    public void getBanned(String gid, long uid, BaseRequestManager.IIsBannedCallBack callBack) {
        this.roleRequestManager.getBanned(gid, uid, callBack);
    }

    public void updateDoNotDisturb(String cid, boolean switchOn, IMsgService.ISetDoNotDisturbCallBack callBack) {
        this.cInfoRequestManager.updateDoNotDisturb(cid, switchOn, callBack);
    }

    public void getInviteEnterToken(String cid, IDataService.IGetInviteTokenCallBack callBack) {
        this.cInfoRequestManager.getInviteEnterToken(cid, callBack);
    }

    public void setRole(String gid, long uid, int roleType, String joinFrom, IRoleService.ISetRoleCallBack callBack) {
        this.roleRequestManager.setRole(gid, uid, roleType, joinFrom, callBack);
    }

    public void acceptRole(String cid, String inviteId, boolean accept, IRoleService.IAcceptRoleInviteCallBack callBack) {
        this.roleRequestManager.acceptRole(cid, inviteId, accept, callBack);
    }

    public void applyJoin(String cid, String joinFrom, String invitedId, IRoleService.IJoinApplyCallBack callback2) {
        this.roleRequestManager.applyJoin(cid, joinFrom, invitedId, callback2);
    }

    public void joinApprove(String cid, JoinApproveData data2, IRoleService.IJoinApproveCallBack callBack) {
        this.roleRequestManager.joinApprove(cid, data2, callBack);
    }

    public void setRole(String cid, HashMap<Long, Integer> uidAndRoles, String joinFrom, IRoleService.ISetRolesCallBack callBack) {
        this.roleRequestManager.setRoles(cid, uidAndRoles, joinFrom, callBack);
    }

    public void sendProbeRequest(String cid, String data2) {
        this.joinRequestManager.sendProbeRequest(cid, data2);
    }

    public void fetchAcrossRecommendList(String channelId, String guideCid, String pid, int recommendType, @Nullable String pluginId, boolean videoMode, IDataService.IGetAcrossRecommendListCallback callback2) {
        this.cInfoRequestManager.fetchAcrossRecommendList(channelId, guideCid, pid, recommendType, pluginId, videoMode, callback2);
    }

    public void fetchRecommendGangUpList(@NotNull BaseRequestManager.IGetGangUpRecommendListCallback callback2) {
        this.cInfoRequestManager.fetchGangUpRecommendList(callback2);
    }

    public void pullBlackThisChannel(final String cid, final IChannel.IPullBackCallBack callBack) {
        ReportBlockChannelReq req = new ReportBlockChannelReq.Builder().cid(cid).build();
        MLog.info((Object)TAG, (String)"pullBlackThisChannel cid:%s", (Object[])new Object[]{cid});
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(cid, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<ReportBlockChannelRes>(){

            @Deprecated
            @UiThread
            public void onResponse(@Nullable ReportBlockChannelRes message) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("ChannelRequest error, use old result!");
                }
            }

            @UiThread
            public void onResponse(@NonNull ReportBlockChannelRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (callBack != null) {
                        callBack.onSuccess(cid);
                    }
                    MLog.info((Object)ChannelRequestManager.TAG, (String)"pullBlackThisChannel success cid:%s", (Object[])new Object[]{cid});
                    BaseRequestManager.statMetric((String)"channel/pullblack", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                } else {
                    MLog.info((Object)ChannelRequestManager.TAG, (String)"pullBlackThisChannel code:%d,tips:%s", (Object[])new Object[]{code, message.result != null ? message.result.errmsg : ""});
                    BaseRequestManager.statMetric((String)"channel/pullblack", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)ChannelRequestManager.TAG, (String)"pullBlackThisChannel Timeout!", (Object[])new Object[0]);
                        BaseRequestManager.statMetric((String)"channel/pullblack", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)ChannelRequestManager.TAG, (String)"pullBlackThisChannel netError code:%d, reason:%s!", (Object[])new Object[]{code, reason});
                        BaseRequestManager.statMetric((String)"channel/pullblack", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    }
                });
                return false;
            }
        });
    }

    public void getChannelNotice(long offset, final long limit, long snap, final ICommonCallback<NoticeResp> callback2) {
        ProtoManager.Page page = new ProtoManager.Page();
        page.offset = offset;
        page.limit = limit;
        page.snap = snap;
        GetNoticeReq getNoticeReq = new GetNoticeReq.Builder().page(ProtoManager.obtainPage((ProtoManager.Page)page)).build();
        ProgressDialog progressDialog2 = new ProgressDialog();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getNoticeReq, (IProtoCallback)new IProtoCallback<GetNoticeRes>(){

            public void onResponse(final @NonNull GetNoticeRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                String errorMsg = "";
                if (!ProtoManager.isSuccessCode((long)code)) {
                    errorMsg = StringUtils.formatWitUSLocal((String)"getChannelNotice error, code:%s, msg:%s", (Object[])new Object[]{code, msg});
                    FeatureLog.i((String)"FTChannelNotice", (String)errorMsg, (Object[])new Object[0]);
                    if (callback2 != null) {
                        callback2.onFail(-1, errorMsg, new Object[0]);
                    }
                    return;
                }
                if (message.page != null && message.result != null) {
                    Page resultPage = message.page;
                    final long mOffset = resultPage.offset;
                    final long mSnap = resultPage.snap;
                    boolean hasMore = resultPage.offset != null && resultPage.offset.equals(message.page.total);
                    FeatureLog.i((String)"FTChannelNotice", (String)"getChannelNotice success result offset:%s, snap:%s, totalCount:%s, hasMore:%b", (Object[])new Object[]{resultPage.offset, resultPage.snap, resultPage.total, hasMore});
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (message == null) {
                                return;
                            }
                            List msgItemList = message.items;
                            ArrayList<Notify> notifyList = new ArrayList<Notify>();
                            for (NoticeItem item : msgItemList) {
                                try {
                                    Notify notify2 = (Notify)Notify.ADAPTER.decode(item.payload);
                                    notifyList.add(notify2);
                                }
                                catch (Exception e) {
                                    FeatureLog.i((String)"FTChannelNotice", (String)"parseNotify error:%s", (Object[])new Object[]{e.toString()});
                                }
                            }
                            final ArrayList<ChannelNotify> channelNotifyList = ChannelNotifyHandler.parseRoleMsgNotifys(notifyList);
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ArrayList<Long> channelNotifyUidList = new ArrayList<Long>();
                                    ArrayList<ChannelNoticeMessage> result = new ArrayList<ChannelNoticeMessage>();
                                    for (ChannelNotify channelNotify : channelNotifyList) {
                                        ChannelNoticeMessage channelNoticeMessage;
                                        if (channelNotify == null || (channelNoticeMessage = ChannelMessageCreator.createNoticeMessageFrom(channelNotify, false)) == null) continue;
                                        channelNotifyUidList.add(channelNoticeMessage.getChannelOwnerId());
                                        result.add(channelNoticeMessage);
                                    }
                                    NoticeResp noticeResp = new NoticeResp();
                                    noticeResp.limit = limit;
                                    noticeResp.notice = result;
                                    noticeResp.snap = mSnap;
                                    noticeResp.offset = mOffset;
                                    if (callback2 != null) {
                                        callback2.onSuccess((Object)noticeResp, new Object[0]);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    errorMsg = "getChannelNotice not page or not result";
                    if (callback2 != null) {
                        callback2.onFail(-2, errorMsg, new Object[0]);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                String errMsg = "getChannelNotice timeout";
                FeatureLog.i((String)"FTChannelNotice", (String)errMsg, (Object[])new Object[0]);
                if (callback2 != null) {
                    callback2.onFail(-3, errMsg, new Object[0]);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                String errorMsg = StringUtils.formatWitUSLocal((String)"getChannelNotice code:%s, reason:%s", (Object[])new Object[]{code, reason});
                FeatureLog.i((String)"FTChannelNotice", (String)errorMsg, (Object[])new Object[0]);
                if (callback2 != null) {
                    callback2.onFail(-4, errorMsg, new Object[0]);
                }
                return false;
            }
        });
    }

    public void getMyJoinedFamilyChannel(ICommonCallback<MyJoinChannelItem> callback2) {
        this.joinRequestManager.getMyJoinedFamilyChannel(callback2);
    }

    public void getFamilyInfo(String fid, ICommonCallback<GetFamilyProfileRes> callback2) {
        this.joinRequestManager.getFamilyInfo(fid, callback2);
    }

    public void updateGroupChatBg(String cid, String bgUrl, BaseRequestManager.IRequestCallBack callback2) {
        this.cInfoRequestManager.updateGroupChatBg(cid, bgUrl, callback2);
    }

    public void clearGroupChatBg(String cid, BaseRequestManager.IRequestCallBack callback2) {
        this.cInfoRequestManager.clearGroupChatBg(cid, callback2);
    }

    public void updateSendPicSwitch(String cid, boolean picSwitch, ICommonCallback<Boolean> callback2) {
        this.cInfoRequestManager.updateSendPicSwitch(cid, picSwitch, callback2);
    }

    public void getSongChannels(int limit, IChannelCenterService.IGetSongChannelCallback callback2) {
        this.listenTogetherRequestManager.getSongChannels(limit, callback2);
    }
}

