/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.notify;

import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.callback.IChannelNotifyHandler;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IImMsgMatcher;
import com.yy.hiyo.channel.cbase.publicscreen.msg.ChallengeStateMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameChallengeMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteCancelMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameInviteMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameLobbyMatchMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GameLobbyMatchStateMsg;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SysTextMsg;
import com.yy.hiyo.channel.component.textgroup.GroupUtils;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.service.msg.IChannelMsgModel;
import com.yy.hiyo.channel.service.notify.BaseNotifyHandler;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SignalNotifyHandler
extends BaseNotifyHandler {
    private static final String TAG = "ChannelNotifyHandler_Signal";

    public SignalNotifyHandler(BaseNotifyHandler.ICallBack callback2) {
        super(callback2);
    }

    public static void parseRolesSignalMsg(String gid, BaseImMsg msgItem, ArrayList<ChannelNotify> channelNotifies) {
        if (msgItem == null || !GroupUtils.containFlag(msgItem.getFlags(), 1) || !GroupUtils.containFlag(msgItem.getFlags(), 16)) {
            return;
        }
        List msgSections = msgItem.getSections();
        if (msgSections == null || msgSections.isEmpty()) {
            return;
        }
        for (MsgSection msgSection : msgSections) {
            if (msgSection == null) continue;
            NotifyDataDefine.SignalContext signalContext = (NotifyDataDefine.SignalContext)JsonParser.parseJsonObject((String)msgSection.getExtention(), NotifyDataDefine.SignalContext.class);
            if (signalContext != null) {
                signalContext.cname = msgItem.getChannelName();
                signalContext.time = msgItem.getTs();
                signalContext.msgId = msgItem.getMsgId();
                signalContext.pwd = msgItem.getPwd();
                signalContext.seqId = msgItem.getSeqid();
                signalContext.channelOwnerId = msgItem.getChannelOwnerId();
                signalContext.channelSource = msgItem.getChannelSource();
                if (StringUtils.isEmpty((String)signalContext.cid) && RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("signalContext error:" + msgSection.getExtention() + "!");
                }
            } else if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("signalContext error:" + msgSection.getExtention() + "!");
            }
            if (msgSection.getType() == 1100) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.JoinApply.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 1101) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.JoinApprove.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 1102) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.SetRole.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 1103) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.AcceptRole.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 1107) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.UserRoleChange.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 1001) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.DisbandGroup.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 3700) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.InviteApprove.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 3701) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.InviteApproveStatus.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 1013) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.SetHiddenChannelNick.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() == 1014) {
                channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.SetHiddenChannelTitle.class, gid, msgSection.getContent(), signalContext, msgItem));
                continue;
            }
            if (msgSection.getType() != 1015) continue;
            channelNotifies.add(SignalNotifyHandler.parseData(NotifyDataDefine.SetPicSendMode.class, gid, msgSection.getContent(), signalContext, msgItem));
        }
    }

    private static ChannelNotify parseData(Class clz, String gid, String content, NotifyDataDefine.SignalContext signalContext, BaseImMsg msgItem) {
        if (StringUtils.isEmpty((String)content)) {
            return null;
        }
        Object data2 = JsonParser.parseJsonObject((String)content, (Class)clz);
        if (data2 == null || !(data2 instanceof NotifyDataDefine.AbsSignal)) {
            return null;
        }
        ((NotifyDataDefine.AbsSignal)data2).updateSignalContext(signalContext);
        ChannelNotify channelNotify = new ChannelNotify();
        channelNotify.cid = gid;
        channelNotify.notify = new ChannelNotify.Notify();
        if (data2 instanceof NotifyDataDefine.JoinApply) {
            channelNotify.uri = ChannelNotify.Uri.UriJoinApplyNotify;
            channelNotify.notify.joinApply = (NotifyDataDefine.JoinApply)data2;
            channelNotify.notify.joinApply.applyerUid = channelNotify.notify.joinApply.getUid();
            channelNotify.notify.joinApply.applyerNick = channelNotify.notify.joinApply.getOperNick();
            channelNotify.notify.joinApply.applyAvatar = msgItem.getAvatarUrl();
            channelNotify.notify.joinApply.channelType = msgItem.getChannelType();
            channelNotify.notify.joinApply.channelAvatar = msgItem.getChannelAvatar();
            channelNotify.notify.joinApply.version = msgItem.getVersion();
        } else if (data2 instanceof NotifyDataDefine.JoinApprove) {
            channelNotify.uri = ChannelNotify.Uri.UriJoinApproveNotify;
            channelNotify.notify.joinApprove = (NotifyDataDefine.JoinApprove)data2;
            channelNotify.notify.joinApprove.masterUid = channelNotify.notify.joinApprove.getUid();
            channelNotify.notify.joinApprove.masterNick = msgItem.getNick();
            channelNotify.notify.joinApprove.masterAvatar = msgItem.getAvatarUrl();
            channelNotify.notify.joinApprove.channelType = msgItem.getChannelType();
            channelNotify.notify.joinApprove.channelAvatar = msgItem.getChannelAvatar();
            channelNotify.notify.joinApprove.version = msgItem.getVersion();
        } else if (data2 instanceof NotifyDataDefine.SetRole) {
            channelNotify.uri = ChannelNotify.Uri.UriSetRoleNotify;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.setRole = (NotifyDataDefine.SetRole)data2;
            channelNotify.notify.setRole.masterNick = channelNotify.notify.setRole.getOperNick();
            channelNotify.notify.setRole.masterUid = channelNotify.notify.setRole.getUid();
            channelNotify.notify.setRole.role = msgItem.getRole();
            channelNotify.notify.setRole.uid = msgItem.getFrom();
            channelNotify.notify.setRole.masterAvatar = msgItem.getAvatarUrl();
            channelNotify.notify.setRole.channelType = msgItem.getChannelType();
            channelNotify.notify.setRole.channelAvatar = msgItem.getChannelAvatar();
            channelNotify.notify.setRole.version = msgItem.getVersion();
        } else if (data2 instanceof NotifyDataDefine.AcceptRole) {
            channelNotify.uri = ChannelNotify.Uri.UriAcceptRoleNotify;
            channelNotify.notify.acceptRole = (NotifyDataDefine.AcceptRole)data2;
            channelNotify.notify.acceptRole.masterUid = msgItem.getFrom();
            channelNotify.notify.acceptRole.masterNick = msgItem.getNick();
            channelNotify.notify.acceptRole.masterAvatar = msgItem.getAvatarUrl();
            channelNotify.notify.acceptRole.channelType = msgItem.getChannelType();
            channelNotify.notify.acceptRole.channelAvatar = msgItem.getChannelAvatar();
            channelNotify.notify.acceptRole.version = msgItem.getVersion();
        } else if (data2 instanceof NotifyDataDefine.UserRoleChange) {
            channelNotify.uri = ChannelNotify.Uri.UriUserRoleChangeNotify;
            channelNotify.notify.userRoleChange = (NotifyDataDefine.UserRoleChange)data2;
            channelNotify.notify.userRoleChange.masterNick = msgItem.getNick();
            channelNotify.notify.userRoleChange.masterAvatar = msgItem.getAvatarUrl();
            channelNotify.notify.userRoleChange.channelType = msgItem.getChannelType();
            channelNotify.notify.userRoleChange.channelAvatar = msgItem.getChannelAvatar();
            channelNotify.notify.userRoleChange.version = msgItem.getVersion();
        } else if (data2 instanceof NotifyDataDefine.SetRemark) {
            channelNotify.uri = ChannelNotify.Uri.UriSetRoleRemarkNotify;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.setRemark = (NotifyDataDefine.SetRemark)data2;
        } else if (data2 instanceof NotifyDataDefine.SetJoinChannelMode) {
            channelNotify.uri = ChannelNotify.Uri.UriBeRoleMode;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.beRoleMode = (NotifyDataDefine.SetJoinChannelMode)data2;
        } else if (data2 instanceof NotifyDataDefine.SetPrivacyMode) {
            channelNotify.uri = ChannelNotify.Uri.UriSetPrivacyModeNotify;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.privacyMode = (NotifyDataDefine.SetPrivacyMode)data2;
        } else if (data2 instanceof NotifyDataDefine.SetVoiceOpenMode) {
            channelNotify.uri = ChannelNotify.Uri.UriSetVoiceOpenModeNotify;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.voiceOpenMode = (NotifyDataDefine.SetVoiceOpenMode)data2;
        } else if (data2 instanceof NotifyDataDefine.DisbandGroup) {
            channelNotify.uri = ChannelNotify.Uri.UriDisbandChannel;
            channelNotify.notify.disbandGroup = (NotifyDataDefine.DisbandGroup)data2;
            channelNotify.notify.disbandGroup.fromNick = msgItem.getNick();
        } else if (data2 instanceof NotifyDataDefine.ChannelNewPost) {
            channelNotify.uri = ChannelNotify.Uri.UriChannelNewPost;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.channelNewPost = (NotifyDataDefine.ChannelNewPost)data2;
        } else if (data2 instanceof NotifyDataDefine.ChannelNewMember) {
            channelNotify.uri = ChannelNotify.Uri.UriChannelNewMEMBER;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.mChannelNewMember = (NotifyDataDefine.ChannelNewMember)data2;
        } else if (data2 instanceof NotifyDataDefine.AnchorSitDown) {
            channelNotify.uri = ChannelNotify.Uri.UriAnchorSitDown;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.anchorSitDown = (NotifyDataDefine.AnchorSitDown)data2;
        } else if (data2 instanceof NotifyDataDefine.SubFirstOnline) {
            channelNotify.uri = ChannelNotify.Uri.UriSubFirstOnline;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.subFirstOnline = (NotifyDataDefine.SubFirstOnline)data2;
        } else if (data2 instanceof NotifyDataDefine.SubSecondOnline) {
            channelNotify.uri = ChannelNotify.Uri.UriSubSecondOnline;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.subSecondOnline = (NotifyDataDefine.SubSecondOnline)data2;
        } else if (data2 instanceof NotifyDataDefine.SetAllMemeberDistrub) {
            channelNotify.uri = ChannelNotify.Uri.UriSetAllMemberDisturb;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.setAllMemeberDistrub = (NotifyDataDefine.SetAllMemeberDistrub)data2;
        } else if (data2 instanceof NotifyDataDefine.ChannelShowPermit) {
            channelNotify.uri = ChannelNotify.Uri.UriChannelShowPermit;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.channelShowPermitNotify = (NotifyDataDefine.ChannelShowPermit)data2;
        } else if (data2 instanceof NotifyDataDefine.ChannelLightEffect) {
            channelNotify.uri = ChannelNotify.Uri.UriChannelLightEffect;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.channelLightEffectNotify = (NotifyDataDefine.ChannelLightEffect)data2;
        } else if (data2 instanceof NotifyDataDefine.InviteApprove) {
            channelNotify.uri = ChannelNotify.Uri.UriChannelInviteApprove;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.inviteApprove = (NotifyDataDefine.InviteApprove)data2;
        } else if (data2 instanceof NotifyDataDefine.InviteApproveStatus) {
            channelNotify.uri = ChannelNotify.Uri.UriChannelInviteApproveStatus;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.inviteApproveStatus = (NotifyDataDefine.InviteApproveStatus)data2;
        } else if (data2 instanceof NotifyDataDefine.SetHiddenChannelNick) {
            channelNotify.uri = ChannelNotify.Uri.UriSetHiddenChannelNick;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.setHiddenChannelNick = (NotifyDataDefine.SetHiddenChannelNick)data2;
        } else if (data2 instanceof NotifyDataDefine.SetHiddenChannelTitle) {
            channelNotify.uri = ChannelNotify.Uri.UriSetShowChannelTitle;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.setHiddenChannelTitle = (NotifyDataDefine.SetHiddenChannelTitle)data2;
        } else if (data2 instanceof NotifyDataDefine.SetPicSendMode) {
            channelNotify.uri = ChannelNotify.Uri.UriSetPicSendMode;
            channelNotify.notify = new ChannelNotify.Notify();
            channelNotify.notify.setPicSendMode = (NotifyDataDefine.SetPicSendMode)data2;
        }
        return channelNotify;
    }

    private boolean handleBaseSignalMsg(String gid, BaseImMsg msgItem) {
        boolean handled = false;
        if (msgItem == null || !GroupUtils.containFlag(msgItem.getFlags(), 1) || !GroupUtils.containFlag(msgItem.getFlags(), 16)) {
            return handled;
        }
        List msgSections = msgItem.getSections();
        if (msgSections == null || msgSections.isEmpty()) {
            return handled;
        }
        for (MsgSection msgSection : msgSections) {
            if (msgSection == null) continue;
            NotifyDataDefine.SignalContext signalContext = (NotifyDataDefine.SignalContext)JsonParser.parseJsonObject((String)msgSection.getExtention(), NotifyDataDefine.SignalContext.class);
            if (signalContext != null) {
                signalContext.cname = msgItem.getChannelName();
                signalContext.time = msgItem.getTs();
                signalContext.msgId = msgItem.getMsgId();
                signalContext.pwd = msgItem.getPwd();
                signalContext.seqId = msgItem.getSeqid();
                signalContext.channelOwnerId = msgItem.getChannelOwnerId();
                signalContext.channelSource = msgItem.getChannelSource();
                if (StringUtils.isEmpty((String)signalContext.cid) && RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("signalContext error:" + msgSection.getExtention() + "!");
                }
            } else if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("signalContext error:" + msgSection.getExtention() + "!");
            }
            if (msgSection.getType() == 1003) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.SetName.class, signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1004) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.SetAnnouncement.class, msgSection.getExtention(), NotifyDataDefine.Extention.class, signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1006) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.SetJoinMode.class, signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 1005) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.SetSpeakMode.class, msgSection.getExtention(), NotifyDataDefine.Extention.class, signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1011) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.SetGuestSpeakLimit.class, msgSection.getExtention(), NotifyDataDefine.Extention.class, signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1010) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.SetVoiceEnterMode.class, msgSection.getExtention(), NotifyDataDefine.Extention.class, signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1000) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.CreateGroup.class, signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 1001) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.DisbandGroup.class, signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 2003) {
                this.handleWithDrawMsg(gid, msgItem.getMsgId(), msgItem, signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 1100) {
                this.handleJoinApplyMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1101) {
                this.handleJoinApproveMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1102) {
                this.handleSetRoleMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1103) {
                this.handleAcceptRoleMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 1107) {
                this.handleUserRoleChanged(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1106) {
                this.handleSetRemarkMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 1104) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.SpeakBan.class, msgSection.getExtention(), NotifyDataDefine.Extention.class, signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1105) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.KickOff.class, signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1007) {
                this.handleSetBeRoleModeMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1002) {
                this.handleSetPrivacyMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 1008) {
                this.handleSetVoiceOpenModeMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 1012) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.SetTags.class, signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3200) {
                this.handleChannelNewPostMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3310) {
                this.handleChannelNewMemberMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3400) {
                this.handleAnchorSitDownMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3401) {
                this.handleSubFirstOnlineMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3402) {
                this.handleSubSecondOnlineMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3500) {
                this.handleChannelRobotMsg(gid, msgItem, msgSection.getContent(), signalContext, 3500);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3501) {
                this.handleChannelRobotMsg(gid, msgItem, msgSection.getContent(), signalContext, 3500);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3502) {
                this.handleChannelRobotMsg(gid, msgItem, msgSection.getContent(), signalContext, 3502);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3503) {
                this.handleChannelRobotMsg(gid, msgItem, msgSection.getContent(), signalContext, 3503);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 3603) {
                this.handleServerSignal(gid, msgSection.getType(), msgItem, msgSection.getContent(), NotifyDataDefine.FamilyShowNotify.class, signalContext);
                handled = true;
                continue;
            }
            if (msgSection.getType() == 3607) {
                this.handleSetAllMemberDisturb(gid, msgItem, msgSection.getContent(), signalContext);
                continue;
            }
            if (msgSection.getType() == 3608) {
                this.handleChannelShowPermit(gid, msgItem, msgSection.getContent(), signalContext);
                continue;
            }
            if (msgSection.getType() == 3700) {
                this.handleInviteApprove(gid, msgItem, msgSection.getContent(), signalContext);
                continue;
            }
            if (msgSection.getType() == 3701) {
                this.handleInviteApproveStatus(gid, msgItem, msgSection.getContent(), signalContext);
                continue;
            }
            if (msgSection.getType() == 1013) {
                this.handleSetHiddenChannelNickMsg(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() == 1014) {
                this.handleSetShowChannelTitle(gid, msgItem, msgSection.getContent(), signalContext);
                handled = false;
                continue;
            }
            if (msgSection.getType() != 1015) continue;
            this.handleSetPicModeMsg(gid, msgItem, msgSection.getContent(), signalContext);
            handled = false;
        }
        return handled;
    }

    private void handleSetShowChannelTitle(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetHiddenChannelTitle.class, gid, content, signalContext, msgItem));
    }

    private void handleSetHiddenChannelNickMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetHiddenChannelNick.class, gid, content, signalContext, msgItem));
    }

    private void handleInviteApproveStatus(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.InviteApproveStatus.class, gid, content, signalContext, msgItem));
    }

    private void handleSetPicModeMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetPicSendMode.class, gid, content, signalContext, msgItem));
    }

    private void handleInviteApprove(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.InviteApprove.class, gid, content, signalContext, msgItem));
    }

    private void handleSetAllMemberDisturb(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetAllMemeberDistrub.class, gid, content, signalContext, msgItem));
    }

    private void handleChannelShowPermit(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.ChannelShowPermit.class, gid, content, signalContext, msgItem));
    }

    private void handleCHannelLightEffect(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.ChannelLightEffect.class, gid, content, signalContext, msgItem));
    }

    private void handleSubSecondOnlineMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SubSecondOnline.class, gid, content, signalContext, msgItem));
    }

    private void handleSubFirstOnlineMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SubFirstOnline.class, gid, content, signalContext, msgItem));
    }

    private void handleAnchorSitDownMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.AnchorSitDown.class, gid, content, signalContext, msgItem));
    }

    private void handleChannelNewPostMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.ChannelNewPost.class, gid, content, signalContext, msgItem));
    }

    private void handleChannelNewMemberMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.ChannelNewMember.class, gid, content, signalContext, msgItem));
    }

    private void handleChannelRobotMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext, int type) {
        if (type == 3500) {
            this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.ChannelRobotWelcomeMsg.class, gid, content, signalContext, msgItem));
        } else if (type == 3501) {
            this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.ChannelRobotTATMsg.class, gid, content, signalContext, msgItem));
        } else if (type == 3502) {
            this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.ChannelRobotSystemMsg.class, gid, content, signalContext, msgItem));
        } else if (type == 3503) {
            this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.ChannelRobotAtMsg.class, gid, content, signalContext, msgItem));
        }
    }

    private boolean handleExtSignalMsg(String gid, final BaseImMsg msgItem) {
        if (msgItem == null) {
            return false;
        }
        List msgSections = msgItem.getSections();
        if (msgSections == null || msgSections.isEmpty()) {
            return false;
        }
        boolean handled = false;
        for (MsgSection msgSection : msgSections) {
            IChannelMsgModel model;
            if (msgSection == null) continue;
            if (msgItem instanceof GameInviteMsg) {
                String gameId = ((GameInviteMsg)msgItem).getGameInviteState().getGameId();
                if (!StringUtils.isNotEmpty((String)gameId)) continue;
                GameInfo gameInfoByGid = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                if (gameInfoByGid == null) {
                    MLog.info((Object)TAG, (String)"GameInviteMsg game id:%s with no game info null!!!", (Object[])new Object[0]);
                    handled = true;
                    continue;
                }
                if (((GameInviteMsg)msgItem).getGameInviteState().getGameInfo() != null) continue;
                ((GameInviteMsg)msgItem).getGameInviteState().setGameInfo(gameInfoByGid);
                continue;
            }
            if (msgItem instanceof GameInviteCancelMsg && this.callback != null) {
                String cancelPkId;
                model = this.callback.getMsgModel();
                if (model == null || StringUtils.isEmpty((String)(cancelPkId = ((GameInviteCancelMsg)msgItem).getPkId()))) continue;
                model.findMsg(msgItem.getCid(), new IImMsgMatcher(){

                    public boolean match(BaseImMsg msg, int position) {
                        String pkId;
                        return msg instanceof GameInviteMsg && StringUtils.isNotEmpty((String)(pkId = ((GameInviteMsg)msg).getPkId())) && pkId.equals(cancelPkId);
                    }
                }, new IMsgService.IGetMsgCallBack(){

                    public void onMsg(String channelId, BaseImMsg msg) {
                        if (msg instanceof GameInviteMsg) {
                            GameInviteMsg replaceMsg = (GameInviteMsg)msg;
                            replaceMsg.getGameInviteState().setState(4);
                            replaceMsg.getGameInviteState().setCancelType(((GameInviteCancelMsg)msgItem).getCancelType());
                        }
                    }
                });
                continue;
            }
            if (msgItem instanceof ChallengeStateMsg && this.callback != null) {
                String cancelteamId;
                model = this.callback.getMsgModel();
                if (model == null || StringUtils.isEmpty((String)(cancelteamId = ((ChallengeStateMsg)msgItem).getCardId()))) continue;
                model.findMsg(msgItem.getCid(), new IImMsgMatcher(){

                    public boolean match(BaseImMsg msg, int position) {
                        String cardId;
                        return msg instanceof GameChallengeMsg && StringUtils.isNotEmpty((String)(cardId = ((GameChallengeMsg)msg).getCardId())) && cardId.equals(cancelteamId);
                    }
                }, new IMsgService.IGetMsgCallBack(){

                    public void onMsg(String channelId, BaseImMsg msg) {
                        if (msg instanceof GameChallengeMsg) {
                            GameChallengeMsg replaceMsg = (GameChallengeMsg)msg;
                            replaceMsg.setChallengeState(((ChallengeStateMsg)msgItem).getChallengeState());
                            replaceMsg.setChallengerUid(((ChallengeStateMsg)msgItem).getCUid());
                        }
                    }
                });
                continue;
            }
            if (msgItem instanceof GameLobbyMatchStateMsg && this.callback != null) {
                String cancelTeamId;
                model = this.callback.getMsgModel();
                if (model == null || StringUtils.isEmpty((String)(cancelTeamId = ((GameLobbyMatchStateMsg)msgItem).getTeamId()))) continue;
                model.findMsg(msgItem.getCid(), new IImMsgMatcher(){

                    public boolean match(BaseImMsg msg, int position) {
                        String teamId;
                        return msg instanceof GameLobbyMatchMsg && StringUtils.isNotEmpty((String)(teamId = ((GameLobbyMatchMsg)msg).getTeamId())) && teamId.equals(cancelTeamId);
                    }
                }, new IMsgService.IGetMsgCallBack(){

                    public void onMsg(String channelId, BaseImMsg msg) {
                        if (msg instanceof GameLobbyMatchMsg) {
                            GameLobbyMatchMsg replaceMsg = (GameLobbyMatchMsg)msg;
                            MLog.info((Object)SignalNotifyHandler.TAG, (String)("msg:" + replaceMsg.hashCode()), (Object[])new Object[0]);
                            replaceMsg.setMatchState(((GameLobbyMatchStateMsg)msgItem).getMatchState());
                        }
                    }
                });
                continue;
            }
            if (msgSection.getType() != 3620) continue;
            NotifyDataDefine.SignalContext signalContext = (NotifyDataDefine.SignalContext)JsonParser.parseJsonObject((String)msgSection.getExtention(), NotifyDataDefine.SignalContext.class);
            this.handleCHannelLightEffect(gid, msgItem, msgSection.getContent(), signalContext);
        }
        return handled;
    }

    public boolean handleSignalMsg(String gid, BaseImMsg msgItem) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"handleSignalMsg cid:%s,msgItem:%s", (Object[])new Object[]{gid, msgItem.toString()});
        }
        boolean handled = false;
        handled = this.handleBaseSignalMsg(gid, msgItem);
        if (handled) {
            if (!RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"handleSignalMsg cid:%s,msgItem id:%s,type:%d, handled:%d by inner", (Object[])new Object[]{gid, msgItem.getMsgId(), msgItem.getMsgType(), 1});
            }
            return handled;
        }
        handled = this.handleExtSignalMsg(gid, msgItem);
        if (!RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"handleSignalMsg cid:%s,msgItem id:%s,type:%d, handled:%d by inner", (Object[])new Object[]{gid, msgItem.getMsgId(), msgItem.getMsgType(), 0});
        }
        return handled;
    }

    private void handleJoinApplyMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.JoinApply.class, gid, content, signalContext, msgItem));
    }

    private void handleJoinApproveMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.JoinApprove.class, gid, content, signalContext, msgItem));
    }

    private void handleSetRoleMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetRole.class, gid, content, signalContext, msgItem));
    }

    private void handleAcceptRoleMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        ChannelNotify channelNotify = SignalNotifyHandler.parseData(NotifyDataDefine.AcceptRole.class, gid, content, signalContext, msgItem);
        if (channelNotify == null) {
            return;
        }
        this.callback.getNormalHandler().dispatchChannelNotify(gid, channelNotify);
    }

    private void handleUserRoleChanged(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        ChannelNotify channelNotify = SignalNotifyHandler.parseData(NotifyDataDefine.UserRoleChange.class, gid, content, signalContext, msgItem);
        if (channelNotify == null) {
            return;
        }
        this.callback.getNormalHandler().dispatchChannelNotify(gid, channelNotify);
    }

    private void handleSetRemarkMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetRemark.class, gid, content, signalContext, msgItem));
    }

    private void handleSetBeRoleModeMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetJoinChannelMode.class, gid, content, signalContext, msgItem));
    }

    private void handleSetPrivacyMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetPrivacyMode.class, gid, content, signalContext, msgItem));
    }

    private void handleSetVoiceOpenModeMsg(String gid, BaseImMsg msgItem, String content, NotifyDataDefine.SignalContext signalContext) {
        this.callback.getNormalHandler().dispatchChannelNotify(gid, SignalNotifyHandler.parseData(NotifyDataDefine.SetVoiceOpenMode.class, gid, content, signalContext, msgItem));
    }

    private void handleWithDrawMsg(String gid, String msgId, BaseImMsg msgItem, NotifyDataDefine.SignalContext signalContext) {
        List sections = msgItem.getSections();
        if (sections != null && !sections.isEmpty()) {
            for (MsgSection section : sections) {
                if (section.getType() != 2003) {
                    MLog.info((Object)"FTRoomGroupSigNotify", (String)"type is not withdraw!!!", (Object[])new Object[0]);
                    return;
                }
                String content = section.getContent();
                MLog.info((Object)"FTRoomGroupSigNotify", (String)"withdraw content:%s", (Object[])new Object[]{content});
                try {
                    SysTextMsg msg;
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)content);
                    String sid = jsonObject.optString("sid");
                    String mid = jsonObject.optString("msgid");
                    int type = jsonObject.optInt("wtype", 0);
                    String nick = "";
                    if (type == 2) {
                        nick = jsonObject.optString("nick", "");
                    }
                    if (StringUtils.isEmpty((String)mid)) {
                        return;
                    }
                    if (type == 1) {
                        if (this.callback.getMsgModel() == null) continue;
                        this.callback.getMsgModel().deleteMsg(gid, mid);
                        continue;
                    }
                    if (type == 0) {
                        msgItem.setFlags(1L);
                        msgItem.setMsgState(1);
                        msg = new SysTextMsg(msgItem);
                        msg.setSysMsg((CharSequence)ResourceUtils.getString((int)R.string.tips_group_report_withdraw_msg));
                        section.setContent(msg.getSysMsg().toString());
                        section.setType(1);
                        if (this.callback.getMsgModel() == null) continue;
                        this.callback.getMsgModel().replaceMsg(gid, mid, (BaseImMsg)msg, type);
                        continue;
                    }
                    if (type != 2) continue;
                    msgItem.setFlags(1L);
                    msgItem.setMsgState(1);
                    msg = new SysTextMsg(msgItem);
                    msg.setSysMsg((CharSequence)ResourceUtils.getString((int)R.string.tips_group_user_withdraw_msg, (Object[])new Object[]{nick}));
                    section.setContent(msg.getSysMsg().toString());
                    section.setType(1);
                    if (this.callback.getMsgModel() == null) continue;
                    this.callback.getMsgModel().replaceMsg(gid, mid, (BaseImMsg)msg, type);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    MLog.error((Object)"FTRoomGroupSigNotify", (String)"parse hide msg exception!!!content:%s", (Object[])new Object[]{content});
                }
            }
        }
    }

    private void handleServerSignal(String gid, int type, BaseImMsg msgItem, String content, Class theClass, NotifyDataDefine.SignalContext signalContext) {
        this.handleServerSignal(gid, type, msgItem, content, theClass, null, null, signalContext);
    }

    private void handleServerSignal(final String gid, final int type, final BaseImMsg msgItem, String content, Class theClass, String extention, Class extendtionClass, NotifyDataDefine.SignalContext signalContext) {
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)"FTRoomGroupSigNotify", (String)"cid:%s, type:%d, content:%s!", (Object[])new Object[]{gid, type, content});
        }
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        final Object data2 = JsonParser.parseJsonObject((String)content, (Class)theClass);
        if (data2 == null || !(data2 instanceof NotifyDataDefine.AbsSignal)) {
            return;
        }
        Object extentionObj = null;
        if (StringUtils.isNotEmpty((String)extention) && extendtionClass != null) {
            extentionObj = JsonParser.parseJsonObject((String)extention, (Class)extendtionClass);
        }
        ((NotifyDataDefine.AbsSignal)data2).updateSignalContext(signalContext);
        final Object finalExtentionObj = extentionObj;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SignalNotifyHandler.this.handleServerSignal(gid, type, msgItem, data2, finalExtentionObj);
            }
        });
    }

    private void handleServerSignal(String gid, int type, BaseImMsg msgItem, Object data2, Object extention) {
        ArrayList<WeakReference<IChannelNotifyHandler>> notifyHandlers = this.callback.getNotifyHandlers();
        if (notifyHandlers == null || notifyHandlers.size() == 0) {
            return;
        }
        IChannelNotifyHandler listener2 = null;
        for (WeakReference<IChannelNotifyHandler> item : notifyHandlers) {
            NotifyDataDefine.SetRole theData;
            if (item == null || (listener2 = (IChannelNotifyHandler)item.get()) == null) continue;
            if (type == 1102) {
                theData = (NotifyDataDefine.SetRole)data2;
                listener2.handleNotifySetRole(gid, theData);
                continue;
            }
            if (type == 1003) {
                listener2.handleNotifySetName(gid, (NotifyDataDefine.SetName)data2);
                continue;
            }
            if (type == 1004) {
                listener2.handleNotifySetAnnouncement(gid, (NotifyDataDefine.SetAnnouncement)data2);
                continue;
            }
            if (type == 1006) {
                listener2.handleNotifySetJoinMode(gid, (NotifyDataDefine.SetJoinMode)data2);
                continue;
            }
            if (type == 1005) {
                listener2.handleNotifySetSpeakMode(gid, (NotifyDataDefine.SetSpeakMode)data2);
                continue;
            }
            if (type == 1010) {
                listener2.handleNotifySetVoiceEnterMode(gid, (NotifyDataDefine.SetVoiceEnterMode)data2);
                continue;
            }
            if (type == 1011) {
                listener2.handleNotifySetGuestSpeakLimit(gid, (NotifyDataDefine.SetGuestSpeakLimit)data2);
                continue;
            }
            if (type == 1000) {
                listener2.handleNotifyCreateChannel(gid, (NotifyDataDefine.CreateGroup)data2);
                continue;
            }
            if (type == 1001) {
                listener2.handleNotifyDisbandChannel(gid, (NotifyDataDefine.DisbandGroup)data2);
                ChannelNotify notify2 = new ChannelNotify();
                notify2.cid = gid;
                notify2.uri = ChannelNotify.Uri.UriDisbandChannel;
                notify2.notify = new ChannelNotify.Notify();
                notify2.notify.disbandGroup = (NotifyDataDefine.DisbandGroup)data2;
                if (msgItem != null) {
                    notify2.notify.disbandGroup.fromNick = msgItem.getNick();
                }
                listener2.handleNotify(gid, notify2);
                continue;
            }
            if (type == 1012) {
                NotifyDataDefine.SetTags tags = (NotifyDataDefine.SetTags)data2;
                listener2.handleTagUpdates(gid, tags != null ? tags.tags : Collections.emptyList());
                continue;
            }
            if (type == 3200) {
                listener2.handleChannelNewPost(gid, (NotifyDataDefine.ChannelNewPost)data2);
                continue;
            }
            if (type == 3310) continue;
            if (type == 3400) {
                listener2.handleAnchorSitDown(gid, (NotifyDataDefine.ChannelNewPost)data2);
                continue;
            }
            if (type == 3603) {
                listener2.handleFamilyMemberShow(gid, (NotifyDataDefine.FamilyShowNotify)data2);
                continue;
            }
            if (type == 3700) {
                theData = (NotifyDataDefine.InviteApprove)data2;
                listener2.handleInviteApprove(gid, (NotifyDataDefine.InviteApprove)theData);
                continue;
            }
            if (type == 3701) {
                theData = (NotifyDataDefine.InviteApproveStatus)data2;
                listener2.handleInviteApproveStatus(gid, (NotifyDataDefine.InviteApproveStatus)theData);
                continue;
            }
            if (type == 1013) {
                NotifyDataDefine.SetHiddenChannelNick channelNick = (NotifyDataDefine.SetHiddenChannelNick)data2;
                listener2.handleSetHiddenChannelNick(gid, channelNick);
                continue;
            }
            if (type == 1014) {
                NotifyDataDefine.SetHiddenChannelTitle channelTitle = (NotifyDataDefine.SetHiddenChannelTitle)data2;
                listener2.handleSetShowChannelTitle(gid, channelTitle);
                continue;
            }
            if (type != 1015) continue;
            NotifyDataDefine.SetPicSendMode picSendMode = (NotifyDataDefine.SetPicSendMode)data2;
            listener2.handleSetPicSendMode(gid, picSendMode);
        }
    }
}

