/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.notify;

import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.callback.forwardjoinnotify.IForwardJoinRoomNotifyCallback;
import com.yy.hiyo.channel.base.callback.forwardjoinnotify.IJoinRoomNotifyHandler;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IJoinNotifyService;
import com.yy.hiyo.channel.service.BaseService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/yy/hiyo/channel/service/notify/JoinNotifyService;", "Lcom/yy/hiyo/channel/service/BaseService;", "Lcom/yy/hiyo/channel/base/service/IJoinNotifyService;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;)V", "removePendingRunnable", "Ljava/lang/Runnable;", "addJoinNotifyCallback", "", "forwardJoinRoomCallback", "Lcom/yy/hiyo/channel/base/callback/forwardjoinnotify/IForwardJoinRoomNotifyCallback;", "cleanChannelPendingNotify", "getHandler", "Lcom/yy/hiyo/channel/base/callback/forwardjoinnotify/IJoinRoomNotifyHandler;", "markSavePending", "save", "", "onJoined", "rejoin", "info", "Lcom/yy/hiyo/channel/base/bean/ChannelDetailInfo;", "data", "Lcom/yy/hiyo/channel/base/bean/EnterChannelData;", "onLeaved", "removeJoinNotifyCallback", "startRemovePendingRunnable", "Companion", "channel-components_debug"})
public final class JoinNotifyService
extends BaseService
implements IJoinNotifyService {
    private final Runnable removePendingRunnable;
    @NotNull
    public static final String TAG = "JoinNotifyService";
    public static final long DELAY_TIME = 15000L;
    public static final Companion Companion = new Companion(null);

    public void addJoinNotifyCallback(@NotNull IForwardJoinRoomNotifyCallback forwardJoinRoomCallback) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)forwardJoinRoomCallback, (String)"forwardJoinRoomCallback");
            IJoinRoomNotifyHandler iJoinRoomNotifyHandler = this.getHandler();
            if (iJoinRoomNotifyHandler == null) break block0;
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            String string2 = iChannel.getChannelId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"channel.channelId");
            iJoinRoomNotifyHandler.addJoinNotifyCallback(string2, forwardJoinRoomCallback);
        }
    }

    public void removeJoinNotifyCallback(@NotNull IForwardJoinRoomNotifyCallback forwardJoinRoomCallback) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)forwardJoinRoomCallback, (String)"forwardJoinRoomCallback");
            IJoinRoomNotifyHandler iJoinRoomNotifyHandler = this.getHandler();
            if (iJoinRoomNotifyHandler == null) break block0;
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            String string2 = iChannel.getChannelId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"channel.channelId");
            iJoinRoomNotifyHandler.removeJoinNotifyCallback(string2, forwardJoinRoomCallback);
        }
    }

    @Override
    public void onJoined(boolean rejoin2, @NotNull ChannelDetailInfo info, @NotNull EnterChannelData data2) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        super.onJoined(rejoin2, info, data2);
        MLog.info((Object)TAG, (String)"onJoined", (Object[])new Object[0]);
        this.startRemovePendingRunnable();
    }

    @Override
    public void onLeaved() {
        super.onLeaved();
        MLog.info((Object)TAG, (String)"onLeaved", (Object[])new Object[0]);
        YYTaskExecutor.removeTask((Runnable)this.removePendingRunnable);
        this.cleanChannelPendingNotify();
        this.markSavePending(true);
    }

    private final void startRemovePendingRunnable() {
        YYTaskExecutor.removeTask((Runnable)this.removePendingRunnable);
        YYTaskExecutor.postToMainThread((Runnable)this.removePendingRunnable, (long)15000L);
    }

    private final void markSavePending(boolean save) {
        block0: {
            IJoinRoomNotifyHandler iJoinRoomNotifyHandler = this.getHandler();
            if (iJoinRoomNotifyHandler == null) break block0;
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            String string2 = iChannel.getChannelId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"channel.channelId");
            iJoinRoomNotifyHandler.markSavePendingNotify(string2, save);
        }
    }

    private final void cleanChannelPendingNotify() {
        block0: {
            IJoinRoomNotifyHandler iJoinRoomNotifyHandler = this.getHandler();
            if (iJoinRoomNotifyHandler == null) break block0;
            IChannel iChannel = this.channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"channel");
            String string2 = iChannel.getChannelId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"channel.channelId");
            iJoinRoomNotifyHandler.cleanChannelPendingNotify(string2);
        }
    }

    private final IJoinRoomNotifyHandler getHandler() {
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        return iServiceManager != null && (iServiceManager = (IChannelCenterService)iServiceManager.getService(IChannelCenterService.class)) != null ? iServiceManager.getJoinRoomNotifyHandler() : null;
    }

    public JoinNotifyService(@NotNull IChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(channel);
        this.removePendingRunnable = new Runnable(this){
            final /* synthetic */ JoinNotifyService this$0;

            public final void run() {
                JoinNotifyService.access$cleanChannelPendingNotify(this.this$0);
                JoinNotifyService.access$markSavePending(this.this$0, false);
            }
            {
                this.this$0 = joinNotifyService;
            }
        };
    }

    public static final /* synthetic */ void access$cleanChannelPendingNotify(JoinNotifyService $this) {
        $this.cleanChannelPendingNotify();
    }

    public static final /* synthetic */ void access$markSavePending(JoinNotifyService $this, boolean save) {
        $this.markSavePending(save);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yy/hiyo/channel/service/notify/JoinNotifyService$Companion;", "", "()V", "DELAY_TIME", "", "TAG", "", "channel-components_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

