/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.notify;

import androidx.annotation.NonNull;
import biz.IMMsgItem;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.callback.IChannelNotifyHandler;
import com.yy.hiyo.channel.base.callback.IChannelNotifyListener;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SysTextMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.service.msg.IChannelMsgModel;
import com.yy.hiyo.channel.service.notify.BaseNotifyHandler;
import com.yy.hiyo.channel.service.notify.NormalNotifyHandler;
import com.yy.hiyo.channel.service.notify.NotifyHandlerProxy;
import com.yy.hiyo.channel.service.notify.SignalNotifyHandler;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.ihago.channel.srv.mgr.Notify;
import net.ihago.channel.srv.mgr.NotifyReceiveMsg;
import net.ihago.channel.srv.mgr.Uri;

public class ChannelNotifyHandler {
    private static final String TAG = "ChannelNotifyHandler";
    private ArrayList<WeakReference<IChannelNotifyHandler>> notifyHandlers;
    private ArrayList<NotifyHandlerProxy> notifyHandlerProxys;
    private ICallBack callBack;
    private NormalNotifyHandler normalNotifyHandler;
    private SignalNotifyHandler signalNotifyHandler;
    private IProtoNotify notify = new IProtoNotify<Notify>(){

        public String serviceName() {
            return "net.ihago.channel.srv.mgr";
        }

        public void onNotify(@NonNull Notify notify2) {
            List uris;
            if (!ChannelDefine.sUnEnableLog) {
                MLog.debug((Object)"FTRoomGroupSigNotify", (String)"onNotify:%s!", (Object[])new Object[]{notify2 != null ? notify2.toString() : ""});
            }
            if ((uris = notify2.uris) != null && uris.size() > 0) {
                for (Integer uri : uris) {
                    if (uri == null) continue;
                    ChannelNotifyHandler.this.normalNotifyHandler.handleNotify(uri, notify2);
                }
            }
        }
    };

    public ChannelNotifyHandler(ICallBack callBack) {
        this.callBack = callBack;
        BaseNotifyHandler.ICallBack subCallBack = this.getSubCallBack();
        this.normalNotifyHandler = new NormalNotifyHandler(subCallBack);
        this.signalNotifyHandler = new SignalNotifyHandler(subCallBack);
    }

    private BaseNotifyHandler.ICallBack getSubCallBack() {
        BaseNotifyHandler.ICallBack subCallBack = new BaseNotifyHandler.ICallBack(){

            @Override
            public IChannelMsgModel getMsgModel() {
                return ChannelNotifyHandler.this.callBack.getMsgModel();
            }

            @Override
            public NormalNotifyHandler getNormalHandler() {
                return ChannelNotifyHandler.this.normalNotifyHandler;
            }

            @Override
            public SignalNotifyHandler getSignalHandler() {
                return ChannelNotifyHandler.this.signalNotifyHandler;
            }

            @Override
            public void addSystemMsg(String gid, String sysMsg, String useThisMsgId) {
                ChannelNotifyHandler.this.addSystemMsg(gid, sysMsg, useThisMsgId);
            }

            @Override
            public ArrayList<WeakReference<IChannelNotifyHandler>> getNotifyHandlers() {
                ArrayList<WeakReference<IChannelNotifyHandler>> arrayList = new ArrayList<WeakReference<IChannelNotifyHandler>>();
                if (ChannelNotifyHandler.this.notifyHandlers != null) {
                    arrayList.addAll(ChannelNotifyHandler.this.notifyHandlers);
                }
                return arrayList;
            }
        };
        return subCallBack;
    }

    public synchronized void addGroupNotifyHandler(IChannelNotifyHandler handler) {
        if (handler == null) {
            return;
        }
        if (this.notifyHandlers == null) {
            this.notifyHandlers = new ArrayList();
        } else if (this.notifyHandlers != null) {
            for (WeakReference<IChannelNotifyHandler> item : this.notifyHandlers) {
                if (item == null || item.get() != handler) continue;
                return;
            }
        }
        this.notifyHandlers.add(new WeakReference<IChannelNotifyHandler>(handler));
    }

    public synchronized void removeGroupNotifyHandler(IChannelNotifyHandler handler) {
        if (handler == null || this.notifyHandlers == null || this.notifyHandlers.size() <= 0) {
            return;
        }
        for (WeakReference<IChannelNotifyHandler> item : this.notifyHandlers) {
            if (item == null || item.get() != handler) continue;
            this.notifyHandlers.remove(item);
            break;
        }
    }

    private synchronized NotifyHandlerProxy findNotifyProxy(IChannelNotifyListener listener2) {
        if (listener2 == null || this.notifyHandlerProxys == null || this.notifyHandlerProxys.size() <= 0) {
            return null;
        }
        for (NotifyHandlerProxy notifyHandlerProxy : this.notifyHandlerProxys) {
            if (notifyHandlerProxy.getListener() != listener2) continue;
            return notifyHandlerProxy;
        }
        return null;
    }

    public synchronized void addNotifyListener(IChannelNotifyListener listener2) {
        if (listener2 == null) {
            return;
        }
        if (this.notifyHandlerProxys == null) {
            this.notifyHandlerProxys = new ArrayList();
        }
        if (this.findNotifyProxy(listener2) != null) {
            return;
        }
        NotifyHandlerProxy notifyHandlerProxy = new NotifyHandlerProxy(listener2);
        this.notifyHandlerProxys.add(notifyHandlerProxy);
        this.addGroupNotifyHandler(notifyHandlerProxy);
    }

    public synchronized void removeNotifyListener(IChannelNotifyListener listener2) {
        if (listener2 == null) {
            return;
        }
        NotifyHandlerProxy notifyHandlerProxy = this.findNotifyProxy(listener2);
        if (notifyHandlerProxy != null) {
            this.notifyHandlerProxys.remove(notifyHandlerProxy);
            this.removeGroupNotifyHandler(notifyHandlerProxy);
        }
    }

    public void regsiter() {
        ProtoManager.getInstance().registerNotify(this.notify);
    }

    public void unRegister() {
        ProtoManager.getInstance().unregisterNotify(this.notify);
    }

    public static ArrayList<ChannelNotify> parseRoleMsgNotifys(ArrayList<Notify> notifys) {
        if (notifys == null || notifys.size() <= 0) {
            return new ArrayList<ChannelNotify>();
        }
        ArrayList<ChannelNotify> channelNotifies = new ArrayList<ChannelNotify>(notifys.size());
        for (Notify notify2 : notifys) {
            if (notify2 == null) continue;
            ChannelNotifyHandler.parseRoleMsgNotify(notify2, channelNotifies);
        }
        return channelNotifies;
    }

    public static void parseRoleMsgNotify(Notify notify2, ArrayList<ChannelNotify> channelNotifies) {
        List uris = notify2.uris;
        if (uris != null && uris.size() > 0) {
            for (Integer uri : uris) {
                BaseImMsg baseImMsg;
                IPublicScreenService service;
                NotifyReceiveMsg receiveMsg;
                if (uri == null || uri.intValue() != Uri.UriReceiveMsg.getValue() || (receiveMsg = notify2.receive_msg) == null) continue;
                String msgId = receiveMsg.msgid;
                IMMsgItem msg = receiveMsg.msg;
                if (msg == null || StringUtils.isEmpty((String)msgId) || msg.sections == null || msg.sections.size() <= 0 || (service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)) == null || (baseImMsg = service.getMsgItemFactory().transformMsgItem(msgId, msg, null)) == null) continue;
                SignalNotifyHandler.parseRolesSignalMsg(notify2.cid, baseImMsg, channelNotifies);
            }
        }
    }

    public boolean handleSignalMsg(String gid, BaseImMsg msgItem) {
        return this.signalNotifyHandler.handleSignalMsg(gid, msgItem);
    }

    public void notifyReceiveMsg(String gid, String msgId, BaseImMsg msgItem) {
        if (this.notifyHandlers == null || this.notifyHandlers.size() == 0) {
            return;
        }
        IChannelNotifyHandler listener2 = null;
        for (WeakReference<IChannelNotifyHandler> item : this.notifyHandlers) {
            if (item == null || (listener2 = (IChannelNotifyHandler)item.get()) == null) continue;
            listener2.handleNotifyReceiveMsg(gid, msgId, msgItem);
        }
    }

    private void addSystemMsg(String gid, String sysMsg, String useThisMsgId) {
        IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
        if (service != null) {
            SysTextMsg sysTextMsg = service.getMsgItemFactory().generateSysTextMsg(gid, sysMsg);
            if (StringUtils.isNotEmpty((String)useThisMsgId)) {
                sysTextMsg.setMsgId(useThisMsgId);
            }
            if (this.callBack.getMsgModel() != null) {
                this.callBack.getMsgModel().onReceiveMsg(gid, (BaseImMsg)sysTextMsg, null);
            }
        }
    }

    public static interface ICallBack {
        public IChannelMsgModel getMsgModel();
    }
}

