/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.media;

import biz.MediaToken;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.Callback;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.component.base.util.ToastErrorUtil;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import net.ihago.channel.srv.mgr.ECode;
import net.ihago.channel.srv.mgr.GetMediaTokenReq;
import net.ihago.channel.srv.mgr.GetMediaTokenRes;
import net.ihago.channel.srv.mgr.SetMicReq;
import net.ihago.channel.srv.mgr.SetMicRes;

class VoiceModel {
    private static final String TAG = "VoiceModel";
    private String mRoomId;

    VoiceModel() {
    }

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }

    public void fetchMediaToken(String roomId, final Callback<MediaToken> callback2) {
        GetMediaTokenReq req = new GetMediaTokenReq.Builder().cid(this.mRoomId).build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetMediaTokenRes>("fetchMediaToken"){

            public void onResponse(GetMediaTokenRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (!message.media_token.__isDefaultInstance()) {
                    if (callback2 != null) {
                        callback2.onResponse((Object)message.media_token);
                    }
                } else if (callback2 != null) {
                    callback2.onResponse(null);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback2 != null) {
                    callback2.onResponse(null);
                }
            }
        });
    }

    public void changeMic(final int index, final long uid, boolean turnOn, final IOperationCallback callback2, boolean mySelf) {
        MLog.info((Object)TAG, (String)"changeMic index %s, uid %s, turnOn %b", (Object[])new Object[]{index, uid, turnOn});
        SetMicReq.Builder builder = new SetMicReq.Builder().cid(this.mRoomId).seat(Integer.valueOf(index)).uid(Long.valueOf(uid));
        if (mySelf) {
            builder.mic_close(Integer.valueOf(turnOn ? 2 : 1));
        } else {
            builder.mic_ban(Integer.valueOf(turnOn ? 2 : 1));
        }
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)builder.build(), (IProtoCallback)new SimpleProtoCallback<SetMicRes>(TAG){

            public void onResponse(SetMicRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message);
                FeatureLog.i((String)"FTVoiceRoom", (String)"\u623f\u4e3b\u4fee\u6539index:%s, uid:%s\u7528\u6237\u7684\u9ea6\u72b6\u6001,code:%s", (Object[])new Object[]{index, uid, code});
                if (message != null) {
                    ToastErrorUtil.toast(code);
                }
                if (ProtoManager.isSuccessCode((long)code)) {
                    if (null != callback2) {
                        callback2.onSuccess();
                    }
                } else if (null != callback2) {
                    callback2.onFail((long)ECode.NO_ARROW.getValue() == code ? 1L : 2L);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                FeatureLog.e((String)"FTVoiceRoom", (String)"code: %s, reason: %s", (Object[])new Object[]{code, reason});
                if (null != callback2) {
                    callback2.onFail(ECode.NO_ARROW.getValue() == code ? 1L : 2L);
                }
            }
        });
    }
}

