/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.crawler;

import android.content.Context;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.Callback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.CrawlerGroupBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IGetCrawlerService;
import com.yy.hiyo.channel.service.BaseService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.official.srv.group.ECode;
import net.ihago.official.srv.group.GetGroupInfoByGidReq;
import net.ihago.official.srv.group.GetGroupInfoByGidRes;
import net.ihago.official.srv.group.JoinGroupReq;
import net.ihago.official.srv.group.JoinGroupRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J,\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u000eH\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/yy/hiyo/channel/service/crawler/CrawlerService;", "Lcom/yy/hiyo/channel/service/BaseService;", "Lcom/yy/hiyo/channel/base/service/IGetCrawlerService;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;)V", "mCrawlerGroupBean", "Lcom/yy/hiyo/channel/base/bean/CrawlerGroupBean;", "cacheCrawlerGroup", "getCrawlerGroup", "", "cid", "", "callback", "Lcom/yy/appbase/common/Callback;", "forceServer", "", "getCrawlerGroupInner", "joinCrawlerGroup", "groupId", "Companion", "channel-components_debug"})
public final class CrawlerService
extends BaseService
implements IGetCrawlerService {
    private CrawlerGroupBean mCrawlerGroupBean;
    @NotNull
    public static final String TAG = "CrawlerService";
    public static final Companion Companion = new Companion(null);

    public void joinCrawlerGroup(@NotNull String groupId, @Nullable Callback<Boolean> callback2) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        MLog.info((Object)TAG, (String)("joinCrawlerGroup groupId: " + groupId), (Object[])new Object[0]);
        JoinGroupReq req = new JoinGroupReq.Builder().group_id(groupId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<JoinGroupRes>(callback2){
            final /* synthetic */ Callback $callback;

            public void onResponse(@NotNull JoinGroupRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)"CrawlerService", (String)("joinCrawlerGroup code: " + code), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    Callback callback2 = this.$callback;
                    if (callback2 != null) {
                        callback2.onResponse((Object)true);
                    }
                } else if (code == (long)ECode.JOIN_NUM_LIMIT.getValue()) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_join_failed_channel_counts_limit);
                } else if (code == (long)ECode.HAS_JOIN.getValue()) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_has_join);
                } else if (!FP.empty((CharSequence)msg)) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)msg, (int)0);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_join_channel_failed);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)"CrawlerService", (String)"joinCrawlerGroup time out", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.error((Object)"CrawlerService", (String)("joinCrawlerGroup error, code: " + code), (Object[])new Object[0]);
                return false;
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @Nullable
    public CrawlerGroupBean cacheCrawlerGroup() {
        return this.mCrawlerGroupBean;
    }

    public void getCrawlerGroup(@Nullable String cid, @Nullable Callback<CrawlerGroupBean> callback2, boolean forceServer) {
        MLog.info((Object)TAG, (String)("getCrawlerGroup cid: " + cid), (Object[])new Object[0]);
        if (FP.empty((CharSequence)cid)) {
            Callback<CrawlerGroupBean> callback3 = callback2;
            if (callback3 != null) {
                callback3.onResponse(null);
            }
            return;
        }
        if (!forceServer && this.mCrawlerGroupBean != null) {
            Callback<CrawlerGroupBean> callback4 = callback2;
            if (callback4 != null) {
                callback4.onResponse((Object)this.mCrawlerGroupBean);
            }
            return;
        }
        this.getCrawlerGroupInner(cid, callback2);
    }

    private final void getCrawlerGroupInner(String cid, Callback<CrawlerGroupBean> callback2) {
        GetGroupInfoByGidReq req = new GetGroupInfoByGidReq.Builder().group_id(cid).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetGroupInfoByGidRes>(this, cid, callback2){
            final /* synthetic */ CrawlerService this$0;
            final /* synthetic */ String $cid;
            final /* synthetic */ Callback $callback;

            public void onResponse(@NotNull GetGroupInfoByGidRes message, long code, @Nullable String msg) {
                block2: {
                    block1: {
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        super.onResponse((AndroidMessage)message, code, msg);
                        if (!ProtoManager.isSuccessCode((long)code)) break block1;
                        CrawlerGroupBean crawlerGroupBean = new CrawlerGroupBean();
                        String string2 = this.$cid;
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        crawlerGroupBean.setCid(string2);
                        crawlerGroupBean.setThemeId(message.theme_id);
                        crawlerGroupBean.setThemeName(message.theme_name);
                        crawlerGroupBean.setGroupCover(message.avatar);
                        crawlerGroupBean.setTopBg(message.top_bg);
                        crawlerGroupBean.setBottomBg(message.bottom_bg);
                        crawlerGroupBean.setBgUrl(message.bg_url);
                        CrawlerService.access$setMCrawlerGroupBean$p(this.this$0, crawlerGroupBean);
                        MLog.info((Object)"CrawlerService", (String)("getCrawlerGroup " + CrawlerService.access$getMCrawlerGroupBean$p(this.this$0)), (Object[])new Object[0]);
                        Callback callback2 = this.$callback;
                        if (callback2 == null) break block2;
                        callback2.onResponse((Object)CrawlerService.access$getMCrawlerGroupBean$p(this.this$0));
                        break block2;
                    }
                    MLog.info((Object)"CrawlerService", (String)("getCrawlerGroup code: " + code), (Object[])new Object[0]);
                    Callback callback3 = this.$callback;
                    if (callback3 == null) break block2;
                    callback3.onResponse(null);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                block0: {
                    MLog.error((Object)"CrawlerService", (String)"getCrawlerGroup time out", (Object[])new Object[0]);
                    Callback callback2 = this.$callback;
                    if (callback2 == null) break block0;
                    callback2.onResponse(null);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                block0: {
                    MLog.error((Object)"CrawlerService", (String)("getCrawlerGroup error, code: " + code), (Object[])new Object[0]);
                    Callback callback2 = this.$callback;
                    if (callback2 == null) break block0;
                    callback2.onResponse(null);
                }
                return false;
            }
            {
                this.this$0 = $outer;
                this.$cid = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
            }
        });
    }

    public CrawlerService(@NotNull IChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(channel);
    }

    public static final /* synthetic */ CrawlerGroupBean access$getMCrawlerGroupBean$p(CrawlerService $this) {
        return $this.mCrawlerGroupBean;
    }

    public static final /* synthetic */ void access$setMCrawlerGroupBean$p(CrawlerService $this, CrawlerGroupBean crawlerGroupBean) {
        $this.mCrawlerGroupBean = crawlerGroupBean;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/service/crawler/CrawlerService$Companion;", "", "()V", "TAG", "", "channel-components_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

