/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.service.composequeue;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.service.IComposeQueue;
import com.yy.hiyo.channel.base.service.IComposeTask;
import com.yy.hiyo.channel.service.composequeue.ComposeQueue;
import com.yy.hiyo.channel.service.composequeue.IndexTask;
import com.yy.hiyo.channel.service.composequeue.TimeOutWatcher;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/yy/hiyo/channel/service/composequeue/ComposeQueue;", "Lcom/yy/hiyo/channel/base/service/IComposeQueue;", "()V", "increaseIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "isExecuting", "", "queue", "Ljava/util/PriorityQueue;", "Lcom/yy/hiyo/channel/service/composequeue/IndexTask;", "testQueue", "Lcom/yy/hiyo/channel/base/service/IComposeTask;", "getTestQueue", "()Ljava/util/PriorityQueue;", "timeOutWatcher", "Lcom/yy/hiyo/channel/service/composequeue/TimeOutWatcher;", "clear", "", "contains", "predicate", "Lkotlin/Function1;", "next", "push", "task", "removeTimeout", "watchTimeOut", "channel-components_debug"})
public final class ComposeQueue
implements IComposeQueue {
    private final AtomicInteger increaseIndex = new AtomicInteger();
    private final PriorityQueue<IndexTask> queue = new PriorityQueue(8, queue.1.INSTANCE);
    private boolean isExecuting;
    private TimeOutWatcher timeOutWatcher;
    @NotNull
    private final PriorityQueue<? extends IComposeTask> testQueue = this.queue;

    public void push(@NotNull IComposeTask task2) {
        Intrinsics.checkParameterIsNotNull((Object)task2, (String)"task");
        MLog.info((Object)"ComposeQueue", (String)("push isExecuting " + this.isExecuting + ", " + task2), (Object[])new Object[0]);
        this.queue.add(new IndexTask(this.increaseIndex.incrementAndGet(), task2, 0, 4, null));
        if (!this.isExecuting) {
            this.next();
        }
    }

    public boolean contains(@NotNull Function1<? super IComposeTask, Boolean> predicate) {
        int n;
        block3: {
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            Iterable $this$indexOfFirst$iv = this.queue;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                boolean bl = false;
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IndexTask it = (IndexTask)((Object)item$iv);
                boolean bl2 = false;
                if (((Boolean)predicate.invoke((Object)it.getTask())).booleanValue()) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n != -1;
    }

    public void clear() {
        MLog.info((Object)"ComposeQueue", (String)("clear " + this.queue.size()), (Object[])new Object[0]);
        this.queue.clear();
        this.removeTimeout();
    }

    private final void next() {
        block0: {
            IndexTask indexTask = this.queue.poll();
            if (indexTask == null) break block0;
            IndexTask indexTask2 = indexTask;
            boolean bl = false;
            boolean bl2 = false;
            IndexTask task2 = indexTask2;
            boolean bl3 = false;
            MLog.info((Object)"ComposeQueue", (String)("next start " + (Object)((Object)task2)), (Object[])new Object[0]);
            this.isExecuting = true;
            task2.onExecute((Function0<Unit>)((Function0)new Function0<Unit>(task2, this){
                final /* synthetic */ IndexTask $task;
                final /* synthetic */ ComposeQueue this$0;
                {
                    this.$task = indexTask;
                    this.this$0 = composeQueue;
                    super(0);
                }

                public final void invoke() {
                    MLog.info((Object)"ComposeQueue", (String)("next end, " + (Object)((Object)this.$task) + ", onExecute finished\uff0ccall next"), (Object[])new Object[0]);
                    ComposeQueue.access$removeTimeout(this.this$0);
                    ComposeQueue.access$setExecuting$p(this.this$0, false);
                    ComposeQueue.access$next(this.this$0);
                }
            }));
            this.watchTimeOut(task2);
        }
    }

    private final void watchTimeOut(IComposeTask task2) {
        YYTaskExecutor.removeTask((Runnable)this.timeOutWatcher);
        this.timeOutWatcher = new TimeOutWatcher(task2, (Function0<Unit>)((Function0)new Function0<Unit>(this, task2){
            final /* synthetic */ ComposeQueue this$0;
            final /* synthetic */ IComposeTask $task;

            public final void invoke() {
                MLog.error((Object)"ComposeQueue", (String)("watchTimeOut isExecuting " + ComposeQueue.access$isExecuting$p(this.this$0) + ", " + this.$task), (Object[])new Object[0]);
                ComposeQueue.access$setExecuting$p(this.this$0, false);
                ComposeQueue.access$next(this.this$0);
            }
            {
                this.this$0 = composeQueue;
                this.$task = iComposeTask;
                super(0);
            }
        }));
        YYTaskExecutor.postToMainThread((Runnable)this.timeOutWatcher, (long)30000L);
    }

    private final void removeTimeout() {
        YYTaskExecutor.removeTask((Runnable)this.timeOutWatcher);
    }

    @NotNull
    public final PriorityQueue<? extends IComposeTask> getTestQueue() {
        return this.testQueue;
    }

    public static final /* synthetic */ void access$removeTimeout(ComposeQueue $this) {
        $this.removeTimeout();
    }

    public static final /* synthetic */ boolean access$isExecuting$p(ComposeQueue $this) {
        return $this.isExecuting;
    }

    public static final /* synthetic */ void access$setExecuting$p(ComposeQueue $this, boolean bl) {
        $this.isExecuting = bl;
    }

    public static final /* synthetic */ void access$next(ComposeQueue $this) {
        $this.next();
    }
}

