/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextSwitcher;
import android.widget.TextView;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.press.ClickScaleAnimProvider;
import com.yy.appbase.ui.press.PressAlpha;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.util.RemoveViewUtils;
import com.yy.base.R;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.seat.DownloadingView;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.mvp.base.ICustomView;
import com.yy.hiyo.mvp.base.SimpleLifeCycleOwner;
import java.util.Collection;

public class GamePrepareView
extends YYConstraintLayout
implements ICustomView {
    private static final String TAG = "FTVoiceRoomGame GamePrepareView";
    private static final int LEVEL_GREEN = 1;
    private static final int LEVEL_RED = 2;
    private static final int LEVEL_GRAY = 3;
    private YYTextView mPlayerCount;
    private TextSwitcher mGameNameSwitcher;
    private YYTextView mTips;
    private View mActionLayout;
    private YYTextView mActionBtn;
    private DownloadingView mDownloadingView;
    private GameInfo mGameInfo;
    private String mGameMainName;
    private String mGameSubName;
    private View mCloseIcon;
    private SeatMvp.IGamePresenter mPresenter;
    private RecycleImageView mBgImage;
    private View mActionIcon;
    private LinearLayout mFuncBtnsContainer;
    private SimpleLifeCycleOwner mLifecycleOwner = new SimpleLifeCycleOwner();
    private View mRuleIcon;
    private Runnable mGameNameSwitchRunnable;
    private String mCurrGameName;
    private boolean destroyed = false;
    private boolean isSubName = false;
    private boolean recoverUpdateNameAfterAttach = false;
    private Boolean mCacheIsManager;
    private Pair<Boolean, String> mCacheState;

    public GamePrepareView(Context context) {
        super(context);
        this.createView(null);
    }

    public GamePrepareView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public GamePrepareView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.createView(attrs);
    }

    public void createView(@Nullable AttributeSet attrs) {
        this.setClipChildren(false);
        GamePrepareView.inflate((Context)this.getContext(), (int)R.layout.seat_game_prepare_channel, (ViewGroup)this);
        this.mRuleIcon = this.findViewById(R.id.rule_icon);
        this.mBgImage = (RecycleImageView)this.findViewById(R.id.bg_image);
        this.mPlayerCount = (YYTextView)this.findViewById(R.id.player_count);
        this.mCloseIcon = this.findViewById(R.id.close_icon);
        this.mGameNameSwitcher = (TextSwitcher)this.findViewById(R.id.game_name_switcher);
        this.mTips = (YYTextView)this.findViewById(R.id.tips);
        this.mActionLayout = this.findViewById(R.id.action_layout);
        this.mActionIcon = this.findViewById(R.id.action_icon);
        this.mActionBtn = (YYTextView)this.findViewById(R.id.action_btn);
        FontUtils.setFontType((TextView)this.mActionBtn, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mDownloadingView = (DownloadingView)this.findViewById(R.id.downloading);
        this.mFuncBtnsContainer = (LinearLayout)this.findViewById(R.id.func_btn_container);
        PressAlpha.of((View)this.mRuleIcon);
        this.mRuleIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GamePrepareView.this.mPresenter != null && GamePrepareView.this.mGameInfo != null) {
                    GamePrepareView.this.mPresenter.showGameRule(GamePrepareView.this.mGameInfo);
                }
            }
        });
        PressAlpha.of((View)this.mCloseIcon);
        this.mCloseIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GamePrepareView.this.confirmClose();
                GamePrepareView.this.mPresenter.trackClose();
            }
        });
        ClickScaleAnimProvider.apply((View)this.mActionLayout);
        this.mActionLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GamePrepareView.this.mPresenter.onGamePrepareAction();
            }
        });
        this.mTips.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GamePrepareView.this.mPresenter.prepareState() != null && GamePrepareView.this.mPresenter.prepareState().getValue() != null && "FAIL".equals(((Pair)((GamePrepareView)GamePrepareView.this).mPresenter.prepareState().getValue()).second)) {
                    GamePrepareView.this.mPresenter.onLoadAgain();
                }
            }
        });
        this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_START);
        this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_RESUME);
    }

    public void setData(GameInfo gameInfo, int playerCount, int maxCount) {
        MLog.info((Object)TAG, (String)"setData %s, count %d", (Object[])new Object[]{gameInfo, playerCount});
        if (gameInfo != null) {
            this.mGameInfo = gameInfo;
            this.mPlayerCount.setText((CharSequence)ResourceUtils.getString((int)R.string.team_match_player_count, (Object[])new Object[]{playerCount + "-" + maxCount}));
            ImageLoader.loadImage((ImageView)this.mBgImage, (String)gameInfo.getGamePrepareBgUrl());
            this.mGameMainName = this.mGameInfo.getGname();
            this.updateGameName(false);
            if (this.mCacheIsManager != null && this.mCacheState != null) {
                this.setState(this.mCacheIsManager, this.mCacheState);
                this.mCacheIsManager = null;
                this.mCacheState = null;
            }
        }
    }

    public void setState(boolean isManager, Pair<Boolean, String> state) {
        MLog.info((Object)TAG, (String)"setState isManager %b, state\u7684\u7b2c\u4e00\u4e2a\u503c%s, \u7b2c\u4e8c\u4e2a\u503c:%s", (Object[])new Object[]{isManager, state.first, state.second});
        if (this.mGameInfo == null) {
            this.mCacheIsManager = isManager;
            this.mCacheState = state;
        }
        if (isManager) {
            this.setOwnerShowState(state);
        } else {
            this.setGuestShowState(state);
        }
    }

    private void updateGameName(boolean isSubName) {
        if (this.isRecycled()) {
            return;
        }
        this.isSubName = isSubName;
        if (this.mGameNameSwitchRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mGameNameSwitchRunnable);
        }
        if (FP.empty((CharSequence)this.mGameSubName)) {
            if (!FP.eq((Object)this.mCurrGameName, (Object)this.mGameMainName)) {
                if (!RemoveViewUtils.isViewRecycled((View)this.mGameNameSwitcher)) {
                    this.mGameNameSwitcher.setText((CharSequence)this.mGameMainName);
                }
                this.mCurrGameName = this.mGameMainName;
            }
        } else {
            if (this.mGameNameSwitchRunnable == null) {
                this.mGameNameSwitchRunnable = () -> {
                    if (this.destroyed || RemoveViewUtils.isViewRecycled((View)this.mGameNameSwitcher)) {
                        return;
                    }
                    String nextName = FP.eq((Object)this.mCurrGameName, (Object)this.mGameMainName) ? this.mGameSubName : this.mGameMainName;
                    this.mGameNameSwitcher.setText((CharSequence)nextName);
                    this.mCurrGameName = nextName;
                    YYTaskExecutor.postToMainThread((Runnable)this.mGameNameSwitchRunnable, (long)5000L);
                };
            }
            if (isSubName) {
                if (!RemoveViewUtils.isViewRecycled((View)this.mGameNameSwitcher)) {
                    this.mGameNameSwitcher.setText((CharSequence)this.mGameSubName);
                }
                this.mCurrGameName = this.mGameSubName;
            } else {
                if (!RemoveViewUtils.isViewRecycled((View)this.mGameNameSwitcher)) {
                    this.mGameNameSwitcher.setText((CharSequence)this.mGameMainName);
                }
                this.mCurrGameName = this.mGameMainName;
            }
            YYTaskExecutor.postToMainThread((Runnable)this.mGameNameSwitchRunnable, (long)5000L);
        }
    }

    private boolean isRecycled() {
        Object removed = this.getTag(R.id.yy_be_removed_by_recycle);
        return removed instanceof Boolean && (Boolean)removed != false;
    }

    private void setGuestShowState(Pair<Boolean, String> state) {
        switch ((String)state.second) {
            case "FAIL": {
                this.mTips.setVisibility(0);
                this.mTips.setText(R.string.tips_room_game_load_error);
                LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.mTips, (int)0, (int)0, (int)R.drawable.ico_retry, (int)0);
                this.mActionLayout.setVisibility(4);
                this.mDownloadingView.setVisibility(8);
                break;
            }
            case "NOT_SUPPORT": {
                this.mTips.setVisibility(0);
                this.mTips.setText(R.string.short_tips_game_not_compat);
                LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.mTips, (int)0, (int)0, (int)0, (int)0);
                this.mActionLayout.setVisibility(4);
                this.mDownloadingView.setVisibility(8);
                this.reportHiido();
                break;
            }
            case "LOADING": {
                this.mTips.setVisibility(8);
                this.mActionLayout.setVisibility(4);
                this.mDownloadingView.setVisibility(0);
                break;
            }
            case "INIT": {
                this.mTips.setVisibility(8);
                this.mDownloadingView.setVisibility(8);
                if (this.mGameInfo == null || this.mGameInfo.isRoomAssistGame()) break;
                this.mActionLayout.setVisibility(0);
                this.mActionIcon.setVisibility(0);
                this.mActionBtn.setText(R.string.join);
                this.mActionLayout.getBackground().setLevel((Boolean)state.first != false ? 2 : 3);
                break;
            }
            case "JOINED": {
                this.mTips.setVisibility(8);
                this.mDownloadingView.setVisibility(8);
                if (this.mGameInfo == null || this.mGameInfo.isRoomAssistGame()) break;
                this.mActionLayout.setVisibility(0);
                this.mActionIcon.setVisibility(8);
                this.mActionBtn.setText(R.string.btn_game_ready);
                this.mActionLayout.getBackground().setLevel(1);
                break;
            }
            case "READIED": {
                this.mTips.setVisibility(8);
                this.mDownloadingView.setVisibility(8);
                if (this.mGameInfo == null || this.mGameInfo.isRoomAssistGame()) break;
                this.mActionLayout.setVisibility(0);
                this.mActionIcon.setVisibility(8);
                this.mActionBtn.setText(R.string.btn_game_ready_cancel);
                this.mActionLayout.getBackground().setLevel(3);
                break;
            }
        }
        if (((Boolean)state.first).booleanValue()) {
            ClickScaleAnimProvider.apply((View)this.mActionLayout);
        } else {
            ClickScaleAnimProvider.clear((View)this.mActionLayout);
        }
    }

    private void reportHiido() {
        if (this.mGameInfo != null && "ktv".equals(this.mGameInfo.gid)) {
            ChannelTrack.INSTANCE.onUnComptiblleShow();
        }
    }

    private void setOwnerShowState(Pair<Boolean, String> state) {
        switch ((String)state.second) {
            case "FAIL": {
                this.mTips.setVisibility(0);
                this.mTips.setText(R.string.tips_room_game_load_error);
                LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.mTips, (int)0, (int)0, (int)R.drawable.ico_retry, (int)0);
                this.mActionLayout.setVisibility(4);
                this.mDownloadingView.setVisibility(8);
                break;
            }
            case "LOADING": {
                this.mTips.setVisibility(8);
                this.mActionLayout.setVisibility(4);
                this.mDownloadingView.setVisibility(0);
                break;
            }
            case "INIT": {
                this.mTips.setVisibility(8);
                if (this.mGameInfo != null && !this.mGameInfo.isRoomAssistGame()) {
                    this.mActionLayout.setVisibility(0);
                    this.mActionIcon.setVisibility(0);
                    this.mActionBtn.setText(R.string.pk);
                    this.mActionLayout.getBackground().setLevel(3);
                }
                this.mDownloadingView.setVisibility(8);
                break;
            }
            case "JOINED": {
                this.mTips.setVisibility(8);
                this.mDownloadingView.setVisibility(8);
                if (this.mGameInfo == null || this.mGameInfo.isRoomAssistGame()) break;
                this.mActionLayout.setVisibility(0);
                this.mActionIcon.setVisibility(8);
                this.mActionBtn.setText(R.string.btn_game_ready);
                this.mActionLayout.getBackground().setLevel(1);
                break;
            }
            case "READIED": {
                this.mTips.setVisibility(8);
                if (this.mGameInfo != null && !this.mGameInfo.isRoomAssistGame()) {
                    this.mActionIcon.setVisibility(0);
                    this.mActionLayout.setVisibility(0);
                    this.mActionBtn.setText(R.string.pk);
                    this.mActionLayout.getBackground().setLevel((Boolean)state.first != false ? 2 : 3);
                }
                this.mDownloadingView.setVisibility(8);
                break;
            }
        }
        if (((Boolean)state.first).booleanValue()) {
            ClickScaleAnimProvider.apply((View)this.mActionLayout);
        } else {
            ClickScaleAnimProvider.clear((View)this.mActionLayout);
        }
    }

    private void setProgress(@IntRange(from=0L, to=100L) int progress) {
        MLog.info((Object)TAG, (String)"setProgress %s", (Object[])new Object[]{progress});
        if (0 <= progress && progress < 100) {
            this.mDownloadingView.setVisibility(0);
            this.mDownloadingView.setProgress(progress);
        } else {
            this.mDownloadingView.setVisibility(8);
        }
    }

    public void setPresenter(SeatMvp.IGamePresenter presenter) {
        MLog.info((Object)TAG, (String)"setPresenter %s", (Object[])new Object[]{presenter});
        this.mPresenter = presenter;
        this.mPresenter.gameInfo().observe((LifecycleOwner)this.mLifecycleOwner, gameInfo -> this.setData((GameInfo)gameInfo, gameInfo != null ? gameInfo.getMinPlayerCount() : 0, this.mPresenter.getTotalSeatCount()));
        this.mPresenter.gameSubName().observe((LifecycleOwner)this.mPresenter.getMvpContext().getLifecycleOwner(), gameName2 -> {
            this.mGameSubName = gameName2;
            this.updateGameName(true);
        });
        this.mPresenter.prepareState().observe((LifecycleOwner)this.mLifecycleOwner, state -> {
            if (state != null) {
                this.setState(Boolean.TRUE.equals(presenter.isMePlayManager().getValue()), (Pair<Boolean, String>)state);
            }
        });
        this.mPresenter.gameProgress().observe((LifecycleOwner)this.mLifecycleOwner, progress -> {
            if (progress != null) {
                this.setProgress((int)progress);
            }
        });
        this.mPresenter.getPrepareUiData().observe((LifecycleOwner)this.mLifecycleOwner, visible -> {
            if (!Boolean.TRUE.equals(visible)) {
                this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_DESTROY);
                if (this.mGameNameSwitchRunnable != null) {
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mGameNameSwitchRunnable);
                    this.mGameNameSwitchRunnable = null;
                }
            }
        });
        this.mPresenter.funcBtns().observe((LifecycleOwner)this.mLifecycleOwner, funcBtnList -> {
            this.mFuncBtnsContainer.removeAllViews();
            if (!FP.empty((Collection)funcBtnList)) {
                for (View view2 : funcBtnList) {
                    if (view2.getParent() instanceof ViewGroup) {
                        ((ViewGroup)view2.getParent()).removeView(view2);
                    }
                    int size = ResolutionUtils.dip2Px((float)38.0f);
                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(size, size);
                    this.mFuncBtnsContainer.addView(view2, (ViewGroup.LayoutParams)lp);
                }
            }
        });
        presenter.isCanClose().observe((LifecycleOwner)this.mLifecycleOwner, canClose -> this.mCloseIcon.setVisibility(Boolean.TRUE.equals(canClose) ? 0 : 4));
    }

    private void confirmClose() {
        DialogLinkManager manager = new DialogLinkManager(this.getContext());
        OkCancelDialog dialog2 = new OkCancelDialog.Builder().cancelable(true).message((CharSequence)ResourceUtils.getString((int)R.string.short_tips_close_prepare)).listener(new OkCancelDialogListener(){

            public void onCancel() {
                MLog.info((Object)GamePrepareView.TAG, (String)"\u53d6\u6d88 \u5173\u95ed\u6e38\u620f", (Object[])new Object[0]);
            }

            public void onOk() {
                MLog.info((Object)GamePrepareView.TAG, (String)"\u786e\u8ba4 \u5173\u95ed\u6e38\u620f", (Object[])new Object[0]);
                if (GamePrepareView.this.mPresenter.canClosePlugin()) {
                    GamePrepareView.this.mPresenter.quitGameMode();
                } else {
                    MLog.info((Object)GamePrepareView.TAG, (String)"\u5173\u95ed\u6e38\u620f\u5931\u8d25", (Object[])new Object[0]);
                }
            }
        }).build();
        manager.showDialog((BaseDialog)dialog2);
    }

    public void adjustLayoutForChess() {
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, ScreenUtils.getInstance().getWidthPixels() * 5 / 8));
        this.mRuleIcon.setVisibility(8);
        this.mPlayerCount.setVisibility(8);
        ConstraintSet set = new ConstraintSet();
        set.clone((ConstraintLayout)this);
        set.connect(R.id.downloading, 3, 0, 3, 0);
        set.connect(R.id.downloading, 6, 0, 6, 0);
        set.connect(R.id.downloading, 7, 0, 7, this.getHeight() / 2 - 30);
        set.connect(R.id.game_name, 3, R.id.downloading, 4, ResolutionUtils.dip2Px((float)15.0f));
        set.applyTo((ConstraintLayout)this);
    }

    public void adjustLayoutForAssistGame() {
        this.mRuleIcon.setVisibility(8);
        this.mPlayerCount.setVisibility(8);
        this.mActionLayout.setVisibility(4);
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mDownloadingView.getLayoutParams();
        layoutParams.bottomMargin = ResolutionUtils.dip2Px((float)45.0f);
        this.mDownloadingView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mGameNameSwitchRunnable != null && this.recoverUpdateNameAfterAttach) {
            this.updateGameName(this.isSubName);
            this.recoverUpdateNameAfterAttach = false;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mGameNameSwitchRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mGameNameSwitchRunnable);
            this.recoverUpdateNameAfterAttach = true;
        }
    }

    public void destroy() {
        this.destroyed = true;
        if (this.mDownloadingView != null) {
            this.mDownloadingView.destroy();
        }
        if (this.mGameNameSwitchRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mGameNameSwitchRunnable);
        }
    }
}

