/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare;

import android.app.Activity;
import android.content.Context;
import android.util.Pair;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.model.bean.RoomInfo;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.component.seat.bean.PrepareStateLiveData;
import com.yy.hiyo.channel.plugins.voiceroom.common.game.IRoomGameService;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare.EmptyPrepareService;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare.PrepareStatusPresenter;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakCallback;
import java.util.Collection;
import java.util.List;

public class GamePreparePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements SeatMvp.IGamePresenter,
ISeatUpdateListener,
INotify {
    private static final String TAG = "FTVoiceRoomGame GamePreparePresenter";
    private static final int TOTAL_SEAT_COUNT = 8;
    private PrepareStateLiveData mPrepareState = new PrepareStateLiveData();
    private MutableLiveData<Integer> mGameProgress = new SafeLiveData();
    private MutableLiveData<GameInfo> mGameInfo = new SafeLiveData();
    private MutableLiveData<String> mGameSubName = new SafeLiveData();
    private MutableLiveData<List<View>> mFuncBtns = new MutableLiveData();
    private SeatMvp.IGamePresenter.OnUiCallback mOnUiCallback;
    private MutableLiveData<String> mTips = new SafeLiveData();
    private MutableLiveData<Boolean> mPrepareUiData = new SafeLiveData();
    private MutableLiveData<Boolean> isMePlayManager = new SafeLiveData();
    private IRoomGameService roomGameService;
    private MutableLiveData<Boolean> isCanClose = new SafeLiveData();
    private IRoleService.IMemberOrMasterChangeListener memberOrMasterChangeListener;
    private OnGameInfoChangedListener gameListChangeListener = new OnGameInfoChangedListener(){

        public void onGameInfoChanged(GameInfoSource type, List<GameInfo> list2) {
            if (!FP.empty(list2) && GameInfoSource.VOICE_ROOM == type) {
                GameInfo temp;
                for (GameInfo item : list2) {
                    if (item == null || !GamePreparePresenter.this.getGameId().equals(item.gid)) continue;
                    GamePreparePresenter.this.mGameInfo.setValue((Object)item);
                    MLog.info((Object)GamePreparePresenter.TAG, (String)"onGameInfoChanged %s", (Object[])new Object[]{item});
                    ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).removeGameInfoListener(GamePreparePresenter.this.gameListChangeListener);
                    break;
                }
                if ((temp = (GameInfo)GamePreparePresenter.this.mGameInfo.getValue()) != null && !StringUtils.equal((String)temp.gid, (String)GamePreparePresenter.this.getGameId())) {
                    GamePreparePresenter.this.mGameInfo.setValue(null);
                }
            }
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public void onInit(@NonNull IChannelPageContext<AbsPage> mvpContext) {
        super.onInit(mvpContext);
        this.roomGameService = new EmptyPrepareService((IChannel)this.getChannel());
        this.memberOrMasterChangeListener = new IRoleService.IMemberOrMasterChangeListener(){

            public void onMyRoleChanged(String channelId, int newRoleType) {
                GamePreparePresenter.this.isCanClose.setValue((Object)(GamePreparePresenter.this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid()) || GamePreparePresenter.this.getChannel().getRoleService().isMeAnchor() ? 1 : 0));
                GamePreparePresenter.this.refreshGameState();
            }
        };
        this.getChannel().getRoleService().addDataListener(this.memberOrMasterChangeListener);
        this.isCanClose.setValue((Object)(this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid()) || this.getChannel().getRoleService().isMeAnchor() ? 1 : 0));
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.WEBSOCKET_CONNECT, (INotify)this);
    }

    public void onPageAttach(@NonNull AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach) {
            YYTaskExecutor.postToMainThread(() -> {
                this.mBinder.singleBindSourceTo((KvoSource)this.getRoomData().getRoomInfo());
                this.getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
            });
        }
    }

    public void setRoomGameService(@NonNull IRoomGameService roomGameService) {
        this.roomGameService = roomGameService;
    }

    private void setData(String gameId) {
        MLog.info((Object)TAG, (String)"setData gameId: %s", (Object[])new Object[]{gameId});
        this.mPrepareState.setValue(null);
        if (!FP.empty((CharSequence)gameId)) {
            ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).addGameInfoListener(this.gameListChangeListener, true);
        }
    }

    @KvoMethodAnnotation(name="mode", sourceClass=RoomInfo.class)
    public void onRoomModeChanged(KvoEventIntent event) {
        this.setData(this.getGameId());
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        this.refreshGameState();
        if (!Boolean.valueOf(this.isManager()).equals(this.isMePlayManager.getValue())) {
            this.isMePlayManager.setValue((Object)this.isManager());
        }
    }

    private void refreshGameState() {
        this.updateActionBtn(this.getChannel().getSeatService().getSeatUidsList(), this.getChannel().getSeatService().getSeatStatusList(), this.mPrepareState.isLoading());
    }

    public boolean isChessGameMode() {
        return this.getRoomData().isInChessGame();
    }

    public boolean isAssistGameMode() {
        return this.getRoomData().isInAssistGame();
    }

    @Override
    public void onGameStateChanged(String mode) {
        if (this.isPrepareMode(mode)) {
            boolean fromVisible;
            if ("GAME_LOADING".equals(mode)) {
                this.prepareState().postValue(new Pair((Object)false, (Object)"LOADING"));
            } else if ("GAME_FAIL".equals(mode)) {
                this.prepareState().postValue(new Pair((Object)false, (Object)"FAIL"));
            } else if ("GAME_NOT_SUPPORT".equals(mode) || !this.roomGameService.isSupportGame()) {
                this.prepareState().postValue(new Pair((Object)false, (Object)"NOT_SUPPORT"));
                this.getTips().postValue((Object)ResourceUtils.getString((int)R.string.short_tips_game_not_compat));
            } else {
                this.prepareState().postValue(new Pair((Object)false, (Object)"INIT"));
                this.updateActionBtn(this.getChannel().getSeatService().getSeatUidsList(), this.getChannel().getSeatService().getSeatStatusList(), false);
            }
            boolean bl = fromVisible = !Boolean.TRUE.equals(this.mPrepareUiData.getValue());
            if (!fromVisible) {
                String roomId = ((PrepareStatusPresenter)this.getPresenter(PrepareStatusPresenter.class)).getRoomData().getRoomId();
                SeatTrack.INSTANCE.reportGameRulePanelShow(roomId);
            }
            this.mPrepareUiData.setValue((Object)true);
        } else {
            MLog.info((Object)TAG, (String)"destroy GamePreparePresenter ui", (Object[])new Object[0]);
            this.mPrepareUiData.setValue((Object)false);
        }
    }

    private boolean isPrepareMode(String mode) {
        PrepareStatusPresenter modePresenter = (PrepareStatusPresenter)this.getPresenter(PrepareStatusPresenter.class);
        return modePresenter.isGameMode(mode) && modePresenter.isPrepare(mode);
    }

    private void updateActionBtn(List<Long> seatUids, List<Long> status, boolean isLoading) {
        if (this.roomGameService.isSupportGame() && !isLoading && this.prepareState() != null && this.prepareState().getValue() != null && !StringUtils.equal((String)"FAIL", (String)(this.mPrepareState.getValue() != null ? (String)((Pair)this.mPrepareState.getValue()).second : "")) && !this.isDestroyed()) {
            this.updateActionEnable(seatUids, status);
        }
    }

    @Override
    public void setPrepareState(Pair<Boolean, String> state) {
        MLog.info((Object)TAG, (String)"setPrepareState %s", (Object[])new Object[]{state.toString()});
        this.mPrepareState.postValue(state);
    }

    @Override
    public void onGamePrepareAction() {
        if (this.mPrepareState.getValue() != null) {
            if (this.isManager()) {
                this.onOwnerAction((Pair<Boolean, String>)((Pair)this.mPrepareState.getValue()));
            } else {
                this.onGuestAction((Pair<Boolean, String>)((Pair)this.mPrepareState.getValue()));
            }
        }
    }

    public PrepareStateLiveData prepareState() {
        return this.mPrepareState;
    }

    private void onOwnerAction(Pair<Boolean, String> state) {
        MLog.info((Object)TAG, (String)"onOwnerAction %s", (Object[])new Object[]{state.toString()});
        switch ((String)state.second) {
            case "LOADING": {
                break;
            }
            case "INIT": {
                ToastUtils.showToast((Activity)this.getContext(), (int)R.string.short_tips_not_all_ready, (int)0);
                break;
            }
            case "READIED": {
                if (((Boolean)state.first).booleanValue()) {
                    this.roomGameService.startPlay((Callback<Boolean>)((Callback)data2 -> MLog.info((Object)TAG, (String)"startPlay onResponse %b", (Object[])new Object[]{data2})));
                    SeatTrack.INSTANCE.startGameClick(this.getChannelId(), this.getGameId());
                    break;
                }
                ToastUtils.showToast((Activity)this.getContext(), (int)R.string.short_tips_not_all_ready, (int)0);
                break;
            }
            case "JOINED": {
                this.onReady();
                break;
            }
        }
    }

    private void onGuestAction(Pair<Boolean, String> state) {
        MLog.info((Object)TAG, (String)"onGuestAction %s", (Object[])new Object[]{state.toString()});
        switch ((String)state.second) {
            case "LOADING": {
                break;
            }
            case "INIT": {
                if (((Boolean)state.first).booleanValue()) {
                    ((SeatPresenter)((IChannelPageContext)this.getMvpContext()).getPresenter(SeatPresenter.class)).onSitDown(-1, (Callback<Integer>)((Callback)data2 -> {
                        if (data2 instanceof Integer && (Integer)data2 > 0) {
                            this.roomGameService.changeReady(true, (Callback<Boolean>)((Callback)isSuccess -> {
                                if (isSuccess.booleanValue()) {
                                    this.mPrepareState.postValue(new Pair((Object)true, (Object)"READIED"));
                                } else {
                                    this.mPrepareState.postValue(new Pair((Object)true, (Object)"JOINED"));
                                }
                            }));
                        }
                    }));
                    SeatTrack.INSTANCE.downJoinClick(this.getChannelId(), this.getGameId());
                    break;
                }
                ToastUtils.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_seat_full), (int)0);
                break;
            }
            case "READIED": {
                this.roomGameService.changeReady(false, (Callback<Boolean>)((Callback)data2 -> {
                    if (data2.booleanValue()) {
                        this.mPrepareState.postValue(new Pair((Object)true, (Object)"JOINED"));
                    }
                }));
                SeatTrack.INSTANCE.cancelReadyClick(this.getChannelId(), this.getGameId());
                break;
            }
            case "JOINED": {
                this.onReady();
                SeatTrack.INSTANCE.upReadyClick(this.getChannelId(), this.getGameId());
                break;
            }
        }
    }

    private void onReady() {
        MLog.info((Object)TAG, (String)"onReady", (Object[])new Object[0]);
        this.roomGameService.changeReady(true, (Callback<Boolean>)WeakCallback.of((IDestroyable)this, data2 -> {
            if (data2.booleanValue()) {
                this.mPrepareState.postValue(new Pair((Object)true, (Object)"READIED"));
            }
        }));
    }

    private void updateActionEnable(List<Long> seatUids, List<Long> status) {
        MLog.info((Object)TAG, (String)"updateActionEnable isManager %s, isDestroyed: %b, uid: %s, status: %s, is", (Object[])new Object[]{this.isManager(), this.isDestroyed(), seatUids, status});
        if (this.isDestroyed()) {
            MLog.error((Object)TAG, (String)"updateActionEnable isDestroyed presenter \u88ab\u9500\u6bc1\u4e86", (Object[])new Object[0]);
            return;
        }
        if (this.isManager()) {
            boolean isReady = this.isAllReady();
            boolean isMeReady = SeatStatusUtils.isGameReady((long)this.getChannel().getSeatService().getSeatStatus(AccountUtil.getUid()));
            this.mPrepareState.postValue(new Pair((Object)isReady, (Object)(isReady ? "READIED" : (isMeReady ? "READIED" : "JOINED"))));
        } else {
            boolean enable = this.isActionBtnEnable(seatUids, status);
            int index = seatUids.indexOf(AccountUtil.getUid());
            if (index > 0) {
                MLog.info((Object)TAG, (String)"\u5728\u5ea7\u4f4d%s\u4e0a\uff0c\u662f\u5426\u53ef\u4ee5\u64cd\u4f5c:%s", (Object[])new Object[]{index, enable});
                this.mPrepareState.postValue(new Pair((Object)enable, (Object)(SeatStatusUtils.isGameReady((long)status.get(index)) ? "READIED" : "JOINED")));
            } else {
                MLog.info((Object)TAG, (String)"\u4e0d\u5728\u5ea7\u4f4d\u4e0a\uff0c\u662f\u5426\u53ef\u4ee5\u64cd\u4f5c:%s", (Object[])new Object[]{enable});
                this.mPrepareState.postValue(new Pair((Object)enable, (Object)"INIT"));
            }
        }
    }

    private boolean isActionBtnEnable(List<Long> seatUids, List<Long> status) {
        if (!this.getChannel().getSeatService().isInSeat(AccountUtil.getUid())) {
            int size = seatUids.size();
            for (int i = 0; i < size; ++i) {
                long uid = seatUids.get(i);
                if (uid != 0L || SeatStatusUtils.isLocked((long)status.get(i))) continue;
                if (this.getChannel().getSeatService().isFirstSeatIndex(i + 1)) {
                    if (!this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid()) && !this.getChannel().getRoleService().isMeAnchor()) continue;
                    return true;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isAllReady() {
        GameInfo info = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.getGameId());
        if (info != null) {
            int playerCount = info.getMinPlayerCount();
            int readyCount = 0;
            boolean isAllReady = true;
            int uidSize = FP.size((Collection)this.getRoomData().getSeatData().getSeatUidsList());
            int statusSize = FP.size((Collection)this.getChannel().getSeatService().getSeatStatusList());
            for (int i = 0; i < uidSize; ++i) {
                long status;
                long uid = (Long)this.getChannel().getSeatService().getSeatUidsList().get(i);
                long l = status = i < statusSize ? (Long)this.getChannel().getSeatService().getSeatStatusList().get(i) : 0L;
                if (uid <= 0L) continue;
                if (SeatStatusUtils.isGameReady((long)status)) {
                    ++readyCount;
                    continue;
                }
                isAllReady = false;
                break;
            }
            FeatureLog.i((String)"FTVoiceRoom", (String)"seat user is all ready:%b, ready count:%d, min player count:%d", (Object[])new Object[]{isAllReady, readyCount, playerCount});
            return isAllReady && readyCount >= playerCount;
        }
        FeatureLog.e((String)"FTVoiceRoom", (String)"\u6e38\u620fid\uff1a%s \u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c\u672a\u51c6\u5907\u72b6\u6001\u3002", (Object[])new Object[]{this.getGameId()});
        return false;
    }

    @Override
    public LiveData<GameInfo> gameInfo() {
        return this.mGameInfo;
    }

    @Override
    public MutableLiveData<String> gameSubName() {
        return this.mGameSubName;
    }

    @Override
    public MutableLiveData<List<View>> funcBtns() {
        return this.mFuncBtns;
    }

    @Override
    public LiveData<Integer> gameProgress() {
        return this.mGameProgress;
    }

    @Override
    public void setGameProgress(int progress) {
        if (this.mGameProgress.getValue() == null || !((Integer)this.mGameProgress.getValue()).equals(progress)) {
            MLog.info((Object)TAG, (String)"setGameProgress %d", (Object[])new Object[]{progress});
            this.mGameProgress.setValue((Object)progress);
        }
    }

    private boolean isManager() {
        return (this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid()) || this.getChannel().getRoleService().isMeAnchor()) && this.getChannel().getSeatService().isInFirstSeat(AccountUtil.getUid());
    }

    @Override
    public void quitGameMode() {
        MLog.info((Object)TAG, (String)"quitGameMode", (Object[])new Object[0]);
        this.getChannel().getPluginService().closeCurrentPlugin(null);
    }

    @Override
    public boolean canClosePlugin() {
        IPlugin.InterceptPluginChange intercept = ((AbsPluginPresenter)this.getPresenter(AbsPluginPresenter.class)).canBeRemoveWhileRunning(null, null);
        return (this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid()) || this.getChannel().getRoleService().isMeAnchor()) && intercept.canChange;
    }

    @Override
    public MutableLiveData<String> getTips() {
        return this.mTips;
    }

    @Override
    public void onLoadAgain() {
        if (((IChannelPageContext)this.getMvpContext()).hasPresenter(AbsPluginPresenter.class)) {
            ((AbsPluginPresenter)this.getPresenter(AbsPluginPresenter.class)).reLoadGame();
        }
    }

    @Override
    public void showGameRule(GameInfo gameInfo) {
        if (this.mOnUiCallback != null) {
            this.mOnUiCallback.showGameRule(gameInfo);
        }
        SeatTrack.INSTANCE.reportGameRuleBtnClick(this.getChannelId());
    }

    @Override
    public void setOnUiCallback(SeatMvp.IGamePresenter.OnUiCallback callback2) {
        this.mOnUiCallback = callback2;
    }

    @Override
    public void trackClose() {
        SeatTrack.INSTANCE.panelCloseClick(this.getChannelId(), this.getGameId());
    }

    @Override
    public int getTotalSeatCount() {
        return 8;
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationIdDef.WEBSOCKET_CONNECT) {
            this.onLoadAgain();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        this.mBinder.clearAllKvoConnections();
        this.getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
        ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).removeGameInfoListener(this.gameListChangeListener);
        NotificationCenter.getGlobalInstance().unregister(NotificationIdDef.WEBSOCKET_CONNECT, (INotify)this);
    }

    private String getGameId() {
        return this.getRoomData().getRoomGame().getPluginId();
    }

    @Override
    public LiveData<Boolean> getPrepareUiData() {
        return this.mPrepareUiData;
    }

    private FragmentActivity getContext() {
        return ((IChannelPageContext)this.getMvpContext()).getContext();
    }

    @Override
    public LiveData<Boolean> isMePlayManager() {
        return this.isMePlayManager;
    }

    @Override
    public LiveData<Boolean> isCanClose() {
        return this.isCanClose;
    }
}

