/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.plugin;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.FacePoint;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IGameData;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.PluginKvoDelegate;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbsPluginPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IPlugin,
IHolderPresenter,
IGameData {
    private static final String TAG = "AbsPluginPresenter";
    private PluginKvoDelegate kvoDelegate;
    protected final MutableLiveData<Boolean> isRunning = new MutableLiveData();
    private MutableLiveData<Boolean> mGamingUiData = new SafeLiveData();
    protected MutableLiveData<Map<Long, FacePoint>> mLocationSeatList = new MutableLiveData();

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach) {
            this.handleModeChange(this.getRoomData().getGameInfo().mode);
            this.kvoDelegate = new PluginKvoDelegate(this);
            this.kvoDelegate.onInit(this.getRoomData().getGameInfo());
        }
    }

    @Override
    public boolean interceptModeChange() {
        return false;
    }

    @Override
    public void handleModeChange(long mode) {
        MLog.info((Object)TAG, (String)"handleModeChange mode: %s, this %s", (Object[])new Object[]{mode, this});
        if (!this.interceptRunningState()) {
            this.isRunning.setValue((Object)true);
        }
    }

    @Override
    public void handleGameStateChange(boolean started) {
        MLog.info((Object)TAG, (String)"handleGameStateChange started %b, this %s", (Object[])new Object[]{started, this});
    }

    @Override
    public void exit(ICommonCallback<Boolean> callback2) {
    }

    @Override
    public void resumeStateAfterExit() {
        this.handleGameStateChange(false);
    }

    @Override
    public void reLoadGame() {
    }

    @Override
    public void resumePlugin() {
    }

    protected void setGameContainerVisibility(boolean show) {
        this.mGamingUiData.setValue((Object)show);
    }

    protected void setSeatViewVisibility(boolean show) {
        ((SeatPresenter)this.getPresenter(SeatPresenter.class)).setSeatVisibility(show);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.kvoDelegate != null) {
            this.kvoDelegate.onDestroy();
        }
    }

    @Override
    @NonNull
    public LiveData<Boolean> isRunning() {
        return this.isRunning;
    }

    @Override
    public LiveData<Boolean> getGamingUiData() {
        return this.mGamingUiData;
    }

    @Override
    public MutableLiveData<Map<Long, FacePoint>> getGameSeatLocation() {
        return this.mLocationSeatList;
    }

    public boolean isCompatible() {
        return true;
    }

    public void setContainer(@NotNull View container) {
    }
}

