/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.voiceroom.common.gamelobby;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/yy/hiyo/channel/plugins/voiceroom/common/gamelobby/GameStartChecker;", "", "()V", "TAG", "", "canPlay", "", "context", "Landroid/content/Context;", "gameId", "ignorePlaying", "channel-components_debug"})
public final class GameStartChecker {
    @NotNull
    public static final String TAG = "GameStartChecker";
    public static final GameStartChecker INSTANCE;

    public final boolean canPlay(@NotNull Context context, @NotNull String gameId, boolean ignorePlaying) {
        boolean isPlaying;
        GameInfo gameInfo;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)gameId, (String)"gameId");
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.error_team_game_invalid), (int)0);
            MLog.error((Object)TAG, (String)"canPlay():gameId is empty!!!", (Object[])new Object[0]);
            return false;
        }
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        GameInfo gameInfo2 = iServiceManager != null && (iServiceManager = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) != null ? iServiceManager.getGameInfoByGid(gameId) : (gameInfo = null);
        if (gameInfo == null) {
            ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.error_team_game_invalid), (int)0);
            MLog.error((Object)TAG, (String)"canPlay():gameInfo is null!!!", (Object[])new Object[0]);
            return false;
        }
        IServiceManager iServiceManager2 = ServiceManagerProxy.getServiceManager();
        boolean bl = iServiceManager2 != null && (iServiceManager2 = (IGameCenterService)iServiceManager2.getService(IGameCenterService.class)) != null ? iServiceManager2.isPlaying() : (isPlaying = false);
        if (isPlaying && !ignorePlaying) {
            ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.in_game), (int)0);
            MLog.error((Object)TAG, (String)"canPlay():game is playing!!!", (Object[])new Object[0]);
            return false;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            MLog.error((Object)TAG, (String)ResourceUtils.getString((int)R.string.network_error), (Object[])new Object[0]);
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return false;
        }
        return true;
    }

    public final boolean canPlay(@NotNull Context context, @NotNull String gameId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)gameId, (String)"gameId");
        return this.canPlay(context, gameId, false);
    }

    private GameStartChecker() {
    }

    static {
        GameStartChecker gameStartChecker;
        INSTANCE = gameStartChecker = new GameStartChecker();
    }
}

