/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.secretcall;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.util.KeepScreenOnTask;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.module.mini.MiniMvp;
import com.yy.hiyo.channel.module.secretcall.SecretCallReport;
import com.yy.hiyo.channel.module.secretcall.SecretUICallback;
import com.yy.hiyo.channel.module.secretcall.secretmini.SecretCallMiniPresenter;
import com.yy.hiyo.channel.module.secretcall.secretvoice.SecretCallVoicePresenter;
import com.yy.hiyo.channel.secretcall.ISecretCallService;
import com.yy.hiyo.channel.secretcall.SecretCallData;
import com.yy.hiyo.channel.secretcall.SecretCallMatchInfo;
import com.yy.hiyo.channel.secretcall.SecretCallStatus;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.secretcall.InviteType;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0003J\u0006\u0010 \u001a\u00020\u0012J\u0006\u0010!\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0012J\u0006\u0010&\u001a\u00020\u0012J\u0006\u0010'\u001a\u00020\u0012J\u000e\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u001bJ\b\u0010*\u001a\u00020\u0012H\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u001fH\u0007J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u001fH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/yy/hiyo/channel/module/secretcall/SecretCallPresenter;", "", "callback", "Lcom/yy/hiyo/channel/module/secretcall/SecretUICallback;", "(Lcom/yy/hiyo/channel/module/secretcall/SecretUICallback;)V", "getCallback", "()Lcom/yy/hiyo/channel/module/secretcall/SecretUICallback;", "kvoBinder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "mKeepScreenOnTask", "Lcom/yy/appbase/util/KeepScreenOnTask;", "miniPresenter", "Lcom/yy/hiyo/channel/module/mini/MiniMvp$IPresenter;", "service", "Lcom/yy/hiyo/channel/secretcall/ISecretCallService;", "voicePresenter", "Lcom/yy/hiyo/channel/module/secretcall/secretvoice/SecretCallVoicePresenter;", "bindOtherFollowStatus", "", "closeSpeaker", "destroy", "getServiceManager", "Lcom/yy/appbase/service/IServiceManager;", "notifyWebFollowStatus", "uid", "", "follow", "", "notifyWebViewMatchStatus", "onFollowStatusChanged", "event", "Lcom/yy/base/event/kvo/KvoEventIntent;", "onStartSecretPage", "openSpeaker", "playSound", "soundType", "", "resumeWebView", "startMatch", "stopMatch", "switchMic", "open", "unBindOtherFollowStatus", "updateMiniWindow", "eventIntent", "updateWebNotifyFromService", "Companion", "channel-components_debug"})
public final class SecretCallPresenter {
    private final ISecretCallService service;
    private MiniMvp.IPresenter miniPresenter;
    private SecretCallVoicePresenter voicePresenter;
    private final KvoBinder kvoBinder;
    private KeepScreenOnTask mKeepScreenOnTask;
    @NotNull
    private final SecretUICallback callback;
    @NotNull
    public static final String TAG = "SecretCallPresenter";
    public static final Companion Companion = new Companion(null);

    public final void resumeWebView() {
        block0: {
            MLog.info((Object)TAG, (String)"resumeWebView", (Object[])new Object[0]);
            MiniMvp.IPresenter iPresenter = this.miniPresenter;
            if (iPresenter == null) break block0;
            iPresenter.enterRoom();
        }
    }

    public final void onStartSecretPage() {
        MLog.info((Object)TAG, (String)"onStartSecretPage", (Object[])new Object[0]);
        this.voicePresenter.onStartSecretPage();
    }

    @KvoMethodAnnotation(name="kvo_secret_call_mini", sourceClass=SecretCallData.class)
    public final void updateMiniWindow(@NotNull KvoEventIntent eventIntent) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)eventIntent, (String)"eventIntent");
                MLog.info((Object)TAG, (String)("secret call mini show:" + this.service.data().getShowMiniWebView() + ' '), (Object[])new Object[0]);
                if (!this.service.data().getShowMiniWebView()) break block0;
                MiniMvp.IPresenter iPresenter = this.miniPresenter;
                if (iPresenter == null) break block1;
                iPresenter.showMiniUi();
                break block1;
            }
            MiniMvp.IPresenter iPresenter = this.miniPresenter;
            if (iPresenter == null) break block1;
            iPresenter.hideMiniUi();
        }
    }

    @KvoMethodAnnotation(name="kvo_secret_call_status", sourceClass=SecretCallData.class)
    public final void updateWebNotifyFromService(@NotNull KvoEventIntent eventIntent) {
        Intrinsics.checkParameterIsNotNull((Object)eventIntent, (String)"eventIntent");
        SecretCallMatchInfo matchInfo = this.service.data().getMatchInfo();
        if (matchInfo.getStatus() == SecretCallStatus.MATCH) {
            String acceptChannelId = this.service.data().getAcceptInfo().getChannelId();
            if (matchInfo.getMatchPath() == 1 && matchInfo.getInviteType() == InviteType.INVITE_PARTY.getValue() && !TextUtils.isEmpty((CharSequence)acceptChannelId)) {
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL, -1, -1, (Object)acceptChannelId);
                Message msg = Message.obtain();
                msg.what = AppbaseMsgDef.SecretCallDef.OPEN_SECRET_CALL_MATCHING_PAGE;
                Bundle bundle = new Bundle();
                bundle.putInt("inviteType", matchInfo.getInviteType());
                bundle.putString("sid", matchInfo.getSid());
                bundle.putString("matchId", matchInfo.getMatchId());
                bundle.putLong("otherUid", matchInfo.getOtherUid());
                bundle.putLong("heartBeat", matchInfo.getHeartBeat());
                bundle.putString("backChannelId", acceptChannelId);
                Message message = msg;
                Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"msg");
                message.setData(bundle);
                MsgDispatcher.getInstance().sendMessage(msg);
                SecretCallReport.INSTANCE.matchSuccessReport(matchInfo.getOtherUid(), "2", acceptChannelId);
                return;
            }
            if (matchInfo.getMatchPath() == 1 && matchInfo.getInviteType() == InviteType.INVITE_PULLDOWN_POPUPS.getValue()) {
                Message msg = Message.obtain();
                msg.what = AppbaseMsgDef.SecretCallDef.OPEN_SECRET_CALL_MATCHING_PAGE;
                Bundle bundle = new Bundle();
                bundle.putInt("inviteType", matchInfo.getInviteType());
                bundle.putString("sid", matchInfo.getSid());
                bundle.putString("matchId", matchInfo.getMatchId());
                bundle.putLong("otherUid", matchInfo.getOtherUid());
                bundle.putLong("heartBeat", matchInfo.getHeartBeat());
                Message message = msg;
                Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"msg");
                message.setData(bundle);
                MsgDispatcher.getInstance().sendMessage(msg);
                SecretCallReport.INSTANCE.matchSuccessReport(matchInfo.getOtherUid(), "1", acceptChannelId);
            }
        }
        this.notifyWebViewMatchStatus();
    }

    private final void notifyWebViewMatchStatus() {
        String json = this.service.getMatchStatusJson();
        MLog.info((Object)TAG, (String)"notify secret call status json: %s", (Object[])new Object[]{json});
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        ((IWebService)iServiceManager.getService(IWebService.class)).loadNotifyJs("", JsEventDefine.NOTIFY.onSecretCallStatus, json);
    }

    public final void playSound(@NotNull String soundType) {
        Intrinsics.checkParameterIsNotNull((Object)soundType, (String)"soundType");
        MLog.info((Object)TAG, (String)("playSound soundType:" + soundType), (Object[])new Object[0]);
        this.voicePresenter.playSound(soundType);
    }

    public final void startMatch() {
        MLog.info((Object)TAG, (String)"startMatch", (Object[])new Object[0]);
        this.voicePresenter.matchSecret(true);
        this.bindOtherFollowStatus();
        Context context = this.callback.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        this.mKeepScreenOnTask.keepScreenOn((Activity)context);
    }

    public final void stopMatch() {
        MLog.info((Object)TAG, (String)"stopMatch", (Object[])new Object[0]);
        this.voicePresenter.matchSecret(false);
        this.voicePresenter.switchMic(false);
        Context context = this.callback.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        this.mKeepScreenOnTask.unDoKeepScreenOn((Activity)context);
    }

    public final void switchMic(boolean open) {
        MLog.info((Object)TAG, (String)("switchMic:" + open), (Object[])new Object[0]);
        this.voicePresenter.switchMic(open);
    }

    public final void openSpeaker() {
        MLog.info((Object)TAG, (String)"openSpeaker", (Object[])new Object[0]);
        this.voicePresenter.openSpeaker();
    }

    public final void closeSpeaker() {
        MLog.info((Object)TAG, (String)"closeSpeaker", (Object[])new Object[0]);
        this.voicePresenter.closeSpeaker();
    }

    private final void bindOtherFollowStatus() {
        MLog.info((Object)TAG, (String)"bindOtherFollowStatus", (Object[])new Object[0]);
        if (ServiceManagerProxy.getService(IRelationService.class) != null) {
            RelationInfo info;
            IRelationService iRelationService = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
            RelationInfo relationInfo = info = iRelationService != null ? iRelationService.getRelationLocal(this.service.getTargetUid()) : null;
            if (info != null) {
                MLog.info((Object)TAG, (String)("bindOtherFollowStatus:info:" + info), (Object[])new Object[0]);
                this.kvoBinder.singleBindSourceTo("SecretCallFollow", (KvoSource)info);
            }
        }
    }

    private final void unBindOtherFollowStatus() {
        MLog.info((Object)TAG, (String)"unBindOtherFollowStatus", (Object[])new Object[0]);
        if (ServiceManagerProxy.getService(IRelationService.class) != null) {
            RelationInfo info;
            IRelationService iRelationService = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
            RelationInfo relationInfo = info = iRelationService != null ? iRelationService.getRelationLocal(this.service.getTargetUid()) : null;
            if (info != null) {
                this.kvoBinder.clearKvoConnection("SecretCallFollow");
            }
        }
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    private final void onFollowStatusChanged(KvoEventIntent event) {
        KvoSource kvoSource = event.source();
        Intrinsics.checkExpressionValueIsNotNull((Object)kvoSource, (String)"event.source()");
        RelationInfo info = (RelationInfo)kvoSource;
        if (info != null) {
            this.notifyWebFollowStatus(info.getUid(), info.isFollow());
        }
    }

    private final void notifyWebFollowStatus(long uid, boolean follow) {
        String string2 = new JSONObject(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"uid", (Object)uid), TuplesKt.to((Object)"follow", (Object)follow)})).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JSONObject(mapOf(\n      \u2026low\n        )).toString()");
        String post = string2;
        MLog.info((Object)TAG, (String)"notifyWebFollowStatus: %s", (Object[])new Object[]{post});
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        ((IWebService)iServiceManager.getService(IWebService.class)).loadNotifyJs("", JsEventDefine.NOTIFY.onNotifyFollowStatus, post);
    }

    @NotNull
    public final IServiceManager getServiceManager() {
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.yy.appbase.service.IServiceManager");
        }
        return iServiceManager;
    }

    public final void destroy() {
        MLog.info((Object)TAG, (String)"destroy", (Object[])new Object[0]);
        this.kvoBinder.clearKvoConnection("SecretCallFollow");
        Context context = this.callback.getContext();
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        this.mKeepScreenOnTask.unDoKeepScreenOn((Activity)context);
        MiniMvp.IPresenter iPresenter = this.miniPresenter;
        if (iPresenter != null) {
            iPresenter.hideMiniUi();
        }
        this.voicePresenter.switchMic(false);
        this.voicePresenter.destroy();
    }

    @NotNull
    public final SecretUICallback getCallback() {
        return this.callback;
    }

    public SecretCallPresenter(@NotNull SecretUICallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        this.callback = callback2;
        IService iService = ServiceManagerProxy.getService(ISecretCallService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)iService, (String)"ServiceManagerProxy.getS\u2026tCallService::class.java)");
        this.service = (ISecretCallService)iService;
        this.voicePresenter = new SecretCallVoicePresenter(this.callback);
        this.kvoBinder = new KvoBinder((Object)this);
        this.mKeepScreenOnTask = new KeepScreenOnTask();
        this.miniPresenter = new SecretCallMiniPresenter(this.callback);
        this.kvoBinder.singleBindSourceTo((KvoSource)this.service.data());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/module/secretcall/SecretCallPresenter$Companion;", "", "()V", "TAG", "", "channel-components_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

