/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.notice;

import android.text.Spanned;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.im.base.ChannelNoticeMessage;

public class ChannelMessageCreator {
    public static ChannelNoticeMessage createUserRoleChangeMsg(NotifyDataDefine.UserRoleChange userRoleChange) {
        if (userRoleChange == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createUserRoleChangeMsg null", (Object[])new Object[0]);
            return null;
        }
        if (!userRoleChange.chNotify) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createUserRoleChangeMsg not ch", (Object[])new Object[]{userRoleChange.getMsgId()});
            return null;
        }
        if (userRoleChange.changedUserInfo == null || userRoleChange.operatorUserInfo == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createUserRoleChangeMsg userInfo null, msgId:%s", (Object[])new Object[]{userRoleChange.getMsgId()});
            return null;
        }
        if (userRoleChange.autoApprove) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createUserRoleChangeMsg autoApprove", (Object[])new Object[0]);
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createBaseInfo((NotifyDataDefine.AbsSignal)userRoleChange);
        channelNoticeMessage.setFromAvatar(userRoleChange.operatorUserInfo.avatar);
        channelNoticeMessage.setFromNick(userRoleChange.operatorUserInfo.nick);
        channelNoticeMessage.setFromUid(userRoleChange.operatorUserInfo.uid);
        channelNoticeMessage.setNeedJump(true);
        channelNoticeMessage.setShowChannelHeader(true);
        channelNoticeMessage.setChannelAvatar(userRoleChange.channelAvatar);
        channelNoticeMessage.setVersion(userRoleChange.version);
        if (userRoleChange.channelType == 0) {
            channelNoticeMessage.setChannelType(1);
        } else {
            channelNoticeMessage.setChannelType(userRoleChange.channelType);
        }
        int roleType = userRoleChange.roleType;
        Spanned content = null;
        if (roleType == 10) {
            content = userRoleChange.uid != AccountUtil.getUid() ? (userRoleChange.operatorUserInfo.uid != AccountUtil.getUid() ? StringUtils.getHtmlText((int)R.string.tips_channel_set_admi_notice_new, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.operatorUserInfo.nick, (int)15), ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.changedUserInfo.nick, (int)15)}) : StringUtils.getHtmlText((int)R.string.tips_channel_self_set_admi_notice_new, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.changedUserInfo.nick, (int)15)})) : StringUtils.getHtmlText((int)R.string.tips_channel_set_you_admi_notice_new, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.operatorUserInfo.nick, (int)15)});
        } else if (roleType == 5) {
            content = userRoleChange.uid != AccountUtil.getUid() ? StringUtils.getHtmlText((int)R.string.tips_channel_cancel_admi_notice_new, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.operatorUserInfo.nick, (int)15), ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.changedUserInfo.nick, (int)15)}) : StringUtils.getHtmlText((int)R.string.tips_channel_cancel_you_admi_notice_new, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.operatorUserInfo.nick, (int)15)});
        } else if (roleType == 1) {
            channelNoticeMessage.setNeedJump(false);
            if (userRoleChange.operatorUserInfo.uid == userRoleChange.changedUserInfo.uid) {
                channelNoticeMessage.setShowChannelHeader(false);
                content = StringUtils.getHtmlText((int)R.string.tips_channel_self_remove, (Object[])new Object[]{userRoleChange.getCname()});
            } else {
                content = userRoleChange.uid != AccountUtil.getUid() ? StringUtils.getHtmlText((int)R.string.tips_channel_leave_notice, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.operatorUserInfo.nick, (int)15), ShortNameUtils.getShortNameWithoutColon((String)userRoleChange.changedUserInfo.nick, (int)15)}) : StringUtils.getHtmlText((int)R.string.tips_channel_leave_you_notice, (Object[])new Object[0]);
            }
        }
        channelNoticeMessage.setContent(content);
        channelNoticeMessage.setType(5);
        channelNoticeMessage.setOperatorName(userRoleChange.operatorUserInfo.nick);
        channelNoticeMessage.setNeedLarge(false);
        FeatureLog.i((String)"FTChannelNotice", (String)"createUserRoleChangeMsg:%s", (Object[])new Object[]{channelNoticeMessage.toString()});
        return channelNoticeMessage;
    }

    public static ChannelNoticeMessage createJoinApproveMsg(NotifyDataDefine.JoinApprove approve) {
        if (approve == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApproveMsg null", (Object[])new Object[0]);
            return null;
        }
        if (!approve.chNotify) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApproveMsg not ch", (Object[])new Object[]{approve.getMsgId()});
            return null;
        }
        if (approve.applyUserInfo == null || approve.approveUserInfo == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApproveMsg userInfo null, msgId:%s", (Object[])new Object[]{approve.getMsgId()});
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createBaseInfo((NotifyDataDefine.AbsSignal)approve);
        if (approve.channelType == 0) {
            channelNoticeMessage.setChannelType(1);
        } else {
            channelNoticeMessage.setChannelType(approve.channelType);
        }
        channelNoticeMessage.setFromAvatar(approve.applyUserInfo.avatar);
        channelNoticeMessage.setFromNick(approve.applyUserInfo.nick);
        channelNoticeMessage.setFromUid(approve.applyUserInfo.uid);
        channelNoticeMessage.setNeedLarge(true);
        channelNoticeMessage.setShowChannelHeader(false);
        channelNoticeMessage.setChannelAvatar(approve.channelAvatar);
        channelNoticeMessage.setVersion(approve.version);
        channelNoticeMessage.setStatus(approve.accept ? 2 : 1);
        Spanned content = null;
        if (approve.accept) {
            if (approve.applyerUid == AccountUtil.getUid()) {
                channelNoticeMessage.setShowChannelHeader(true);
                channelNoticeMessage.setNeedJump(true);
                content = StringUtils.getHtmlText((int)R.string.tips_channel_admin_agree_notice_new, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)approve.approveUserInfo.nick, (int)15)});
            } else {
                content = StringUtils.getHtmlText((int)R.string.tips_channel_apply_notice_new, (Object[])new Object[]{approve.getCname()});
            }
        } else if (approve.applyerUid == AccountUtil.getUid()) {
            channelNoticeMessage.setShowChannelHeader(true);
            content = StringUtils.getHtmlText((int)R.string.tips_channel_refuse_notice_new, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)approve.approveUserInfo.nick, (int)15)});
        } else {
            content = StringUtils.getHtmlText((int)R.string.tips_channel_apply_notice_new, (Object[])new Object[]{approve.getCname()});
        }
        channelNoticeMessage.setContent(content);
        channelNoticeMessage.setApplyId(approve.applyId);
        channelNoticeMessage.setType(3);
        channelNoticeMessage.setOperatorName(approve.approveUserInfo.nick);
        FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApproveMsg:%s", (Object[])new Object[]{channelNoticeMessage.toString()});
        return channelNoticeMessage;
    }

    public static ChannelNoticeMessage createAcceptRoleMsg(NotifyDataDefine.AcceptRole notify2) {
        if (notify2 == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createAcceptRoleMsg null", (Object[])new Object[0]);
            return null;
        }
        if (!notify2.chNotify) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createAcceptRoleMsg not ch", (Object[])new Object[]{notify2.getMsgId()});
            return null;
        }
        if (notify2.inviteeUserInfo == null || notify2.inviterUserInfo == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createAcceptRoleMsg userInfo null, msgId:%s", (Object[])new Object[]{notify2.getMsgId()});
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createBaseInfo((NotifyDataDefine.AbsSignal)notify2);
        if (notify2.channelType == 0) {
            channelNoticeMessage.setChannelType(1);
        } else {
            channelNoticeMessage.setChannelType(notify2.channelType);
        }
        channelNoticeMessage.setStatus(notify2.accept ? 2 : 1);
        channelNoticeMessage.setType(4);
        channelNoticeMessage.setFromAvatar(notify2.inviteeUserInfo.avatar);
        channelNoticeMessage.setFromNick(notify2.inviteeUserInfo.nick);
        channelNoticeMessage.setFromUid(notify2.inviteeUserInfo.uid);
        channelNoticeMessage.setSetId(notify2.roleSetId);
        channelNoticeMessage.setChannelAvatar(notify2.channelAvatar);
        channelNoticeMessage.setVersion(notify2.version);
        Spanned content = null;
        if (notify2.inviterUserInfo.uid == AccountUtil.getUid()) {
            channelNoticeMessage.setShowChannelHeader(false);
            content = notify2.accept ? StringUtils.getHtmlText((int)R.string.tips_channel_accept_join_notice_new, (Object[])new Object[]{notify2.getCname()}) : StringUtils.getHtmlText((int)R.string.tips_channel_refuse_join_notice_new, (Object[])new Object[]{notify2.getCname()});
        } else if (notify2.inviteeUserInfo.uid == AccountUtil.getUid()) {
            channelNoticeMessage.setShowChannelHeader(true);
            if (notify2.accept) {
                channelNoticeMessage.setNeedJump(true);
            }
            if (channelNoticeMessage.getChannelType() == 2) {
                channelNoticeMessage.setNeedLarge(false);
                content = StringUtils.getHtmlText((int)R.string.tips_room_invite_notice, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)notify2.inviterUserInfo.nick, (int)15)});
            } else if (channelNoticeMessage.getChannelType() == 1) {
                channelNoticeMessage.setNeedLarge(true);
                content = StringUtils.getHtmlText((int)R.string.tips_channel_invite_notice, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)notify2.inviterUserInfo.nick, (int)15)});
            }
        } else {
            channelNoticeMessage.setNeedLarge(true);
            channelNoticeMessage.setShowChannelHeader(false);
            content = StringUtils.getHtmlText((int)R.string.tips_channel_accept_join_notice_new, (Object[])new Object[]{notify2.getCname()});
        }
        channelNoticeMessage.setContent(content);
        FeatureLog.i((String)"FTChannelNotice", (String)"createAcceptRoleMsg:%s", (Object[])new Object[]{channelNoticeMessage.toString()});
        return channelNoticeMessage;
    }

    public static ChannelNoticeMessage createSetRoleMsg(NotifyDataDefine.SetRole setRole2) {
        if (setRole2 == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createSetRoleMsg null", (Object[])new Object[0]);
            return null;
        }
        if (!setRole2.chNotify) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createSetRoleMsg not ch", (Object[])new Object[]{setRole2.getMsgId()});
            return null;
        }
        if (setRole2.inviterUserInfo == null || setRole2.inviterUserInfo == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createSetRoleMsg userInfo null, msgId:%s", (Object[])new Object[]{setRole2.getMsgId()});
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createBaseInfo((NotifyDataDefine.AbsSignal)setRole2);
        if (setRole2.channelType == 0) {
            channelNoticeMessage.setChannelType(1);
        } else {
            channelNoticeMessage.setChannelType(setRole2.channelType);
        }
        channelNoticeMessage.setNeedJump(true);
        if (TimeUtils.getServiceRealTime() / 1000L - setRole2.expireTime > 0L) {
            channelNoticeMessage.setStatus(3);
            channelNoticeMessage.setNeedJump(false);
        }
        channelNoticeMessage.setShowChannelHeader(true);
        channelNoticeMessage.setChannelAvatar(setRole2.channelAvatar);
        channelNoticeMessage.setVersion(setRole2.version);
        channelNoticeMessage.setType(1);
        channelNoticeMessage.setFromAvatar(setRole2.inviterUserInfo.avatar);
        channelNoticeMessage.setFromNick(setRole2.inviterUserInfo.nick);
        channelNoticeMessage.setFromUid(setRole2.inviterUserInfo.uid);
        channelNoticeMessage.setSetId(setRole2.setId);
        if (channelNoticeMessage.getChannelType() == 1) {
            channelNoticeMessage.setNeedLarge(true);
            channelNoticeMessage.setContent(StringUtils.getHtmlText((int)R.string.tips_channel_invite_notice, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)channelNoticeMessage.getFromNick(), (int)15)}));
        } else if (channelNoticeMessage.getChannelType() == 2) {
            channelNoticeMessage.setNeedLarge(false);
            channelNoticeMessage.setContent(StringUtils.getHtmlText((int)R.string.tips_room_invite_notice, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)channelNoticeMessage.getFromNick(), (int)15)}));
        }
        FeatureLog.i((String)"FTChannelNotice", (String)"createSetRoleMsg:%s", (Object[])new Object[]{channelNoticeMessage.toString()});
        return channelNoticeMessage;
    }

    public static ChannelNoticeMessage createJoinApplyMsg(NotifyDataDefine.JoinApply joinApply) {
        if (joinApply == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApplyMsg null", (Object[])new Object[0]);
            return null;
        }
        if (!joinApply.chNotify) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApplyMsg not ch", (Object[])new Object[]{joinApply.getMsgId()});
            return null;
        }
        if (joinApply.applyUserInfo == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApplyMsg userInfo null, msgId:%s", (Object[])new Object[]{joinApply.getMsgId()});
            return null;
        }
        if (joinApply.applyUserInfo.uid == AccountUtil.getUid()) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApplyMsg self, msgId:%s", (Object[])new Object[]{joinApply.getMsgId()});
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createBaseInfo((NotifyDataDefine.AbsSignal)joinApply);
        if (joinApply.channelType == 0) {
            channelNoticeMessage.setChannelType(1);
        } else {
            channelNoticeMessage.setChannelType(joinApply.channelType);
        }
        if (TimeUtils.getServiceRealTime() / 1000L - joinApply.expireTs > 0L) {
            channelNoticeMessage.setStatus(3);
        }
        channelNoticeMessage.setType(2);
        channelNoticeMessage.setFromAvatar(joinApply.applyUserInfo.avatar);
        channelNoticeMessage.setFromNick(joinApply.applyUserInfo.nick);
        channelNoticeMessage.setFromUid(joinApply.applyUserInfo.uid);
        channelNoticeMessage.setApplyId(joinApply.applyId);
        channelNoticeMessage.setChannelAvatar(joinApply.channelAvatar);
        channelNoticeMessage.setVersion(joinApply.version);
        channelNoticeMessage.setContent(StringUtils.getHtmlText((int)R.string.tips_channel_apply_notice_new, (Object[])new Object[]{joinApply.getCname()}));
        channelNoticeMessage.setNeedLarge(true);
        FeatureLog.i((String)"FTChannelNotice", (String)"createJoinApplyMsg:%s", (Object[])new Object[]{channelNoticeMessage.toString()});
        return channelNoticeMessage;
    }

    public static ChannelNoticeMessage createDisbandChannelMsg(NotifyDataDefine.DisbandGroup disbandGroup) {
        if (disbandGroup == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createDisbandChannelMsg null", (Object[])new Object[0]);
            return null;
        }
        if (!disbandGroup.chNotify) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createDisbandChannelMsg not ch", (Object[])new Object[]{disbandGroup.getMsgId()});
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createBaseInfo((NotifyDataDefine.AbsSignal)disbandGroup);
        channelNoticeMessage.setNeedJump(false);
        if (disbandGroup.channelType == 0) {
            channelNoticeMessage.setChannelType(1);
        } else {
            channelNoticeMessage.setChannelType(2);
        }
        channelNoticeMessage.setShowChannelHeader(true);
        channelNoticeMessage.setType(6);
        channelNoticeMessage.setContent(StringUtils.getHtmlText((int)R.string.tips_delete_room_notice_new, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)disbandGroup.fromNick, (int)15)}));
        channelNoticeMessage.setNeedLarge(false);
        FeatureLog.i((String)"FTChannelNotice", (String)"createDisbandChannelMsg:%s", (Object[])new Object[]{channelNoticeMessage.toString()});
        return channelNoticeMessage;
    }

    @Nullable
    public static ChannelNoticeMessage createNoticeMessageFrom(ChannelNotify notify2, boolean excludeFromGame) {
        ChannelNoticeMessage channelNoticeMessage = null;
        if (notify2.uri == ChannelNotify.Uri.UriJoinApplyNotify) {
            NotifyDataDefine.JoinApply joinApply = notify2.notify.joinApply;
            channelNoticeMessage = ChannelMessageCreator.createJoinApplyMsg(joinApply);
        } else if (notify2.uri == ChannelNotify.Uri.UriJoinApproveNotify) {
            NotifyDataDefine.JoinApprove joinApprove = notify2.notify.joinApprove;
            channelNoticeMessage = ChannelMessageCreator.createJoinApproveMsg(joinApprove);
        } else if (notify2.uri == ChannelNotify.Uri.UriSetRoleNotify) {
            NotifyDataDefine.SetRole setRole2 = notify2.notify.setRole;
            channelNoticeMessage = ChannelMessageCreator.createSetRoleMsg(setRole2);
        } else if (notify2.uri == ChannelNotify.Uri.UriUserRoleChangeNotify) {
            NotifyDataDefine.UserRoleChange userRoleChange = notify2.notify.userRoleChange;
            channelNoticeMessage = ChannelMessageCreator.createUserRoleChangeMsg(userRoleChange);
        } else if (notify2.uri == ChannelNotify.Uri.UriAcceptRoleNotify) {
            NotifyDataDefine.AcceptRole acceptRole = notify2.notify.acceptRole;
            channelNoticeMessage = ChannelMessageCreator.createAcceptRoleMsg(acceptRole);
        } else if (notify2.uri == ChannelNotify.Uri.UriDisbandChannel) {
            NotifyDataDefine.DisbandGroup disbandGroup = notify2.notify.disbandGroup;
            channelNoticeMessage = ChannelMessageCreator.createDisbandChannelMsg(disbandGroup);
        } else if (notify2.uri == ChannelNotify.Uri.UriChannelInviteApprove) {
            NotifyDataDefine.InviteApprove inviteApprove = notify2.notify.inviteApprove;
            channelNoticeMessage = ChannelMessageCreator.createInviteApproveMsg(inviteApprove);
        } else if (notify2.uri == ChannelNotify.Uri.UriChannelInviteApproveStatus) {
            NotifyDataDefine.InviteApproveStatus inviteApproveStatus = notify2.notify.inviteApproveStatus;
            channelNoticeMessage = ChannelMessageCreator.createInviteApproveStatusMsg(inviteApproveStatus);
        }
        if (excludeFromGame && channelNoticeMessage != null && FP.eq((Object)"hago.game", (Object)channelNoticeMessage.getChannelSource())) {
            channelNoticeMessage = null;
        }
        return channelNoticeMessage;
    }

    public static ChannelNoticeMessage createInviteApproveMsg(NotifyDataDefine.InviteApprove inviteApprove) {
        if (inviteApprove == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createInviteApproveMsg null", (Object[])new Object[0]);
            return null;
        }
        if (!inviteApprove.chNotify) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createInviteApproveMsg not ch", (Object[])new Object[]{inviteApprove.getMsgId()});
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createBaseInfo((NotifyDataDefine.AbsSignal)inviteApprove);
        channelNoticeMessage.setNeedJump(false);
        if (inviteApprove.channelType == 0) {
            channelNoticeMessage.setChannelType(1);
        } else {
            channelNoticeMessage.setChannelType(2);
        }
        if (TimeUtils.getServiceRealTime() / 1000L - inviteApprove.expireTs > 0L) {
            channelNoticeMessage.setStatus(3);
        }
        channelNoticeMessage.setSetId(inviteApprove.setId);
        channelNoticeMessage.setNeedLarge(true);
        channelNoticeMessage.setShowChannelHeader(true);
        channelNoticeMessage.setType(7);
        channelNoticeMessage.setContent(StringUtils.getHtmlText((int)R.string.tips_channel_invite_approve, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)inviteApprove.inviteUserInfo.nick, (int)15), ShortNameUtils.getShortNameWithoutColon((String)inviteApprove.inviteeNick, (int)15), inviteApprove.getCname()}));
        FeatureLog.i((String)"FTChannelNotice", (String)"createInviteApproveMsg:%s", (Object[])new Object[]{channelNoticeMessage.toString()});
        return channelNoticeMessage;
    }

    private static ChannelNoticeMessage createBaseInfo(NotifyDataDefine.AbsSignal signal) {
        if (signal == null) {
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = new ChannelNoticeMessage();
        channelNoticeMessage.setMsgId(signal.getMsgId());
        channelNoticeMessage.setTs(signal.getTime());
        channelNoticeMessage.setChannelId(signal.getChannelId());
        channelNoticeMessage.setChannelName(signal.getCname());
        channelNoticeMessage.setChannelPwd(signal.getPwd());
        channelNoticeMessage.setSeqId(signal.getSeqId());
        channelNoticeMessage.setChannelOwnerId(signal.getChannelOwnerId());
        channelNoticeMessage.setChannelSource(signal.getChannelSource());
        return channelNoticeMessage;
    }

    public static ChannelNoticeMessage createInviteApproveStatusMsg(NotifyDataDefine.InviteApproveStatus inviteApproveStatus) {
        if (inviteApproveStatus == null) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createInviteApproveStatusMsg null", (Object[])new Object[0]);
            return null;
        }
        if (!inviteApproveStatus.chNotify) {
            FeatureLog.i((String)"FTChannelNotice", (String)"createInviteApproveStatusMsg not ch", (Object[])new Object[]{inviteApproveStatus.getMsgId()});
            return null;
        }
        ChannelNoticeMessage channelNoticeMessage = ChannelMessageCreator.createBaseInfo((NotifyDataDefine.AbsSignal)inviteApproveStatus);
        channelNoticeMessage.setNeedJump(false);
        if (inviteApproveStatus.channelType == 0) {
            channelNoticeMessage.setChannelType(1);
        } else {
            channelNoticeMessage.setChannelType(2);
        }
        if (TimeUtils.getServiceRealTime() / 1000L - inviteApproveStatus.expireTs > 0L) {
            channelNoticeMessage.setStatus(3);
        }
        channelNoticeMessage.setSetId(inviteApproveStatus.setId);
        channelNoticeMessage.setNeedLarge(true);
        channelNoticeMessage.setStatus(inviteApproveStatus.accept ? 2 : 1);
        channelNoticeMessage.setShowChannelHeader(true);
        channelNoticeMessage.setType(8);
        channelNoticeMessage.setContent(StringUtils.getHtmlText((int)R.string.tips_channel_invite_approve, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)inviteApproveStatus.inviterUserInfo.nick, (int)15), ShortNameUtils.getShortNameWithoutColon((String)inviteApproveStatus.inviteeUserInfo.nick, (int)15), inviteApproveStatus.getCname()}));
        FeatureLog.i((String)"FTChannelNotice", (String)"createInviteApproveStatusMsg:%s", (Object[])new Object[]{channelNoticeMessage.toString()});
        return channelNoticeMessage;
    }
}

