/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.mvp;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.ChannelGameMatchMsgDef;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.RoomGameMatchPage;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.mvp.RoomGameMatchModel;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.mvp.RoomGameMatchMvp;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.service.RoomGameMatchDispatchService;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import java.util.List;

public class RoomGameMatchPresenter
implements RoomGameMatchMvp.IRoomGameMatchPresenter,
INotifyDispatchService.INotifyHandler {
    private static final String TAG = "RoomGameMatchPresenter";
    private RoomGameMatchMvp.IRoomGameMatchModel model = new RoomGameMatchModel();
    private RoomGameMatchPage mRoomGameMatchPage;
    private RoomGameMatchDispatchService mMatchDispatchService = new RoomGameMatchDispatchService();
    private IServiceManager mServiceManager;

    public RoomGameMatchPresenter(IServiceManager iServiceManager) {
        this.mMatchDispatchService.addHandler(this);
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.mMatchDispatchService);
        this.mServiceManager = iServiceManager;
    }

    @Override
    public void startMatch(GameInfo gameInfo, Bundle args) {
        if (this.model == null) {
            return;
        }
        this.model.startMatch(gameInfo, args, new RoomGameMatchMvp.CallBack<String, Integer, Integer>(){

            @Override
            public void onError(String data2) {
                RoomGameMatchPresenter.this.exitVoiceRoomMatch();
            }

            @Override
            public void onResponse(Integer result1, Integer result2) {
                if (RoomGameMatchPresenter.this.mRoomGameMatchPage != null) {
                    RoomGameMatchPresenter.this.mRoomGameMatchPage.setGamePlayCount(result1, result2);
                }
            }
        });
    }

    @Override
    public void setData(GameInfo gameInfo) {
        if (this.mRoomGameMatchPage != null) {
            this.mRoomGameMatchPage.setGameData(gameInfo);
        }
    }

    @Override
    public void setView(View view2) {
        this.mRoomGameMatchPage = (RoomGameMatchPage)view2;
    }

    @Override
    public void cancelMatch() {
        if (this.model != null) {
            this.model.cancelMatch();
        }
    }

    public void onHandleNotify(Object notify2) {
        MLog.info((Object)TAG, (String)"onHandleNotify", (Object[])new Object[0]);
    }

    public void initUser() {
        ((IUserInfoService)this.mServiceManager.getService(IUserInfoService.class)).requestUserInfoFromServer(AccountUtil.getUid(), new OnKSProfileListCallback(){

            public void onUISuccess(List<UserInfoKS> userInfo) {
                UserInfoKS userInfoBean;
                if (userInfo != null && userInfo.size() > 0 && (userInfoBean = userInfo.get(0)) != null && RoomGameMatchPresenter.this.mRoomGameMatchPage != null) {
                    RoomGameMatchPresenter.this.mRoomGameMatchPage.setUserData(userInfoBean);
                }
            }

            public void onError(String reason, long code) {
            }
        });
    }

    public void cleatData() {
        this.model = null;
        this.mRoomGameMatchPage = null;
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mMatchDispatchService);
        this.mMatchDispatchService = null;
    }

    public void exitVoiceRoomMatch() {
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_match_failure);
        Message message = new Message();
        message.what = ChannelGameMatchMsgDef.EXIT_ROOM_GAME_MATCH_WINDOW;
        MsgDispatcher.getInstance().sendMessage(message);
    }
}

