/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch;

import android.content.Context;
import android.os.CountDownTimer;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.ChannelGameMatchMsgDef;
import com.yy.hiyo.channel.module.main.enter.gameenter.roomgamematch.MatchRoomGameSuccessAvatarView;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.List;

public class RoomGameMatchPage
extends YYRelativeLayout {
    private YYTextView mRoomGameTitle;
    private YYTextView mRoomGamePlayCount;
    private YYTextView mMatchTime;
    private SVGAImageView mMatchSvgaView;
    private CircleImageView mHead;
    private YYImageView mExitMatch;
    private CountDownTimer mTimer;
    private int secondTime;
    private GameInfo gameInfo;
    private UICallBack mCallBack;
    private YYLinearLayout mMatchingLayout;
    private YYLinearLayout mMatchSuccessLayout;
    private YYTextView mMatchPlayCount;
    private static final String TAG = "RoomGameMatchPage";
    private MatchRoomGameSuccessAvatarView matchSuccessAvatarView;

    public RoomGameMatchPage(Context context) {
        super(context);
        this.initView();
        this.initData();
        this.initListener();
    }

    private void initListener() {
        this.mExitMatch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view2) {
                if (RoomGameMatchPage.this.mCallBack != null) {
                    RoomGameMatchPage.this.mCallBack.onExitRoomGame();
                }
            }
        });
    }

    private void initView() {
        RoomGameMatchPage.inflate((Context)this.getContext(), (int)R.layout.layout_room_game_macth_channel, (ViewGroup)this);
        this.mRoomGameTitle = (YYTextView)this.findViewById(R.id.tv_room_game_title);
        this.mRoomGamePlayCount = (YYTextView)this.findViewById(R.id.tv_room_game_play_count);
        this.mMatchSvgaView = (SVGAImageView)this.findViewById(R.id.svga_matching);
        this.mMatchTime = (YYTextView)this.findViewById(R.id.tv_room_game_match_time);
        this.mHead = (CircleImageView)this.findViewById(R.id.room_game_my_head);
        this.mExitMatch = (YYImageView)this.findViewById(R.id.btn_cancel);
        this.mMatchingLayout = (YYLinearLayout)this.findViewById(R.id.layout_matching);
        this.mMatchSuccessLayout = (YYLinearLayout)this.findViewById(R.id.layout_match_success);
        this.mMatchPlayCount = (YYTextView)this.findViewById(R.id.tv_match_count);
        this.matchSuccessAvatarView = (MatchRoomGameSuccessAvatarView)this.findViewById(R.id.view_avatars);
    }

    private void initData() {
        if (this.gameInfo != null) {
            this.mRoomGameTitle.setText((CharSequence)this.gameInfo.getGname());
            this.showMatchTime();
        }
    }

    public void setGameData(GameInfo gameInfo) {
        this.gameInfo = gameInfo;
        if (gameInfo != null && this.mRoomGameTitle != null) {
            this.mRoomGameTitle.setText((CharSequence)gameInfo.getGname());
            this.showMatchTime();
            this.startMatchIconAnim();
        }
    }

    public void setUserData(UserInfoKS userInfoBean) {
        String loadUrl = userInfoBean.avatar + YYImageUtils.getThumbnailPostfixPx((int)75, (int)75, (boolean)true);
        ImageLoader.loadImage((ImageView)this.mHead, (String)loadUrl, (int)R.drawable.icon_avatar_default_female);
    }

    private void showMatchTime() {
        this.mTimer = new CountDownTimer(Long.MAX_VALUE, 1000L){

            public void onTick(long l) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RoomGameMatchPage.this.secondTime++;
                        String strTime = ResourceUtils.getString((int)R.string.short_tips_room_game_match, (Object[])new Object[]{RoomGameMatchPage.this.secondTime});
                        RoomGameMatchPage.this.mMatchTime.setText((CharSequence)strTime);
                    }
                });
            }

            public void onFinish() {
            }
        };
        this.mTimer.start();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopMatchIconAnim();
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
    }

    public void matchSuccess(List<UserInfoKS> userInfoBeans, final String strRoomId) {
        MLog.info((Object)TAG, (String)"matchSuccess", (Object[])new Object[0]);
        String strMatchPlayerCount = ResourceUtils.getString((int)R.string.short_tips_room_game_match_people, (Object[])new Object[]{userInfoBeans.size()});
        this.mMatchPlayCount.setText((CharSequence)strMatchPlayerCount);
        this.mMatchingLayout.setVisibility(8);
        this.mMatchSuccessLayout.setVisibility(0);
        this.matchSuccessAvatarView.setData(userInfoBeans);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RoomGameMatchPage.this.exitRoomGameMatch();
                RoomGameMatchPage.this.goRoom(strRoomId);
            }
        }, (long)2000L);
    }

    private void goRoom(String strRoomId) {
        MLog.info((Object)TAG, (String)"goRoom", (Object[])new Object[0]);
        EnterParam param2 = EnterParam.of((String)strRoomId).isQuickMatch(true).entry(5).isBackToList(true).build();
        ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param2);
    }

    private void exitRoomGameMatch() {
        MLog.info((Object)TAG, (String)"exitRoomGameMatch", (Object[])new Object[0]);
        Message message = new Message();
        message.what = ChannelGameMatchMsgDef.EXIT_ROOM_GAME_MATCH_WINDOW_NO_ANIM;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public void setGamePlayCount(int minPlayCount, int maxPlayCount) {
        String strPlayers = ResourceUtils.getString((int)R.string.short_room_players_num, (Object[])new Object[]{minPlayCount, maxPlayCount});
        this.mRoomGamePlayCount.setText((CharSequence)strPlayers);
    }

    public void startMatchIconAnim() {
        this.mMatchSvgaView.setVisibility(0);
        SvgaLoader.load((SVGAImageView)this.mMatchSvgaView, (String)"room_game_match_loading.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (RoomGameMatchPage.this.mMatchSvgaView != null) {
                    RoomGameMatchPage.this.mMatchSvgaView.startAnimation();
                }
            }

            public void onFailed(Exception e) {
            }
        });
    }

    public void stopMatchIconAnim() {
        this.mMatchSvgaView.setVisibility(8);
        this.mMatchSvgaView.stopAnimation();
    }

    public void setUICallBack(UICallBack mCallBack) {
        this.mCallBack = mCallBack;
    }

    static interface UICallBack {
        public void onExitRoomGame();
    }
}

