/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main.enter;

import android.app.Activity;
import android.text.TextUtils;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.RecommendEnterData;
import com.yy.hiyo.channel.base.bean.RoomlistEventBean;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class EnterStatsHelper {
    private static final String TAG = "EnterStatsHelper";
    private static ChannelHeartItem sMainChannel;
    private static ChannelHeartItem sCoexistence;

    public static void onEntered(IChannel thisEnterChannel, IChannel channel, EnterParam param2, EnterChannelData data2, IChannel coexistenceChannel, EnterParam coexistenceParam, EnterChannelData coexistenceData) {
        if (thisEnterChannel == channel && channel != null) {
            if (EnterStatsHelper.updateMainChannel(channel, param2, data2)) {
                EnterStatsHelper.trackEnterChannel(channel, param2);
            }
            EnterStatsHelper.updateCoexistenceChannel(coexistenceChannel, coexistenceParam, coexistenceData);
        } else if (thisEnterChannel == coexistenceChannel && coexistenceChannel != null) {
            if (EnterStatsHelper.updateCoexistenceChannel(coexistenceChannel, coexistenceParam, coexistenceData)) {
                EnterStatsHelper.trackEnterChannel(coexistenceChannel, coexistenceParam);
            }
            EnterStatsHelper.updateMainChannel(channel, param2, data2);
        }
        if (sMainChannel != null && sCoexistence != null && StringUtils.equal((String)sMainChannel.getCid(), (String)sCoexistence.getCid())) {
            sCoexistence.destroy();
            RuntimeContext.setCoexistenceChannel(null);
            sCoexistence = null;
        }
    }

    private static boolean updateCoexistenceChannel(IChannel coexistenceChannel, EnterParam coexistenceParam, EnterChannelData coexistenceData) {
        if (coexistenceChannel != null) {
            if (sCoexistence == null) {
                sCoexistence = new ChannelHeartItem(coexistenceChannel, coexistenceParam, coexistenceData);
                RuntimeContext.setCoexistenceChannel((RuntimeContext.ChannelHeartItem)sCoexistence);
                return true;
            }
            if (!StringUtils.equal((String)coexistenceChannel.getChannelId(), (String)sCoexistence.getCid())) {
                sCoexistence.destroy();
                sCoexistence = new ChannelHeartItem(coexistenceChannel, coexistenceParam, coexistenceData);
                RuntimeContext.setCoexistenceChannel((RuntimeContext.ChannelHeartItem)sCoexistence);
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean updateMainChannel(IChannel channel, EnterParam param2, EnterChannelData data2) {
        if (channel == null) {
            return false;
        }
        if (sMainChannel == null) {
            sMainChannel = new ChannelHeartItem(channel, param2, data2);
            RuntimeContext.setChannel((RuntimeContext.ChannelHeartItem)sMainChannel);
            return true;
        }
        if (!StringUtils.equal((String)channel.getChannelId(), (String)sMainChannel.getCid())) {
            sMainChannel.destroy();
            sMainChannel = new ChannelHeartItem(channel, param2, data2);
            RuntimeContext.setChannel((RuntimeContext.ChannelHeartItem)sMainChannel);
            return true;
        }
        return false;
    }

    public static void onExited(IChannel channel, EnterParam param2) {
        if (channel == null) {
            return;
        }
        ChannelHeartItem channelHeartItem = EnterStatsHelper.getChannelItem(channel.getChannelId());
        if (channelHeartItem != null) {
            if (channelHeartItem == sMainChannel) {
                RuntimeContext.setChannel(null);
                sMainChannel = null;
                if (sCoexistence != null) {
                    sMainChannel = sCoexistence;
                    RuntimeContext.setCoexistenceChannel(null);
                    RuntimeContext.setChannel((RuntimeContext.ChannelHeartItem)sMainChannel);
                    sCoexistence = null;
                }
            } else if (channelHeartItem == sCoexistence) {
                sCoexistence = null;
                RuntimeContext.setCoexistenceChannel(null);
            }
            channelHeartItem.destroy(channel, param2);
        }
        if (!EnterParam.useTextChannelAndVoiceCoexistence()) {
            RuntimeContext.setChannel(null);
            RuntimeContext.setCoexistenceChannel(null);
            sMainChannel = null;
            sCoexistence = null;
        }
    }

    private static ChannelHeartItem getChannelItem(String channelId) {
        if (StringUtils.isEmpty((String)channelId)) {
            return null;
        }
        if (sMainChannel != null && StringUtils.equal((String)channelId, (String)sMainChannel.getCid())) {
            return sMainChannel;
        }
        if (sCoexistence != null && StringUtils.equal((String)channelId, (String)sCoexistence.getCid())) {
            return sCoexistence;
        }
        return null;
    }

    public static void onTagUpdate(String channelId, String tagId) {
        if (StringUtils.equal((String)RuntimeContext.getVoiceRoomId(), (String)channelId)) {
            RuntimeContext.setChannelTagId((String)channelId, (String)tagId);
        }
    }

    private static void setChannelPluginId(String channelId, String pluginID) {
        if (StringUtils.equal((String)RuntimeContext.getVoiceRoomId(), (String)channelId)) {
            MLog.info((Object)TAG, (String)"setCPId CId:%s, pluginID:%s", (Object[])new Object[]{channelId, pluginID});
            RuntimeContext.setChannelPluginId((String)channelId, (String)pluginID);
        }
    }

    public static String getId(int mode) {
        switch (mode) {
            case 11: {
                return "ktv";
            }
            case 12: {
                return "micup";
            }
            case 13: {
                return "pickme";
            }
            case 101: {
                return "dayingjia";
            }
            case 100: {
                return "baijiale_yn";
            }
            case 300: {
                return "yangyangxiaochu";
            }
            case 10: {
                return "chat";
            }
            case 14: {
                return "radio";
            }
        }
        return "";
    }

    private static void trackEnterChannel(final IChannel channel, final EnterParam enterParam) {
        if (enterParam == null || channel == null) {
            return;
        }
        channel.getDataService().getChannelDetailInfo(new IDataService.IGetDetailInfoCallBack(){

            public void onSuccess(String channelId, ChannelDetailInfo info) {
                String gameId = "";
                String roomId = channel.getChannelId();
                ChannelPluginData curPluginData = channel.getPluginService().getCurPluginData();
                if (curPluginData != null) {
                    gameId = curPluginData.getPluginId();
                    if ("radio".equals(gameId)) {
                        gameId = "radio_audio";
                    }
                    if (curPluginData.isVideoMode()) {
                        gameId = "radio_video";
                    }
                    if (StringUtils.isEmpty((String)gameId)) {
                        gameId = EnterStatsHelper.getId(curPluginData.getMode());
                    }
                }
                String followUid = (String)enterParam.getExtra("follow_uid", (Object)"");
                String isSameCityChannel = null != info && info.baseInfo.isSameCity ? "1" : "2";
                String isOfficalChannel = null != info && info.baseInfo.isOffcial ? "1" : "2";
                long startTime = System.currentTimeMillis();
                int entry = enterParam.entry;
                Boolean guideEnter = null;
                boolean isGuideEnter = (Boolean)enterParam.getExtra("IS_GUIDE_ENTER", (Object)false);
                boolean isJoinByPW = (Boolean)enterParam.getExtra("IS_ENTER_BY_PWD", (Object)false);
                RoomlistEventBean roomlistEventBean = (RoomlistEventBean)enterParam.getExtra("ROOM_LIST_EVENT", null);
                if (entry == 3) {
                    guideEnter = isGuideEnter;
                }
                String slither = "";
                boolean fromRadioVideo = (Boolean)enterParam.getExtra("from_radio_video", (Object)false);
                slither = enterParam.entry == 24 || fromRadioVideo ? "1" : "2";
                String seatTrackInfo = "";
                int inSeatCount = 0;
                if (null != info && null != channel.getSeatService() && null != channel.getRoleService()) {
                    StringBuilder seatSb = new StringBuilder();
                    List seatList = channel.getSeatService().getSeatList();
                    for (SeatUser seatUser : seatList) {
                        if (seatUser.uid > 0L) {
                            ++inSeatCount;
                        }
                        seatSb.append("&").append(seatUser.uid).append("&").append(seatUser.uid == info.baseInfo.ownerUid ? "1" : "0").append("&").append(SeatStatusUtils.isMicOpen((long)seatUser.status) ? "0" : "1").append("&").append(SeatStatusUtils.isLocked((long)seatUser.status) ? "1" : "0");
                    }
                    if (seatSb.length() > 0) {
                        seatTrackInfo = seatSb.substring(1);
                    }
                }
                boolean hasLocation = PermissionHelper.hasLocationPermission((Activity)channel.getContext());
                String token = null;
                if (roomlistEventBean != null) {
                    token = roomlistEventBean.getToken();
                }
                if (TextUtils.isEmpty(token)) {
                    token = (String)enterParam.getExtra("token", (Object)"");
                }
                RoomTrack.INSTANCE.onEnterVoiceRoom(String.valueOf(entry), (String)enterParam.getExtra("enter_room_push", (Object)""), String.valueOf(startTime), roomId, FP.empty((CharSequence)gameId) ? "0" : gameId, followUid, guideEnter, isJoinByPW ? "1" : "2", isSameCityChannel, isOfficalChannel, (String)enterParam.getExtra("JOIN_SESSION", (Object)""), slither, hasLocation ? "1" : "2", roomlistEventBean, Long.valueOf(null != info ? info.dynamicInfo.onlines : 0L), seatTrackInfo, inSeatCount, token, enterParam.preSource, enterParam.entryInfo, enterParam.roomDistributeType);
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
            }
        });
    }

    public static void onChannelWindow(IChannel channel, EnterParam enterParam) {
        long currServerTime;
        if (!SettingFlags.containKey((String)"key_first_enter_channel_time")) {
            currServerTime = TimeUtils.getServiceRealTime();
            SettingFlags.setLongValue((String)"key_first_enter_channel_time", (long)currServerTime);
            MLog.info((Object)TAG, (String)("set firstEnterChannelTime=" + currServerTime), (Object[])new Object[0]);
        }
        if (!SettingFlags.containKey((String)"key_first_enter_samecity_channel_time") && channel.getDataService().getCacheDetail() != null && channel.getDataService().getCacheDetail().baseInfo.isSameCity) {
            currServerTime = TimeUtils.getServiceRealTime();
            SettingFlags.setLongValue((String)"key_first_enter_samecity_channel_time", (long)currServerTime);
            MLog.info((Object)TAG, (String)("set firstEnterSameCityChannelTime=" + currServerTime), (Object[])new Object[0]);
        }
    }

    public static class ChannelHeartItem
    extends RuntimeContext.ChannelHeartItem {
        private static IPluginService.IPluginDataChangedCallBack pluginCallBack;

        public ChannelHeartItem(IChannel channel, EnterParam param2, EnterChannelData data2) {
            String pluginId = "";
            ChannelPluginData pluginData = channel.getPluginService().getCurPluginData();
            boolean isVideoOpen = false;
            if (pluginData != null) {
                pluginId = pluginData.getPluginId();
                if (StringUtils.isEmpty((String)pluginId)) {
                    pluginId = EnterStatsHelper.getId(pluginData.getMode());
                }
                isVideoOpen = pluginData.isVideoMode();
            }
            ChannelDetailInfo detailInfo = channel.getDataService().getCacheDetail();
            boolean isSameCity = false;
            if (null != detailInfo) {
                isSameCity = detailInfo.baseInfo.isSameCity;
            }
            String recommendToken = "";
            RecommendEnterData recommendEnterData = (RecommendEnterData)param2.getExtra("from_recommend_info", null);
            if (recommendEnterData != null && StringUtils.isNotEmpty((String)recommendEnterData.getToken())) {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)recommendEnterData.getToken());
                    recommendToken = jsonObject.optString("dispatch_id");
                }
                catch (JSONException e) {
                    MLog.error((Object)EnterStatsHelper.TAG, (String)"recommendEnterData parse error", (Object[])new Object[0]);
                }
            }
            String subType = "";
            if (detailInfo != null && detailInfo.baseInfo != null) {
                String source = detailInfo.baseInfo.source;
                if ("hago.family".equals(source)) {
                    subType = "1";
                } else if ("hago.game".equals(source)) {
                    subType = "2";
                } else if ("crawler".equals(source)) {
                    subType = "4";
                } else if (ChannelDefine.isChannelSource((String)source)) {
                    if ("base".equals(pluginId)) {
                        subType = "3";
                    }
                } else if ("hago.indiegame".equals(source)) {
                    subType = "5";
                }
            }
            int channelType = detailInfo.baseInfo.enterMode;
            if (pluginData.mode == 1) {
                channelType = detailInfo.baseInfo.isPrivate ? 2 : 1;
            }
            YYTaskExecutor.executeByReportPriority((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThirdTrackHelper.INSTANCE.reportVoiceRoomDuration();
                }
            });
            this.setRuntimeContextInfo(channel.getChannelId(), (String)param2.getExtra("JOIN_SESSION", (Object)""), pluginId, channel.getDataService().getTagId(), isVideoOpen, isSameCity, recommendToken, subType, channelType);
            if (pluginCallBack == null) {
                pluginCallBack = new IPluginService.IPluginDataChangedCallBack(){

                    public void onPluginModeChanged(String cid, ChannelPluginData pluginData, ChannelPluginData beforePlugin) {
                        if (pluginData != null) {
                            String pluginId = pluginData.getPluginId();
                            if (StringUtils.isEmpty((String)pluginId)) {
                                pluginId = EnterStatsHelper.getId(pluginData.getMode());
                            }
                            EnterStatsHelper.setChannelPluginId(cid, pluginData.getPluginId());
                        }
                    }

                    public void onPluginInfoChanged(String cid, ChannelPluginData pluginData) {
                    }
                };
            }
            channel.getPluginService().addPluginDataListener(pluginCallBack);
        }

        private void setRuntimeContextInfo(String cid, String joinSession, String pluginId, String tagId, boolean isVideoOpen, boolean isSameCity, String recommendToken, String subType, int channelType) {
            MLog.info((Object)EnterStatsHelper.TAG, (String)"setCId CId %s, joinSession %s, pluginId %s, tagId %s, subType:%s", (Object[])new Object[]{cid, joinSession, pluginId, tagId, subType});
            this.voiceRoomId = cid;
            this.lastVoiceRoomJoinSession = joinSession;
            this.channelPluginId = pluginId;
            this.channelTagId = tagId;
            this.recommendToken = recommendToken;
            this.channelOpenVideo = isVideoOpen;
            this.sameCityChannel = isSameCity;
            this.subType = subType;
            this.channelType = channelType;
            if (StringUtils.isEmpty((String)cid)) {
                RuntimeContext.setVoiceRoomInMic((String)cid, (boolean)false);
                RuntimeContext.setSeatIndex((String)cid, (int)-1);
            }
        }

        public void destroy(IChannel channel, EnterParam param2) {
            if (channel != null && StringUtils.equal((String)channel.getChannelId(), (String)this.voiceRoomId)) {
                channel.getPluginService().removePluginDataListener(pluginCallBack);
                ChannelPluginData pluginData = channel.getPluginService().getCurPluginData();
                if (param2 != null && null != pluginData) {
                    Object tabType = param2.extra.get("tab_type");
                    int fromTabType = -1;
                    if (tabType instanceof Integer) {
                        fromTabType = (Integer)tabType;
                    }
                    param2.mChannelTimingStat.onLeave(pluginData.getMode(), pluginData.isVideoMode(), fromTabType, param2.entry);
                }
            }
            YYTaskExecutor.executeByReportPriority((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThirdTrackHelper.INSTANCE.stopVoiceRoomDuration();
                }
            });
        }

        public void destroy() {
            IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getInstance().getService(IChannelCenterService.class)).getChannel(this.voiceRoomId);
            if (channel != null) {
                this.destroy(channel, channel.getEnterParam());
            }
        }

        public String getCid() {
            return this.voiceRoomId;
        }
    }
}

