/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main;

import android.content.DialogInterface;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.callback.IVoiceRoomExitCallback;
import com.yy.appbase.live.LiveCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.ChannelBannedData;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelLeaveResp;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.base.utils.ChannelPlayInfoService;
import com.yy.hiyo.channel.cbase.AbsChannelController;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.utils.perf.ChannelPathLog;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.module.main.ChannelWindow;
import com.yy.hiyo.channel.module.main.ChannelWindowController;
import com.yy.hiyo.channel.module.main.IChannelWindowCallback;
import com.yy.hiyo.channel.module.main.IChannelWindowController;
import com.yy.hiyo.channel.module.main.web.ChannelLifecycle;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.multivideo.view.ForceLeaveDialog;
import com.yy.hiyo.voice.base.VoiceConstant;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ChannelWindowTestController
extends AbsChannelController
implements IChannelWindowController,
IChannelWindowCallback {
    private static final String TAG = "ChannelWindowTestController";
    private ChannelWindowController.ICallback mCallback;
    private ChannelWindow mWindow;
    private IChannel mChannel;
    private EnterParam enterParams;
    private boolean destroyed;
    private boolean joinSuccessed;
    private ProgressDialog progressDialog;
    protected DialogLinkManager myDialogLinkManager;
    private LiveCallback mLiveCallback;
    private ProgressDialog videoLoadingDialog;
    private long mCurrentRemoteUID = -1L;
    private boolean mVideoOpen;
    private boolean mVideoStart;
    private boolean mVideoMode = true;
    private long mVideoShowPeopleReactionStartTime = 0L;
    private Runnable showWindowRunnable = null;
    private boolean isShowing = false;
    private FrameLayout frameLayout = null;
    private View mPlayView;
    private View mBgView;
    private static boolean lastUseTest = false;

    public ChannelWindowTestController(Environment environment, ChannelWindowController.ICallback callback2) {
        super(environment);
        this.mCallback = callback2;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public String getChannelId() {
        if (this.mChannel != null) {
            return this.mChannel.getChannelId();
        }
        if (this.enterParams != null) {
            return this.enterParams.roomId;
        }
        return "";
    }

    @Override
    public IChannel getChannel() {
        return this.mChannel;
    }

    @Override
    public EnterParam getEnterParams() {
        if (this.mChannel != null) {
            return this.mChannel.getEnterParam();
        }
        return this.enterParams;
    }

    @Override
    public void enterChannel(EnterParam enterParam, boolean showWindowAfterJoinSuccess, boolean callJoinRequest) {
        MLog.info((Object)TAG, (String)"enterChannel, cid:%s,gameId:%s,showWindowAfterJoinSucces:%s!", (Object[])new Object[]{enterParam.roomId, enterParam.gameInfo != null ? enterParam.gameInfo.gid : "", showWindowAfterJoinSuccess ? "true" : "false"});
        enterParam.mChannelTimingStat.start(enterParam.roomId);
        if (StringUtils.isEmpty((String)enterParam.roomId)) {
            MLog.error((Object)TAG, (String)"enterChannel error:param is errored,no cid and no gameid!", (Object[])new Object[0]);
            return;
        }
        this.mVideoShowPeopleReactionStartTime = SystemClock.uptimeMillis();
        this.getLayout();
        this.enterParams = enterParam;
        IChannel channel = ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(enterParam.roomId);
        this.requestJoinChannel(channel, enterParam);
        Runnable showLoading = new Runnable(){

            @Override
            public void run() {
                if (ChannelWindowTestController.this.destroyed || ChannelWindowTestController.this.joinSuccessed) {
                    return;
                }
                if (ChannelWindowTestController.this.myDialogLinkManager == null) {
                    ChannelWindowTestController.this.myDialogLinkManager = new DialogLinkManager(ChannelWindowTestController.this.mContext);
                }
                MLog.info((Object)ChannelWindowTestController.TAG, (String)"enterChannel, show loading Dialog!", (Object[])new Object[0]);
                if (ChannelWindowTestController.this.progressDialog != null) {
                    ChannelWindowTestController.this.myDialogLinkManager.dismissDialog();
                }
                ChannelWindowTestController.this.progressDialog = new ProgressDialog("", true, false, null, new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog2) {
                        MLog.info((Object)ChannelWindowTestController.TAG, (String)"enterChannel, loadingDialog cancel clicked!", (Object[])new Object[0]);
                        if (ChannelWindowTestController.this.destroyed) {
                            return;
                        }
                        ChannelWindowTestController.this.destroy(true);
                    }
                });
                ChannelWindowTestController.this.mVideoShowPeopleReactionStartTime = 0L;
                ChannelWindowTestController.this.myDialogLinkManager.showDialog((BaseDialog)ChannelWindowTestController.this.progressDialog);
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)showLoading, (long)(!showWindowAfterJoinSuccess ? 400L : 200L));
    }

    private void requestJoinChannel(@NonNull IChannel channel, EnterParam enterParams) {
        channel.join(enterParams, this.getJoinCallBack());
    }

    @Override
    public void bringWindowToFront(EnterParam enterParam) {
        if (this.showWindowRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.showWindowRunnable);
        }
        if (this.mWindow != null) {
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        }
    }

    @Override
    public void destroy(boolean popWinAni) {
        this.destroy(popWinAni, null, null, false, null, 0);
    }

    @Override
    public void destroy(boolean popWinAni, IVoiceRoomExitCallback callbackWhenExited, Map<String, Object> extMap, boolean notLeaveRequest, String nextJoinSuccessChannel, int nextJoinSuccessEntry) {
        this.destroyed = true;
        this.mVideoShowPeopleReactionStartTime = 0L;
        this.cancelLoadingDialog();
        if (this.mChannel != null) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).stopWatchLive(this.mChannel.getChannelId(), this.mCurrentRemoteUID);
        }
        if (this.mWindow != null) {
            this.mWindowMgr.popToWindow((AbstractWindow)this.mWindow, false);
        }
        if (this.mCallback != null) {
            this.mCallback.onChannelDestroyed(this);
        }
        if (callbackWhenExited != null) {
            callbackWhenExited.onExit(true);
        }
        this.joinSuccessed = false;
        this.mWindow = null;
    }

    @Override
    public void setIntercepter(IChannelWindowController.IIntercepter intercepter) {
    }

    private void onJoinSuccess(final EnterParam requestParams, final EnterChannelData data2, final IChannel channel) {
        this.cancelLoadingDialog();
        this.joinSuccessed = true;
        if (this.mVideoShowPeopleReactionStartTime == 0L) {
            this.mVideoShowPeopleReactionStartTime = SystemClock.uptimeMillis();
        }
        this.mVideoMode = data2.pluginData.isVideoMode();
        ChannelPathLog.getEnterChannelLogger((String)requestParams.roomId).add("Window Join Success!", new Object[0]);
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                ((ChannelWindowTestController)ChannelWindowTestController.this).enterParams.mChannelTimingStat.onJoinChannelRequestEnd();
                if (ChannelWindowTestController.this.destroyed) {
                    MLog.error((Object)ChannelWindowTestController.TAG, (String)"onJoinSuccess but destroyed,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                    if (requestParams == ChannelWindowTestController.this.enterParams) {
                        MLog.info((Object)ChannelWindowTestController.TAG, (String)"play leave channel request by onJoinSuccess but destroyed!", (Object[])new Object[0]);
                        channel.leave(new IChannel.ILeaveCallBack(){

                            public void onSuccess(String channelId, ChannelLeaveResp leaveResp) {
                            }

                            public void onError(int errorCode, String errorTips, Exception e) {
                            }
                        });
                    }
                    ChannelPathLog.getEnterChannelLogger((String)requestParams.roomId).end("End by Window destroy!", new Object[0]);
                    return;
                }
                ChannelWindowTestController.this.mChannel = channel;
                if (((ChannelWindowTestController)ChannelWindowTestController.this).enterParams.callBack != null) {
                    ((ChannelWindowTestController)ChannelWindowTestController.this).enterParams.callBack.onSuccess();
                    ((ChannelWindowTestController)ChannelWindowTestController.this).enterParams.callBack = null;
                }
                ChannelPathLog.getEnterChannelLogger((String)requestParams.roomId).add("Window Pre Show!", new Object[0]);
                MLog.info((Object)ChannelWindowTestController.TAG, (String)"onJoinSuccess cid:%s!", (Object[])new Object[]{channel.getChannelId()});
                ChannelWindowTestController.this.joinSuccessed = true;
                if (ChannelWindowTestController.this.mWindow == null) {
                    ChannelWindowTestController.this.showWindow(channel, ChannelWindowTestController.this.enterParams);
                } else if (RuntimeContext.sIsForeground) {
                    channel.getMsgService().inMsgPage();
                }
                ChannelInfo channelInfo = channel.getDataService().getChannelDetailInfo(null).baseInfo;
                if (data2.isUpgrade) {
                    IChannelCenterService service;
                    MLog.info((Object)ChannelWindowTestController.TAG, (String)"channel upgrade version:%s!", (Object[])new Object[]{channelInfo.version});
                    if (null != ServiceManagerProxy.getServiceManager() && null != (service = (IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class))) {
                        service.getMyJoinedChannels(null, true);
                        service.updateControlConfigFromServer(null);
                    }
                }
                if (ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.onJoinSuccess(requestParams, data2, ChannelWindowTestController.this);
                }
                MLog.info((Object)ChannelWindowTestController.TAG, (String)"onJoinSuccess hide dialog", (Object[])new Object[0]);
                ChannelWindowTestController.this.cancelLoadingDialog();
                ChannelLifecycle.INSTANCE.onJoin(channel);
                ChannelPlayInfoService.Companion.enterChannel(channel);
                if (channelInfo.version == 0 && channel.getPluginService().getCurPluginData().mode == 1) {
                    ChannelTrack.INSTANCE.unUpdateChannelShow();
                }
                PrivilegeHelper.INSTANCE.enterRoom();
            }
        };
        if (this.mCallback != null) {
            this.mCallback.preJoinSuccess(this, runnable2, channel.getChannelId());
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((ChannelWindowTestController)ChannelWindowTestController.this).enterParams.mChannelTimingStat.onChannelPageFirstFrame();
                if (data2 != null && data2.pluginData != null && !data2.pluginData.isVideoMode() && data2.pluginData.mode != 15) {
                    ((ChannelWindowTestController)ChannelWindowTestController.this).enterParams.mChannelTimingStat.report(data2.pluginData.mode, data2.pluginData.getPluginId(), false, ((ChannelWindowTestController)ChannelWindowTestController.this).enterParams.entry);
                }
                ChannelPathLog.getEnterChannelLogger((String)requestParams.roomId).add("Window After Show!", new Object[0]);
            }
        });
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ChannelPathLog.getEnterChannelLogger((String)requestParams.roomId).end(" End by Window 8\u79d2\u540e", new Object[0]);
            }
        }, (long)8000L);
    }

    private void showWindow(IChannel channel, EnterParam enterParam) {
        AbstractWindow behindWin;
        this.mChannel = channel;
        YYFrameLayout layout2 = new YYFrameLayout(this.mContext);
        layout2.setBackgroundColor(-256);
        layout2.setLayoutParams(new ViewGroup.LayoutParams(100, 1000));
        this.mWindow = new ChannelWindow(this.getEnvironment().getContext(), enterParam, this, false);
        this.mWindow.getBaseLayer().addView((View)this.getVideoView());
        if (enterParam.entry == 24 && (behindWin = this.mWindowMgr.getWindowBehind((AbstractWindow)this.mWindow)) instanceof ChannelWindow) {
            this.mWindowMgr.removeWindow(behindWin, true);
        }
        if (!SettingFlags.containKey((String)"key_first_enter_channel_time")) {
            long currServerTime = TimeUtils.getServiceRealTime();
            SettingFlags.setLongValue((String)"key_first_enter_channel_time", (long)currServerTime);
            MLog.info((Object)TAG, (String)("set firstEnterChannelTime=" + currServerTime), (Object[])new Object[0]);
        }
        if (channel.getDataService().getChannelDetailInfo(null).baseInfo.isSameCity && !SettingFlags.containKey((String)"key_first_enter_samecity_channel_time")) {
            long currServerTime = TimeUtils.getServiceRealTime();
            SettingFlags.setLongValue((String)"key_first_enter_samecity_channel_time", (long)currServerTime);
            MLog.info((Object)TAG, (String)("set firstEnterSameCityChannelTime=" + currServerTime), (Object[])new Object[0]);
        }
        channel.getPluginService().addPluginDataListener(new IPluginService.IPluginDataChangedCallBack(){

            public void onPluginModeChanged(String channelId, ChannelPluginData pluginData, ChannelPluginData beforePlugin) {
            }

            public void onPluginInfoChanged(String channelId, ChannelPluginData pluginData) {
            }

            public void onVideoModeChanged(String channelId, boolean isVideoMode) {
                long scenedId = isVideoMode ? VoiceConstant.SCENE_ID_RADIO : VoiceConstant.SCENE_ID_MULTI_AUDIO;
                ChannelWindowTestController.this.setVideoModel(isVideoMode);
                ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSceneId(channelId, scenedId);
            }
        });
        int time = ChannelWindowTestController.getVideoShowReactionTime();
        long hasPastTime = SystemClock.uptimeMillis() - this.mVideoShowPeopleReactionStartTime;
        long timeDelayPushWindow = 0L;
        if (hasPastTime > 0L && hasPastTime < (long)time) {
            timeDelayPushWindow = (long)time - hasPastTime;
            MLog.info((Object)TAG, (String)"delay show Window:%d", (Object[])new Object[]{(int)timeDelayPushWindow});
        }
        YYTaskExecutor.postToMainThread((Runnable)this.getShowWindowRunnable(), (long)timeDelayPushWindow);
    }

    private FrameLayout getLayout() {
        if (this.frameLayout != null) {
            return this.frameLayout;
        }
        YYFrameLayout frameLayout = new YYFrameLayout(this.mContext);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mPlayView = ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).createPlayerView(this.mContext).getView();
        frameLayout.addView(this.mPlayView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mPlayView.setVisibility(0);
        this.frameLayout = frameLayout;
        this.mBgView = new YYView(this.mContext);
        frameLayout.addView(this.mBgView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mBgView.setBackgroundResource(R.drawable.icon_end_page_bg);
        this.mBgView.setVisibility(8);
        return frameLayout;
    }

    private Runnable getShowWindowRunnable() {
        if (this.showWindowRunnable != null) {
            return this.showWindowRunnable;
        }
        this.showWindowRunnable = new Runnable(){

            @Override
            public void run() {
                if (ChannelWindowTestController.this.isShowing || ChannelWindowTestController.this.destroyed) {
                    return;
                }
                ChannelWindowTestController.this.isShowing = true;
                ChannelWindowTestController.this.showOrHideBgView();
                if (ChannelWindowTestController.this.mWindow != null) {
                    ChannelWindowTestController.this.mWindowMgr.pushWindow((AbstractWindow)ChannelWindowTestController.this.mWindow, true);
                }
            }
        };
        return this.showWindowRunnable;
    }

    private FrameLayout getVideoView() {
        LiveCallback liveCallback;
        this.getLayout();
        if (((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel() != null) {
            ChannelPathLog.getEnterChannelLogger((String)((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel().getChannelId()).add("VideoPlayer Pre Create PlayView", new Object[0]);
        }
        if (((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel() != null) {
            ChannelPathLog.getEnterChannelLogger((String)((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel().getChannelId()).add("VideoPlayer After Create PlayView", new Object[0]);
        }
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).listenLineStreamInfos();
        this.mLiveCallback = liveCallback = new LiveCallback(){

            public void onVideoStart(long anchorId, int width, int height, boolean isCdn) {
                ChannelWindowTestController.this.mVideoStart = true;
                ChannelWindowTestController.this.showOrHideBgView();
                ChannelWindowTestController.this.hideVideoLoadingDialog();
                final String cid = ChannelWindowTestController.this.mChannel.getChannelId();
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ChannelPathLog.getEnterChannelLogger((String)cid).add("VideoPlayer Video Started", new Object[0]);
                    }
                });
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ChannelPathLog.getEnterChannelLogger((String)cid).end("End By VideoPlayer Video Start 3\u79d2\u540e", new Object[0]);
                    }
                }, (long)1000L);
                if (ChannelWindowTestController.this.showWindowRunnable != null) {
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)ChannelWindowTestController.this.showWindowRunnable);
                }
                ChannelWindowTestController.this.getShowWindowRunnable().run();
            }

            public void onVideoStop(final long anchorId) {
                ChannelWindowTestController.this.mVideoStart = false;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ChannelWindowTestController.this.mWindow != null) {
                            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).stopWatchLive(ChannelWindowTestController.this.mChannel.getChannelId(), anchorId);
                        }
                    }
                });
            }

            public void onVideoSizeChange(long anchorId, int width, int height, int rotation) {
                ChannelPathLog.getEnterChannelLogger((String)ChannelWindowTestController.this.mChannel.getChannelId()).add("VideoPlayer VideoSize Change", new Object[0]);
            }

            public void onVideoStreamOpen(long anchorId) {
                if (ChannelWindowTestController.this.mCurrentRemoteUID <= 0L) {
                    ChannelWindowTestController.this.mCurrentRemoteUID = anchorId;
                    ChannelPathLog.getEnterChannelLogger((String)ChannelWindowTestController.this.mChannel.getChannelId()).add("VideoPlayer Pre WatchLive", new Object[0]);
                    ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).startWatchLive(ChannelWindowTestController.this.mPlayView, anchorId, "hd", null);
                    ChannelPathLog.getEnterChannelLogger((String)ChannelWindowTestController.this.mChannel.getChannelId()).add("VideoPlayer After WatchLive", new Object[0]);
                }
            }

            public void onJoinChannelSuccess(@Nullable String channel, @Nullable String p1, int elapsed) {
            }

            public void onSourceChange(boolean isCdn) {
            }
        };
        this.mChannel.getMediaService().registerLiveListener(this.mLiveCallback);
        this.subscribeStreamInfo();
        return this.frameLayout;
    }

    private void subscribeStreamInfo() {
        MLog.info((Object)TAG, (String)"subscribeStreamInfo", (Object[])new Object[0]);
        if (!this.mVideoOpen) {
            this.mVideoOpen = true;
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).changeShowVideo(true);
        }
    }

    private void setVideoModel(boolean isVideoMode) {
        this.mVideoMode = isVideoMode;
        if (!this.mVideoMode) {
            this.mVideoOpen = false;
            this.mVideoStart = false;
        }
    }

    private void showOrHideBgView() {
        if (this.mVideoMode) {
            if (this.mVideoStart) {
                if (this.mBgView.getVisibility() != 8) {
                    this.mBgView.setVisibility(8);
                }
            } else if (this.mBgView.getVisibility() != 0) {
                this.mBgView.setVisibility(0);
            }
        } else if (this.mBgView.getVisibility() != 8) {
            this.mBgView.setVisibility(8);
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        if (abstractWindow == this.mWindow && this.mVideoMode && !this.mVideoStart && !this.destroyed) {
            this.showVideoLoadingDialog();
        }
    }

    private void hideVideoLoadingDialog() {
        if (this.videoLoadingDialog != null && this.myDialogLinkManager != null) {
            this.myDialogLinkManager.dismissDialog();
            this.videoLoadingDialog = null;
        }
    }

    private void showVideoLoadingDialog() {
        if (this.videoLoadingDialog == null) {
            this.videoLoadingDialog = new ProgressDialog("", true, false, null, new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog2) {
                }
            });
        }
        if (this.myDialogLinkManager == null) {
            this.myDialogLinkManager = new DialogLinkManager(this.mContext);
        }
        this.myDialogLinkManager.showDialog((BaseDialog)this.videoLoadingDialog);
    }

    private IChannel.IJoinCallBack getJoinCallBack() {
        return new IChannel.IJoinCallBack(){

            public void onSuccess(final EnterParam requestParams, final ChannelDetailInfo info, final EnterChannelData data2) {
                if (data2 == null || data2.pluginData == null || data2.mediaToken == null) {
                    MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack success cid:%s, but data is invalid!", (Object[])new Object[]{info.baseInfo.gid});
                } else {
                    MLog.info((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack success, cid:%s, pmode:%d,pluginId:%s!", (Object[])new Object[]{info.baseInfo.gid, data2.pluginData.getMode(), data2.pluginData.getId()});
                }
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onSuccess(ChannelWindowTestController.this.enterParams, info, data2);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ChannelWindowTestController.this.onJoinSuccess(requestParams, data2, ((IChannelCenterService)ChannelWindowTestController.this.getServiceManager().getService(IChannelCenterService.class)).getChannel(info.baseInfo.gid));
                    }
                });
            }

            public void onFailByOnlineLimit(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailByOnlineLimit,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailByOnlineLimit(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailByNeedPassword(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailByNeedPassword,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailByNeedPassword(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailByPasswordError(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailByPasswordError,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailByPasswordError(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onKickOffFrozenError(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onKickOffFrozenError,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onKickOffFrozenError(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailByChannelNotExist(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailByChannelNotExist,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailByChannelNotExist(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onChannelBanned(EnterParam requestParams, ChannelBannedData bannedData, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onChannelBanned,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onChannelBanned(requestParams, bannedData, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailByPasswordTryTooFrequently(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailByPasswordTryTooFrequently,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailByPasswordTryTooFrequently(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onPrivateChannel(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onPrivateChannel,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onPrivateChannel(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailByInviteExpire(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailByInviteExpire,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailByInviteExpire(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailByInviteClickMaxLimit(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailByInviteClickMaxLimit,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailByInviteClickMaxLimit(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailChannelMatchFail(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onChannelNoMatch,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailChannelMatchFail(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailChannelAllDisBand(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onChannelNoMatch,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailChannelAllDisBand(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailNumberNoArrow(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailNumberNoArrow,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailNumberNoArrow(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onRetryUnBannedChannel(String channelId, EnterParam requestParams, String msgTip) {
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onRetryUnBannedChannel(channelId, requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onCrossRegionNotAllow(EnterParam requestParams, String msgTip) {
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onCrossRegionNotAllow(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onError(EnterParam requestParams, int errorCode, String errorTips, Exception e) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack on other error,cid:%s,gameid:%s,errorCode:%d,errorTips:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : "", errorCode, errorTips});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onError(requestParams, errorCode, errorTips, e);
                }
                ChannelWindowTestController.this.onJoinError(errorCode, "");
            }

            public void onNotMatchChannel(EnterParam param2) {
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onNotMatchChannel(param2);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onEnterLimitPopWindow(EnterParam param2, String errmsg) {
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onEnterLimitPopWindow(param2, errmsg);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onModifyChannelLimit() {
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onModifyChannelLimit();
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailEnterMultiVideoRoom(EnterParam requestParams, String msgTip) {
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailEnterMultiVideoRoom(requestParams, msgTip);
                    ForceLeaveDialog dialog2 = new ForceLeaveDialog();
                    dialog2.setOnDialogListener(() -> {
                        ChannelWindowTestController.this.getDialogLinkManager().dismissDialog();
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045047").put("function_id", "room_enter_click"));
                        EnterParam enterParam = EnterParam.of((String)"multivideo", (int)-1, null).entry(66).build();
                        ((IRoomService)ChannelWindowTestController.this.getServiceManager().getService(IRoomService.class)).enterRoom(enterParam);
                    });
                    ChannelWindowTestController.this.getDialogLinkManager().showDialog((BaseDialog)dialog2);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailClientHardwareBad(EnterParam requestParams, String msgTip) {
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailClientHardwareBad(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailChannelShowNumLimit(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailChannelShowNumLimit,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailChannelShowNumLimit(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onInBlackList(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onInBlackList,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onInBlackList(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onInOwnerBlackList(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onInOwnerBlackList,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onInOwnerBlackList(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onFailSensitive(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onFailSensitive,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onFailSensitive(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onOtherError(EnterParam requestParams, String msgTip) {
                MLog.error((Object)ChannelWindowTestController.TAG, (String)"JoinCallBack onOtherError,cid:%s,gameid:%s!", (Object[])new Object[]{requestParams.roomId, requestParams.gameInfo != null ? requestParams.gameInfo.gid : ""});
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onOtherError(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }

            public void onAgeLimit(EnterParam requestParams, String msgTip) {
                if (!ChannelWindowTestController.this.destroyed && ChannelWindowTestController.this.mCallback != null) {
                    ChannelWindowTestController.this.mCallback.getJoinErrorHandler(ChannelWindowTestController.this.enterParams).onAgeLimit(requestParams, msgTip);
                }
                ChannelWindowTestController.this.onJoinError(-1, "");
            }
        };
    }

    private void cancelLoadingDialog() {
        this.hideVideoLoadingDialog();
        if (this.progressDialog != null) {
            MLog.info((Object)TAG, (String)"cancelLoadingDialog!", (Object[])new Object[0]);
            this.myDialogLinkManager.dismissDialog();
            this.progressDialog.setCancelListener(null);
            this.progressDialog = null;
        }
    }

    private void onJoinError(int errorCode, String errorTips) {
        MLog.error((Object)TAG, (String)"onJoinError!", (Object[])new Object[0]);
        if (this.enterParams != null && this.enterParams.callBack != null) {
            this.enterParams.callBack.onError(errorCode, errorTips);
            this.enterParams.callBack = null;
        }
        this.cancelLoadingDialog();
        if (this.mCallback != null && !this.destroyed) {
            this.mCallback.onJoinError(this, errorCode);
        }
    }

    public static boolean isSwitchOn() {
        return RuntimeContext.sIsDebuggable || SystemUtils.isShowEnvSetting();
    }

    private static int getVideoShowReactionTime() {
        int time = SettingFlags.getIntValue((String)"videoshowtime", (int)-1);
        if (time < 0) {
            time = 0;
        }
        return time;
    }

    public static boolean useTestController() {
        if (ChannelWindowTestController.isSwitchOn()) {
            int type = SettingFlags.getIntValue((String)"videoshowtype", (int)-1);
            if (type == 1) {
                return true;
            }
            if (type == 2) {
                if (lastUseTest) {
                    lastUseTest = false;
                    return false;
                }
                lastUseTest = true;
                return true;
            }
            return false;
        }
        return false;
    }
}

