/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.main;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import androidx.arch.core.util.Function;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.IVoiceRoomExitCallback;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.event.fw.FWEvent;
import com.yy.base.event.fw.FWEventActionKey;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.ChannelBannedData;
import com.yy.hiyo.channel.base.bean.EnterChannelData;
import com.yy.hiyo.channel.base.bean.KickOffData;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.callback.IChannelMiniListener;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.AbsChannelController;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.cbase.EnterChannelService;
import com.yy.hiyo.channel.cbase.module.common.CodeRateUtils;
import com.yy.hiyo.channel.cbase.module.radio.config.LiveConstants;
import com.yy.hiyo.channel.cbase.utils.perf.ChannelPathLog;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.channelswipe.ChatRoomSwipeData;
import com.yy.hiyo.channel.component.music.MusicHelper;
import com.yy.hiyo.channel.growth.IInterceptMiniCallaback;
import com.yy.hiyo.channel.growth.IUserGuideManager;
import com.yy.hiyo.channel.module.main.ChannelComplexWindowController;
import com.yy.hiyo.channel.module.main.ChannelWindowController;
import com.yy.hiyo.channel.module.main.ChannelWindowTestController;
import com.yy.hiyo.channel.module.main.IChannelWindowController;
import com.yy.hiyo.channel.module.main.enter.ChannelGameListUtil;
import com.yy.hiyo.channel.module.main.enter.ChannelJoinErrorHandler;
import com.yy.hiyo.channel.module.main.enter.ChannelJoinGuideUtils;
import com.yy.hiyo.channel.module.main.enter.EnterStatsHelper;
import com.yy.hiyo.channel.module.main.enter.gameenter.GameEnterDispatchController;
import com.yy.hiyo.channel.module.main.enter.tips.ChannelTipsManager;
import com.yy.hiyo.channel.module.main.game.LudoNewUserGameHelper;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.multivideo.view.ForceLeaveDialog;
import com.yy.hiyo.channel.secretcall.ISecretCallService;
import com.yy.hiyo.channel.service.ChannelRecover;
import com.yy.hiyo.channel.service.request.join.JoinRequestManager;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.mixmodule.base.IUserRemainActiveService;
import com.yy.hiyo.proto.GlobalBanInterface;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.voice.base.mediav1.bean.IMediaRoom;
import com.yy.hiyo.voice.base.mediav1.bean.MediaRoomType;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;
import com.yy.hiyo.wallet.base.privilege.service.VIPSeatService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.ihago.channel.srv.mgr.ECode;

public class ChannelController
extends AbsChannelController
implements ChannelWindowController.ICallback {
    private static final String TAG = "ChannelController";
    private IChannelWindowController curJoinedChannel;
    private IChannelWindowController curJoiningChannel;
    private GameEnterDispatchController gameEnterController;
    private ChannelJoinErrorHandler joinErrorHandler;
    private final ChannelRecover groupRecover;
    private final ChannelTipsManager mChannelTipsManager;
    private boolean initMedia;
    private LudoNewUserGameHelper mLudoNewUserGameHelper = new LudoNewUserGameHelper();
    private IUserGuideManager.LowActiveRoomGuideCallback mLowActiveRoomGuideCallback;

    public ChannelController(Environment env) {
        super(env);
        this.joinErrorHandler = new ChannelJoinErrorHandler(this.getEnvironment());
        this.groupRecover = new ChannelRecover(this.joinErrorHandler);
        this.mChannelTipsManager = new ChannelTipsManager(this.mContext, this);
        this.registerMessage(AppbaseMsgDef.ChannelMsgDef.GET_CUR_CHANNEL);
        this.registerMessage(ChannelBaseMsgDef.MULTIVIDEO_MINI_SHOW_GET_VIDEO_VIEW);
        this.registerMessage(ChannelBaseMsgDef.IS_OPEN_BY_GAME);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_MYSELF_IS_KICK_OFF, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_FORCE_LEAVE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.WEBSOCKET_DISCONNECT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.WEBSOCKET_CONNECT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        if (SystemUtils.isShowEnvSetting() && SettingFlags.getBoolean((String)"channel_opt_switch", (boolean)false)) {
            MLog.info((Object)TAG, (String)"start channel task monitor!", (Object[])new Object[0]);
            PerfActionLog.end((String)"ChannelOptPerfActionLog", (String)"end last!", (Object[])new Object[0]);
            PerfActionLog.start((String)"ChannelOptPerfActionLog", (String)"", (Object[])new Object[0]);
        } else {
            MLog.info((Object)TAG, (String)"not start channel task monitor!", (Object[])new Object[0]);
        }
        boolean flag = RuntimeContext.sIsAppStartFinishAfterOneSecond;
        if (flag) {
            this.initMedia();
        }
    }

    private void initMedia() {
        if (this.initMedia) {
            return;
        }
        this.initMedia = true;
        ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).initMedia(() -> CodeRateUtils.INSTANCE.getCodeRateLevelString(LiveConstants.INSTANCE.getPlayQualityLevel(false)));
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL) {
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_ENTER_CHANNEL);
            int pluginType = -1;
            if (msg.obj instanceof EnterParam) {
                EnterParam param2 = (EnterParam)msg.obj;
                if (GlobalBanInterface.INSTANCE.isBandAction()) {
                    final String id2 = param2.roomId;
                    ArrayList channels = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getMyJoinedChannels(null, false, (Function)new IChannelCenterService.SupFunction<MyJoinChannelItem, Boolean>(){
                        private boolean end = false;

                        public boolean isBreak() {
                            return this.end;
                        }

                        public Boolean apply(MyJoinChannelItem input) {
                            if (input.cid.equals(id2)) {
                                this.end = true;
                                if (input.myRoleData != null) {
                                    return input.myRoleData.roleType == 15 || input.myRoleData.roleType == 10;
                                }
                            }
                            return false;
                        }
                    });
                    if (!FP.empty((Collection)channels)) {
                        MLog.error((Object)TAG, (String)"enter my join channel with baned!!! id:%s", (Object[])new Object[]{id2});
                        GlobalBanInterface.INSTANCE.notifyBanDialog();
                        return;
                    }
                }
                if ((param2.entryInfo == null || param2.entryInfo.getFirstEntType() == FirstEntType.UNKNOWN) && (RuntimeContext.sIsDebuggable || SystemUtils.isShowEnvSetting())) {
                    String stack = msg.getData().getString("thread_stack");
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("sfieldfive", stack);
                    statContent.put("perftype", "entry_info_stat");
                    HiidoStatis.reportContent((StatisContent)statContent);
                    MLog.info((Object)"EntryInfoTag", (String)stack, (Object[])new Object[0]);
                    boolean switchOn = SettingFlags.getBoolean((String)"pageautoswitch", (boolean)false);
                    boolean switchOnVoice = SettingFlags.getBoolean((String)"pageautovoiceswitch", (boolean)false);
                    if (!switchOn && !switchOnVoice) {
                        throw new RuntimeException("\u8fdb\u623f\u5165\u53e3\u6ca1\u6709\u52a0\u57cb\u70b9\uff0c\u8bf7\u8054\u7cfb\u90d1\u7115\u519b\u8be2\u95ee\u76f8\u5173\u4fe1\u606f\u6216\u8fc7\u6ee4EntryInfoTag\u67e5\u770b\u76f8\u5173\u5806\u6808");
                    }
                }
                pluginType = (Integer)param2.getExtra("pluginType", (Object)-1);
                MLog.info((Object)TAG, (String)"prefetchVideo before", (Object[])new Object[0]);
                if (AccountUtil.getUid() > 0L && StringUtils.isNotEmpty((String)param2.roomId)) {
                    this.initMedia();
                    IMediaRoom mediaRoom = ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).createMediaRoom(param2.roomId, MediaRoomType.VoiceRoom, (Context)this.getContext());
                    mediaRoom.setEnterEntry(param2.entry);
                    mediaRoom.setCanWatchRtc((Integer)param2.getExtra("key_radio_rtc", (Object)0) == 1);
                    Boolean isLive = (Boolean)param2.getExtra("is_live", (Object)false);
                    if (Boolean.TRUE.equals(isLive)) {
                        String roomMiddleInfo;
                        String middleInfo = (String)param2.getExtra("middle_ware_info", (Object)"");
                        if (StringUtils.isEmpty((String)middleInfo) && StringUtils.isNotEmpty((String)(roomMiddleInfo = ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).getRoomMiddleInfo(param2.roomId)))) {
                            middleInfo = roomMiddleInfo;
                        }
                        mediaRoom.prefetchVideo(middleInfo);
                    }
                }
                ArrayList<String> ids = new ArrayList<String>();
                if (this.curJoinedChannel != null) {
                    ids.add(this.curJoinedChannel.getChannelId());
                }
                ids.add(param2.roomId);
                ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).destroyRoomExcept(ids);
            }
            ISecretCallService secretService = (ISecretCallService)this.getServiceManager().getService(ISecretCallService.class);
            boolean isSecretCall = false;
            if (secretService != null && secretService.isCalling()) {
                isSecretCall = true;
            }
            if (pluginType == 1 && EnterParam.useTextChannelAndVoiceCoexistence() && !isSecretCall) {
                this.preEnterChannel((EnterParam)msg.obj, false);
                this.mChannelTipsManager.addChannelNotify();
            } else {
                IChannelMiniListener listener2 = (exit, afterShowDialog) -> {
                    if (exit && msg.obj instanceof EnterParam) {
                        this.preEnterChannel((EnterParam)msg.obj, afterShowDialog);
                        this.mChannelTipsManager.addChannelNotify();
                    }
                    if (!exit && RuntimeContext.isHagoPartySdk()) {
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_PARTY_SDK_BACK_ROOT_WINDOW));
                    }
                };
                Message showDialogMsg = Message.obtain();
                showDialogMsg.what = BaseMsgDef.SHOW_MINI_EXIT_CHANNEL_DIALOG;
                showDialogMsg.obj = listener2;
                if (msg.obj instanceof EnterParam) {
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("enter_param", (Serializable)((EnterParam)msg.obj));
                    showDialogMsg.setData(bundle);
                }
                this.sendMessage(showDialogMsg);
                SettingFlags.setLongValue((String)(pluginType == 14 ? "key_last_time_live_active" : "key_last_time_party_active"), (long)System.currentTimeMillis());
                if (msg.obj instanceof EnterParam) {
                    SettingFlags.setStringValue((String)"key_last_cid_channel_active", (String)((EnterParam)msg.obj).roomId);
                }
            }
            this.recordEnterRoomTimeStamp();
        } else if (msg.what == ChannelBaseMsgDef.EXCUTE_AFTER_CHANNEL_PRIVACYAGREEMENT_OR_GUEST) {
            if (msg.obj instanceof Runnable) {
                ChannelJoinGuideUtils.executeAfterPrivacyAgreementOrGuestLoginGuide(this.mContext, this.getCurrentWindow().getName(), (Runnable)msg.obj);
            }
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL_BY_ENTER_GAME) {
            this.enterGame(msg);
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.RESUME_CUR_CHANNEL) {
            this.resumeChannel(msg.obj instanceof String ? (String)msg.obj : null);
            if (this.curJoinedChannel != null && this.curJoinedChannel.getChannel() != null) {
                this.curJoinedChannel.handleMessage(msg);
            } else {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_PARTY_SDK_BACK_ROOT_WINDOW));
            }
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL) {
            HashMap<String, Object> extMap = new HashMap<String, Object>();
            if (msg.getData() != null) {
                Bundle bundle = msg.getData();
                int type = bundle.getInt("channel_exit_type");
                extMap.put("channel_exit_type", type);
            }
            if (msg.obj instanceof IVoiceRoomExitCallback) {
                this.exitCurChannel(msg.arg1 == 1, null, (IVoiceRoomExitCallback)msg.obj, extMap);
            } else {
                this.exitCurChannel(msg.arg1 == 1, msg.obj != null ? (String)msg.obj : null, null, extMap);
            }
        } else if (msg.what == ChannelMsgDef.REQUEST_ROOM_GAME_LIST) {
            ChannelGameListUtil.requestGameList(null);
        } else if (msg.what == BaseMsgDef.OPEN_VOICE_ROOM_BY_DEEPLINK) {
            this.getServiceManager().observeService(IRoomService.class, service -> {
                if (service instanceof EnterChannelService) {
                    ((EnterChannelService)service).enterVoiceRoom(msg.peekData());
                }
            });
        } else if (msg.what == BaseMsgDef.SHOW_VOICE_ROOM_NO_MATCH_FROM_LINK) {
            this.getServiceManager().observeService(IRoomService.class, service -> {
                if (service instanceof EnterChannelService && msg.obj instanceof GameInfo) {
                    ((EnterChannelService)service).enterRoomGameNoMatchFromLink((GameInfo)msg.obj, msg.getData());
                }
            });
        } else if (this.curJoinedChannel != null) {
            this.curJoinedChannel.handleMessage(msg);
        }
    }

    public final void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.destroyAllChannel();
            this.groupRecover.onDestroy();
            this.mChannelTipsManager.onDestroy();
        } else if (notification.id == NotificationIdDef.CHANNEL_MYSELF_IS_KICK_OFF) {
            this.kickoff((KickOffData)notification.extObj);
        } else if (notification.id == NotificationIdDef.CHANNEL_BANNED) {
            if (notification.extObj instanceof ChannelBannedData) {
                this.bannedChannel((ChannelBannedData)notification.extObj);
            }
        } else if (notification.id == NotificationIdDef.CHANNEL_FORCE_LEAVE) {
            this.forceLeave((String)notification.extObj);
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
            if (this.curJoinedChannel == null && this.curJoiningChannel == null && ProtoManager.getInstance().isWSConnected()) {
                JoinRequestManager.leaveLastJoinChannel();
                JoinRequestManager.leaveLastJoinBaseBroadCast();
            }
            this.handleStartupAfter3Seconds();
        } else if (notification.id == NotificationIdDef.WEBSOCKET_DISCONNECT || notification.id == NotificationIdDef.WEBSOCKET_CONNECT) {
            this.groupRecover.onWsConnect(notification.id == NotificationIdDef.WEBSOCKET_CONNECT);
            if (notification.id == NotificationIdDef.WEBSOCKET_CONNECT && this.curJoinedChannel == null && this.curJoiningChannel == null && ProtoManager.getInstance().isWSConnected()) {
                JoinRequestManager.leaveLastJoinChannel();
                JoinRequestManager.leaveLastJoinBaseBroadCast();
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            this.initMedia();
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS) {
            this.initMedia();
        } else if (this.curJoinedChannel != null) {
            this.curJoinedChannel.notify(notification);
        }
    }

    public final Object handleMessageSync(Message msg) {
        if (msg != null && msg.what == AppbaseMsgDef.ChannelMsgDef.GET_CUR_CHANNEL) {
            if (this.curJoinedChannel != null) {
                return this.curJoinedChannel.getChannelId();
            }
            return "";
        }
        if (msg != null && msg.what == AppbaseMsgDef.ChannelMsgDef.IS_PLAYING_MUSIC) {
            return MusicHelper.getMusicStatus() == 1;
        }
        if (msg != null && msg.what == AppbaseMsgDef.ChannelMsgDef.GET_SUB_CHANNEL) {
            if (this.curJoinedChannel != null) {
                return this.curJoinedChannel.getJoinedSubChannelId();
            }
            return "";
        }
        if (this.curJoinedChannel != null) {
            return this.curJoinedChannel.handleMessageSync(msg);
        }
        return super.handleMessageSync(msg);
    }

    private void preEnterChannel(EnterParam param2, boolean forceExitLastChannel) {
        param2.setExtra("shouldexitCurChannel", (Object)forceExitLastChannel);
        this.mLudoNewUserGameHelper.checkLudoNewUser(param2, () -> this.enterChannel(param2));
    }

    private void enterChannel(final EnterParam enterChannelParams) {
        if (enterChannelParams == null) {
            return;
        }
        final EnterParam.ICallBack originCallBack = enterChannelParams.callBack;
        enterChannelParams.callBack = new EnterParam.ICallBack(){

            public void onSuccess() {
                if (originCallBack != null) {
                    originCallBack.onSuccess();
                }
                Notification notification = Notification.obtain((int)ChannelNotifyDef.ENTER_CHANNEL_WINDOW_RESULT);
                HashMap<String, String> param2 = new HashMap<String, String>(2);
                param2.put("roomId", enterChannelParams.roomId);
                param2.put("code", "0");
                notification.extObj = param2;
                NotificationCenter.getGlobalInstance().notify(notification);
            }

            public void onError(int errorCode, String errorInfo) {
                if (originCallBack != null) {
                    originCallBack.onError(errorCode, errorInfo);
                }
                Notification notification = Notification.obtain((int)ChannelNotifyDef.ENTER_CHANNEL_WINDOW_RESULT);
                HashMap<String, String> param2 = new HashMap<String, String>(2);
                param2.put("roomId", enterChannelParams.roomId);
                param2.put("code", "" + errorCode);
                notification.extObj = param2;
                NotificationCenter.getGlobalInstance().notify(notification);
            }
        };
        VIPSeatService vipSeatService2 = PrivilegeHelper.INSTANCE.getVipSeatService();
        if (vipSeatService2 != null) {
            enterChannelParams.isVipSeat = vipSeatService2.getUserPrivilegeByCache(AccountUtil.getUid(), true);
        }
        if (this.showGuestLoginGuide()) {
            if (enterChannelParams.callBack != null) {
                enterChannelParams.callBack.onError(1000000, "");
                enterChannelParams.callBack = null;
            }
        } else {
            if (!ProtoManager.getInstance().isWSConnected() && !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.str_network_not_capable), (int)0);
                if (enterChannelParams.callBack != null) {
                    enterChannelParams.callBack.onError(1000003, "");
                }
                return;
            }
            this.joinAfterPrivacyAgreement(() -> this.enterChannelNow(enterChannelParams), enterChannelParams);
        }
    }

    private void enterChannelNow(EnterParam enterChannelParams) {
        IChannelCenterService channelCenterService;
        MLog.info((Object)TAG, (String)"enterChannelNow params:%s", (Object[])new Object[]{enterChannelParams.toString()});
        this.initMedia();
        if (MsgDispatcher.getInstance().hasMsgHandler(BaseMsgDef.ENTER_VOICE_ROOM_CLOSE_IM_MIC)) {
            this.sendMessageSync(BaseMsgDef.ENTER_VOICE_ROOM_CLOSE_IM_MIC);
        }
        this.destroyJoiningChannel(false);
        ChannelGameListUtil.requestGameList(null);
        if (StringUtils.isNotEmpty((String)enterChannelParams.roomId)) {
            ChannelPathLog.getEnterChannelLogger((String)enterChannelParams.roomId).add("enterChannel", new Object[0]);
        }
        if ((channelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)) != null) {
            channelCenterService.getNewGuideManager().onEnterChannel(enterChannelParams.roomId);
        }
        if (this.curJoinedChannel != null) {
            if (StringUtils.isEmpty((String)enterChannelParams.roomId) || !StringUtils.equal((String)enterChannelParams.roomId, (String)this.curJoinedChannel.getChannelId())) {
                if (ChannelWindowTestController.useTestController()) {
                    this.curJoiningChannel = new ChannelWindowTestController(this.getEnvironment(), this);
                    this.curJoiningChannel.enterChannel(enterChannelParams, true, true);
                    enterChannelParams.enterStartTime = System.currentTimeMillis();
                    YYTaskExecutor.postToMainThread(() -> this.exitCurChannel(false, this.curJoinedChannel.getChannelId(), null, null));
                } else {
                    boolean curChannelNotBaseMode = false;
                    String needDestroyChannelId = "";
                    if (enterChannelParams.entry != 24 && this.curJoinedChannel.getChannel() != null && this.curJoinedChannel.getChannel().getPluginService().getCurPluginData() != null) {
                        curChannelNotBaseMode = this.curJoinedChannel.getChannel().getPluginService().getCurPluginData().mode != 1;
                        int pluginType = (Integer)enterChannelParams.getExtra("pluginType", (Object)0);
                        if (pluginType > 0 && pluginType != 1) {
                            needDestroyChannelId = this.curJoinedChannel.getChannel().getPluginService().getCurPluginData().isVideoMode() ? this.curJoinedChannel.getChannelId() : "";
                        }
                    }
                    Boolean shouldExitCurChannel = (Boolean)enterChannelParams.getExtra("shouldexitCurChannel", (Object)false);
                    if (EnterParam.useTextChannelAndVoiceCoexistence() && StringUtils.isNotEmpty((String)enterChannelParams.roomId) && StringUtils.equal((String)enterChannelParams.roomId, (String)this.curJoinedChannel.getJoinedSubChannelId())) {
                        this.curJoinedChannel.bringWindowToFront(enterChannelParams);
                        needDestroyChannelId = "";
                        if (enterChannelParams.callBack != null) {
                            enterChannelParams.callBack.onSuccess();
                        }
                    } else if (EnterParam.useTextChannelAndVoiceCoexistence() && StringUtils.isNotEmpty((String)enterChannelParams.roomId) && curChannelNotBaseMode && !shouldExitCurChannel.booleanValue()) {
                        this.curJoiningChannel = new ChannelComplexWindowController(this.getEnvironment(), this, this.curJoinedChannel);
                        this.curJoiningChannel.enterChannel(enterChannelParams, this.needShowWindowAfterJoinSuccess(enterChannelParams), true);
                        enterChannelParams.enterStartTime = System.currentTimeMillis();
                    } else {
                        this.curJoiningChannel = new ChannelWindowController(this.getEnvironment(), this);
                        this.curJoiningChannel.enterChannel(enterChannelParams, this.needShowWindowAfterJoinSuccess(enterChannelParams), true);
                        enterChannelParams.enterStartTime = System.currentTimeMillis();
                    }
                    if (StringUtils.isNotEmpty((String)needDestroyChannelId)) {
                        String channelID = needDestroyChannelId;
                        YYTaskExecutor.postToMainThread(() -> this.exitCurChannel(false, channelID, null, null));
                    }
                }
                ChannelPathLog.initEnterChannelLogger((String)enterChannelParams.roomId);
            } else {
                this.curJoinedChannel.bringWindowToFront(enterChannelParams);
                if (enterChannelParams.callBack != null) {
                    enterChannelParams.callBack.onSuccess();
                }
            }
        } else {
            ChannelPathLog.initEnterChannelLogger((String)enterChannelParams.roomId);
            this.curJoiningChannel = ChannelWindowTestController.useTestController() ? new ChannelWindowTestController(this.getEnvironment(), this) : new ChannelWindowController(this.getEnvironment(), this);
            this.curJoiningChannel.enterChannel(enterChannelParams, this.needShowWindowAfterJoinSuccess(enterChannelParams), true);
            enterChannelParams.enterStartTime = System.currentTimeMillis();
        }
    }

    private void resumeChannel(String channelId) {
        if (this.curJoinedChannel != null && (StringUtils.equal((String)channelId, (String)this.curJoinedChannel.getChannelId()) || StringUtils.isEmpty((String)channelId))) {
            MLog.info((Object)TAG, (String)"resumeChannel:%s", (Object[])new Object[]{this.curJoinedChannel.getChannelId()});
            this.bringWindowToFront(this.curJoinedChannel.getEnterParams());
        } else if (this.curJoinedChannel != null && StringUtils.equal((String)channelId, (String)this.curJoinedChannel.getJoinedSubChannelId())) {
            EnterParam enterParam = new EnterParam();
            enterParam.roomId = channelId;
            this.bringWindowToFront(enterParam);
        }
    }

    private void bringWindowToFront(EnterParam param2) {
        if (this.curJoinedChannel != null && this.curJoinedChannel.isActivityDestroy()) {
            this.exitCurChannel(false, param2.roomId, isExit -> this.enterChannel(param2), null);
        } else if (this.curJoinedChannel != null) {
            this.curJoinedChannel.bringWindowToFront(param2);
        }
    }

    private void exitCurChannel(boolean ani, String exitThisChannel, IVoiceRoomExitCallback callback2, Map<String, Object> extMap) {
        if (this.curJoinedChannel != null) {
            MLog.info((Object)TAG, (String)"exitCurChannel ani:%b, exitChanel:%s, callback:%s, map:%s,curJoinedChannel:%s,curJoinedSubChannel:%s", (Object[])new Object[]{ani, exitThisChannel, callback2, extMap, this.curJoinedChannel.getChannelId(), this.curJoinedChannel.getJoinedSubChannelId()});
        } else {
            MLog.info((Object)TAG, (String)"exitCurChannel ani:%b, exitChanel:%s, callback:%s, map:%s", (Object[])new Object[]{ani, exitThisChannel, callback2, extMap});
        }
        if (this.curJoinedChannel != null && StringUtils.equal((String)exitThisChannel, (String)this.curJoinedChannel.getChannelId()) && StringUtils.isNotEmpty((String)exitThisChannel)) {
            if (this.curJoinedChannel instanceof ChannelComplexWindowController && ((ChannelComplexWindowController)this.curJoinedChannel).getJoinedSubChannelEnterParam() != null && ((ChannelComplexWindowController)this.curJoinedChannel).getJoinedSubChannelEnterParam().isFromChannelParty()) {
                MLog.info((Object)TAG, (String)"exitCurChannel joinedSubChannel isFromChannelParty, subChannelId:%s", (Object[])new Object[]{((ChannelComplexWindowController)this.curJoinedChannel).getJoinedSubChannelId()});
                this.destroyCurChannel(ani, callback2, extMap, null, 0);
            } else if (this.curJoinedChannel instanceof ChannelComplexWindowController && StringUtils.isNotEmpty((String)this.curJoinedChannel.getJoinedSubChannelId())) {
                ((ChannelComplexWindowController)this.curJoinedChannel).destroyWithoutSubChannel(ani, callback2, extMap);
            } else {
                this.destroyCurChannel(ani, callback2, extMap, null, 0);
            }
        } else if (this.curJoinedChannel != null && StringUtils.equal((String)exitThisChannel, (String)this.curJoinedChannel.getJoinedSubChannelId()) && StringUtils.isNotEmpty((String)exitThisChannel)) {
            this.saveExitChannelInfo(this.curJoinedChannel.getSubJoinedChannel());
            this.curJoinedChannel.destroyJoinedSubChannel(ani);
        }
        if (StringUtils.isEmpty((String)exitThisChannel)) {
            this.destroyJoiningChannel(false);
            if (this.curJoinedChannel != null) {
                this.curJoinedChannel.destroy(ani);
            }
        }
    }

    private void enterGame(Message message) {
        if (!this.showGuestLoginGuide()) {
            this.joinAfterPrivacyAgreement(() -> {
                if (this.gameEnterController == null) {
                    this.gameEnterController = new GameEnterDispatchController(this.mEnvironment);
                }
                this.gameEnterController.handleMessage(message);
            }, null);
        }
    }

    private void joinAfterPrivacyAgreement(final Runnable command, final EnterParam enterChannelParams) {
        boolean show = ChannelJoinGuideUtils.showPrivacyAgreementGuide(this.mContext, this.getCurrentWindow().getName(), new ChannelJoinGuideUtils.IPrivacyAgreementGuideCallBack(){

            @Override
            public void onAgree() {
                MLog.info((Object)ChannelController.TAG, (String)"HomeMainController \u534f\u8bae\u5f39\u7a97\u70b9\u51fbagree", (Object[])new Object[0]);
                SettingFlags.setBoolean((String)"key_voice_room_agreement_showed", (boolean)true);
                command.run();
            }

            @Override
            public void onCancel() {
                if (enterChannelParams != null && enterChannelParams.callBack != null) {
                    enterChannelParams.callBack.onError(1000000, "");
                    enterChannelParams.callBack = null;
                }
            }
        });
        if (!show) {
            command.run();
        }
    }

    private boolean showGuestLoginGuide() {
        return ChannelJoinGuideUtils.showGuestGuide();
    }

    private void destroyAllChannel() {
        this.destroyCurChannel();
        this.destroyJoiningChannel(false);
    }

    private void destroyJoiningChannel(boolean ani) {
        if (this.curJoiningChannel != null) {
            MLog.info((Object)TAG, (String)"destroy curJoiningChannel:%s", (Object[])new Object[]{this.curJoiningChannel.getEnterParams() != null ? this.curJoiningChannel.getEnterParams().toString() : this.curJoiningChannel.getChannelId()});
            this.curJoiningChannel.destroy(ani);
        }
    }

    private void notifyRecoverChannelLeave(IChannelWindowController curJoiningChannel) {
        this.groupRecover.onLeave(curJoiningChannel.getChannelId());
    }

    private void destroyCurChannel(boolean ani, IVoiceRoomExitCallback callbackWhenExited, Map<String, Object> extMap, String nextJoinSuccessChannel, int nextJoinSuccessEntry) {
        boolean needChannelAndVoiceCoexistence = false;
        if (this.curJoinedChannel != null && this.curJoiningChannel != null) {
            MLog.info((Object)TAG, (String)"nextJoinSuccessChannel:%s,curJoinedChannel:%s,curJoiningChannel:%s,curJoiningSubChannel:%s", (Object[])new Object[]{nextJoinSuccessChannel, this.curJoinedChannel.getChannelId(), this.curJoiningChannel.getChannelId(), this.curJoiningChannel.getJoinedSubChannelId()});
            if (nextJoinSuccessChannel != null && !StringUtils.equal((String)this.curJoinedChannel.getChannelId(), (String)nextJoinSuccessChannel) && StringUtils.equal((String)this.curJoiningChannel.getChannelId(), (String)nextJoinSuccessChannel) && StringUtils.isNotEmpty((String)this.curJoiningChannel.getJoinedSubChannelId()) && StringUtils.equal((String)this.curJoinedChannel.getChannelId(), (String)this.curJoiningChannel.getJoinedSubChannelId())) {
                needChannelAndVoiceCoexistence = true;
            }
        }
        if (needChannelAndVoiceCoexistence) {
            if (callbackWhenExited != null) {
                callbackWhenExited.onExit(true);
            }
            return;
        }
        if (this.curJoinedChannel != null) {
            MLog.info((Object)TAG, (String)"curJoinedChannel destroy :%s", (Object[])new Object[]{this.curJoinedChannel.getEnterParams() != null ? this.curJoinedChannel.getEnterParams().toString() : this.curJoinedChannel.getChannelId()});
            this.saveExitChannelInfo(this.curJoinedChannel);
            boolean notLeaveRequest = false;
            if (StringUtils.isNotEmpty((String)nextJoinSuccessChannel) && StringUtils.equal((String)this.curJoinedChannel.getChannelId(), (String)nextJoinSuccessChannel)) {
                notLeaveRequest = true;
            }
            this.curJoinedChannel.destroy(ani, callbackWhenExited, extMap, notLeaveRequest || needChannelAndVoiceCoexistence, nextJoinSuccessChannel, nextJoinSuccessEntry);
        } else if (callbackWhenExited != null) {
            callbackWhenExited.onExit(true);
        }
    }

    private void saveExitChannelInfo(IChannelWindowController exitChannel) {
        if (exitChannel != null && exitChannel.getEnterParams() != null && exitChannel.getEnterParams().showInfo != null) {
            String exitRoomName = exitChannel.getEnterParams().showInfo.name;
            int exitPluginMode = exitChannel.getChannel().getPluginService().getCurPluginData().mode;
            boolean isVideo = exitChannel.getChannel().getPluginService().getCurPluginData().isVideoMode();
            MLog.debug((Object)TAG, (String)("exit channel info: name: %s, mode: %d, isVideo: " + isVideo), (Object[])new Object[]{exitRoomName, exitPluginMode});
            if (exitChannel.getEnterParams().showInfo.show_type == 1) {
                if (exitChannel.getChannel().getPluginService().getCurPluginData() != null) {
                    SettingFlags.setStringValue((String)"key_exit_channel_name", (String)exitRoomName);
                    SettingFlags.setIntValue((String)"key_exit_channel_mode", (int)exitPluginMode);
                    SettingFlags.setBoolean((String)"key_exit_channel_radio_video_mode", (boolean)isVideo);
                }
            } else if (exitChannel.getEnterParams().showInfo.show_type == 2) {
                SettingFlags.setStringValue((String)"key_exit_group_channel_name", (String)exitRoomName);
                SettingFlags.setIntValue((String)"key_exit_group_channel_mode", (int)exitPluginMode);
                SettingFlags.setBoolean((String)"key_exit_group_channel_radio_video_mode", (boolean)isVideo);
            }
        }
        if (exitChannel != null) {
            boolean meOwner = exitChannel.getChannel().getRoleService().isMeOwner();
            int mode = exitChannel.getChannel().getPluginService().getCurPluginData().mode;
            if (meOwner && mode == 1) {
                SettingFlags.setStringValue((String)"key_last_enter_self_channel_id", (String)exitChannel.getChannelId());
            }
        }
    }

    private void destroyCurChannel(IVoiceRoomExitCallback callbackWhenExited, String nextJoinSuccessChannel, int nextJoinSuccessEntry) {
        this.destroyCurChannel(false, callbackWhenExited, null, nextJoinSuccessChannel, nextJoinSuccessEntry);
    }

    private void destroyCurChannel() {
        this.destroyCurChannel(null, null, 0);
    }

    private void kickoff(KickOffData data2) {
        if (this.curJoinedChannel != null && StringUtils.equal((String)this.curJoinedChannel.getChannelId(), (String)data2.groupId)) {
            this.destroyCurChannel();
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_be_kick_off), (int)0);
        }
        if (this.curJoinedChannel != null && StringUtils.equal((String)this.curJoinedChannel.getJoinedSubChannelId(), (String)data2.groupId)) {
            this.saveExitChannelInfo(this.curJoinedChannel.getSubJoinedChannel());
            this.curJoinedChannel.destroyJoinedSubChannel(false);
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_be_kick_off), (int)0);
        }
        if (this.curJoiningChannel != null && StringUtils.equal((String)this.curJoiningChannel.getChannelId(), (String)data2.groupId)) {
            this.destroyJoiningChannel(this.curJoinedChannel == null);
        }
    }

    private void forceLeave(String cid) {
        if (this.curJoinedChannel != null && StringUtils.equal((String)this.curJoinedChannel.getChannelId(), (String)cid)) {
            this.destroyCurChannel();
            MLog.debug((Object)TAG, (String)"forceLeave", (Object[])new Object[0]);
            ForceLeaveDialog dialog2 = new ForceLeaveDialog();
            dialog2.setOnDialogListener(() -> {
                this.getDialogLinkManager().dismissDialog();
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045047").put("function_id", "room_enter_click"));
                EnterParam enterParam = EnterParam.of((String)"multivideo", (int)-1, null).entry(66).entryInfo(new EntryInfo(FirstEntType.SUB_WINDOW, "3", null)).build();
                ((IRoomService)this.getServiceManager().getService(IRoomService.class)).enterRoom(enterParam);
            });
            this.getDialogLinkManager().showDialog((BaseDialog)dialog2);
        }
        if (this.curJoiningChannel != null && StringUtils.equal((String)this.curJoiningChannel.getChannelId(), (String)cid)) {
            this.destroyJoiningChannel(this.curJoinedChannel == null);
        }
    }

    private void bannedChannel(ChannelBannedData data2) {
        if (this.curJoinedChannel != null && StringUtils.equal((String)this.curJoinedChannel.getChannelId(), (String)data2.gid)) {
            this.destroyCurChannel();
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_group_banned), (int)0);
        }
        if (this.curJoiningChannel != null && StringUtils.equal((String)this.curJoiningChannel.getChannelId(), (String)data2.gid)) {
            this.destroyJoiningChannel(this.curJoinedChannel == null);
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_group_banned), (int)0);
        }
    }

    private void handleStartupAfter3Seconds() {
        SettingFlags.setBoolean((String)"key_send_location_permission_msg", (boolean)true);
    }

    @Override
    public void preJoinSuccess(IChannelWindowController controller, Runnable callBack, String channelId) {
        if (this.curJoinedChannel != null && StringUtils.equal((String)this.curJoinedChannel.getChannelId(), (String)channelId)) {
            if (controller == this.curJoiningChannel) {
                this.destroyJoiningChannel(false);
            }
            this.curJoinedChannel.bringWindowToFront(this.curJoinedChannel.getEnterParams());
            return;
        }
        int entry = 0;
        if (controller.getEnterParams() != null) {
            entry = controller.getEnterParams().entry;
        }
        if (this.curJoinedChannel != null && StringUtils.equal((String)this.curJoinedChannel.getJoinedSubChannelId(), (String)channelId)) {
            MLog.info((Object)TAG, (String)"preJoinSuccess channelId:%s, entry:%d, subChannelOfCurJoinedChannel:%s", (Object[])new Object[]{channelId, entry, this.curJoinedChannel.getJoinedSubChannelId()});
            this.destroyCurChannel(true, isExit -> callBack.run(), null, channelId, entry);
        } else {
            MLog.info((Object)TAG, (String)"preJoinSuccess id:%s, entry:%d", (Object[])new Object[]{channelId, entry});
            this.destroyCurChannel(isExit -> callBack.run(), channelId, entry);
        }
    }

    @Override
    public void onJoinSuccess(EnterParam requestParams, EnterChannelData data2, IChannelWindowController controller, boolean resumeFromBg) {
        if (this.curJoiningChannel == controller || resumeFromBg) {
            if (this.curJoiningChannel != null && this.curJoiningChannel != controller) {
                this.curJoiningChannel.destroy(false);
            }
            this.curJoinedChannel = controller;
            MLog.info((Object)TAG, (String)"onJoinSuccess curJoinedChannel:%s, curJoinedSubChannel:%s", (Object[])new Object[]{this.curJoinedChannel.getChannelId(), this.curJoinedChannel.getJoinedSubChannelId()});
            if (!resumeFromBg) {
                HiidoStatis.pauseReport((long)5000L);
            }
            if (data2.pluginData != null) {
                int pluginMode = data2.pluginData.mode;
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_ENTERED_WiTH_MODE_EXTRA, (Object)pluginMode));
            }
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_ENTERED, (Object)this.curJoinedChannel.getChannelId()));
            String subCid = this.curJoinedChannel.getJoinedSubChannelId();
            IChannel channelSub = StringUtils.isNotEmpty((String)subCid) ? ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannel(subCid) : null;
            EnterParam subEnterParam = this.curJoinedChannel.getJoinedSubChannelEnterParam();
            this.groupRecover.onJoinSuccess(this.curJoinedChannel.getChannelId(), data2, requestParams, subCid, subEnterParam);
            IChannel channel = this.curJoinedChannel.getChannel();
            if (channel != null) {
                channel.getConfigService().getConfigInChannel(null);
                if (channelSub != null && this.curJoinedChannel.getSubJoinedChannel() != null && this.curJoinedChannel.getSubJoinedChannel().getChannel() != null && channelSub != this.curJoinedChannel.getSubJoinedChannel().getChannel() && SystemUtils.isShowEnvSetting()) {
                    throw new RuntimeException("\u4ece\u5f53\u524d\u8fdb\u5165\u9891\u9053\u83b7\u53d6\u5230\u7684Channel\u4e0d\u7b49\u4e8e\u901a\u8fc7cid\u83b7\u53d6\u7684Channel:" + channelSub.toString() + ", " + this.curJoinedChannel.getSubJoinedChannel().getChannel().toString());
                }
                if (channelSub != null) {
                    if (channelSub.getPluginService().getCurPluginData() != null && channelSub.getPluginService().getCurPluginData().mode != 1) {
                        EnterStatsHelper.onEntered(channel, channel, this.curJoinedChannel.getEnterParams(), data2, channelSub, subEnterParam, channelSub.getEnterChannelData());
                    } else {
                        if (SystemUtils.isShowEnvSetting() || TargetBuildConstant.showSetting == 1 && TargetBuildConstant.releaseApkCheck) {
                            throw new RuntimeException("\u76ee\u524d\u7684\u9891\u9053\u5171\u5b58\uff0c\u53ea\u6709\u5f53\u524d\u662f\u8bed\u97f3\u623f\uff0c\u518d\u8fdb\u5165\u6587\u5b57\u623f\u53ef\u4ee5\u5171\u5b58\uff1b\u5176\u4ed6\u7684\u4e0d\u80fd\u5171\u5b58\uff1b \u800c\u73b0\u5728\u51fa\u73b0\u4e86\u975e\u8bed\u97f3\u623f+\u6587\u5b57\u623f/\u8bed\u97f3\u623f\u7684\u7ec4\u5408");
                        }
                        EnterStatsHelper.onEntered(channel, channel, this.curJoinedChannel.getEnterParams(), data2, channelSub, subEnterParam, channelSub.getEnterChannelData());
                    }
                } else {
                    EnterStatsHelper.onEntered(channel, channel, this.curJoinedChannel.getEnterParams(), data2, null, null, null);
                }
            }
            if (data2.isUpgrade) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_VERSION_UPGRADE, (Object)this.curJoinedChannel.getChannelId()));
            }
            this.curJoiningChannel = null;
        }
    }

    @Override
    public void onJoinSuccess(EnterParam requestParams, EnterChannelData data2, IChannelWindowController controller) {
        this.onJoinSuccess(requestParams, data2, controller, false);
    }

    @Override
    public void onJoinError(IChannelWindowController controller, int errorCode) {
        boolean canHandle;
        boolean isChatSwipe = this.curJoiningChannel.getEnterParams().entry == 24 && ((IChannelCenterService)this.getServiceManager().getService(IChannelCenterService.class)).getChannelSwipeModel().getSwipeData() instanceof ChatRoomSwipeData;
        boolean bl = canHandle = errorCode == ECode.ONLY_ARROW_MEMBER_ENTER.getValue() || errorCode == ECode.LOCKED.getValue() || errorCode == ECode.PRIVATE.getValue() || errorCode == ECode.PASSWORD_ERROR.getValue() || errorCode == ECode.KICK_OFF_FROZE.getValue();
        if (isChatSwipe && canHandle) {
            this.destroyJoiningChannel(this.curJoinedChannel == null);
        } else if (this.curJoiningChannel != null && this.curJoiningChannel.getEnterParams() != null && this.curJoiningChannel.getEnterParams().entry == 24) {
            this.destroyAllChannel();
        } else {
            this.destroyJoiningChannel(this.curJoinedChannel == null);
        }
    }

    @Override
    public IChannel.IJoinCallBack getJoinErrorHandler(EnterParam enterChannelParams) {
        if (this.joinErrorHandler == null) {
            this.joinErrorHandler = new ChannelJoinErrorHandler(this.getEnvironment());
        }
        return this.joinErrorHandler;
    }

    @Override
    public void preDestroy(IChannelWindowController controller) {
        if (controller != null) {
            this.notifyRecoverChannelLeave(controller);
        }
    }

    @Override
    public void onChannelDestroyed(IChannelWindowController controller) {
        if (this.curJoiningChannel == controller) {
            MLog.info((Object)TAG, (String)"onChannelDestroyed, curJoiningChannel cid:%s", (Object[])new Object[]{this.curJoiningChannel.getChannelId()});
            this.curJoiningChannel = null;
        }
        if (this.curJoinedChannel == controller) {
            MLog.info((Object)TAG, (String)"onChannelDestroyed, curJoinedChannel cid:%s", (Object[])new Object[]{this.curJoinedChannel.getChannelId()});
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_EXITED, (Object)this.curJoinedChannel.getChannelId()));
            FWEvent.sendEvent((Object)this, (FWEventActionKey)FWEventActionKey.FWAction_On_ChannelExit, (Object[])new Object[]{this.curJoinedChannel.getChannelId()});
            EnterStatsHelper.onExited(this.curJoinedChannel.getChannel(), this.curJoinedChannel.getEnterParams());
            this.curJoinedChannel = null;
        } else if (controller != null) {
            EnterStatsHelper.onExited(controller.getChannel(), controller.getEnterParams());
        }
    }

    @Override
    public void onBeforeMinimize(final IInterceptMiniCallaback callaback) {
        EnterParam enterParam;
        IChannelCenterService channelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
        EnterParam enterParam2 = enterParam = this.curJoinedChannel == null ? null : this.curJoinedChannel.getEnterParams();
        if (channelCenterService == null || enterParam == null) {
            if (callaback != null) {
                callaback.onProceed();
            }
            return;
        }
        channelCenterService.getNewGuideManager().onBeforeMinimize(this.getCurChannelId(), (Context)this.getContext(), enterParam, this.mDialogLinkManager, new IInterceptMiniCallaback(){

            public void onProceed() {
                if (callaback != null) {
                    callaback.onProceed();
                }
            }
        });
    }

    @Override
    public void onAfterMinimize(String channelId) {
        IChannelCenterService channelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
        if (channelCenterService == null) {
            return;
        }
        channelCenterService.getNewGuideManager().onAfterMinimize(channelId);
    }

    public String getCurChannelId() {
        if (this.curJoinedChannel != null) {
            return this.curJoinedChannel.getChannelId();
        }
        return "";
    }

    private void recordEnterRoomTimeStamp() {
        ((IUserRemainActiveService)ServiceManagerProxy.getInstance().getService(IUserRemainActiveService.class)).recordEnterChannelTime(System.currentTimeMillis());
    }

    private void recordEnterRoomCount() {
        int enterCount = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_enter_room_count"), (int)0);
        if (enterCount <= 1) {
            SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_enter_room_count"), (int)(++enterCount));
        }
    }
}

