/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow.list.reminderlist;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.data.PageData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.ReminderDetails;
import com.yy.hiyo.channel.follow.IFollowProtoCallback;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ReminderListMvp;
import com.yy.hiyo.channel.module.follow.protocol.ProtoHelper;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ihago.channel.srv.edge.NoticeChannelInfo;
import net.ihago.channel.srv.edge.PullNoticeChannelListReq;
import net.ihago.channel.srv.edge.PullNoticeChannelListRes;

public class ReminderListModel
implements ReminderListMvp.IModel {
    private final String TAG = "ReminderListModel";
    private List<Long> noticeUidList;
    private int pageSize = 50;
    private int pageIndex = 0;

    @Override
    public void reminderListRefresh(final IFollowProtoCallback<PageData<ReminderDetails>> callback2) {
        PullNoticeChannelListReq.Builder reqBuilder = new PullNoticeChannelListReq.Builder().limit(Integer.valueOf(20)).need_friends(Boolean.valueOf(true));
        if (NewABDefine.FRIENDS_IN_ROOM_TEST.getTest() != null) {
            reqBuilder.ab_val(NewABDefine.FRIENDS_IN_ROOM_TEST.getTest().getValue("action"));
        }
        MLog.info((Object)"ReminderListModel", (String)("ListRefresh req: " + JsonParser.toJson((Object)reqBuilder)), (Object[])new Object[0]);
        ProtoManager.getInstance().sendRpc((AndroidMessage)reqBuilder.build(), (IProtoCallback)new IProtoCallback<PullNoticeChannelListRes>(){

            public void onResponse(@NonNull PullNoticeChannelListRes data2, long code, String msgTip) {
                super.onResponse((AndroidMessage)data2, code, msgTip);
                MLog.info((Object)"ReminderListModel", (String)("ListRefresh onResponse size = " + data2.list.size()), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    ReminderListModel.this.noticeUidList = data2.uids;
                    ReminderListModel.this.pageSize = FP.orInt((Long)data2.page_size);
                    List noticeUserList = data2.list;
                    PageData pageData = new PageData();
                    pageData.setPageIndex(0);
                    if (ReminderListModel.this.noticeUidList != null && ReminderListModel.this.noticeUidList.size() > 0) {
                        if (ReminderListModel.this.noticeUidList.size() < ReminderListModel.this.pageSize) {
                            pageData.setHasNextPage(false);
                        } else {
                            pageData.setHasNextPage(true);
                        }
                        pageData.setTotal(ReminderListModel.this.noticeUidList.size());
                        ReminderListModel.this.requestPageUserDetails(noticeUserList, (PageData<ReminderDetails>)pageData, (IFollowProtoCallback<PageData<ReminderDetails>>)callback2);
                    } else {
                        pageData.setHasNextPage(false);
                        pageData.setTotal(0);
                        ReminderListModel.this.pageIndex = 0;
                        ProtoHelper.handleOnSuccessInMain(callback2, pageData);
                    }
                } else {
                    ProtoHelper.handleOnFailInMain(callback2, 500, "onResponseError");
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                ProtoHelper.handleOnFailInMain(callback2, 400, "timeOut");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                ProtoHelper.handleOnFailInMain(callback2, code, reason);
                return false;
            }
        });
    }

    @Override
    public void reminderListNextPage(boolean isNeedPullNoInRoom, IFollowProtoCallback<PageData<ReminderDetails>> callback2) {
        int reqPageIndex = this.pageIndex + 1;
        ArrayList<Long> reqUidList = new ArrayList<Long>();
        PageData pageData = new PageData();
        pageData.setPageIndex(reqPageIndex);
        if (isNeedPullNoInRoom) {
            this.requestNextPageList(true, reqUidList, (PageData<ReminderDetails>)pageData, callback2);
            return;
        }
        if (this.noticeUidList != null) {
            int index;
            pageData.setTotal(this.noticeUidList.size());
            int startIndex = reqPageIndex * this.pageSize;
            int endIndex = startIndex + this.pageSize;
            for (index = startIndex; index < this.noticeUidList.size() && index <= endIndex; ++index) {
                reqUidList.add(this.noticeUidList.get(index));
            }
            if (index < this.noticeUidList.size()) {
                pageData.setHasNextPage(true);
            } else {
                pageData.setHasNextPage(false);
            }
        } else {
            pageData.setTotal(0);
            pageData.setHasNextPage(false);
        }
        if (reqUidList.size() > 0) {
            this.requestNextPageList(false, reqUidList, (PageData<ReminderDetails>)pageData, callback2);
        } else {
            this.pageIndex = pageData.getPageIndex();
            ProtoHelper.handleOnSuccessInMain(callback2, pageData);
        }
    }

    private void requestNextPageList(final boolean isNeedPullNoInRoom, List<Long> reqUidList, final PageData<ReminderDetails> pageData, final IFollowProtoCallback<PageData<ReminderDetails>> callback2) {
        PullNoticeChannelListReq.Builder reqBuilder = new PullNoticeChannelListReq.Builder().need_friends(Boolean.valueOf(false));
        if (isNeedPullNoInRoom) {
            reqBuilder.pull_not_onshow(Boolean.valueOf(true));
        } else {
            reqBuilder.limit(Integer.valueOf(20));
            reqBuilder.uids(reqUidList);
            reqBuilder.pull_not_onshow(Boolean.valueOf(false));
        }
        if (NewABDefine.FRIENDS_IN_ROOM_TEST.getTest() != null) {
            reqBuilder.ab_val(NewABDefine.FRIENDS_IN_ROOM_TEST.getTest().getValue("action"));
        }
        MLog.info((Object)"ReminderListModel", (String)("NextPage \u8fd9\u662f" + (isNeedPullNoInRoom ? "\u672a\u5f00\u64ad\u5217\u8868" : "\u5f00\u64ad\u5217\u8868") + " req = " + JsonParser.toJson((Object)reqBuilder)), (Object[])new Object[0]);
        ProtoManager.getInstance().sendRpc((AndroidMessage)reqBuilder.build(), (IProtoCallback)new IProtoCallback<PullNoticeChannelListRes>(){

            public void onResponse(@NonNull PullNoticeChannelListRes data2, long code, String msgTip) {
                super.onResponse((AndroidMessage)data2, code, msgTip);
                MLog.info((Object)"ReminderListModel", (String)("NextPage onResponse code = " + code), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)"ReminderListModel", (String)("NextPage onResponse \u8fd9\u662f" + (isNeedPullNoInRoom ? "\u672a\u5f00\u64ad\u5217\u8868" : "\u5f00\u64ad\u5217\u8868") + ", size= " + (data2.list != null ? data2.list.size() : 0)), (Object[])new Object[0]);
                    if (isNeedPullNoInRoom) {
                        pageData.setTotal(ReminderListModel.this.noticeUidList.size() + (data2.list != null ? data2.list.size() : 0));
                        pageData.setHasNextPage(false);
                    }
                    ReminderListModel.this.requestPageUserDetails(data2.list, (PageData<ReminderDetails>)pageData, (IFollowProtoCallback<PageData<ReminderDetails>>)callback2);
                } else {
                    ProtoHelper.handleOnFailInMain(callback2, 500, "onResponseError");
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)"ReminderListModel", (String)("NextPage retryWhenTimeout canRetry = " + canRetry), (Object[])new Object[0]);
                ProtoHelper.handleOnFailInMain(callback2, 400, "timeOut");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)"ReminderListModel", (String)("NextPage retryWhenError canRetry = " + canRetry + " reason = " + reason + " code = " + code), (Object[])new Object[0]);
                ProtoHelper.handleOnFailInMain(callback2, code, reason);
                return false;
            }
        });
    }

    private void requestPageUserDetails(final List<NoticeChannelInfo> noticeUserList, final PageData<ReminderDetails> pageData, final IFollowProtoCallback<PageData<ReminderDetails>> callback2) {
        if (noticeUserList != null && noticeUserList.size() > 0) {
            ArrayList<Long> uidList = new ArrayList<Long>();
            for (NoticeChannelInfo noticeUserInfo : noticeUserList) {
                uidList.add(noticeUserInfo.uid);
            }
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uidList, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    HashMap<Long, UserInfoKS> userInfoKSMap = new HashMap<Long, UserInfoKS>();
                    if (userInfoKSList != null) {
                        for (UserInfoKS userInfoKS : userInfoKSList) {
                            if (userInfoKS == null) continue;
                            userInfoKSMap.put(userInfoKS.uid, userInfoKS);
                        }
                    }
                    ArrayList<ReminderDetails> reminderDetailsList = new ArrayList<ReminderDetails>();
                    for (NoticeChannelInfo noticeUserInfo : noticeUserList) {
                        ReminderDetails reminderDetails = new ReminderDetails();
                        reminderDetails.setUserInfoKS((UserInfoKS)userInfoKSMap.get(noticeUserInfo.uid));
                        reminderDetails.setNoticeUserInfo(noticeUserInfo);
                        reminderDetailsList.add(reminderDetails);
                    }
                    ReminderListModel.this.pageIndex = pageData.getPageIndex();
                    pageData.setData(reminderDetailsList);
                    ProtoHelper.handleOnSuccessInMain(callback2, pageData);
                }

                public void onFail(int id2, String msg, String response) {
                    ProtoHelper.handleOnFail(callback2, 5000, msg);
                }

                public int id() {
                    return 0;
                }
            });
        } else {
            this.pageIndex = pageData.getPageIndex();
            ProtoHelper.handleOnSuccessInMain(callback2, pageData);
        }
    }
}

