/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.module.creator.widget.FlowAdapter;
import java.util.ArrayList;
import java.util.List;

public class AutoFlowLayout<T>
extends ViewGroup {
    private List<List<View>> mAllViews = new ArrayList<List<View>>();
    private List<Integer> mWidthList = new ArrayList<Integer>();
    private boolean mIsSingleLine;
    private List<Integer> mLineHeight = new ArrayList<Integer>();
    private int mMaxLineNumbers;
    private int mCount;
    private boolean mHasMoreData;
    private OnItemClickListener mOnItemClickListener;
    private int mCurrentItemIndex = -1;
    private boolean mIsMultiChecked;
    private View mSelectedView;
    private List<View> mCheckedViews = new ArrayList<View>();
    private int mDisplayNumbers;
    private FlowAdapter<T> mAdapter;
    private float mHorizontalSpace;
    private float mVerticalSpace;
    private int mColumnNumbers;
    private int mRowNumbers;
    private boolean mIsGridMode;
    private boolean mIsCutLine;
    private float mCutLineWidth;
    private int mCutLineColor;
    private boolean mIsCenter;
    private OnLongItemClickListener mOnLongItemClickListener;
    private int mMinHeight;

    public AutoFlowLayout(Context context) {
        super(context);
    }

    public AutoFlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AutoFlowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AutoFlowLayout);
        this.mIsSingleLine = ta.getBoolean(R.styleable.AutoFlowLayout_singleLine, false);
        this.mMaxLineNumbers = ta.getInteger(R.styleable.AutoFlowLayout_maxLines, Integer.MAX_VALUE);
        this.mIsMultiChecked = ta.getBoolean(R.styleable.AutoFlowLayout_multiChecked, false);
        this.mHorizontalSpace = ta.getDimension(R.styleable.AutoFlowLayout_horizontalSpace, 0.0f);
        this.mVerticalSpace = ta.getDimension(R.styleable.AutoFlowLayout_verticalSpace, 0.0f);
        this.mColumnNumbers = ta.getInteger(R.styleable.AutoFlowLayout_columnNumbers, 0);
        this.mRowNumbers = ta.getInteger(R.styleable.AutoFlowLayout_rowNumbers, 0);
        this.mCutLineColor = ta.getColor(R.styleable.AutoFlowLayout_cutLineColor, this.getResources().getColor(0x1060000));
        this.mCutLineWidth = ta.getDimension(R.styleable.AutoFlowLayout_cutLineWidth, 1.0f);
        this.mIsCutLine = ta.getBoolean(R.styleable.AutoFlowLayout_cutLine, false);
        this.mIsCenter = ta.getBoolean(R.styleable.AutoFlowLayout_lineCenter, false);
        if (this.mColumnNumbers != 0) {
            this.mIsGridMode = true;
        }
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIsGridMode) {
            this.setGridMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.setFlowMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void setGridMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        if (this.mRowNumbers == 0) {
            this.mRowNumbers = this.getChildCount() % this.mColumnNumbers == 0 ? this.getChildCount() / this.mColumnNumbers : this.getChildCount() / this.mColumnNumbers + 1;
        }
        int maxChildHeight = 0;
        int maxWidth = 0;
        int maxHeight = 0;
        int maxLineWidth = 0;
        for (int i = 0; i < this.mRowNumbers; ++i) {
            for (int j = 0; j < this.mColumnNumbers; ++j) {
                View child = this.getChildAt(i * this.mColumnNumbers + j);
                if (child == null || child.getVisibility() == 8) continue;
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                maxLineWidth += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
                maxChildHeight = Math.max(maxChildHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            }
            maxWidth = Math.max(maxLineWidth, maxWidth);
            maxLineWidth = 0;
            maxHeight += maxChildHeight;
            maxChildHeight = 0;
        }
        int tempWidth = (int)((float)maxWidth + this.mHorizontalSpace * (float)(this.mColumnNumbers - 1) + (float)paddingLeft + (float)paddingRight);
        int tempHeight = (int)((float)maxHeight + this.mVerticalSpace * (float)(this.mRowNumbers - 1) + (float)paddingBottom + (float)paddingTop);
        int widthResult = tempWidth > sizeWidth ? sizeWidth : tempWidth;
        int heightResult = tempHeight > sizeHeight ? (sizeHeight == 0 ? tempHeight : sizeHeight) : tempHeight;
        this.setMeasuredDimension(widthResult, heightResult);
    }

    private void setFlowMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mCount = 0;
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = 0;
        int height = this.getPaddingTop() + this.getPaddingBottom();
        int lineWidth = this.getPaddingLeft() + this.getPaddingRight();
        int lineHeight = 0;
        int cCount = this.getChildCount();
        for (int i = 0; i < cCount; ++i) {
            View child = this.getChildAt(i);
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            if (lineWidth + childWidth > sizeWidth) {
                width = Math.max(lineWidth, childWidth);
                lineWidth = childWidth;
                height += lineHeight;
                lineHeight = childHeight;
                ++this.mCount;
                if (this.mCount >= this.mMaxLineNumbers) {
                    this.setHasMoreData(i + 1, cCount);
                    break;
                }
                if (this.mIsSingleLine) {
                    this.setHasMoreData(i + 1, cCount);
                    break;
                }
            } else {
                lineWidth += childWidth;
                lineHeight = Math.max(lineHeight, childHeight);
            }
            if (i != cCount - 1) continue;
            width = Math.max(width, lineWidth);
            height += lineHeight;
        }
        this.setMeasuredDimension(modeWidth == 0x40000000 ? sizeWidth : width, modeHeight == 0x40000000 ? sizeHeight : height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mIsGridMode) {
            this.setGridLayout();
        } else {
            this.setFlowLayout();
        }
    }

    private void setGridLayout() {
        this.mCheckedViews.clear();
        this.mCurrentItemIndex = -1;
        int sizeWidth = this.getWidth();
        int sizeHeight = this.getHeight();
        View tempChild = this.getChildAt(0);
        if (tempChild == null) {
            return;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)tempChild.getLayoutParams();
        int childAvWidth = (int)(((float)(sizeWidth - this.getPaddingLeft() - this.getPaddingRight()) - this.mHorizontalSpace * (float)(this.mColumnNumbers - 1)) / (float)this.mColumnNumbers) - lp.leftMargin - lp.rightMargin;
        int childAvHeight = (int)(((float)(sizeHeight - this.getPaddingTop() - this.getPaddingBottom()) - this.mVerticalSpace * (float)(this.mRowNumbers - 1)) / (float)this.mRowNumbers) - lp.topMargin - lp.bottomMargin;
        if (childAvHeight < this.mMinHeight) {
            childAvHeight = this.mMinHeight;
        }
        for (int i = 0; i < this.mRowNumbers; ++i) {
            for (int j = 0; j < this.mColumnNumbers; ++j) {
                View child = this.getChildAt(i * this.mColumnNumbers + j);
                if (child == null) continue;
                ++this.mCurrentItemIndex;
                if (child.getVisibility() == 8) continue;
                this.setChildClickOperation(child, -1);
                int childLeft = (int)((float)this.getPaddingLeft() + (float)j * ((float)childAvWidth + this.mHorizontalSpace)) + j * (lp.leftMargin + lp.rightMargin) + lp.leftMargin;
                int childTop = (int)((float)this.getPaddingTop() + (float)i * ((float)childAvHeight + this.mVerticalSpace)) + i * (lp.topMargin + lp.bottomMargin) + lp.topMargin;
                child.layout(childLeft, childTop, childLeft + childAvWidth, childAvHeight + childTop);
            }
        }
    }

    public void setMinHeight(int minHeight) {
        this.mMinHeight = minHeight;
    }

    private void setFlowLayout() {
        this.mCurrentItemIndex = -1;
        this.mCount = 0;
        this.mAllViews.clear();
        this.mLineHeight.clear();
        this.mWidthList.clear();
        this.mCheckedViews.clear();
        int width = this.getWidth();
        int lineWidth = this.getPaddingLeft();
        int lineHeight = this.getPaddingTop();
        List<Object> lineViews = new ArrayList<View>();
        int cCount = this.getChildCount();
        for (int i = 0; i < cCount; ++i) {
            View child = this.getChildAt(i);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (childWidth + lp.leftMargin + lp.rightMargin + this.getPaddingRight() + lineWidth > width) {
                this.mLineHeight.add(lineHeight);
                this.mAllViews.add(lineViews);
                this.mWidthList.add(lp.leftMargin + lp.rightMargin + this.getPaddingRight() + lineWidth);
                lineWidth = 0;
                lineViews = new ArrayList();
                ++this.mCount;
                if (this.mCount >= this.mMaxLineNumbers) {
                    this.setHasMoreData(i + 1, cCount);
                    break;
                }
                if (this.mIsSingleLine) {
                    this.setHasMoreData(i + 1, cCount);
                    break;
                }
            }
            lineWidth += childWidth + lp.leftMargin + lp.rightMargin;
            lineHeight = Math.max(lineHeight, childHeight + lp.topMargin + lp.bottomMargin);
            lineViews.add(child);
        }
        this.mLineHeight.add(lineHeight);
        this.mAllViews.add(lineViews);
        this.mWidthList.add(lineWidth);
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int lineNums = this.mAllViews.size();
        if (this.mAllViews.get(this.mAllViews.size() - 1).size() == 0) {
            lineNums = this.mAllViews.size() - 1;
        }
        for (int i = 0; i < lineNums; ++i) {
            lineViews = this.mAllViews.get(i);
            lineHeight = this.mLineHeight.get(i);
            if (this.mIsCenter && this.mWidthList.get(i) < this.getWidth()) {
                left += (this.getWidth() - this.mWidthList.get(i)) / 2;
            }
            for (int j = 0; j < lineViews.size(); ++j) {
                View child = (View)lineViews.get(j);
                ++this.mCurrentItemIndex;
                if (child.getVisibility() == 8) continue;
                this.setChildClickOperation(child, -1);
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                int lc = left + lp.leftMargin;
                int tc = top + lp.topMargin;
                int rc = lc + child.getMeasuredWidth();
                int bc = tc + child.getMeasuredHeight();
                child.layout(lc, tc, rc, bc);
                left += child.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
            }
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.getChildAt(0).getLayoutParams();
            left = this.getPaddingLeft();
            top += lineHeight + lp.topMargin + lp.bottomMargin;
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(super.generateDefaultLayoutParams());
    }

    private void setChildClickOperation(View child, final Integer key) {
        if (child.getTag() == null) {
            child.setTag((Object)this.mCurrentItemIndex);
        }
        child.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view2) {
                if (AutoFlowLayout.this.mOnLongItemClickListener != null) {
                    AutoFlowLayout.this.mOnLongItemClickListener.onLongItemClick((Integer)(key == -1 ? view2.getTag() : key), view2);
                    return true;
                }
                return false;
            }
        });
        child.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view2) {
                if (AutoFlowLayout.this.mIsMultiChecked) {
                    if (AutoFlowLayout.this.mCheckedViews.contains(view2)) {
                        AutoFlowLayout.this.mCheckedViews.remove(view2);
                        view2.setSelected(false);
                    } else {
                        view2.setSelected(true);
                        AutoFlowLayout.this.mCheckedViews.add(view2);
                        AutoFlowLayout.this.mSelectedView = view2;
                    }
                } else if (view2.isSelected()) {
                    view2.setSelected(false);
                } else {
                    if (AutoFlowLayout.this.mSelectedView != null) {
                        AutoFlowLayout.this.mSelectedView.setSelected(false);
                    }
                    view2.setSelected(true);
                    AutoFlowLayout.this.mSelectedView = view2;
                }
                if (AutoFlowLayout.this.mOnItemClickListener != null) {
                    AutoFlowLayout.this.mOnItemClickListener.onItemClick((Integer)(key == -1 ? view2.getTag() : key), view2);
                }
            }
        });
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mIsGridMode && this.mIsCutLine) {
            Paint linePaint = new Paint();
            linePaint.setStyle(Paint.Style.STROKE);
            linePaint.setStrokeWidth(this.mCutLineWidth);
            linePaint.setColor(this.mCutLineColor);
            for (int i = 0; i < this.mRowNumbers; ++i) {
                for (int j = 0; j < this.mColumnNumbers; ++j) {
                    View child = this.getChildAt(i * this.mColumnNumbers + j);
                    if (j == this.mColumnNumbers - 1) {
                        if (i == this.mRowNumbers - 1) continue;
                        canvas.drawLine((float)child.getLeft() - this.mHorizontalSpace / 2.0f, (float)child.getBottom() + this.mVerticalSpace / 2.0f, (float)child.getRight(), (float)child.getBottom() + this.mVerticalSpace / 2.0f, linePaint);
                        continue;
                    }
                    if (i == this.mRowNumbers - 1) {
                        canvas.drawLine((float)child.getRight() + this.mHorizontalSpace / 2.0f, (float)child.getTop() - this.mVerticalSpace / 2.0f, (float)child.getRight() + this.mHorizontalSpace / 2.0f, (float)child.getBottom(), linePaint);
                        continue;
                    }
                    if (j == 0) {
                        canvas.drawLine((float)child.getLeft(), (float)child.getBottom() + this.mVerticalSpace / 2.0f, (float)child.getRight() + this.mHorizontalSpace / 2.0f, (float)child.getBottom() + this.mVerticalSpace / 2.0f, linePaint);
                    } else {
                        canvas.drawLine((float)child.getLeft() - this.mHorizontalSpace / 2.0f, (float)child.getBottom() + this.mVerticalSpace / 2.0f, (float)child.getRight() + this.mHorizontalSpace / 2.0f, (float)child.getBottom() + this.mVerticalSpace / 2.0f, linePaint);
                    }
                    if (i == 0) {
                        canvas.drawLine((float)child.getRight() + this.mHorizontalSpace / 2.0f, (float)child.getTop(), (float)child.getRight() + this.mHorizontalSpace / 2.0f, (float)child.getBottom() + this.mVerticalSpace / 2.0f, linePaint);
                        continue;
                    }
                    canvas.drawLine((float)child.getRight() + this.mHorizontalSpace / 2.0f, (float)child.getTop() - this.mVerticalSpace / 2.0f, (float)child.getRight() + this.mHorizontalSpace / 2.0f, (float)child.getBottom() + this.mVerticalSpace / 2.0f, linePaint);
                }
            }
        }
    }

    private void setHasMoreData(int i, int count) {
        if (i < count) {
            this.mHasMoreData = true;
        }
    }

    public void setAllViews(List<View> views) {
        this.removeAllViews();
        if (views == null || views.size() == 0) {
            return;
        }
        for (int i = 0; i < views.size(); ++i) {
            View view2 = views.get(i);
            this.addView(view2);
        }
        this.requestLayout();
    }

    public boolean deleteView(int index) {
        if (this.mCurrentItemIndex != 0) {
            this.mDisplayNumbers = this.mCurrentItemIndex;
            if (index > this.mDisplayNumbers) {
                return false;
            }
            this.removeViewAt(index);
            return true;
        }
        return false;
    }

    public boolean deleteView() {
        if (this.mCurrentItemIndex != 0) {
            this.mDisplayNumbers = this.mCurrentItemIndex;
            this.removeViewAt(this.mDisplayNumbers);
            return true;
        }
        return false;
    }

    public boolean deleteView(int start, int end) {
        if (this.mCurrentItemIndex != 0) {
            this.mDisplayNumbers = this.mCurrentItemIndex;
            if (start < 0) {
                start = 0;
            }
            if (end > this.mDisplayNumbers) {
                end = this.mDisplayNumbers;
            }
            this.removeViews(start, end - start + 1);
            return true;
        }
        return false;
    }

    public boolean clearViews() {
        if (this.getChildCount() > 0) {
            this.removeAllViews();
            return true;
        }
        return false;
    }

    public void setMaxLines(int number) {
        this.mMaxLineNumbers = number;
        this.requestLayout();
    }

    public void setSingleLine(boolean isSingle) {
        this.mIsSingleLine = isSingle;
        this.requestLayout();
    }

    public boolean isSingleLine() {
        return this.mIsSingleLine;
    }

    public int getMaxLineNumbers() {
        return this.mMaxLineNumbers;
    }

    public boolean hasMoreData() {
        return this.mHasMoreData;
    }

    public boolean isMultiChecked() {
        return this.mIsMultiChecked;
    }

    public void setMultiChecked(boolean isMultiChecked) {
        this.mIsMultiChecked = isMultiChecked;
    }

    public List<View> getCheckedViews() {
        if (this.mIsMultiChecked) {
            return this.mCheckedViews;
        }
        this.mCheckedViews.add(this.mSelectedView);
        return this.mCheckedViews;
    }

    public View getSelectedView() {
        return this.mSelectedView;
    }

    public void setAdapter(FlowAdapter<T> adapter2) {
        this.mAdapter = adapter2;
        if (this.mAdapter.getCount() != 0) {
            for (int i = 0; i < this.mAdapter.getCount(); ++i) {
                View view2 = this.mAdapter.getView(i);
                this.addView(view2);
            }
            this.requestLayout();
        }
    }

    public FlowAdapter<T> getAdapter() {
        return this.mAdapter;
    }

    public void setHorizontalSpace(int horizontalSpace) {
        this.mHorizontalSpace = horizontalSpace;
        this.requestLayout();
    }

    public float getHorizontalSpace() {
        return this.mHorizontalSpace;
    }

    public void setVerticalSpace(int verticalSpace) {
        this.mVerticalSpace = verticalSpace;
        this.requestLayout();
    }

    public float getVerticalSpace() {
        return this.mVerticalSpace;
    }

    public void setColumnNumbers(int columnNumbers) {
        this.mColumnNumbers = columnNumbers;
        this.requestLayout();
    }

    public int getColumnNumbers() {
        return this.mColumnNumbers;
    }

    public void setRowNumbers(int rowNumbers) {
        this.mRowNumbers = rowNumbers;
        this.requestLayout();
    }

    public int getRowNumbers() {
        return this.mRowNumbers;
    }

    public void setCutLineWidth(float width) {
        this.mCutLineWidth = width;
        this.invalidate();
    }

    public float getCutLineWidth() {
        return this.mCutLineWidth;
    }

    public void setCutLineColor(int color2) {
        this.mCutLineColor = color2;
        this.invalidate();
    }

    public int getCutLineColor() {
        return this.mCutLineColor;
    }

    public void setCutLine(boolean isCutLine) {
        this.mIsCutLine = isCutLine;
        this.invalidate();
    }

    public boolean hasCutLine() {
        return this.mIsCutLine;
    }

    public void setLineCenter(boolean isCenter) {
        this.mIsCenter = isCenter;
        this.requestLayout();
    }

    public boolean isLineCenter() {
        return this.mIsCenter;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnLongItemClickListener(OnLongItemClickListener onLongItemClickListener) {
        this.mOnLongItemClickListener = onLongItemClickListener;
    }

    public static interface OnLongItemClickListener {
        public void onLongItemClick(int var1, View var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, View var2);
    }
}

