/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator;

import android.content.Context;
import android.os.Message;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.notify.notifyobj.ChannelCreateSuccessObj;
import com.yy.appbase.service.IOOSService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.oos.IUploadObjectCallBack;
import com.yy.appbase.service.oos.UploadObjectRequest;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.FamilyGateInfo;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.creator.ChannelCreateManager;
import com.yy.hiyo.channel.module.creator.IChannelCreateCallback;
import com.yy.hiyo.channel.module.creator.widget.LevelPickerPanel;
import com.yy.hiyo.channel.module.creator.window.FamilyCreateWindow;
import com.yy.hiyo.channel.service.family.FamilyService;
import com.yy.hiyo.mvp.base.MvpController;
import java.util.ArrayList;

public class ChannelCreatorController
extends MvpController
implements IChannelCreateCallback {
    private static final String TAG = "ChannelCreatorController";
    private ChannelCreateManager mChannelCreateManager = new ChannelCreateManager(this.getServiceManager());
    private FamilyCreateWindow mWindow;
    private FamilyGateInfo mFamilyGateInfo = new FamilyGateInfo(1L, 3L);
    protected DialogLinkManager mDialogLinkManager;
    private boolean isFamily;
    private int type;
    private CreateChannelParams params;

    public ChannelCreatorController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.ChannelMsgDef.OPEN_CHANNEL_CREATE && msg.obj instanceof CreateChannelParams) {
            CreateChannelParams params = (CreateChannelParams)msg.obj;
            this.isFamily = "hago.family".equals(params.source);
            if (this.isFamily) {
                this.createFamilyChannel(params);
            } else {
                Message message = Message.obtain();
                message.what = AppbaseMsgDef.ChannelMsgDef.OPEN_CREATE_BASE_CHANNEL;
                message.obj = params;
                this.sendMessage(message);
            }
            if (params.createFrom != 0) {
                RoomTrack.INSTANCE.reportNewChannelClick(String.valueOf(params.createFrom));
            }
        } else if (msg.what == AppbaseMsgDef.ChannelMsgDef.CLOSE_CHANNEL_CREATE_WINDOW && this.mWindow != null) {
            this.mWindow.getPage().hideLoading();
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    private void createFamilyChannel(CreateChannelParams params) {
        this.params = params;
        this.type = params.type;
        this.showCreateWindow();
    }

    private void showCreateWindow() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.mDialogLinkManager = new DialogLinkManager(this.mContext);
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
        this.mWindow = new FamilyCreateWindow(this.getActivity(), this);
        if (this.params != null && this.params.isSameCity) {
            this.mWindow.getPage().selectPublicType();
        } else if (this.type == 0) {
            if (NAB.A.equals((Object)NewABDefine.CHANNEL_TYPE.getTest())) {
                this.mWindow.getPage().selectPrivateType();
            } else {
                this.mWindow.getPage().selectPublicType();
            }
        } else if (this.type == 2) {
            this.mWindow.getPage().selectPrivateType();
        } else {
            this.mWindow.getPage().selectPublicType();
        }
        this.mWindow.getPage().showOnlyFamilyLayout();
        this.mWindow.getPage().setDurationLevel(this.mFamilyGateInfo.getDuration());
        this.mWindow.getPage().setWealthLevel(this.mFamilyGateInfo.getWeath());
        RoomTrack.INSTANCE.reportCreateFamilyShow();
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        YYTaskExecutor.postToMainThread(() -> {
            if (this.mWindow != null) {
                this.mWindow.getPage().forceInputViewGetFocus();
            }
        }, (long)300L);
    }

    @Override
    public void onBack() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        if (this.mWindow != null) {
            this.mWindow.getPage().hideLoading();
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    @Override
    public void createChannel(int channelType, @NonNull String channelName, String avatar2) {
        if (channelName.isEmpty()) {
            ToastUtils.showToast((Context)this.mContext, (int)R.string.toast_nick_all_white);
        } else {
            if (this.mWindow != null) {
                this.mWindow.getPage().showLoading();
            }
            if (this.params == null) {
                this.params = new CreateChannelParams.Builder().build();
            }
            this.params.name = channelName;
            this.params.avatar = avatar2;
            this.params.type = channelType;
            this.params.source = "hago.family";
            this.params.joinPayLevel = this.mFamilyGateInfo.getWeath();
            this.params.joinActiveTime = this.mFamilyGateInfo.getDuration();
            this.params.createType = 1;
            this.params.channelPluginData = new ChannelPluginData(1, "base");
            this.mChannelCreateManager.createChannel(this.mContext, this.params, new ICommonCallback<Boolean>(){

                public void onSuccess(Boolean aBoolean, Object ... ext) {
                    String channelId = "";
                    if (ext != null && ext.length > 0 && ext[0] instanceof String) {
                        RoomTrack.INSTANCE.reportNewChannelSuccess((String)ext[0], "", String.valueOf(AccountUtil.getUid()), String.valueOf(((ChannelCreatorController)ChannelCreatorController.this).params.createFrom), String.valueOf(((ChannelCreatorController)ChannelCreatorController.this).params.firstType));
                        channelId = (String)ext[0];
                    }
                    if (((ChannelCreatorController)ChannelCreatorController.this).params.isSameCity) {
                        Message message = Message.obtain();
                        message.what = AppbaseMsgDef.ChannelMsgDef.CLOSE_SAME_CITY_CHANNEL_CREATE;
                        ChannelCreatorController.this.sendMessage(message);
                    }
                    if (ChannelCreatorController.this.mWindow != null) {
                        ChannelCreatorController.this.mWindow.getPage().hideLoading();
                    }
                    if (ChannelCreatorController.this.mWindow != null) {
                        ChannelCreatorController.this.mWindow.getPage().hideLoading();
                        ChannelCreatorController.this.mWindowMgr.popWindow(true, (AbstractWindow)ChannelCreatorController.this.mWindow);
                        ChannelCreatorController.this.mWindow = null;
                    }
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_CREATE_SUCCESS, (Object)new ChannelCreateSuccessObj(channelId, ((ChannelCreatorController)ChannelCreatorController.this).params.createFrom)));
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    if (ChannelCreatorController.this.mWindow != null) {
                        ChannelCreatorController.this.mWindow.getPage().hideLoading();
                    }
                }
            });
        }
    }

    @Override
    public void onCameraClick() {
        RoomTrack.INSTANCE.reportNewChannelPicClick();
        ((ICameraService)ServiceManagerProxy.getService(ICameraService.class)).pickPhotoWithClip("FTChannel", path -> {
            if (FP.empty((CharSequence)path)) {
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                MLog.info((Object)TAG, (String)"upload failed", (Object[])new Object[0]);
                if (this.mDialogLinkManager != null) {
                    this.mDialogLinkManager.dismissDialog();
                }
                return;
            }
            String ext = YYFileUtils.getFileExtension((String)path);
            if (FP.empty((CharSequence)ext)) {
                ext = ".jpg";
            }
            ProgressDialog progressDialog2 = new ProgressDialog();
            if (this.mDialogLinkManager != null) {
                this.mDialogLinkManager.showDialog((BaseDialog)progressDialog2);
            }
            String keyMapBuilder = "cavatar/" + AccountUtil.getUid() + "_" + System.currentTimeMillis() / 1000L + ext;
            ((IOOSService)ServiceManagerProxy.getService(IOOSService.class)).uploadFile(keyMapBuilder, path, new IUploadObjectCallBack(){

                public void onSuccess(UploadObjectRequest request) {
                    String imgUrl = request.mUrl;
                    YYTaskExecutor.postToMainThread(() -> {
                        if (ChannelCreatorController.this.mDialogLinkManager != null) {
                            ChannelCreatorController.this.mDialogLinkManager.dismissDialog();
                        }
                        if (ChannelCreatorController.this.mWindow != null) {
                            ChannelCreatorController.this.mWindow.getPage().updateHeader(imgUrl);
                        }
                    });
                }

                public void onFailure(UploadObjectRequest request, int errorCode, Exception exception) {
                    MLog.info((Object)ChannelCreatorController.TAG, (String)"createChannel failed, code:%s", (Object[])new Object[]{errorCode});
                    YYTaskExecutor.postToMainThread(() -> {
                        if (ChannelCreatorController.this.mDialogLinkManager != null) {
                            ChannelCreatorController.this.mDialogLinkManager.dismissDialog();
                        }
                        ToastUtils.showToast((Context)ChannelCreatorController.this.mContext, (int)R.string.upload_failed);
                    });
                }
            });
        }, 8);
    }

    public boolean onWindowBackKeyEvent() {
        if (this.mWindow != null) {
            this.mWindow.getPage().hideLoading();
        }
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        return super.onWindowBackKeyEvent();
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.getMvpContext().getLifecycleOwner().onEvent(Lifecycle.Event.ON_DESTROY);
    }

    @Override
    public void onDurationLevelClick() {
        LevelPickerPanel gateListPanel = new LevelPickerPanel((Context)this.getContext());
        gateListPanel.showBalckMask(true);
        ArrayList<Long> list2 = FamilyService.Companion.getGateDurationList();
        gateListPanel.setMCallback(selectedIndex -> {
            this.mFamilyGateInfo.setDuration(((Long)list2.get(selectedIndex)).longValue());
            if (this.mWindow != null) {
                this.mWindow.getPage().setDurationLevel(this.mFamilyGateInfo.getDuration());
            }
        });
        gateListPanel.setTitle(ResourceUtils.getString((int)R.string.tips_duration_level));
        gateListPanel.setData(list2);
        gateListPanel.setSelection(this.mFamilyGateInfo.getDuration());
        if (this.mWindow != null) {
            ImeUtil.hideIME((Context)this.getContext(), (View)this.mWindow);
            this.mWindow.getPanelLayer().showPanel((BasePanel)gateListPanel, false);
        }
    }

    @Override
    public void onWealthLevelClick() {
        LevelPickerPanel gateListPanel = new LevelPickerPanel((Context)this.getContext());
        gateListPanel.showBalckMask(true);
        ArrayList<Long> list2 = FamilyService.Companion.getGateLvList();
        gateListPanel.setMCallback(selectedIndex -> {
            this.mFamilyGateInfo.setWeath(((Long)list2.get(selectedIndex)).longValue());
            if (this.mWindow != null) {
                this.mWindow.getPage().setWealthLevel(this.mFamilyGateInfo.getWeath());
            }
        });
        gateListPanel.setTitle(ResourceUtils.getString((int)R.string.tips_vip_msg));
        gateListPanel.setData(list2);
        gateListPanel.setSelection(this.mFamilyGateInfo.getWeath());
        gateListPanel.setStringId(R.string.level);
        if (this.mWindow != null) {
            ImeUtil.hideIME((Context)this.getContext(), (View)this.mWindow);
            this.mWindow.getPanelLayer().showPanel((BasePanel)gateListPanel, false);
        }
    }
}

