/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.voicefilter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.unifyconfig.config.VoiceFilterConfig;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.thread.ThreadBus;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.VoiceFilterData;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.voicefilter.VoiceFilterAnimItem;
import com.yy.hiyo.channel.component.voicefilter.VoiceFilterItem;
import com.yy.hiyo.channel.component.voicefilter.VoiceFilterPresenter;
import java.util.ArrayList;
import java.util.List;

public class VoiceFilterPanel
extends YYRelativeLayout {
    private KvoBinder mBinder = new KvoBinder((Object)this);
    private RecyclerView mListView;
    private RecyclerView.Adapter<RecyclerView.ViewHolder> mAdapter;
    private CardView mPanel;
    private YYTextView mTitle;
    private VoiceFilterAnimItem mAnimItem;
    private List<VoiceFilterConfig.VoiceFilterConfigData.VoiceFilterConfigItem> mList = new ArrayList<VoiceFilterConfig.VoiceFilterConfigData.VoiceFilterConfigItem>();
    private VoiceFilterPresenter mPresenter;
    private boolean mIsInDismissAnim = false;

    public VoiceFilterPanel(Context context, VoiceFilterPresenter presenter) {
        super(context);
        this.mPresenter = presenter;
        this.init();
    }

    private void init() {
        VoiceFilterPanel.inflate((Context)this.getContext(), (int)R.layout.layout_channel_voice_filter_panel, (ViewGroup)this);
        this.mListView = (RecyclerView)this.findViewById(R.id.lcvfp_list);
        this.mPanel = (CardView)this.findViewById(R.id.lcvfp_pannel);
        this.mTitle = (YYTextView)this.findViewById(R.id.lcvpf_title);
        this.mAnimItem = new VoiceFilterAnimItem(this.getContext());
        this.mPanel.setOnClickListener(v -> {});
        this.setOnClickListener(v -> this.startDismissAnim());
        this.mListView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 4));
        this.mAdapter = new RecyclerView.Adapter<RecyclerView.ViewHolder>(){

            @NonNull
            public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
                VoiceFilterItem item = new VoiceFilterItem(VoiceFilterPanel.this.getContext(), VoiceFilterPanel.this.mPresenter, (id2, left, top, index) -> {
                    VoiceFilterPanel.this.initAnimItem(left, top, index);
                    VoiceFilterPanel.this.startDismissAnim();
                });
                return new RecyclerView.ViewHolder((View)item){};
            }

            public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
                ((VoiceFilterItem)viewHolder.itemView).update(i, (VoiceFilterConfig.VoiceFilterConfigData.VoiceFilterConfigItem)VoiceFilterPanel.this.mList.get(i));
            }

            public int getItemCount() {
                return VoiceFilterPanel.this.mList.size();
            }
        };
        this.mListView.setAdapter(this.mAdapter);
        this.bindData();
    }

    private void initAnimItem(int left, int top, int index) {
        if (this.mAnimItem.getParent() != null) {
            this.removeView((View)this.mAnimItem);
        }
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(-2, -2);
        int itemWidth = (this.getWidth() - 2 * ResolutionUtils.dip2Px((float)10.0f)) / 4;
        rl.setMarginStart(ResolutionUtils.dip2Px((float)10.0f) + itemWidth * (index % 4) + (itemWidth - ResolutionUtils.dip2Px((float)45.0f)) / 2);
        rl.topMargin = top - SystemUtils.getStatusBarHeight((Context)this.getContext());
        this.addView((View)this.mAnimItem, (ViewGroup.LayoutParams)rl);
        this.mAnimItem.update(this.mList.get(index), LanguageUtils.isRtl() ? ((BottomPresenter)this.mPresenter.getPresenter(BottomPresenter.class)).getMicXAbsolutePosition() - (this.getWidth() - ResolutionUtils.dip2Px((float)22.0f) - rl.getMarginStart()) : ((BottomPresenter)this.mPresenter.getPresenter(BottomPresenter.class)).getMicXAbsolutePosition() - ResolutionUtils.dip2Px((float)22.0f) - rl.leftMargin, (int)((float)this.getHeight() * 0.95f - (float)rl.topMargin - (float)ResolutionUtils.dip2Px((float)25.0f)));
    }

    private void startDismissAnim() {
        if (this.mIsInDismissAnim) {
            return;
        }
        this.mIsInDismissAnim = true;
        AnimationSet aniSet = new AnimationSet(true);
        ScaleAnimation scaleAnim = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 0, (float)(((BottomPresenter)this.mPresenter.getPresenter(BottomPresenter.class)).getMicXAbsolutePosition() - ResolutionUtils.dip2Px((float)10.0f)), 1, 1.0f);
        scaleAnim.setDuration(400L);
        aniSet.addAnimation((Animation)scaleAnim);
        aniSet.setFillAfter(true);
        aniSet.setInterpolator(BasePanel.mPopUpAnimInterpolator);
        aniSet.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VoiceFilterPanel.this.mIsInDismissAnim = false;
                        VoiceFilterPanel.this.mPresenter.hideVoiceFilterPanel();
                    }
                }, (long)300L);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mPanel.startAnimation((Animation)aniSet);
    }

    @KvoMethodAnnotation(name="voiceFilterInfoList", sourceClass=VoiceFilterData.class)
    public void onListChanged(KvoEventIntent kvoEvent) {
        this.mList = (List)kvoEvent.caseNewValue(new ArrayList());
        this.mAdapter.notifyDataSetChanged();
    }

    @KvoMethodAnnotation(name="currentChannelMode", sourceClass=VoiceFilterData.class, thread=1)
    public void onModeChanged(KvoEventIntent kvoEvent) {
        if (!this.isAttachToWindow()) {
            return;
        }
        int mode = (Integer)kvoEvent.caseNewValue((Object)1);
        switch (mode) {
            case 1: {
                this.mPanel.setCardBackgroundColor(-1);
                this.mPanel.setAlpha(1.0f);
                this.mTitle.setTextColor(-6710887);
                this.mTitle.setAlpha(1.0f);
                break;
            }
            default: {
                this.mPanel.setCardBackgroundColor(-14211275);
                this.mPanel.setAlpha(0.95f);
                this.mTitle.setTextColor(-1);
                this.mTitle.setAlpha(0.7f);
            }
        }
    }

    private void bindData() {
        ThreadBus.post((int)1, (Runnable)new Runnable(){

            @Override
            public void run() {
                VoiceFilterPanel.this.mBinder.singleBindSourceTo((KvoSource)VoiceFilterPanel.this.mPresenter.getChannel().getVoiceFilterService().data());
            }
        });
    }

    private void unbindData() {
        ThreadBus.post((int)1, (Runnable)new Runnable(){

            @Override
            public void run() {
                VoiceFilterPanel.this.mBinder.clearAllKvoConnections();
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.bindData();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unbindData();
    }
}

