/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.textgroup.gameplay.gameinvite;

import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.game.base.BaseGameReqBean;
import com.yy.hiyo.game.base.GameProDef;
import com.yy.hiyo.game.base.IMGameCancelReqBean;
import com.yy.hiyo.game.base.IMGamePkAcceptNotifyBean;
import com.yy.hiyo.game.base.IMGameReqBean;
import com.yy.hiyo.game.base.IMGameResBean;
import com.yy.hiyo.game.base.IMPKAcceptReqBean;
import com.yy.hiyo.game.base.IMPKAcceptResBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInviteData;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.IPkGameInviteService;
import com.yy.hiyo.game.service.callback.IGameInviteTimeoutListener;
import com.yy.hiyo.game.service.callback.IIMPKGameListener;
import java.util.HashSet;
import java.util.Set;

public class GroupPkInviteController
extends DefaultController
implements IGameInviteTimeoutListener {
    private static final String TAG = "FTRoomGroupFTRoomGroupTextGroupGameInvite";
    private String mPkId = "";
    private String mGameId;
    private volatile int mStatus;
    Set<GroupSendInviteListenr> listeners = new HashSet<GroupSendInviteListenr>();
    private static final int SEND_SUCCSEE = 0;
    private IIMPKGameListener mIIMPKGameListener = new IIMPKGameListener(){

        public void onPkGameImPkRes(IMGameResBean imGameResBean) {
            GroupPkInviteController.this.onSendInviteResponse(imGameResBean.getCode(), imGameResBean);
        }

        public void onPkAcceptRes(IMPKAcceptResBean imGameResBean) {
            GroupPkInviteController.this.onAcceptInviteResponse(imGameResBean.getCode(), imGameResBean);
        }

        public void onPKGameAccptNotify(IMGamePkAcceptNotifyBean imGamePkAcceptNotifyBean) {
            if (imGamePkAcceptNotifyBean != null && imGamePkAcceptNotifyBean.getPkId().equals(GroupPkInviteController.this.mPkId)) {
                GroupPkInviteController.this.onAcceptNotify(imGamePkAcceptNotifyBean);
            }
        }

        public void onPkCancelRes() {
        }

        public void onPkFail(BaseGameReqBean gameReqBean) {
            GroupPkInviteController.this.onSendInviteResponse(3L, null);
        }
    };

    public GroupPkInviteController(Environment env) {
        super(env);
        this.init();
    }

    public synchronized void sendPkInvite(String gameId, final String groupId) {
        if (this.haveInvite()) {
            MLog.error((Object)TAG, (String)"onPkGameImPkRes \u5f53\u524d\u5df2\u6709\u9080\u8bf7\uff0cpkid = %s", (Object[])new Object[]{this.mPkId});
            this.onSendInviteResponse(1L, null);
            if (RuntimeContext.sIsDebuggable) {
                // empty if block
            }
            return;
        }
        GameInfo gameInfo = this.getGameInfo(gameId);
        if (gameInfo == null) {
            return;
        }
        UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        if (userInfoKS == null || gameInfo == null) {
            MLog.error((Object)TAG, (String)"sendPkInvite,\u81ea\u5df1\u7684\u4fe1\u606f\u4e3a\u7a7a or game info null %s, %s", (Object[])new Object[]{userInfoKS, gameInfo});
            this.onSendInviteResponse(2L, null);
            return;
        }
        MLog.info((Object)TAG, (String)"\u53d1\u9001pk\u6e38\u620f\u9080\u8bf7 gameId = %s\uff0cgroupId\uff1a%s", (Object[])new Object[]{gameId, groupId});
        IMGameReqBean reqBean = IMGameReqBean.newBuilder().fromType((long)GameProDef.GROUP_PK_REQ).gameId(gameId).gameVerion(gameInfo.getModulerVer()).isGoldGame(gameInfo.isGoldGame()).myNick(userInfoKS.nick).myPicUrl(userInfoKS.avatar).mySex(userInfoKS.sex).build();
        this.getPkInviteService().pkGameReq(reqBean, new IIMPKGameListener(){

            public void onPkGameImPkRes(IMGameResBean imGameResBean) {
                if (imGameResBean.getCode() != 0L) {
                    ((IGameService)GroupPkInviteController.this.getServiceManager().getService(IGameService.class)).parseCodeWithToast(imGameResBean.getCode());
                } else {
                    ((IGameInviteService)GroupPkInviteController.this.getServiceManager().getService(IGameInviteService.class)).addGroupGameInvite(GroupPkInviteController.this.getGameInfo(imGameResBean.getGameId()), AccountUtil.getUid(), groupId, imGameResBean.getPkId(), 1, System.currentTimeMillis());
                    GroupPkInviteController.this.setHaveInvite(imGameResBean.getPkId(), imGameResBean.getGameId());
                }
                GroupPkInviteController.this.mIIMPKGameListener.onPkGameImPkRes(imGameResBean);
            }
        });
    }

    protected void sendPkInviteMsg(String gameId, String groupId, IMGameResBean imGameResBean) {
    }

    public synchronized void cancelPkInvite() {
        MLog.info((Object)TAG, (String)"\u53d6\u6d88pk\u6e38\u620f\u9080\u8bf7pkId : %s,\u662f\u5426\u6709\u9080\u8bf7=%s", (Object[])new Object[]{this.mPkId, this.haveInvite()});
        if (this.haveInvite()) {
            IMGameCancelReqBean cancelReqBean = IMGameCancelReqBean.newBuilder().fromType((long)GameProDef.GROUP_PK_REQ).pkId(this.mPkId).build();
            ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).removeGameInvite(this.mPkId);
            this.getPkInviteService().pkGameCancelReq(cancelReqBean, this.mGameId, this.mIIMPKGameListener);
            this.setNoInviteStatus();
        } else {
            MLog.error((Object)TAG, (String)"\u5f53\u524d\u5df2\u6ca1\u6709\u9080\u8bf7", (Object[])new Object[0]);
        }
    }

    public synchronized void acceptPkInvite(String pkId, final String gameId) {
        MLog.info((Object)TAG, (String)"\u63a5\u53d7pk\u6e38\u620f\u9080\u8bf7pkId : %s\uff0cgameId\uff1a%s", (Object[])new Object[]{pkId, gameId});
        UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        GameInfo gameInfo = this.getGameInfo(gameId);
        IMPKAcceptReqBean acceptReqBean = IMPKAcceptReqBean.newBuilder().accept(true).isGoldGame(this.getGameInfo(gameId).isGoldGame()).my_nick(userInfoKS.nick).my_pic_url(userInfoKS.avatar).my_sex(userInfoKS.sex).gameVersion(gameInfo.getModulerVer()).pk_id(pkId).build();
        this.getPkInviteService().pkGameImPkAcceptReq(acceptReqBean, new IIMPKGameListener(){

            public void onPkAcceptRes(IMPKAcceptResBean impkAcceptResBean) {
                GroupPkInviteController.this.mIIMPKGameListener.onPkAcceptRes(impkAcceptResBean);
                ChannelTrack.INSTANCE.onScreenJoinGameResult(gameId, "1");
            }

            public void onPkFail(BaseGameReqBean gameReqBean) {
                ChannelTrack.INSTANCE.onScreenJoinGameResult(gameId, "0");
            }
        });
        ChannelTrack.INSTANCE.onScreenJoinGameClick(gameId);
    }

    private GameInfo getGameInfo(String gameId) {
        return ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
    }

    private IPkGameInviteService getPkInviteService() {
        return ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getPkGameInviteService();
    }

    private void setHaveInvite(String pkId, String gameId) {
        this.mPkId = pkId;
        this.mGameId = gameId;
        this.mStatus = 2;
    }

    private void setNoInviteStatus() {
        this.mGameId = "";
        this.mPkId = "";
        this.mStatus = 0;
    }

    private void onSendInviteResponse(long code, IMGameResBean imGameResBean) {
        MLog.info((Object)TAG, (String)"\u53d1\u9001pk\u6e38\u620f\u9080\u8bf7Reponse code : %s\uff0cimGameResBean\uff1a%s", (Object[])new Object[]{code, imGameResBean != null ? imGameResBean.toString() : "null"});
        if (code == 0L) {
            for (GroupSendInviteListenr listenr : this.listeners) {
                listenr.onSendInviteSuccess(imGameResBean);
            }
        } else {
            for (GroupSendInviteListenr listener2 : this.listeners) {
                listener2.onSendInviteFail(code);
            }
        }
    }

    private void onAcceptInviteResponse(long code, IMPKAcceptResBean impkAcceptResBean) {
        MLog.info((Object)TAG, (String)"\u63a5\u53d7pk\u6e38\u620f\u9080\u8bf7Response code : %s\uff0cimGameResBean\uff1a%s", (Object[])new Object[]{code, impkAcceptResBean != null ? impkAcceptResBean.toString() : "null"});
        if (code == 0L) {
            for (GroupSendInviteListenr listenr : this.listeners) {
                listenr.onAcceptSuccess(impkAcceptResBean);
            }
        } else {
            for (GroupSendInviteListenr listener2 : this.listeners) {
                listener2.onAcceptFail(code, impkAcceptResBean == null ? "" : impkAcceptResBean.getPkId());
            }
        }
    }

    private void onAcceptNotify(IMGamePkAcceptNotifyBean imGamePkAcceptNotifyBean) {
        for (GroupSendInviteListenr listener2 : this.listeners) {
            listener2.onAcceptNotify(imGamePkAcceptNotifyBean);
        }
    }

    private boolean haveInvite() {
        return this.mStatus != 0 && StringUtils.isNotEmpty((String)this.mPkId);
    }

    public void onGameInviteTimeout(GameInviteData data2) {
        if (data2.mPkId.equals(this.mPkId)) {
            this.setNoInviteStatus();
        }
        for (GroupSendInviteListenr listener2 : this.listeners) {
            listener2.onInviteTimeOutNotify(data2.mPkId);
        }
    }

    public String getPkId() {
        return this.mPkId;
    }

    public void registerGruopSendPkInviteListener(@NonNull GroupSendInviteListenr groupSendInviteListenr) {
        if (groupSendInviteListenr != null) {
            this.listeners.add(groupSendInviteListenr);
        }
    }

    public void unRegisterGruopSendPkInviteListener(@NonNull GroupSendInviteListenr groupSendInviteListenr) {
        if (groupSendInviteListenr != null) {
            this.listeners.remove(groupSendInviteListenr);
        }
    }

    void init() {
        ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).registerGameInviteTimeoutListener((IGameInviteTimeoutListener)this);
        ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getPkGameInviteService().registerPKGameNotify(this.mIIMPKGameListener);
    }

    public static interface GroupSendInviteListenr {
        public void onSendInviteSuccess(IMGameResBean var1);

        public void onSendInviteFail(long var1);

        public void onInviteCanceledNotify(String var1);

        public void onInviteTimeOutNotify(String var1);

        public void onAcceptSuccess(IMPKAcceptResBean var1);

        public void onAcceptFail(long var1, String var3);

        public void onAcceptNotify(IMGamePkAcceptNotifyBean var1);
    }
}

