/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.teamup.match;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindowManager;
import com.yy.appbase.unifyconfig.config.TeamUpMatchConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.event.kvo.list.KvoList;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.TeamUpGameData;
import com.yy.hiyo.channel.base.bean.TeamUpGameInfoBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ITeamUpGameProfileService;
import com.yy.hiyo.channel.base.service.ITeamUpGameService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.module.teamup.TeamUpReport;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.teamup.match.TeamUpMatchPresenter;
import com.yy.hiyo.channel.component.teamup.match.TeamUpMatchView;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.normal.VoiceRoomSeatPresenter;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.ihago.channel.srv.mgr.ECode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 Q2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u00012\u00020\u0004:\u0001QB\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\u0014\u0010)\u001a\u00020'2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010+\u001a\u00020'H\u0002J\u0016\u0010,\u001a\u00020'2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020'0-H\u0002J\b\u0010.\u001a\u00020'H\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010/\u001a\u00020'2\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u000100H\u0002J\b\u00101\u001a\u00020\u000bH\u0002J\b\u00102\u001a\u000203H\u0002J\u0006\u00104\u001a\u00020\u000bJ\b\u00105\u001a\u00020\rH\u0002J\b\u00106\u001a\u00020\rH\u0002J\b\u00107\u001a\u00020\rH\u0002J\u001c\u00108\u001a\u00020'2\b\u00109\u001a\u0004\u0018\u00010\u000b2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\b\u0010<\u001a\u00020'H\u0016J\u0010\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020\u000bH\u0002J\u001a\u0010?\u001a\u00020'2\b\u00109\u001a\u0004\u0018\u00010\u000b2\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020'H\u0002J\b\u0010C\u001a\u00020'H\u0002J\u0010\u0010D\u001a\u00020'2\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020'H\u0002J\b\u0010H\u001a\u00020'H\u0002J\u0010\u0010I\u001a\u00020'2\b\b\u0002\u0010J\u001a\u00020\rJ\u0006\u0010K\u001a\u00020'J\b\u0010L\u001a\u00020'H\u0002J\u0010\u0010M\u001a\u00020'2\u0006\u0010N\u001a\u00020OH\u0007J\u0010\u0010P\u001a\u00020'2\u0006\u0010N\u001a\u00020OH\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001b\u001a\u0004\b#\u0010$\u00a8\u0006R"}, d2={"Lcom/yy/hiyo/channel/component/teamup/match/TeamUpMatchPresenter;", "Lcom/yy/hiyo/channel/cbase/context/BaseChannelPresenter;", "Lcom/yy/hiyo/channel/cbase/AbsPage;", "Lcom/yy/hiyo/channel/cbase/context/IChannelPageContext;", "Lcom/yy/hiyo/channel/cbase/context/IHolderPresenter;", "()V", "binder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "callback", "Lcom/yy/hiyo/channel/base/service/ITeamUpGameProfileService$ITeamUpMatchCallback;", "curGid", "", "curMatchStatus", "", "mLastIsInFirst", "mSeatObs", "Landroidx/lifecycle/Observer;", "", "Lcom/yy/hiyo/channel/component/seat/bean/SeatItem;", "mView", "Lcom/yy/hiyo/channel/component/teamup/match/TeamUpMatchView;", "seatService", "Lcom/yy/hiyo/channel/base/service/ISeatService;", "kotlin.jvm.PlatformType", "getSeatService", "()Lcom/yy/hiyo/channel/base/service/ISeatService;", "seatService$delegate", "Lkotlin/Lazy;", "teamUpGamePresenter", "Lcom/yy/hiyo/channel/base/service/ITeamUpGameProfileService;", "getTeamUpGamePresenter", "()Lcom/yy/hiyo/channel/base/service/ITeamUpGameProfileService;", "teamUpGamePresenter$delegate", "teamUpService", "Lcom/yy/hiyo/channel/base/service/ITeamUpGameService;", "getTeamUpService", "()Lcom/yy/hiyo/channel/base/service/ITeamUpGameService;", "teamUpService$delegate", "bindDataListener", "", "bindObserver", "cancelMatch", "gid", "changeViewMatchStatus", "checkInterval", "Lkotlin/Function0;", "confirmMatch", "fetchMatchConfigByGid", "Lcom/yy/appbase/callback/ICommonCallback;", "gameName", "getData", "Lcom/yy/hiyo/channel/base/bean/TeamUpGameData;", "getRole", "isChannelPrivate", "isMatchedBefore", "matchStatus", "onDataUpdate", "channelId", "info", "Lcom/yy/hiyo/channel/base/bean/ChannelDetailInfo;", "onDestroy", "onGroupNameSave", "channelName", "onMyRoleChanged", "newRoleType", "", "publishScreenMsg", "reqMatch", "setContainer", "container", "Landroid/view/View;", "setViewVisibilityStatus", "showConfirmCancelDialog", "showMatchPanel", "modify", "showMatchTips", "unBindObserver", "updateLastMatchStatus", "eventIntent", "Lcom/yy/base/event/kvo/KvoEventIntent;", "updateMatchBtn", "Companion", "channel-components_debug"})
public final class TeamUpMatchPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IHolderPresenter {
    private TeamUpMatchView mView;
    private boolean mLastIsInFirst;
    private final KvoBinder binder = new KvoBinder((Object)this);
    private boolean curMatchStatus;
    private String curGid = "";
    private final Lazy seatService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ISeatService>(this){
        final /* synthetic */ TeamUpMatchPresenter this$0;

        public final ISeatService invoke() {
            return this.this$0.getChannel().getSeatService();
        }
        {
            this.this$0 = teamUpMatchPresenter;
            super(0);
        }
    }));
    private final Lazy teamUpService$delegate = LazyKt.lazy((Function0)teamUpService.2.INSTANCE);
    private final Lazy teamUpGamePresenter$delegate = LazyKt.lazy((Function0)teamUpGamePresenter.2.INSTANCE);
    private final ITeamUpGameProfileService.ITeamUpMatchCallback callback = new ITeamUpGameProfileService.ITeamUpMatchCallback(this){
        final /* synthetic */ TeamUpMatchPresenter this$0;

        public void report(boolean modify, @Nullable String channelName, @NotNull String gid) {
            Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
            if (!TextUtils.isEmpty((CharSequence)channelName)) {
                String string2 = channelName;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                TeamUpMatchPresenter.access$onGroupNameSave(this.this$0, string2);
            }
            TeamUpMatchPresenter.access$reqMatch(this.this$0);
            TeamUpReport.INSTANCE.reportMatchBtnConfirmClick(this.this$0.getChannelId(), TeamUpMatchPresenter.access$curGid(this.this$0), this.this$0.getRole(), modify);
        }
        {
            this.this$0 = $outer;
        }
    };
    private final Observer<List<SeatItem>> mSeatObs = (Observer)new Observer<List<? extends SeatItem>>(this){
        final /* synthetic */ TeamUpMatchPresenter this$0;

        public final void onChanged(List<? extends SeatItem> it) {
            boolean isFirstSeat = TeamUpMatchPresenter.access$getSeatService$p(this.this$0).getSeatData().isInFirstSeat(AccountUtil.getUid());
            MLog.info((Object)"TeamUpMatchPresenter", (String)("updateSeatData isFirstSeat:" + isFirstSeat), (Object[])new Object[0]);
            if (!isFirstSeat) {
                TeamUpMatchView teamUpMatchView = TeamUpMatchPresenter.access$getMView$p(this.this$0);
                if (teamUpMatchView != null) {
                    teamUpMatchView.changeMatchStatus(false);
                }
                if (TeamUpMatchPresenter.access$getMLastIsInFirst$p(this.this$0) && TeamUpMatchPresenter.access$matchStatus(this.this$0)) {
                    TeamUpMatchPresenter.cancelMatch$default(this.this$0, null, 1, null);
                }
            }
            TeamUpMatchPresenter.access$setMLastIsInFirst$p(this.this$0, isFirstSeat);
        }
        {
            this.this$0 = teamUpMatchPresenter;
        }
    };
    @NotNull
    public static final String TAG = "TeamUpMatchPresenter";
    public static final Companion Companion = new Companion(null);

    private final ISeatService getSeatService() {
        Lazy lazy = this.seatService$delegate;
        TeamUpMatchPresenter teamUpMatchPresenter = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ISeatService)lazy.getValue();
    }

    private final ITeamUpGameService getTeamUpService() {
        Lazy lazy = this.teamUpService$delegate;
        TeamUpMatchPresenter teamUpMatchPresenter = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ITeamUpGameService)lazy.getValue();
    }

    private final ITeamUpGameProfileService getTeamUpGamePresenter() {
        Lazy lazy = this.teamUpGamePresenter$delegate;
        TeamUpMatchPresenter teamUpMatchPresenter = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ITeamUpGameProfileService)lazy.getValue();
    }

    private final void onGroupNameSave(String channelName) {
        block1: {
            IDataService iDataService = this.getChannel().getDataService();
            if (Intrinsics.areEqual(iDataService != null && (iDataService = iDataService.getCacheDetail()) != null && (iDataService = iDataService.baseInfo) != null ? iDataService.name : null, (Object)channelName)) {
                MLog.info((Object)TAG, (String)("name same before. channelName:" + channelName), (Object[])new Object[0]);
                return;
            }
            IDataService iDataService2 = this.getChannel().getDataService();
            if (iDataService2 == null) break block1;
            iDataService2.updateName(channelName, new IDataService.IUpdateNameCallBack(this){
                final /* synthetic */ TeamUpMatchPresenter this$0;

                public void onContainSensitiveWord() {
                    ToastUtils.showToast((Context)((Context)((IChannelPageContext)this.this$0.getMvpContext()).getContext()), (String)ResourceUtils.getString((int)R.string.tips_channel_name_sensitive), (int)0);
                }

                public void renameLimit(@Nullable String toast) {
                    Context context = (Context)((IChannelPageContext)this.this$0.getMvpContext()).getContext();
                    String string2 = toast;
                    if (string2 == null) {
                        string2 = "";
                    }
                    ToastUtils.showToast((Context)context, (String)string2, (int)0);
                }

                public void limitNoToast() {
                }

                public void onSuccess(@Nullable IChannel group) {
                }

                public void onError(@Nullable String channelId, int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                    int n = errorCode;
                    if (n == ECode.NO_PERMIT.getValue()) {
                        ToastUtils.showToast((Context)((Context)((IChannelPageContext)this.this$0.getMvpContext()).getContext()), (String)ResourceUtils.getString((int)R.string.tips_channel_no_permission), (int)0);
                    } else if (n != 1016) {
                        ToastUtils.showToast((Context)((Context)((IChannelPageContext)this.this$0.getMvpContext()).getContext()), (int)R.string.tips_channel_join_net_error);
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void bindObserver() {
        MLog.info((Object)TAG, (String)"bindObserver", (Object[])new Object[0]);
        this.binder.singleBindSourceTo((KvoSource)this.getTeamUpService().data());
    }

    private final void unBindObserver() {
        MLog.info((Object)TAG, (String)"unBindObserver", (Object[])new Object[0]);
        this.binder.clearAllKvoConnections();
    }

    public void setContainer(@NotNull View container) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
            if (!(container instanceof YYPlaceHolderView)) {
                return;
            }
            FragmentActivity fragmentActivity = ((IChannelPageContext)this.getMvpContext()).getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"mvpContext.context");
            TeamUpMatchView teamUpMatchView = this.mView = new TeamUpMatchView((Context)fragmentActivity);
            if (teamUpMatchView == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.yy.hiyo.channel.component.teamup.match.TeamUpMatchView");
            }
            ((YYPlaceHolderView)container).inflate((View)teamUpMatchView);
            TeamUpMatchView teamUpMatchView2 = this.mView;
            if (teamUpMatchView2 != null) {
                teamUpMatchView2.setVisibility(8);
            }
            this.mLastIsInFirst = this.getSeatService().getSeatData().isInFirstSeat(AccountUtil.getUid());
            this.bindDataListener();
            TeamUpMatchView teamUpMatchView3 = this.mView;
            if (teamUpMatchView3 != null) {
                teamUpMatchView3.changeMatchStatus(false);
            }
            this.bindObserver();
            this.fetchMatchConfigByGid((ICommonCallback<Boolean>)((ICommonCallback)new ICommonCallback<Boolean>(this){
                final /* synthetic */ TeamUpMatchPresenter this$0;

                public void onSuccess(@Nullable Boolean data2, Object ... ext) {
                    Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                    TeamUpMatchPresenter.access$setViewVisibilityStatus(this.this$0);
                }

                public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                    Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                    TeamUpMatchPresenter.access$setViewVisibilityStatus(this.this$0);
                }
                {
                    this.this$0 = $outer;
                }
            }));
            TeamUpMatchView teamUpMatchView4 = this.mView;
            if (teamUpMatchView4 == null) break block4;
            teamUpMatchView4.setClickCallback(new TeamUpMatchView.IClickCallback(this){
                final /* synthetic */ TeamUpMatchPresenter this$0;

                public void onClickMatch() {
                    TeamUpReport.INSTANCE.reportMatchBtnClick(this.this$0.getChannelId(), TeamUpMatchPresenter.access$curGid(this.this$0), this.this$0.getRole());
                    boolean isFirstSeat = TeamUpMatchPresenter.access$getSeatService$p(this.this$0).getSeatData().isInFirstSeat(AccountUtil.getUid());
                    if (!isFirstSeat) {
                        ToastUtils.showToast((Context)((Context)((IChannelPageContext)this.this$0.getMvpContext()).getContext()), (int)R.string.tips_team_up_match_not_in_first_seat);
                        return;
                    }
                    if (TeamUpMatchPresenter.access$matchStatus(this.this$0)) {
                        TeamUpReport.INSTANCE.reportMatchBtnCancelClick(this.this$0.getChannelId(), TeamUpMatchPresenter.access$curGid(this.this$0), this.this$0.getRole());
                        TeamUpMatchPresenter.access$showConfirmCancelDialog(this.this$0);
                    } else {
                        TeamUpMatchPresenter.access$checkInterval(this.this$0, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ setContainer.2 this$0;

                            public final void invoke() {
                                TeamUpMatchPresenter.access$confirmMatch(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                }

                public void onClickModify() {
                    TeamUpReport.INSTANCE.reportModifyBtnClick(this.this$0.getChannelId(), TeamUpMatchPresenter.access$getCurGid$p(this.this$0), this.this$0.getRole());
                    boolean isFirstSeat = TeamUpMatchPresenter.access$getSeatService$p(this.this$0).getSeatData().isInFirstSeat(AccountUtil.getUid());
                    if (!isFirstSeat) {
                        ToastUtils.showToast((Context)((Context)((IChannelPageContext)this.this$0.getMvpContext()).getContext()), (int)R.string.tips_team_up_match_not_in_first_seat);
                        return;
                    }
                    if (TeamUpMatchPresenter.access$matchStatus(this.this$0)) {
                        this.this$0.showMatchPanel(true);
                    } else {
                        TeamUpMatchPresenter.access$checkInterval(this.this$0, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ setContainer.2 this$0;

                            public final void invoke() {
                                this.this$0.this$0.showMatchPanel(true);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    @KvoMethodAnnotation(sourceClass=TeamUpGameData.class, name="kvo_team_up_match_status")
    public final void updateMatchBtn(@NotNull KvoEventIntent eventIntent) {
        block1: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)eventIntent, (String)"eventIntent");
                if (eventIntent.isStickyNotify()) {
                    return;
                }
                Boolean bl = (Boolean)eventIntent.newValue();
                if (bl == null) break block1;
                Boolean bl2 = bl;
                boolean bl3 = false;
                boolean bl4 = false;
                Boolean it = bl2;
                boolean bl5 = false;
                MLog.info((Object)TAG, (String)("updateMatchBtn gid:" + it), (Object[])new Object[0]);
                boolean matchStatus = this.matchStatus();
                if (!matchStatus) break block2;
                MLog.info((Object)TAG, (String)("getMatchStatus matchStatus:" + matchStatus), (Object[])new Object[0]);
                this.changeViewMatchStatus();
                break block1;
            }
            MLog.info((Object)TAG, (String)"updateMatchBtn match false", (Object[])new Object[0]);
            TeamUpMatchView teamUpMatchView = this.mView;
            if (teamUpMatchView == null) break block1;
            teamUpMatchView.changeMatchStatus(false);
        }
    }

    private final void changeViewMatchStatus() {
        block1: {
            block0: {
                boolean isFirstSeat = this.getSeatService().getSeatData().isInFirstSeat(AccountUtil.getUid());
                if (!isFirstSeat) break block0;
                MLog.info((Object)TAG, (String)"updateMatchBtn match true", (Object[])new Object[0]);
                TeamUpMatchView teamUpMatchView = this.mView;
                if (teamUpMatchView == null) break block1;
                teamUpMatchView.changeMatchStatus(true);
                break block1;
            }
            MLog.info((Object)TAG, (String)"updateMatchBtn but not in first seat, break", (Object[])new Object[0]);
            TeamUpMatchView teamUpMatchView = this.mView;
            if (teamUpMatchView == null) break block1;
            teamUpMatchView.changeMatchStatus(false);
        }
    }

    @KvoMethodAnnotation(sourceClass=TeamUpGameData.class, name="kvo_match_game_info_list")
    public final void updateLastMatchStatus(@NotNull KvoEventIntent eventIntent) {
        block1: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)eventIntent, (String)"eventIntent");
                if (eventIntent.isStickyNotify()) {
                    return;
                }
                KvoList kvoList = (KvoList)eventIntent.newValue();
                if (kvoList == null) break block1;
                KvoList kvoList2 = kvoList;
                boolean bl = false;
                boolean bl2 = false;
                KvoList it = kvoList2;
                boolean bl3 = false;
                if (!this.isMatchedBefore()) break block2;
                TeamUpMatchView teamUpMatchView = this.mView;
                if (teamUpMatchView == null) break block1;
                teamUpMatchView.updateModifyLayout(true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ TeamUpMatchPresenter this$0;
                    {
                        this.this$0 = teamUpMatchPresenter;
                        super(0);
                    }

                    public final void invoke() {
                        TeamUpReport.INSTANCE.reportModifyBtnShow(this.this$0.getChannelId(), TeamUpMatchPresenter.access$getCurGid$p(this.this$0), this.this$0.getRole());
                    }
                }));
                break block1;
            }
            TeamUpMatchView teamUpMatchView = this.mView;
            if (teamUpMatchView == null) break block1;
            TeamUpMatchView.updateModifyLayout$default(teamUpMatchView, false, null, 2, null);
        }
    }

    private final void setViewVisibilityStatus() {
        block5: {
            boolean isFirstSeat;
            block4: {
                block3: {
                    if (this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid())) break block3;
                    IRoleService iRoleService = this.getChannel().getRoleService();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iRoleService, (String)"channel.roleService");
                    if (!iRoleService.isMeAnchor()) break block4;
                }
                if (this.isChannelPrivate()) break block4;
                IPluginService iPluginService = this.getChannel().getPluginService();
                Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
                if (iPluginService.getCurPluginData().mode != 400) break block4;
                Map map = this.getTeamUpService().data().getMatchConfigMap();
                String string2 = this.curGid();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if (map.get(string2) == null) break block4;
                TeamUpMatchView teamUpMatchView = this.mView;
                if (teamUpMatchView == null || teamUpMatchView.getVisibility() != 0) {
                    TeamUpReport.INSTANCE.reportMatchBtnShow(this.getChannelId(), this.curGid(), this.getRole(), this.matchStatus() ? "1" : "3");
                }
                TeamUpMatchView teamUpMatchView2 = this.mView;
                if (teamUpMatchView2 == null) break block5;
                teamUpMatchView2.setVisibility(0);
                break block5;
            }
            if ((isFirstSeat = this.getSeatService().getSeatData().isInFirstSeat(AccountUtil.getUid())) && this.matchStatus()) {
                TeamUpMatchPresenter.cancelMatch$default(this, null, 1, null);
            }
            TeamUpMatchView teamUpMatchView = this.mView;
            if (teamUpMatchView == null) break block5;
            teamUpMatchView.setVisibility(8);
        }
    }

    public void onDataUpdate(@Nullable String channelId, @Nullable ChannelDetailInfo info) {
        ChannelDetailInfo channelDetailInfo;
        super.onDataUpdate(channelId, info);
        MLog.info((Object)TAG, (String)("onDataUpdate isPrivate:" + ((channelDetailInfo = info) != null && (channelDetailInfo = channelDetailInfo.baseInfo) != null ? Boolean.valueOf(channelDetailInfo.isPrivate) : null)), (Object[])new Object[0]);
        this.setViewVisibilityStatus();
    }

    public void onMyRoleChanged(@Nullable String channelId, int newRoleType) {
        super.onMyRoleChanged(channelId, newRoleType);
        this.setViewVisibilityStatus();
    }

    private final void bindDataListener() {
        LiveData<List<SeatItem>> seats = ((VoiceRoomSeatPresenter)this.getPresenter(VoiceRoomSeatPresenter.class)).seats();
        seats.observe((LifecycleOwner)((IChannelPageContext)this.getMvpContext()).getLifecycleOwner(), this.mSeatObs);
    }

    private final void confirmMatch() {
        this.fetchMatchConfigByGid((ICommonCallback<Boolean>)((ICommonCallback)new ICommonCallback<Boolean>(this){
            final /* synthetic */ TeamUpMatchPresenter this$0;

            public void onSuccess(@Nullable Boolean data2, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                if (Intrinsics.areEqual((Object)data2, (Object)true)) {
                    if (!TeamUpMatchPresenter.access$isMatchedBefore(this.this$0)) {
                        TeamUpMatchPresenter.showMatchPanel$default(this.this$0, false, 1, null);
                    } else {
                        TeamUpMatchPresenter.access$reqMatch(this.this$0);
                    }
                }
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
            }
            {
                this.this$0 = $outer;
            }
        }));
    }

    private final void checkInterval(Function0<Unit> callback2) {
        long limited = TeamUpMatchConfig.Companion.getLimitTime();
        long lastCancelTime = SettingFlags.getLongValue((String)("key_long_team_up_match_cancel_time" + this.curGid() + this.getChannelId() + AccountUtil.getUid()), (long)0L);
        long duringTime = (System.currentTimeMillis() - lastCancelTime) / (long)1000;
        if (duringTime >= limited) {
            callback2.invoke();
        } else {
            long leftTime = limited - duringTime;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = ResourceUtils.getString((int)R.string.tips_team_up_match_confirm_limited);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ResourceUtils.getString(\u2026up_match_confirm_limited)");
            String string3 = string2;
            Object[] objectArray = new Object[]{leftTime};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            String leftTip = string4;
            ToastUtils.showToast((Context)((Context)((IChannelPageContext)this.getMvpContext()).getContext()), (String)leftTip, (int)1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMatchedBefore() {
        Object v0;
        boolean bl;
        Iterable iterable;
        block1: {
            KvoList matchInfoList = this.getTeamUpService().data().getMatchInfoList();
            String gid = this.curGid();
            iterable = (Iterable)matchInfoList;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                TeamUpGameInfoBean it = (TeamUpGameInfoBean)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)gid, (Object)it.getGid())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        TeamUpGameInfoBean bean2 = v0;
        if (bean2 == null) return false;
        iterable = bean2.getList();
        bl = false;
        if (iterable.isEmpty()) return false;
        return true;
    }

    private final void fetchMatchConfigByGid(ICommonCallback<Boolean> callback2) {
        block0: {
            MLog.info((Object)TAG, (String)"fetchMatchConfigByGid", (Object[])new Object[0]);
            String string2 = this.curGid();
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String $this$apply = string3;
            boolean bl3 = false;
            this.getTeamUpService().getGameMatchConfig($this$apply, (ICommonCallback)new ICommonCallback<Boolean>($this$apply, this, callback2){
                final /* synthetic */ String $this_apply;
                final /* synthetic */ TeamUpMatchPresenter this$0;
                final /* synthetic */ ICommonCallback $callback$inlined;
                {
                    this.$this_apply = $receiver;
                    this.this$0 = teamUpMatchPresenter;
                    this.$callback$inlined = iCommonCallback;
                }

                public void onSuccess(@Nullable Boolean data2, Object ... ext) {
                    block1: {
                        block0: {
                            Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                            if (!Intrinsics.areEqual((Object)data2, (Object)true)) break block0;
                            TeamUpMatchPresenter.access$getTeamUpService$p(this.this$0).getGameMatchInfo(this.$this_apply, this.this$0.getChannel().getChannelId(), this.$callback$inlined);
                            break block1;
                        }
                        ICommonCallback iCommonCallback = this.$callback$inlined;
                        if (iCommonCallback == null) break block1;
                        iCommonCallback.onFail(0, "getGameMatchConfig fail", new Object[0]);
                    }
                }

                public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                        ICommonCallback iCommonCallback = this.$callback$inlined;
                        if (iCommonCallback == null) break block0;
                        iCommonCallback.onFail(errCode, msg, new Object[0]);
                    }
                }
            });
        }
    }

    public final void showMatchPanel(boolean modify) {
        block0: {
            MLog.info((Object)TAG, (String)"showMatchPanel", (Object[])new Object[0]);
            String string2 = this.curGid();
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String $this$apply = string3;
            boolean bl3 = false;
            this.getTeamUpGamePresenter().showTeamUpMatchPanel(this.callback, modify, $this$apply);
        }
    }

    public static /* synthetic */ void showMatchPanel$default(TeamUpMatchPresenter teamUpMatchPresenter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        teamUpMatchPresenter.showMatchPanel(bl);
    }

    private final void showConfirmCancelDialog() {
        long limitTime = TeamUpMatchConfig.Companion.getLimitTime();
        if (limitTime > 0L) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = ResourceUtils.getString((int)R.string.tips_team_up_match_confirm_cancel);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ResourceUtils.getString(\u2026_up_match_confirm_cancel)");
            String string3 = string2;
            Object[] objectArray = new Object[]{limitTime};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            String string5 = string4;
            OkCancelDialogListener okCancelDialogListener = new OkCancelDialogListener(this){
                final /* synthetic */ TeamUpMatchPresenter this$0;

                public void onCancel() {
                    TeamUpReport.INSTANCE.reportMatchBtnCancelDialogCancel(this.this$0.getChannelId(), TeamUpMatchPresenter.access$curGid(this.this$0), this.this$0.getRole());
                }

                public void onOk() {
                    TeamUpMatchPresenter.cancelMatch$default(this.this$0, null, 1, null);
                    TeamUpReport.INSTANCE.reportMatchBtnCancelDialogConfirm(this.this$0.getChannelId(), TeamUpMatchPresenter.access$curGid(this.this$0), this.this$0.getRole());
                }
                {
                    this.this$0 = $outer;
                }
            };
            CharSequence charSequence = ResourceUtils.getString((int)R.string.contact_dialog_cancel);
            CharSequence charSequence2 = ResourceUtils.getString((int)R.string.minor_dialog_ok);
            CharSequence charSequence3 = string5;
            OkCancelDialog dialog2 = new OkCancelDialog(charSequence3, charSequence2, charSequence, okCancelDialogListener);
            new DialogLinkManager((Context)((IChannelPageContext)this.getMvpContext()).getContext()).showDialog((BaseDialog)dialog2);
            TeamUpReport.INSTANCE.reportMatchBtnCancelDialogShow(this.getChannelId(), this.curGid(), this.getRole());
        } else {
            TeamUpMatchPresenter.cancelMatch$default(this, null, 1, null);
        }
    }

    private final void cancelMatch(String gid) {
        block0: {
            MLog.info((Object)TAG, (String)"cancelMatch", (Object[])new Object[0]);
            String string2 = TextUtils.isEmpty((CharSequence)gid) ? this.curGid() : gid;
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String $this$apply = string3;
            boolean bl3 = false;
            this.getTeamUpService().reportMatchInfo($this$apply, 0, this.getChannel().getChannelId(), null);
        }
    }

    static /* synthetic */ void cancelMatch$default(TeamUpMatchPresenter teamUpMatchPresenter, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        teamUpMatchPresenter.cancelMatch(string2);
    }

    public final void showMatchTips() {
        block5: {
            boolean ifShowTips;
            block4: {
                MLog.info((Object)TAG, (String)"showMatchTips", (Object[])new Object[0]);
                if (this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid())) break block4;
                IRoleService iRoleService = this.getChannel().getRoleService();
                Intrinsics.checkExpressionValueIsNotNull((Object)iRoleService, (String)"channel.roleService");
                if (!iRoleService.isMeAnchor()) break block5;
            }
            if (!this.isChannelPrivate() && (ifShowTips = SettingFlags.getBoolean((String)"key_teamup_game_match_tips", (boolean)true))) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ TeamUpMatchPresenter this$0;

                    public final void run() {
                        block2: {
                            if (this.this$0.isDestroyed()) {
                                return;
                            }
                            TeamUpMatchView teamUpMatchView = TeamUpMatchPresenter.access$getMView$p(this.this$0);
                            if (teamUpMatchView == null) break block2;
                            TeamUpMatchView teamUpMatchView2 = teamUpMatchView;
                            boolean bl = false;
                            boolean bl2 = false;
                            TeamUpMatchView $this$apply = teamUpMatchView2;
                            boolean bl3 = false;
                            if ($this$apply.getVisibility() == 0) {
                                View view2 = (View)$this$apply;
                                FragmentActivity fragmentActivity = ((IChannelPageContext)this.this$0.getMvpContext()).getContext();
                                Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"mvpContext.context");
                                Context context = (Context)fragmentActivity;
                                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                String string2 = ResourceUtils.getString((int)R.string.tips_team_up_match_btn);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ResourceUtils.getString(\u2026g.tips_team_up_match_btn)");
                                String string3 = string2;
                                Object[] objectArray = new Object[]{TeamUpMatchPresenter.access$gameName(this.this$0)};
                                Context context2 = context;
                                View view3 = view2;
                                boolean bl4 = false;
                                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                                String string5 = string4;
                                BubblePopupWindowManager.showTopRightArrow$default((View)view3, (Context)context2, (String)string5, (int)ColorUtils.parseColor((String)"#ffffff"), (long)5000L, (int)0, (int)ResolutionUtils.dip2Px((float)5.0f), (int)4, (int)2, (int)0, (int)ColorUtils.parseColor((String)"#333333"), (int)0, null, (int)6144, null);
                                SettingFlags.setBoolean((String)"key_teamup_game_match_tips", (boolean)false);
                            }
                        }
                    }
                    {
                        this.this$0 = teamUpMatchPresenter;
                    }
                }, (long)3000L);
            }
        }
    }

    private final void publishScreenMsg() {
        block1: {
            IEnteredChannel iEnteredChannel;
            MLog.info((Object)TAG, (String)"publishScreenMsg", (Object[])new Object[0]);
            IUserInfoService iUserInfoService = (IUserInfoService)ServiceManagerProxy.getInstance().getService(IUserInfoService.class);
            UserInfoKS userInfo = iUserInfoService != null ? iUserInfoService.getUserInfo(AccountUtil.getUid()) : null;
            Object[] objectArray = new Object[1];
            UserInfoKS userInfoKS = userInfo;
            objectArray[0] = userInfoKS != null ? userInfoKS.nick : null;
            PureTextMsg pureMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalPureTextMsg(this.getChannelId(), (CharSequence)ResourceUtils.getString((int)R.string.tips_assist_game_start_match_msg, (Object[])objectArray), (iEnteredChannel = ((IChannelPageContext)this.getMvpContext()).getChannel()) != null && (iEnteredChannel = iEnteredChannel.getRoleService()) != null ? iEnteredChannel.getMyRoleCache() : 0);
            if (this.isDestroyed()) break block1;
            IPublicScreenPresenter iPublicScreenPresenter = ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
            if (iPublicScreenPresenter != null) {
                iPublicScreenPresenter.appendLocalMsgAndSendToServer((BaseImMsg)pureMsg);
            }
        }
    }

    private final String curGid() {
        IPluginService iPluginService = this.getChannel().getPluginService();
        this.curGid = iPluginService != null && (iPluginService = iPluginService.getCurPluginData()) != null ? iPluginService.getPluginId() : null;
        return this.curGid;
    }

    @NotNull
    public final String getRole() {
        IRoleService iRoleService = this.getChannel().getRoleService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iRoleService, (String)"channel.roleService");
        return String.valueOf(iRoleService.getMyRoleCache());
    }

    private final String gameName() {
        return this.getChannel().getTeamUpService().getGameName();
    }

    private final TeamUpGameData getData() {
        return this.getTeamUpService().data();
    }

    private final boolean isChannelPrivate() {
        return this.getChannel().getChannelDetail().baseInfo.enterMode == 2;
    }

    private final boolean matchStatus() {
        Object object = this.getTeamUpService();
        this.curMatchStatus = object != null && (object = object.getMatchStatus(this.curGid())) != null ? (Boolean)object : false;
        return this.curMatchStatus;
    }

    private final void reqMatch() {
        ITeamUpGameService iTeamUpGameService = this.getTeamUpService();
        String string2 = this.curGid;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        iTeamUpGameService.reportMatchInfo(string2, 1, this.getChannel().getChannelId(), (ICommonCallback)new ICommonCallback<Boolean>(this){
            final /* synthetic */ TeamUpMatchPresenter this$0;

            public void onSuccess(@Nullable Boolean data2, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                if (Intrinsics.areEqual((Object)data2, (Object)true)) {
                    TeamUpMatchPresenter.access$publishScreenMsg(this.this$0);
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_team_up_match_confirm, (int)0);
                }
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        this.unBindObserver();
        this.mView = null;
        ((SeatPresenter)this.getPresenter(SeatPresenter.class)).seats().removeObserver(this.mSeatObs);
        if (this.mLastIsInFirst && this.curMatchStatus) {
            this.cancelMatch(this.curGid);
        }
        this.getTeamUpService().cleanMatchStatus();
    }

    public static final /* synthetic */ void access$setViewVisibilityStatus(TeamUpMatchPresenter $this) {
        $this.setViewVisibilityStatus();
    }

    public static final /* synthetic */ String access$curGid(TeamUpMatchPresenter $this) {
        return $this.curGid();
    }

    public static final /* synthetic */ ISeatService access$getSeatService$p(TeamUpMatchPresenter $this) {
        return $this.getSeatService();
    }

    public static final /* synthetic */ boolean access$matchStatus(TeamUpMatchPresenter $this) {
        return $this.matchStatus();
    }

    public static final /* synthetic */ void access$showConfirmCancelDialog(TeamUpMatchPresenter $this) {
        $this.showConfirmCancelDialog();
    }

    public static final /* synthetic */ void access$checkInterval(TeamUpMatchPresenter $this, Function0 callback2) {
        $this.checkInterval((Function0<Unit>)callback2);
    }

    public static final /* synthetic */ void access$confirmMatch(TeamUpMatchPresenter $this) {
        $this.confirmMatch();
    }

    public static final /* synthetic */ String access$getCurGid$p(TeamUpMatchPresenter $this) {
        return $this.curGid;
    }

    public static final /* synthetic */ void access$setCurGid$p(TeamUpMatchPresenter $this, String string2) {
        $this.curGid = string2;
    }

    public static final /* synthetic */ boolean access$isMatchedBefore(TeamUpMatchPresenter $this) {
        return $this.isMatchedBefore();
    }

    public static final /* synthetic */ void access$reqMatch(TeamUpMatchPresenter $this) {
        $this.reqMatch();
    }

    public static final /* synthetic */ ITeamUpGameService access$getTeamUpService$p(TeamUpMatchPresenter $this) {
        return $this.getTeamUpService();
    }

    public static final /* synthetic */ TeamUpMatchView access$getMView$p(TeamUpMatchPresenter $this) {
        return $this.mView;
    }

    public static final /* synthetic */ void access$setMView$p(TeamUpMatchPresenter $this, TeamUpMatchView teamUpMatchView) {
        $this.mView = teamUpMatchView;
    }

    public static final /* synthetic */ String access$gameName(TeamUpMatchPresenter $this) {
        return $this.gameName();
    }

    public static final /* synthetic */ void access$publishScreenMsg(TeamUpMatchPresenter $this) {
        $this.publishScreenMsg();
    }

    public static final /* synthetic */ void access$onGroupNameSave(TeamUpMatchPresenter $this, String channelName) {
        $this.onGroupNameSave(channelName);
    }

    public static final /* synthetic */ boolean access$getMLastIsInFirst$p(TeamUpMatchPresenter $this) {
        return $this.mLastIsInFirst;
    }

    public static final /* synthetic */ void access$setMLastIsInFirst$p(TeamUpMatchPresenter $this, boolean bl) {
        $this.mLastIsInFirst = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/teamup/match/TeamUpMatchPresenter$Companion;", "", "()V", "TAG", "", "channel-components_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

