/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.framework.core.ui.gradienttextview.GradientColor;
import com.yy.framework.core.ui.gradienttextview.TextGradientHelper;
import com.yy.hiyo.channel.R;

public class StrokeTextView
extends YYTextView {
    private int mStrokeWidth;
    private int mStrokeColor = -65536;
    private int mTextColor;
    private TextPaint mPaint;
    private GradientColor mGradientColor;
    private Matrix mGradientMatrix = new Matrix();
    private float mTranslate;
    private boolean needStroke;

    public boolean isNeedStroke() {
        return this.needStroke;
    }

    public void setNeedStroke(boolean needStroke) {
        this.needStroke = needStroke;
        this.invalidate();
    }

    public StrokeTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public StrokeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StrokeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mPaint = this.getPaint();
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StrokeTextView);
            this.mStrokeColor = a.getColor(R.styleable.StrokeTextView_stv_strokeColor, -16777216);
            this.mStrokeWidth = a.getDimensionPixelSize(R.styleable.StrokeTextView_stv_strokeWidth, 0);
            this.setStrokeColor(this.mStrokeColor);
            this.setStrokeWidth(this.mStrokeWidth);
            a.recycle();
        }
    }

    public void setGradientColor(GradientColor gradientColor) {
        this.mGradientColor = gradientColor;
        if (gradientColor != null) {
            TextGradientHelper.INSTANCE.setGradient((TextView)this, gradientColor, null);
        } else {
            TextGradientHelper.INSTANCE.clearGradient((TextView)this);
        }
    }

    public void setStrokeColor(int color2) {
        if (this.mStrokeColor != color2) {
            this.mStrokeColor = color2;
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mStrokeWidth > 0 && this.needStroke) {
            this.mTextColor = this.getCurrentTextColor();
            this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
            this.mPaint.setFakeBoldText(true);
            this.mPaint.setShadowLayer((float)this.mStrokeWidth, 0.0f, 0.0f, 0);
            this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.setTextColor(this.mStrokeColor);
            this.mPaint.setShader(null);
            super.onDraw(canvas);
            this.setTextColor(this.mTextColor);
            this.mPaint.setStrokeWidth(0.0f);
            this.mPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        }
        if (this.mGradientColor != null) {
            TextGradientHelper.INSTANCE.setGradient((TextView)this, this.mGradientColor, canvas);
            if (TextGradientHelper.INSTANCE.isRoll(this.mGradientColor)) {
                this.mTranslate += 1.0f;
                if (this.mTranslate > (float)this.getWidth()) {
                    this.mTranslate = -this.getWidth();
                }
                this.mGradientMatrix.setTranslate(this.mTranslate, 0.0f);
                if (this.mPaint.getShader() != null) {
                    this.mPaint.getShader().setLocalMatrix(this.mGradientMatrix);
                }
                this.postInvalidateDelayed(5L);
            }
        }
        super.onDraw(canvas);
    }

    public void setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        this.invalidate();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mTranslate = 0.0f;
    }
}

