/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.seattip;

import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.cbase.ChannelSettingFlag;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.seattip.AbsSeatTipStrategy;
import com.yy.hiyo.channel.component.seat.seattip.SeatTipsPresenter;
import com.yy.hiyo.channel.service.growth.PathTimeAdjustExperiment;
import java.util.List;

class FirstTimeInviteBubbleStrategy
extends AbsSeatTipStrategy {
    private static final String TAG = "FirstTimeInviteBubbleStrategy";

    public FirstTimeInviteBubbleStrategy(@NonNull SeatTipsPresenter seatPresenter) {
        super(seatPresenter);
    }

    @Override
    public boolean resolve() {
        return this.showGuideTip();
    }

    private boolean showGuideTip() {
        boolean toShow = false;
        int times = 0;
        PathTimeAdjustExperiment experiment = PathTimeAdjustExperiment.Companion.newExperiment();
        if (experiment == null || !experiment.matchTest()) {
            toShow = !ChannelSettingFlag.INSTANCE.getBoolean("key_showed_tips_when_first_enter_voice_room", false);
        } else if (experiment.hadSitdown()) {
            toShow = false;
        } else {
            CommonConfigData configData;
            int limit = 2;
            AConfigData config2 = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
            if (config2 instanceof CommonConfig && (configData = ((CommonConfig)config2).getData()) != null) {
                limit = configData.newRegisterSeatGuideBubbleTimes;
            }
            MLog.debug((Object)TAG, (String)"newRegisterSeatGuideBubbleTimes limit: %d", (Object[])new Object[]{limit});
            times = experiment.getTimesOfInSeatBubble();
            if (times < limit) {
                toShow = true;
            }
        }
        if (toShow) {
            int index = this.getFirstEmptySeat();
            MLog.debug((Object)TAG, (String)"showTipsByIndexNoew index: %d", (Object[])new Object[]{index});
            if (index >= 0) {
                if (this.showTipsByIndexNow(index, ResourceUtils.getString((int)R.string.tips_seat_guide))) {
                    if (experiment != null && experiment.matchTest()) {
                        experiment.setTimesOfInSeatBubble(times + 1);
                    }
                    ChannelSettingFlag.INSTANCE.putBoolean("key_showed_tips_when_first_enter_voice_room", true);
                    return true;
                }
                MLog.debug((Object)TAG, (String)"showTipsByIndexNow fail", (Object[])new Object[0]);
            }
        }
        return false;
    }

    private int getFirstEmptySeat() {
        ISeatService seatService2 = ((IChannelPageContext)this.getHost().getMvpContext()).getChannel().getSeatService();
        if (seatService2.isMeInSeat()) {
            return -1;
        }
        IRoleService roleService = ((IChannelPageContext)this.getHost().getMvpContext()).getChannel().getRoleService();
        List seatList = seatService2.getSeatList();
        for (int i = 0; i < seatList.size(); ++i) {
            SeatUser seat = (SeatUser)seatList.get(i);
            if (seat.index == 1 && !roleService.isOwnerOrMaster(AccountUtil.getUid()) || 0L != seat.uid || SeatStatusUtils.isLocked((long)seat.status)) continue;
            return i;
        }
        return -1;
    }
}

