/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.bean;

import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.CalculatorData;
import com.yy.hiyo.channel.base.bean.ISeatUser;
import com.yy.hiyo.wallet.base.privilege.bean.NobleColorConfig;

@DontProguardClass
public class SeatItem
extends KvoSource
implements Cloneable,
ISeatUser {
    public static final int SURRENDER_STATUS_NONE = 0;
    public static final int SURRENDER_STATUS_DECIDING = 1;
    public static final int SURRENDER_STATUS_AGREED = 2;
    public static final int SURRENDER_STATUS_REJECT = 3;
    public static final int HOST_INDEX = 1;
    public long statusFlag;
    public int index;
    public long uid;
    public long ts;
    public UserInfoKS userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(0L);
    public int roleType;
    public boolean isSpeaking;
    public MutableLiveData<String> nickNameColor = new MutableLiveData();
    public MutableLiveData<Boolean> isNoble = new MutableLiveData();
    public MutableLiveData<NobleColorConfig> nobleColor = new MutableLiveData();
    public int theme;
    public boolean lost;
    public int level;
    public boolean isEnemy;
    public boolean warning;
    public int surrenderState = 0;
    public CalculatorData mCalculatorData = new CalculatorData();
    public Object payLoad;

    public boolean hasUser() {
        return this.uid > 0L && this.userInfo != null && this.userInfo.uid > 0L;
    }

    public boolean isMe() {
        return this.uid == AccountUtil.getUid();
    }

    public boolean isLocked() {
        return SeatStatusUtils.isLocked((long)this.statusFlag);
    }

    public boolean isFreezed() {
        return SeatStatusUtils.isFreezed((long)this.statusFlag);
    }

    public boolean isGameReady() {
        return SeatStatusUtils.isGameReady((long)this.statusFlag);
    }

    public boolean isMicOpen() {
        return SeatStatusUtils.isMicOpen((long)this.statusFlag);
    }

    public boolean isMicForbidden() {
        return SeatStatusUtils.isMicForbidden((long)this.statusFlag);
    }

    public static boolean isContentSame(SeatItem old, SeatItem item) {
        return old.uid == item.uid && old.userInfo == item.userInfo && old.index == item.index && old.ts == item.ts && old.statusFlag == item.statusFlag && old.isSpeaking == item.isSpeaking && old.mCalculatorData.getMCalculatorType() == item.mCalculatorData.getMCalculatorType() && old.mCalculatorData.isCalculatorRaise() == item.mCalculatorData.isCalculatorRaise() && old.mCalculatorData.getCalculatorValue() == item.mCalculatorData.getCalculatorValue() && old.mCalculatorData.isFirstCharmValue() == item.mCalculatorData.isFirstCharmValue() && old.payLoad == item.payLoad && old.roleType == item.roleType;
    }

    public String toString() {
        return "SeatItem{statusFlag=" + this.statusFlag + ", index=" + this.index + ", ts=" + this.ts + ", uid=" + this.uid + ", userInfo=" + this.userInfo + ", isSpeaking=" + this.isSpeaking + ", mCalculatorType=" + this.mCalculatorData.getMCalculatorType() + ", calculatorValue=" + this.mCalculatorData.getCalculatorValue() + ", isNeedLarge=" + this.mCalculatorData.isNeedLarge() + ", isFirstCharmValue=" + this.mCalculatorData.isFirstCharmValue() + ", isCalculatorRaise=" + this.mCalculatorData.isCalculatorRaise() + ", roleType=" + this.roleType + ", payLoad=" + this.payLoad + ", isEnemy=" + this.isEnemy + '}';
    }

    protected Object clone() throws CloneNotSupportedException {
        SeatItem copy = (SeatItem)super.clone();
        return copy;
    }

    public SeatItem copy() {
        try {
            return (SeatItem)this.clone();
        }
        catch (CloneNotSupportedException e) {
            MLog.error((Object)"SeatItem", (Throwable)e);
            return null;
        }
    }

    public int index() {
        return this.index;
    }

    public long uid() {
        return this.uid;
    }

    public long status() {
        return this.statusFlag;
    }

    public long ts() {
        return this.ts;
    }
}

