/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat;

import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public enum SeatTrack {
    INSTANCE;

    private static final String KEY_FUNCTION_ID = "function_id";
    private static final String KEY_ROOM_ID = "room_id";
    private static final String KEY_START_TIME = "start_time";
    private static final String KEY_UP_VOICE_TYPE = "up_voice_type";
    private static final String KEY_END_TIME = "end_time";
    private static final String KEY_DOWN_VOICE_TYPE = "down_voice_type";
    private static final String FUNCTION_VOICE_ROOM_NO_VOICE_PERMISSION_SHOW = "no_voice_permission_show";
    private static final String FUNCTION_UP_VOICE_CLICK = "up_voice_click";
    private static final String FUNCTION_DOWN_VOICE_CLICK = "down_voice_click";
    private static final String FUNCTION_VOICE_ROOM_OPEN_MIC_CLICK = "open_voice_click";
    private static final String FUNCTION_VOICE_ROOM_CLOSE_MIC_CLICK = "close_voice_click";
    private static final String FUNCTION_CALCULATOR_CHARM_CLICK = "charm_cal_but_click";
    private static final String FUNCTION_HOST_BLANK_CLICK = "host_blank_click";
    private static final String FUNCTION_HOST_INVITE_CLICK = "host_invite_click";
    private static final String FUNCTION_GAME_RULE_PANEL_SHOW = "game_rule_panel_show";
    private static final String FUNCTION_GAME_RULE_BUT_CLICK = "game_rule_but_click";
    private static final String KEY_OPEN_VOICE_TYPE = "open_voice_type";
    private static final String FUNCTION_HOST_LOCK_CLICK = "host_lock_click";
    private static final String FUNCTION_DOWN_INVITE_SHOW = "down_invite_show";
    private static final String KEY_GID = "gid";
    private static final String KEY_CLOSE_VOICE_TYPE = "close_voice_type";
    private static final String KEY_UID_CHOSEN = "uid_chosen";
    private static final String KEY_CHARM = "charm";
    public static final String KEY_USER_ROLE = "user_role";
    private static final String KEY_TOKEN = "token";
    private static final String FUNCTION_PARTY_INVITE_TAKE_SEAT_POP = "party_invite_take_seat_pop";
    private static final String FUNCTION_PARTY_INVITE_TAKE_SEAT_OK_CLICK = "party_invite_take_seat_ok_click";
    private static final String FUNCTION_PARTY_INVITE_TAKE_SEAT_REJECT_CLICK = "party_invite_take_seat_reject_click";
    private static final String FUNCTION_PARTY_INVITE_TAKE_SEAT_SWITCH = "party_invite_take_seat_switch";

    private HiidoEvent event(String eventId) {
        return HiidoEvent.obtain().eventId(eventId).put("mode_key", String.valueOf(2));
    }

    public void upVoiceClick(String roomId, String type, String token) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, FUNCTION_UP_VOICE_CLICK).put(KEY_START_TIME, "" + System.currentTimeMillis()).put(KEY_UP_VOICE_TYPE, type).put(KEY_TOKEN, token).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))).put(KEY_GID, this.getPluginId(roomId)));
    }

    public void downVoiceClick(String roomId, String type) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, FUNCTION_DOWN_VOICE_CLICK).put(KEY_END_TIME, "" + System.currentTimeMillis()).put(KEY_DOWN_VOICE_TYPE, type).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))).put(KEY_GID, this.getPluginId(roomId)));
    }

    public void openVoiceClick(String roomId, String type) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_VOICE_ROOM_OPEN_MIC_CLICK).put(KEY_ROOM_ID, roomId).put(KEY_OPEN_VOICE_TYPE, type).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))).put(KEY_GID, this.getPluginId(roomId)));
    }

    public void closeVoiceClick(String roomId, String type) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_VOICE_ROOM_CLOSE_MIC_CLICK).put(KEY_ROOM_ID, roomId).put(KEY_CLOSE_VOICE_TYPE, type).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))).put(KEY_GID, this.getPluginId(roomId)));
    }

    public void hostBlankClick(String roomId) {
        int roleType = this.getUserRole(roomId);
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, FUNCTION_HOST_BLANK_CLICK).put(KEY_GID, this.getPluginId(roomId)).put(KEY_USER_ROLE, String.valueOf(roleType)));
    }

    public void hostLockClick(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, FUNCTION_HOST_LOCK_CLICK).put(KEY_GID, this.getPluginId(roomId)).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void downInviteShow(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, FUNCTION_DOWN_INVITE_SHOW).put(KEY_GID, this.getPluginId(roomId)));
    }

    public void downInviteYesClick(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, "down_invite_yes_click").put(KEY_GID, this.getPluginId(roomId)));
    }

    public void downInviteNoClick(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, "down_invite_no_click").put(KEY_GID, this.getPluginId(roomId)));
    }

    public void startGameClick(String roomId, String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_GID, gameId).put(KEY_START_TIME, System.currentTimeMillis() + "").put(KEY_FUNCTION_ID, "start_game_click").put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void upReadyClick(String roomId, String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_GID, gameId).put(KEY_FUNCTION_ID, "up_ready_click").put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void downJoinClick(String roomId, String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_GID, gameId).put(KEY_FUNCTION_ID, "down_join_click").put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void panelCloseClick(String roomId, String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_GID, gameId).put(KEY_FUNCTION_ID, "panel_close_game_click").put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void cancelReadyClick(String roomId, String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_GID, gameId).put(KEY_FUNCTION_ID, "voice_cancel_ready_click").put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void noVoicePermissionShow(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_VOICE_ROOM_NO_VOICE_PERMISSION_SHOW).put(KEY_ROOM_ID, roomId).put(KEY_GID, this.getPluginId(roomId)));
    }

    public void onHostClickUnlock(String roomId, String gid) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, "host_lock_pop_unlock").put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))).put(KEY_GID, gid));
    }

    public void onHostClickInvite(String roomId, String gid) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, "host_lock_pop_invite").put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))).put(KEY_GID, gid));
    }

    public void onHostClickLeaveAndLock(String roomId, String gid) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, "host_leave_lock_click").put(KEY_GID, gid).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void calculatorCharmClick(String roomId, String uid, String charm) {
        FeatureLog.d((String)"FTCalculator", (String)"calculatorCharmClick,roomId:%s, uid:%s, charm:%s", (Object[])new Object[]{roomId, uid, charm});
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_ROOM_ID, roomId).put(KEY_FUNCTION_ID, FUNCTION_CALCULATOR_CHARM_CLICK).put(KEY_UID_CHOSEN, uid).put(KEY_CHARM, charm));
    }

    public void reportGameRulePanelShow(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_GAME_RULE_PANEL_SHOW).put(KEY_ROOM_ID, roomId).put(KEY_GID, this.getPluginId(roomId)).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void reportGameRuleBtnClick(String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_GAME_RULE_BUT_CLICK).put(KEY_ROOM_ID, roomId).put(KEY_GID, this.getPluginId(roomId)).put(KEY_USER_ROLE, String.valueOf(this.getUserRole(roomId))));
    }

    public void reportInviteTakeSeatPop(String gid) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_PARTY_INVITE_TAKE_SEAT_POP).put(KEY_GID, gid));
    }

    public void reportInviteTakeSeatOkClick(String gid) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_PARTY_INVITE_TAKE_SEAT_OK_CLICK).put(KEY_GID, gid));
    }

    public void reportInviteTakeSeatRejectClick(String gid) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_PARTY_INVITE_TAKE_SEAT_REJECT_CLICK).put(KEY_GID, gid));
    }

    public void reportInviteTakeSeatSwitch(int userType, String roomId, boolean notAutoInvite) {
        HiidoStatis.reportEvent((HiidoEvent)this.event("20028823").put(KEY_FUNCTION_ID, FUNCTION_PARTY_INVITE_TAKE_SEAT_SWITCH).put(KEY_GID, this.getPluginId(roomId)).put(KEY_USER_ROLE, userType + "").put("take_seat_switch", notAutoInvite ? "2" : "1"));
    }

    private String getPluginId(IChannel channel) {
        if (channel == null || channel.getPluginService() == null) {
            return "";
        }
        ChannelPluginData data2 = channel.getPluginService().getCurPluginData();
        if (data2 == null) {
            return "";
        }
        return data2.getPluginId() == null ? "" : data2.getPluginId();
    }

    private String getPluginId(String channelid) {
        IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(channelid);
        return this.getPluginId(channel);
    }

    private int getUserRole(String channelId) {
        IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(channelId);
        if (channel == null) {
            return -1;
        }
        return channel.getRoleService().getMyRoleCache();
    }
}

