/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat;

import android.content.Context;
import android.graphics.Point;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.OnLifecycleEvent;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.common.FacePoint;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.unifyconfig.TeamUpCommonConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.SeatStatusUtils;
import com.yy.hiyo.channel.base.bean.CalculatorData;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.NotifyDataDefine;
import com.yy.hiyo.channel.base.bean.RecommendEnterData;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.TeamUpCardItemBean;
import com.yy.hiyo.channel.base.bean.TeamUpCardItemList;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.rolepermission.RolePermission;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.IOperationCallback;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.base.service.ITeamUpGameService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.utils.ChannelUtils;
import com.yy.hiyo.channel.component.base.util.PrivilegeHelper;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.invite.voiceroom.SeatInviteHandler;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.component.seat.ISeatViewWrapper;
import com.yy.hiyo.channel.component.seat.SafeLiveData;
import com.yy.hiyo.channel.component.seat.SeatMvp;
import com.yy.hiyo.channel.component.seat.SeatTrack;
import com.yy.hiyo.channel.component.seat.SeatViewContainer;
import com.yy.hiyo.channel.component.seat.bean.SeatDataHolder;
import com.yy.hiyo.channel.component.seat.bean.SeatGoldenAnimInfo;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.service.growth.PathTimeAdjustExperiment;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakProfileCallback;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.hiyo.voice.base.bean.event.VoiceCallBack;
import com.yy.hiyo.wallet.base.privilege.bean.NobleColorConfig;
import com.yy.hiyo.wallet.base.privilege.service.NobleColorService;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public abstract class SeatPresenter<T extends ISeatViewWrapper>
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements SeatMvp.IPresenter,
VoiceCallBack,
INotifyDispatchService.INotifyHandler<ChannelNotify>,
ISeatUpdateListener,
IHolderPresenter {
    private static final String TAG = "FTVoiceRoomSeat_SeatPresenter";
    private MutableLiveData<List<SeatItem>> mSeats = new SafeLiveData();
    private static final Integer SPEAKING = 1;
    private InnerOnProfileCallback mProfileCallback;
    private boolean isSitDownRequiring = false;
    protected DialogLinkManager mDialogLinkManager;
    private SeatMvp.IPresenter.OnInterceptListener mInterceptListener;
    private Map<Long, Integer> mSpeak = new HashMap<Long, Integer>(0);
    private MutableLiveData<Integer> mUpdateOne = new SafeLiveData();
    private SeatDataHolder mSeatDataHolder = new SeatDataHolder(false, null, null);
    private MutableLiveData<Map<Long, Point>> mAbsoluteSeatLocation = new SafeLiveData();
    private MutableLiveData<Map<Long, Point>> mRelativeSeatLocation = new SafeLiveData();
    private MutableLiveData<Map<Long, FacePoint>> mRealRelSeatMapLocation = new MutableLiveData();
    private MutableLiveData<Map<Long, FacePoint>> mRealAbsSeatMapLocation = new MutableLiveData();
    private MutableLiveData<Boolean> mClipViewData = new SafeLiveData();
    private SeatViewContainer mSeatViewContainer;
    private MutableLiveData<Boolean> mCanCalculateSeatLocation = new SafeLiveData();
    protected T mSeatViewWrapper;
    protected ISeatService mSeatService;
    private ITeamUpGameService teamUpService = (ITeamUpGameService)ServiceManagerProxy.getService(ITeamUpGameService.class);
    private NobleColorService.NobleColorChangeListener mNobleColorChangeListener;
    Observer mRlObserver = new Observer<Map<Long, Point>>(){

        public void onChanged(@Nullable Map<Long, Point> longPointMap) {
            SeatPresenter.this.handleRealRlSeat(longPointMap);
        }
    };
    Observer mAbsObserver = new Observer<Map<Long, Point>>(){

        public void onChanged(@Nullable Map<Long, Point> longPointMap) {
            MLog.info((Object)"SeatPresenter", (String)("longPointMap :" + (longPointMap != null ? Integer.valueOf(longPointMap.size()) : "longPointMap == null")), (Object[])new Object[0]);
            SeatPresenter.this.handleRealAbsSeat(longPointMap);
        }
    };
    private ArrayList<Long> preLoadingUids;

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        mvpContext.getChannel().getMediaService().registerOnSpeakListener((VoiceCallBack)this);
        this.mRelativeSeatLocation.observe((LifecycleOwner)this.getLifeCycleOwner(), this.mRlObserver);
        this.mAbsoluteSeatLocation.observe((LifecycleOwner)this.getLifeCycleOwner(), this.mAbsObserver);
        this.preloadUserInfo(this.getSeatService().getSeatList());
        if (this.mNobleColorChangeListener == null) {
            this.mNobleColorChangeListener = new NoleakNobleColorChangeListener(this);
        }
        PrivilegeHelper.INSTANCE.getNobleColorService().setNobleColorChangeListener(this.mNobleColorChangeListener);
        PrivilegeHelper.INSTANCE.getNobleColorService().setCid(this.getChannelId());
    }

    public void updateSeatValues() {
        if (!FP.empty((Collection)((Collection)this.seats().getValue()))) {
            List seatItems = (List)this.seats().getValue();
            long maxValue = -1L;
            int maxIndex = -1;
            long maxUpdateTime = 0L;
            SeatItem maxValueSeatItem = null;
            for (int i = 0; i < seatItems.size(); ++i) {
                SeatItem seatItem = (SeatItem)seatItems.get(i);
                CalculatorData roomCharmValue = this.getChannel().getCalculatorService().getCharmValue(seatItem.uid);
                if (roomCharmValue != null) {
                    seatItem.mCalculatorData = roomCharmValue;
                    if (maxUpdateTime == 0L) {
                        maxUpdateTime = roomCharmValue.getUpdateTime();
                    }
                    if (roomCharmValue.getCalculatorValue() > maxValue) {
                        maxValue = roomCharmValue.getCalculatorValue();
                        maxValueSeatItem = seatItem;
                        maxIndex = i;
                        maxUpdateTime = roomCharmValue.getUpdateTime();
                    } else if (roomCharmValue.getCalculatorValue() == maxValue && roomCharmValue.getUpdateTime() != 0L && roomCharmValue.getUpdateTime() < maxUpdateTime) {
                        maxUpdateTime = roomCharmValue.getUpdateTime();
                        maxValue = roomCharmValue.getCalculatorValue();
                        maxValueSeatItem = seatItem;
                        maxIndex = i;
                    }
                } else {
                    seatItem.mCalculatorData.resetValue();
                }
                if (seatItem.uid != 0L && this.getChannel().getCalculatorService().isCalculatorOpen()) {
                    seatItem.mCalculatorData.setMCalculatorType(2L);
                    seatItem.mCalculatorData.setNeedLarge(true);
                }
                this.mUpdateOne.setValue((Object)i);
            }
            if (maxValueSeatItem != null && maxValueSeatItem.uid != 0L && this.getChannel().getCalculatorService().isCalculatorOpen() && maxValue > 0L) {
                maxValueSeatItem.mCalculatorData.setFirstCharmValue(true);
                this.mUpdateOne.setValue((Object)maxIndex);
            }
        }
    }

    private void init(long ownerId, SeatDataHolder holder) {
        this.mSeatDataHolder.update(holder);
        this.getNotifyDispatcher().addHandler((INotifyDispatchService.INotifyHandler)this);
    }

    public void setSeatVisibility(boolean show) {
        MLog.info((Object)TAG, (String)"setSeatVisibility %s", (Object[])new Object[]{show});
        if (this.mSeatViewContainer != null) {
            if (show) {
                if (this.mSeatViewContainer.getVisibility() != 0) {
                    this.seatVisibilityChanged(true);
                }
                this.mSeatViewContainer.setVisibility(0);
            } else {
                if (this.mSeatViewContainer.getVisibility() == 0) {
                    this.seatVisibilityChanged(false);
                }
                this.mSeatViewContainer.setVisibility(8);
            }
        }
    }

    protected void seatVisibilityChanged(boolean visiable) {
    }

    @Override
    public LiveData<List<SeatItem>> seats() {
        return this.mSeats;
    }

    public View getItemView(int index) {
        return this.mSeatViewContainer.getItemView(index);
    }

    @Override
    public String getRoomId() {
        return this.getChannel().getChannelId();
    }

    public MutableLiveData<Integer> updateOne() {
        return this.mUpdateOne;
    }

    @Override
    public void onAvatarClick(SeatItem item) {
        MLog.info((Object)TAG, (String)"onAvatarClick %s", (Object[])new Object[]{item});
        ((ProfileCardPresenter)this.getPresenter(ProfileCardPresenter.class)).showProfileCard(item.uid, true, OpenProfileFrom.FROM_SEAT);
    }

    @Override
    public void onOpenInviteList(SeatItem item) {
        MLog.info((Object)TAG, (String)"onOpenInviteList %s", (Object[])new Object[]{item});
        ((InvitePresenter)this.getPresenter(InvitePresenter.class)).showOnlineInvitePanel(new SeatInviteHandler((IChannel)this.getChannel(), item.index));
    }

    @Override
    public void onLockClick(final SeatItem item) {
        MLog.info((Object)TAG, (String)"onLockClick %s", (Object[])new Object[]{item});
        this.getSeatService().lockSeat(true, item.index, new IOperationCallback(){

            public void onSuccess() {
                item.statusFlag |= 1L;
                SeatPresenter.this.mUpdateOne.postValue((Object)(item.index - 1));
            }

            public void onFail(long reason) {
            }
        });
    }

    @Override
    public void onUnLockClick(final SeatItem item) {
        MLog.info((Object)TAG, (String)"onUnLockClick %s", (Object[])new Object[]{item});
        this.getSeatService().lockSeat(false, item.index, new IOperationCallback(){

            public void onSuccess() {
                item.statusFlag &= 0xFFFFFFFFFFFFFFFEL;
                SeatPresenter.this.mUpdateOne.postValue((Object)(item.index - 1));
            }

            public void onFail(long reason) {
            }
        });
    }

    @Override
    public void setInterceptListener(SeatMvp.IPresenter.OnInterceptListener interceptListener) {
        this.mInterceptListener = interceptListener;
    }

    @Override
    public void onStandUp() {
        MLog.info((Object)TAG, (String)"onStandUp my uid %s", (Object[])new Object[]{AccountUtil.getUid()});
        if (!NetworkUtils.isNetworkAvailable((Context)this.getContext())) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        if (this.mInterceptListener == null) {
            this.processStandUp();
        } else if (!this.mInterceptListener.isIntercepted()) {
            this.processStandUp();
        }
    }

    private void processStandUp() {
        MLog.info((Object)TAG, (String)"processStandUp uid %s", (Object[])new Object[]{AccountUtil.getUid()});
        this.getSeatService().standUp(null);
    }

    protected boolean isSupportGame() {
        return true;
    }

    @Override
    public boolean onSitDown(final int index, final Callback<Integer> callback2) {
        MLog.info((Object)TAG, (String)"onSitDown index %d, callback %s", (Object[])new Object[]{index, callback2});
        boolean isSupport = this.isSupportGame();
        MLog.info((Object)TAG, (String)"is Support Game %b", (Object[])new Object[]{isSupport});
        if (!NetworkUtils.isNetworkAvailable((Context)this.getContext())) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            this.isSitDownRequiring = false;
            return false;
        }
        if (!isSupport) {
            ToastUtils.showToast((Context)this.getContext(), (int)R.string.short_tips_game_not_compat);
            return false;
        }
        if (this.isSitDownRequiring) {
            ToastUtils.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.tips_operating_too_fast), (int)0);
            return false;
        }
        this.isSitDownRequiring = true;
        if (this.getSeatService().isInSeat(AccountUtil.getUid())) {
            this.changeSeat(index, new Callback<Boolean>(){

                public void onResponse(Boolean isSuccess) {
                    if (isSuccess.booleanValue()) {
                        if (callback2 != null) {
                            callback2.onResponse((Object)index);
                        }
                    } else if (callback2 != null) {
                        callback2.onResponse(null);
                    }
                    SeatPresenter.this.isSitDownRequiring = false;
                }
            });
        } else {
            RecommendEnterData recommendEnterData;
            this.getSeatService().sitDown(index, (Callback)new Callback<Integer>(){

                public void onResponse(Integer data2) {
                    PathTimeAdjustExperiment experiment;
                    if (callback2 != null) {
                        callback2.onResponse((Object)data2);
                    }
                    if (data2 != null && (experiment = PathTimeAdjustExperiment.Companion.newExperiment()) != null) {
                        experiment.onSitdown();
                    }
                    SeatPresenter.this.isSitDownRequiring = false;
                }
            });
            String token = "";
            if (this.getChannel() != null && this.getChannel().getEnterParam() != null && (recommendEnterData = (RecommendEnterData)this.getChannel().getEnterParam().getExtra("from_recommend_info", null)) != null) {
                token = recommendEnterData.getToken();
            }
            SeatTrack.INSTANCE.upVoiceClick(this.getRoomId(), "2", token);
        }
        return true;
    }

    private void changeSeat(int seat, Callback<Boolean> callback2) {
        this.getSeatService().changeSeat(seat, callback2);
    }

    public void onClickCalculator(long uid, String name, CalculatorData data2) {
    }

    protected boolean shouldUpdateSeats() {
        boolean isChanged;
        SeatDataHolder holder = new SeatDataHolder(this.getSeatService().isInSeat(this.getChannelDetailInfo().baseInfo.ownerUid), this.getSeatService().getSeatUidsList(), this.getSeatService().getSeatStatusList());
        boolean bl = isChanged = FP.empty((Collection)((Collection)this.mSeats.getValue())) || !SeatDataHolder.isEqual(this.mSeatDataHolder, holder);
        if (isChanged) {
            this.mSeatDataHolder.update(holder);
        }
        return isChanged;
    }

    private void updateSeat() {
        if (this.shouldUpdateSeats()) {
            MLog.info((Object)TAG, (String)"updateSeat data: %s, in seat:%b, speak %s", (Object[])new Object[]{this.mSeatDataHolder, this.getSeatService().isInSeat(AccountUtil.getUid()), this.mSpeak});
            this.updateSeatInner();
        }
    }

    public void playSeatAnimation(long uid, int animationType, String svgaUrl) {
        int position = 0;
        List seatItems = (List)this.mSeats.getValue();
        if (FP.empty((Collection)seatItems) || this.mSeatViewWrapper == null) {
            return;
        }
        for (int i = 0; i < seatItems.size(); ++i) {
            if (uid != ((SeatItem)seatItems.get((int)i)).uid) continue;
            position = i;
            break;
        }
        this.mSeatViewWrapper.playAnimation(position, animationType, svgaUrl);
    }

    private void updateSeatInner() {
        List seatUids = this.getSeatService().getSeatUidsList();
        ArrayList<Long> validIdList = new ArrayList<Long>(FP.size((Collection)seatUids));
        ArrayList<Long> inValidIdList = null;
        for (Long item : seatUids) {
            if (item != null && item > 0L) {
                validIdList.add(item);
                continue;
            }
            if (inValidIdList == null) {
                inValidIdList = new ArrayList<Long>(8);
            }
            inValidIdList.add(item);
        }
        if (this.mProfileCallback != null) {
            this.mProfileCallback.onDestroy();
        }
        this.mProfileCallback = new InnerOnProfileCallback(this);
        if (inValidIdList != null) {
            MLog.info((Object)TAG, (String)"updateSeat in seat: %b, invalidIdList: %s", (Object[])new Object[]{this.getSeatService().isInSeat(AccountUtil.getUid()), inValidIdList});
        }
        if (FP.empty((Collection)((Collection)this.mSeats.getValue()))) {
            this.mSeats.setValue(this.getSeatItems());
        }
        if (this.preLoadingUids == null || !this.preLoadingUids.equals(seatUids)) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(validIdList, (OnProfileCallback)this.mProfileCallback);
        } else if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"\u5ea7\u4f4d\u7528\u6237\u83b7\u53d6\u4e2a\u4eba\u8d44\u6599\u547d\u4e2d\u9884\u52a0\u8f7d", (Object[])new Object[0]);
        }
    }

    private void onUserListResponse(List<UserInfoKS> list2) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUserListResponse %s", (Object[])new Object[]{list2});
        }
        List<SeatItem> seatItems = this.getSeatItems();
        PrivilegeHelper.INSTANCE.fetchMultiUserNickColorPrivilegeForSeat(seatItems);
        IUserInfoService service = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        PrivilegeHelper.INSTANCE.fetchNobleColors(seatItems);
        for (SeatItem item : seatItems) {
            UserInfoKS infoKS;
            if (item.uid <= 0L || (infoKS = this.getNewInfo(item.userInfo, list2)) == null) continue;
            item.userInfo = service.getUserInfo(infoKS.uid);
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUserListResponse post value %s", (Object[])new Object[]{seatItems});
        }
        this.mSeats.setValue(seatItems);
    }

    protected List<SeatItem> getSeatItems() {
        List<SeatItem> seatItems = this.createSeatItems(this.getSeatService().getSeatList());
        if (seatItems.size() > 0) {
            SeatItem seatItem = seatItems.get(0);
            if (!this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid()) && !this.getChannel().getRoleService().isMeAnchor() && this.isNeedLock()) {
                seatItem.statusFlag |= 1L;
            }
        }
        return seatItems;
    }

    protected boolean isNeedLock() {
        return true;
    }

    public ISeatService getSeatService() {
        if (this.mSeatService == null) {
            this.mSeatService = ((IChannelPageContext)this.getMvpContext()).getChannel().getSeatService();
        }
        return this.mSeatService;
    }

    protected void initSeat(@NonNull SeatItem item, @Nonnull SeatUser seatUser) {
        item.uid = seatUser.uid;
        item.statusFlag = seatUser.status;
        item.index = seatUser.index;
        item.ts = seatUser.ts;
        item.roleType = this.getChannel().getRoleService().getRoleCache(seatUser.uid);
        item.isSpeaking = SeatStatusUtils.isMicOpen((long)item.statusFlag) && SPEAKING.equals(this.mSpeak.get(item.uid));
        item.userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(item.uid);
        if (item.uid != 0L) {
            CalculatorData pkCalculatorData = this.getChannel().getCalculatorService().getCharmValue(item.uid);
            if (pkCalculatorData != null) {
                item.mCalculatorData = pkCalculatorData;
            } else {
                item.mCalculatorData.resetValue();
            }
        }
        if (item.uid != 0L && this.getChannel().getCalculatorService().isCalculatorOpen()) {
            item.mCalculatorData.setMCalculatorType(2L);
            item.mCalculatorData.setNeedLarge(true);
        }
    }

    protected List<SeatItem> createSeatItems(List<SeatUser> seatList) {
        ArrayList<SeatItem> seatItems = new ArrayList<SeatItem>(seatList.size());
        for (SeatUser seatUser : seatList) {
            SeatItem item = new SeatItem();
            this.initSeat(item, seatUser);
            seatItems.add(item);
        }
        return seatItems;
    }

    private UserInfoKS getNewInfo(UserInfoKS info, List<UserInfoKS> list2) {
        for (UserInfoKS item : list2) {
            if (info.uid != item.uid) continue;
            return item;
        }
        return null;
    }

    @Override
    public void autoInviteOnSitDown(final String gid) {
        if (RuntimeContext.isHagoPartySdk()) {
            return;
        }
        List<SeatItem> seatItems = this.getSeatItems();
        if (FP.empty(seatItems) || seatItems.get((int)0).uid == 0L) {
            MLog.info((Object)TAG, (String)"autoInviteOnSitDown seat is no body", (Object[])new Object[0]);
            return;
        }
        if (this.mSeatService.isInSeat(AccountUtil.getUid())) {
            MLog.info((Object)TAG, (String)"current user is inSeat", (Object[])new Object[0]);
            return;
        }
        if (this.getChannelDetailInfo() == null || this.getChannelDetailInfo().baseInfo == null) {
            MLog.info((Object)TAG, (String)"autoInviteOnSitDown getChannelDetailInfo is null", (Object[])new Object[0]);
            return;
        }
        if (this.getSeatViewContainer().getVisibility() != 0) {
            MLog.info((Object)TAG, (String)"autoInviteOnSitDown seatViewContainer not visible", (Object[])new Object[0]);
            return;
        }
        int mode = this.getChannel().getPluginService().getCurPluginData().getMode();
        if (!ChannelDefine.AUTO_INVITE_SEAT.contains(mode)) {
            MLog.info((Object)TAG, (String)("mode = " + mode + " is not support"), (Object[])new Object[0]);
            return;
        }
        String userNick = seatItems.get((int)0).userInfo.nick;
        if (this.mDialogLinkManager == null || !this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager = new DialogLinkManager((Context)this.getContext());
            String msg = userNick + " ";
            if ("chat".equals(gid)) {
                msg = msg + ResourceUtils.getString((int)R.string.channel_invite_mic_chat);
            } else if ("ktv".equals(gid)) {
                msg = msg + ResourceUtils.getString((int)R.string.channel_invite_mic_sing);
            } else if (GameInfo.ROOM_GAME_LIST.contains(gid) || mode == 400) {
                msg = msg + ResourceUtils.getString((int)R.string.channel_invite_mic_play_game);
            } else {
                MLog.info((Object)TAG, (String)"autoInviteOnSitDown gid not match", (Object[])new Object[0]);
                return;
            }
            OkCancelDialog dialog2 = new OkCancelDialog.Builder().cancelable(true).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_refuse)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_agree)).message((CharSequence)msg).listener(new OkCancelDialogListener(){

                public void onCancel() {
                    SeatTrack.INSTANCE.reportInviteTakeSeatRejectClick(gid);
                    int times = SettingFlags.getIntValue((String)"key_refuse_auto_invite_mic");
                    SettingFlags.setIntValue((String)"key_refuse_auto_invite_mic", (int)(++times));
                    MLog.info((Object)SeatPresenter.TAG, (String)("autoInviteOnSitDown onCancel times = " + times), (Object[])new Object[0]);
                }

                public void onOk() {
                    MLog.info((Object)SeatPresenter.TAG, (String)"autoInviteOnSitDown onOK", (Object[])new Object[0]);
                    try {
                        SeatTrack.INSTANCE.reportInviteTakeSeatOkClick(gid);
                        SeatPresenter.this.onSitDown(-1, null);
                    }
                    catch (Exception e) {
                        MLog.error((Object)SeatPresenter.TAG, (String)"autoInviteOnSitDown error", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }).build();
            if (this.mSeatService.isSeatFullWithLocked()) {
                MLog.info((Object)TAG, (String)"no empty seat", (Object[])new Object[0]);
                return;
            }
            if (((IChannelPageContext)this.getMvpContext()).getLifecycle().getCurrentState() == Lifecycle.State.RESUMED) {
                SeatTrack.INSTANCE.reportInviteTakeSeatPop(gid);
                this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
                YYTaskExecutor.execute(() -> {
                    int count = SettingFlags.getIntValue((String)"key_auto_invite_mic_count", (int)0);
                    SettingFlags.setIntValue((String)"key_auto_invite_mic_count", (int)(++count));
                    SettingFlags.setLongValue((String)"key_last_day_auto_invite_mic", (long)System.currentTimeMillis());
                });
            } else {
                MLog.info((Object)TAG, (String)"autoInviteOnSitDown cancel cause not resume", (Object[])new Object[0]);
            }
        }
    }

    public void onSpeakingChanged(Map<Long, Integer> speakList, int streamType) {
        MLog.debug((Object)TAG, (String)"onSpeakingChanged speakList %s, streamType %d", (Object[])new Object[]{speakList, streamType});
        HashMap<Long, Boolean> speak = new HashMap<Long, Boolean>(FP.size(speakList));
        if (!FP.empty(speakList)) {
            for (Long id2 : speakList.keySet()) {
                speak.put(id2, speakList.get(id2) == 1);
            }
        }
        this.updateSpeaking(speakList);
    }

    protected boolean isSpeaking(Long uid) {
        return SPEAKING.equals(this.mSpeak.get(uid));
    }

    private void updateSpeaking(Map<Long, Integer> speak) {
        this.mSpeak = speak;
        List items = (List)this.mSeats.getValue();
        if (!FP.empty((Collection)items)) {
            for (int i = 0; i < items.size(); ++i) {
                boolean isSpeaking;
                SeatItem item = (SeatItem)items.get(i);
                Integer status = speak != null ? speak.get(item.uid) : null;
                item.isSpeaking = isSpeaking = speak != null && status != null && 1 == status;
                if (this.mSeatViewWrapper == null) continue;
                if (isSpeaking) {
                    this.mSeatViewWrapper.startSpeakingAnimation(i);
                    continue;
                }
                this.mSeatViewWrapper.stopSpeakingAnimation(i);
            }
        }
    }

    @Override
    public void updateSeatViewLocation(Map<Long, Point> absoluteMap, Map<Long, Point> relativeMap) {
        MLog.info((Object)"SeatPresenter", (String)("updateSeatViewLocation absoluteMapSize:" + (absoluteMap != null ? Integer.valueOf(absoluteMap.size()) : "absoluteMap == null")), (Object[])new Object[0]);
        this.mAbsoluteSeatLocation.setValue(absoluteMap);
        this.mRelativeSeatLocation.setValue(relativeMap);
    }

    private SeatItem getSeatItem(long uid) {
        if (!FP.empty((Collection)((Collection)this.mSeats.getValue()))) {
            for (SeatItem item : (List)this.mSeats.getValue()) {
                if (item.uid != uid) continue;
                return item;
            }
        }
        return null;
    }

    public void onHandleNotify(ChannelNotify notify2) {
        if (notify2 == null || notify2.notify == null) {
            return;
        }
        int uri = notify2.uri;
        if (uri == ChannelNotify.Uri.UriSitDownPlzNotify) {
            this.handleSitDownPlz(notify2.notify.sitDownPlz);
        } else if (uri == ChannelNotify.Uri.UriStandUpPlzNotify) {
            FeatureLog.i((String)TAG, (String)"handleMakeStandUp", (Object[])new Object[0]);
            this.handleStandUpPlz(notify2.notify.standUpPlz);
        } else if (uri == ChannelNotify.Uri.UriSitDownPlzAcceptNotify) {
            FeatureLog.i((String)TAG, (String)"handleSitDownAccept", (Object[])new Object[0]);
            this.handleSitDownPlzAccept(notify2.notify.sitDownPlzAccept);
        }
    }

    private void handleSitDownPlz(NotifyDataDefine.SitDownPlzNotify notify2) {
        MLog.info((Object)TAG, (String)"handleSitDownPlz", (Object[])new Object[0]);
        if (this.isSupportGame() && !this.isChannelMinimise() && !this.skipSitDownDialog(notify2.plzId)) {
            this.showSitDownPlzDialog(notify2.plzId);
        }
    }

    private boolean isChannelMinimise() {
        Object isPlaying = MsgDispatcher.getInstance().sendMessageSync(ChannelBaseMsgDef.CHANNEL_MINIMISE_STATUS);
        if (isPlaying instanceof Boolean) {
            return (Boolean)isPlaying;
        }
        return false;
    }

    private void handleStandUpPlz(NotifyDataDefine.StandUpPlzNotify notify2) {
        ToastUtils.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_seat_be_stand_up), (int)0);
        IEnteredChannel channel = this.getChannel();
        if (channel != null && channel.getTeamUpService() != null && channel.getTeamUpService().isTeamUpGroup()) {
            ChannelTrack.INSTANCE.standUpInTeamUpGroup(false);
        }
    }

    private void handleSitDownPlzAccept(NotifyDataDefine.SitDownPlzAcceptNotify notify2) {
        MLog.info((Object)TAG, (String)"handleSitDownPlzAccept accept: %b, seat: %s, uid: %s", (Object[])new Object[]{notify2.accept, notify2.seat, notify2.uid});
        UserInfoKS userInfoBean = ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).getUserInfo(notify2.uid);
        if (userInfoBean != null && userInfoBean.ver > 0L) {
            if (notify2.accept) {
                if (notify2.seat > 0) {
                    ToastUtils.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_sit_down_accept, (Object[])new Object[]{userInfoBean.nick}), (int)0);
                }
            } else {
                ToastUtils.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.short_tips_sit_down_refuse, (Object[])new Object[]{userInfoBean.nick}), (int)0);
            }
        }
    }

    private boolean skipSitDownDialog(String plzId) {
        IEnteredChannel channel = this.getChannel();
        if (channel != null && channel.getTeamUpService().isTeamUpGroup() && channel.getGroupPlayService().isMeInWaitSeat()) {
            this.getSeatService().applySitDownPlz(plzId, true, (Callback)new Callback<Integer>(){

                public void onResponse(Integer realSeat) {
                    MLog.info((Object)SeatPresenter.TAG, (String)"showSitDownPlzDialog acceptSitDownPlz seatL %s", (Object[])new Object[]{realSeat});
                    if (realSeat != null) {
                        MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.RESUME_CUR_CHANNEL);
                        SeatPresenter.this.sitDownEvent();
                        SeatPresenter.this.teamUpAdminInviteUpMicReport(true);
                    } else {
                        SeatPresenter.this.teamUpAdminInviteUpMicReport(false);
                    }
                }
            });
            return true;
        }
        return false;
    }

    private void teamUpAdminInviteUpMicReport(boolean success) {
        IEnteredChannel channel = this.getChannel();
        if (channel != null && channel.getTeamUpService().isTeamUpGroup()) {
            ChannelTrack.INSTANCE.sitDownPlzInTeamUpGroup(success);
        }
    }

    protected void showSitDownPlzDialog(final String plzId) {
        MLog.info((Object)TAG, (String)"showSitDownPlzDialog plzIc %s", (Object[])new Object[]{plzId});
        if (this.mDialogLinkManager == null || !this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager = new DialogLinkManager((Context)this.getContext());
            OkCancelDialog dialog2 = new OkCancelDialog.Builder().cancelable(true).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.btn_no)).message((CharSequence)ResourceUtils.getString((int)R.string.summary_room_invite_to_sit)).listener(new OkCancelDialogListener(){

                public void onCancel() {
                    MLog.info((Object)SeatPresenter.TAG, (String)"showSitDownPlzDialog onCancel", (Object[])new Object[0]);
                    SeatPresenter.this.getSeatService().applySitDownPlz(plzId, false, null);
                    SeatTrack.INSTANCE.downInviteNoClick(SeatPresenter.this.getRoomId());
                    SeatPresenter.this.teamUpAdminInviteUpMicReport(false);
                }

                public void onOk() {
                    MLog.info((Object)SeatPresenter.TAG, (String)"showSitDownPlzDialog onOK", (Object[])new Object[0]);
                    SeatPresenter.this.getSeatService().applySitDownPlz(plzId, true, (Callback)new Callback<Integer>(){

                        public void onResponse(Integer realSeat) {
                            MLog.info((Object)SeatPresenter.TAG, (String)"showSitDownPlzDialog acceptSitDownPlz seatL %s", (Object[])new Object[]{realSeat});
                            MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.RESUME_CUR_CHANNEL);
                            SeatPresenter.this.teamUpAdminInviteUpMicReport(true);
                        }
                    });
                    SeatTrack.INSTANCE.downInviteYesClick(SeatPresenter.this.getRoomId());
                    IChannelCenterService channelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
                    if (channelCenterService != null) {
                        channelCenterService.getNewGuideManager().onInviteSitdownAccept(SeatPresenter.this.getChannelId());
                    }
                }
            }).build();
            this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
            SeatTrack.INSTANCE.downInviteShow(this.getRoomId());
            IChannelCenterService channelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
            if (channelCenterService != null) {
                channelCenterService.getNewGuideManager().onInviteSitdownShow(this.getChannelId());
            }
        }
    }

    protected void sitDownEvent() {
        IEnteredChannel channel = this.getChannel();
        if (channel != null) {
            TeamUpCardItemList list2;
            if (channel.getRoleService().isOwnerOrMaster(AccountUtil.getUid())) {
                return;
            }
            if (channel.getTeamUpService().isTeamUpGroup() && (list2 = (TeamUpCardItemList)this.teamUpService.data().getTeamUpCardMap().get(channel.getChannelId())) != null) {
                for (int i = 0; i < list2.getGameInfoList().size(); ++i) {
                    if (((TeamUpCardItemBean)list2.getGameInfoList().get(i)).getLeader() != AccountUtil.getUid()) continue;
                    return;
                }
                UserInfoKS userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
                this.teamUpService.createTeamUpCard(channel.getChannelId(), ResourceUtils.getString((int)R.string.title_up_mic_create_team_up_room, (Object[])new Object[]{userInfo.nick}), TeamUpCommonConfig.Companion.getDefaultGame());
            }
        }
    }

    public void onRoleChanged(String channelId, long uid, int roleType) {
        MLog.info((Object)TAG, (String)"onRoleChanged channel: %s, uid: %d, role %d", (Object[])new Object[]{channelId, uid, roleType});
        this.refreshSeat();
    }

    public MutableLiveData<Map<Long, Point>> getSeatLocation(boolean isAbsolute) {
        return isAbsolute ? this.mAbsoluteSeatLocation : this.mRelativeSeatLocation;
    }

    @Override
    public int getSeatFaceSize(long uid) {
        if (this.mSeatViewContainer != null) {
            return this.mSeatViewContainer.getSeatFaceSize();
        }
        return 0;
    }

    public int[] getSeatViewPosition() {
        if (this.mSeatViewContainer != null) {
            return this.mSeatViewContainer.getSeatViewPosition();
        }
        return new int[]{-1, -1};
    }

    @Override
    public void showGoldenBeansSvgaAnim(long uid) {
        List items = (List)this.mSeats.getValue();
        if (!FP.empty((Collection)items)) {
            for (int i = 0; i < items.size(); ++i) {
                SeatItem item = (SeatItem)items.get(i);
                if (item.uid != uid) continue;
                item.payLoad = new SeatGoldenAnimInfo();
                this.updateOne().setValue((Object)i);
                break;
            }
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    void onWindowPause() {
        MLog.info((Object)TAG, (String)"onWindowPause", (Object[])new Object[0]);
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach) {
            SeatDataHolder holder = new SeatDataHolder(false, this.getSeatService().getSeatUidsList(), this.getSeatService().getSeatStatusList());
            this.init(this.getChannelDetailInfo().baseInfo.ownerUid, holder);
            YYTaskExecutor.postToMainThread(() -> {
                if (!this.isDestroyed()) {
                    this.getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
                }
            });
        }
        if (isReAttach && this.mSeatViewWrapper != null) {
            this.mSeatViewWrapper.updateSeats((List)this.mSeats.getValue());
        }
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        MLog.debug((Object)TAG, (String)"onSeatUpdate", (Object[])new Object[0]);
        this.updateSeat();
        if (!FP.empty((Collection)this.getSeatService().getSeatUidsList())) {
            this.checkAutoStandUp(this.getSeatService().getSeatUidsList());
        }
        String channelId = this.getChannelId();
        int mySeatIndex = this.getSeatService().getSeatIndex(AccountUtil.getUid());
        RuntimeContext.setSeatIndex((String)channelId, (int)mySeatIndex);
        if (mySeatIndex > 0) {
            RuntimeContext.startRecord((String)channelId, (int)2);
        } else {
            RuntimeContext.stopRecord((String)channelId, (int)2);
        }
    }

    private void checkAutoStandUp(List<Long> uids) {
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"checkAutoStandUp my uid %s, uids %s", (Object[])new Object[]{AccountUtil.getUid(), uids});
        }
        if (uids.contains(AccountUtil.getUid()) && !this.isSupportGame()) {
            MLog.info((Object)TAG, (String)"setSeatMode \u4e0d\u517c\u5bb9\u6e38\u620f\uff0c\u4e0b\u9ea6", (Object[])new Object[0]);
            this.getSeatService().standUp(null);
            ToastUtils.showToast((Context)this.getContext(), (int)R.string.short_tips_game_not_compat);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mSeatViewWrapper != null) {
            this.mSeatViewWrapper.destroy();
            this.mSeatViewWrapper = null;
        }
        if (this.isPageSupportReuse() && this.mSeatViewContainer != null) {
            this.mSeatViewContainer.resetViewState();
        }
        if (this.mProfileCallback != null) {
            this.mProfileCallback.onDestroy();
        }
        this.getChannel().getMediaService().unregisterOnSpeakListener((VoiceCallBack)this);
        this.getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
        this.getNotifyDispatcher().removeHandler((INotifyDispatchService.INotifyHandler)this);
        PrivilegeHelper.INSTANCE.getNobleColorService().setNobleColorChangeListener(null);
        this.mNobleColorChangeListener = null;
        RuntimeContext.stopRecord((String)this.getChannelId(), (int)2);
        this.mSeatViewContainer = null;
    }

    protected FragmentActivity getContext() {
        return ((IChannelPageContext)this.getMvpContext()).getContext();
    }

    public void refreshSeat() {
        this.updateSeatInner();
    }

    @Override
    public SeatViewContainer getSeatViewContainer() {
        return this.mSeatViewContainer;
    }

    @Override
    public LiveData<Boolean> getClipViewData() {
        return this.mClipViewData;
    }

    @Override
    public boolean hasManagerPermission() {
        return this.getChannel().getPermissionService().hasPermission(AccountUtil.getUid(), new RolePermission[]{RolePermission.MANAGE_SEAT}) || AccountUtil.getUid() == this.getChannelDetailInfo().baseInfo.ownerUid;
    }

    @Override
    public void checkManagerPermission(Callback<Boolean> callback2) {
        this.getChannel().getPermissionService().fetchRolePermission(AccountUtil.getUid(), data2 -> callback2.onResponse((Object)this.hasManagerPermission()));
    }

    public void setClipView(boolean clip) {
        this.mClipViewData.setValue((Object)clip);
    }

    @Override
    public boolean needUpdateSeatLocation() {
        ChannelPluginData pluginData = this.getChannel().getPluginService().getCurPluginData();
        return !pluginData.isStarted() || 100 == pluginData.mode || 300 == pluginData.mode;
    }

    @NotNull
    public void setContainer(@NonNull View container) {
        if (container instanceof YYPlaceHolderView) {
            this.mSeatViewContainer = new SeatViewContainer((Context)this.getContext());
            ((YYPlaceHolderView)container).inflate((View)this.mSeatViewContainer);
        } else if (this.mSeatViewContainer == null && container instanceof SeatViewContainer) {
            ChannelUtils.checkReuseViewType(container.getClass());
            this.mSeatViewContainer = (SeatViewContainer)container;
        }
        if (this.mSeatViewWrapper != null) {
            this.setSeatViewWrapper(this.mSeatViewWrapper);
        } else {
            this.setSeatViewWrapper(this.createSeatViewWrapper());
        }
        this.mSeatViewContainer.setPresenter(this);
    }

    protected void setSeatViewWrapper(T seatViewWrapper) {
        if (seatViewWrapper != this.mSeatViewWrapper) {
            this.mSeatViewWrapper = seatViewWrapper;
        }
        if (this.mSeatViewContainer != null) {
            this.mSeatViewContainer.setSeatView((ISeatViewWrapper)this.mSeatViewWrapper);
        }
        YYTaskExecutor.postToMainThread(this::refreshSeat);
    }

    protected void handleRealAbsSeat(Map<Long, Point> mSeat) {
        HashMap<Long, FacePoint> mSeatPointMap = new HashMap<Long, FacePoint>();
        if (mSeat != null) {
            Set<Long> keySet = mSeat.keySet();
            for (long uid : keySet) {
                FacePoint facePoint = new FacePoint();
                Point point = mSeat.get(uid);
                if (null == point) continue;
                facePoint.x = point.x;
                facePoint.y = point.y;
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)TAG, (String)("normalX: " + facePoint.x + " normalY: " + facePoint.y), (Object[])new Object[0]);
                }
                int faceSize = ((SeatPresenter)this.getPresenter(SeatPresenter.class)).getSeatFaceSize(uid);
                facePoint.setWidth(faceSize);
                facePoint.setHeight(faceSize);
                facePoint.setType(0);
                mSeatPointMap.put(uid, facePoint);
            }
        }
        this.mRealAbsSeatMapLocation.setValue(mSeatPointMap);
    }

    protected void handleRealRlSeat(Map<Long, Point> mSeat) {
        HashMap<Long, FacePoint> mSeatPointMap = new HashMap<Long, FacePoint>(FP.size(mSeat));
        if (mSeat != null) {
            Set<Long> keySet = mSeat.keySet();
            for (long uid : keySet) {
                FacePoint facePoint = new FacePoint();
                Point point = mSeat.get(uid);
                if (null == point) continue;
                facePoint.x = point.x;
                facePoint.y = point.y;
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)TAG, (String)("normalX: " + facePoint.x + " normalY: " + facePoint.y), (Object[])new Object[0]);
                }
                int faceSize = ((SeatPresenter)this.getPresenter(SeatPresenter.class)).getSeatFaceSize(uid);
                facePoint.setWidth(faceSize);
                facePoint.setHeight(faceSize);
                facePoint.setType(0);
                mSeatPointMap.put(uid, facePoint);
            }
        }
        this.mRealRelSeatMapLocation.setValue(mSeatPointMap);
    }

    protected abstract T createSeatViewWrapper();

    public MutableLiveData<Map<Long, FacePoint>> getRealAbsSeatMapLocation() {
        return this.mRealAbsSeatMapLocation;
    }

    public MutableLiveData<Map<Long, FacePoint>> getRealRelSeatMapLocation() {
        return this.mRealRelSeatMapLocation;
    }

    @Override
    public LiveData<Boolean> canCalculateSeatLocation() {
        return this.mCanCalculateSeatLocation;
    }

    public void setCanSetSeatLocation(boolean canSetSeatLocation) {
        this.mCanCalculateSeatLocation.setValue((Object)canSetSeatLocation);
    }

    private void preloadUserInfo(List<SeatUser> usersInSeat) {
        if (usersInSeat != null && usersInSeat.size() > 0) {
            ArrayList<Long> uids = new ArrayList<Long>(usersInSeat.size());
            for (SeatUser user : usersInSeat) {
                if (user == null) continue;
                uids.add(user.uid);
            }
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)TAG, (String)"\u5ea7\u4f4d\u7528\u6237\u83b7\u53d6\u4e2a\u4eba\u8d44\u6599\u9884\u52a0\u8f7d!", (Object[])new Object[0]);
            }
            this.preLoadingUids = uids;
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, (OnProfileCallback)WeakProfileCallback.of((IDestroyable)this, (OnProfileCallback)new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    if (SeatPresenter.this.mProfileCallback != null && SeatPresenter.this.mSeatDataHolder != null && SeatPresenter.this.preLoadingUids.equals(((SeatPresenter)SeatPresenter.this).mSeatDataHolder.uidList)) {
                        if (RuntimeContext.isInGray()) {
                            MLog.info((Object)SeatPresenter.TAG, (String)"\u5ea7\u4f4d\u7528\u6237\u83b7\u53d6\u4e2a\u4eba\u8d44\u6599\u9884\u52a0\u8f7dSuccess 1!", (Object[])new Object[0]);
                        }
                        SeatPresenter.this.mProfileCallback.onSuccess(id2, userInfoKSList);
                    } else if (RuntimeContext.isInGray()) {
                        MLog.info((Object)SeatPresenter.TAG, (String)"\u5ea7\u4f4d\u7528\u6237\u83b7\u53d6\u4e2a\u4eba\u8d44\u6599\u9884\u52a0\u8f7dSuccess 2!", (Object[])new Object[0]);
                    }
                    SeatPresenter.this.preLoadingUids = null;
                }

                public void onFail(int id2, String msg, String response) {
                    if (SeatPresenter.this.mProfileCallback != null && SeatPresenter.this.mSeatDataHolder != null && SeatPresenter.this.preLoadingUids.equals(((SeatPresenter)SeatPresenter.this).mSeatDataHolder.uidList)) {
                        SeatPresenter.this.mProfileCallback.onFail(id2, msg, response);
                    }
                    SeatPresenter.this.preLoadingUids = null;
                }

                public boolean notUseAggregate() {
                    return true;
                }
            }));
        }
    }

    private static class InnerOnProfileCallback
    implements OnProfileCallback {
        private WeakReference<SeatPresenter> mWeakReference;

        InnerOnProfileCallback(SeatPresenter seatPresenter) {
            this.mWeakReference = new WeakReference<SeatPresenter>(seatPresenter);
        }

        public void onSuccess(int id2, List<UserInfoKS> userInfoKS) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)SeatPresenter.TAG, (String)"InnerOnProfileCallback  %s, onSuccess, userInfoKS: %s", (Object[])new Object[]{this, userInfoKS});
            }
            this.onResponse(FP.empty(userInfoKS) ? Collections.emptyList() : userInfoKS);
        }

        public void onFail(int id2, String msg, String response) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)SeatPresenter.TAG, (String)"InnerOnProfileCallback %s, onFail, msg: %s, response: %s", (Object[])new Object[]{this, msg, response});
            }
            this.onResponse(Collections.emptyList());
        }

        public int id() {
            return 0;
        }

        private void onResponse(@Nonnull List<UserInfoKS> list2) {
            SeatPresenter presenter;
            SeatPresenter seatPresenter = presenter = this.mWeakReference != null ? (SeatPresenter)this.mWeakReference.get() : null;
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)SeatPresenter.TAG, (String)"InnerOnProfileCallback %s, onResponse presenter %s", (Object[])new Object[]{this, presenter});
            }
            if (presenter != null && !presenter.isDestroyed()) {
                presenter.onUserListResponse(list2);
            }
        }

        private void onDestroy() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.info((Object)SeatPresenter.TAG, (String)"InnerOnProfileCallback %s, onDestroy", (Object[])new Object[]{this});
            }
            this.mWeakReference = null;
        }

        public String toString() {
            return "InnerOnProfileCallback{mWeakReference=" + this.mWeakReference + ",isDestroy=" + (this.mWeakReference == null || this.mWeakReference.get() == null) + '}';
        }
    }

    private static class NoleakNobleColorChangeListener
    implements NobleColorService.NobleColorChangeListener {
        private WeakReference<SeatPresenter> seatPresenterRef;

        public NoleakNobleColorChangeListener(SeatPresenter seatPresenter) {
            this.seatPresenterRef = new WeakReference<SeatPresenter>(seatPresenter);
        }

        public void onNotify(long uid, @NotNull NobleColorConfig nobleColor) {
            if (this.seatPresenterRef != null && this.seatPresenterRef.get() != null) {
                try {
                    SeatPresenter seatPresenter = (SeatPresenter)this.seatPresenterRef.get();
                    List items = (List)seatPresenter.mSeats.getValue();
                    if (!FP.empty((Collection)items)) {
                        for (SeatItem seatItem : items) {
                            if (seatItem.uid != uid) continue;
                            seatItem.nobleColor.postValue((Object)nobleColor);
                        }
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)SeatPresenter.TAG, (String)"NobleColorChangeListener notify error", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
    }
}

