/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat;

import android.graphics.Point;
import android.util.Pair;
import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.common.Callback;
import com.yy.hiyo.channel.base.callback.ICalculatorCallback;
import com.yy.hiyo.channel.component.seat.SeatViewContainer;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.mvp.base.IMvp;
import java.util.List;
import java.util.Map;

public interface SeatMvp {

    public static interface IGamePresenter
    extends IMvp.IPresenter {
        public static final int COUNT_DOWN_FROM = 5;

        public void setPrepareState(Pair<Boolean, String> var1);

        public void onGamePrepareAction();

        public LiveData<Pair<Boolean, String>> prepareState();

        public LiveData<GameInfo> gameInfo();

        public LiveData<Integer> gameProgress();

        public void setGameProgress(@IntRange(from=0L, to=100L) int var1);

        public MutableLiveData<String> gameSubName();

        public MutableLiveData<List<View>> funcBtns();

        public void quitGameMode();

        public boolean canClosePlugin();

        public MutableLiveData<String> getTips();

        public void onLoadAgain();

        public void showGameRule(GameInfo var1);

        public void setOnUiCallback(OnUiCallback var1);

        public int getTotalSeatCount();

        public void trackClose();

        public void onGameStateChanged(String var1);

        default public LiveData<Boolean> getPrepareUiData() {
            return null;
        }

        public LiveData<Boolean> isMePlayManager();

        public LiveData<Boolean> isCanClose();

        public static interface OnUiCallback {
            public void showGameRule(GameInfo var1);
        }
    }

    public static interface IPresenter
    extends IMvp.IPresenter,
    IView.OnSeatItemListener {
        public LiveData<List<SeatItem>> seats();

        public String getRoomId();

        public void setInterceptListener(OnInterceptListener var1);

        public LiveData<Integer> updateOne();

        public void updateSeatViewLocation(Map<Long, Point> var1, Map<Long, Point> var2);

        public LiveData<Boolean> getClipViewData();

        public boolean hasManagerPermission();

        public void checkManagerPermission(Callback<Boolean> var1);

        public LiveData<Map<Long, Point>> getSeatLocation(boolean var1);

        public int getSeatFaceSize(long var1);

        public void showGoldenBeansSvgaAnim(long var1);

        public boolean needUpdateSeatLocation();

        public SeatViewContainer getSeatViewContainer();

        public LiveData<Boolean> canCalculateSeatLocation();

        public void autoInviteOnSitDown(String var1);

        default public void changeSeatStyle(int style2) {
        }

        public static interface OnInterceptListener {
            public boolean isIntercepted();
        }
    }

    public static interface IView
    extends IMvp.IView<IPresenter> {
        @Nullable
        public View getItemView(int var1);

        public void updateSeats(List<SeatItem> var1);

        public void updateSeat(int var1, SeatItem var2);

        public Map<Long, Point> getSeatViewLoaction(boolean var1);

        public int getSeatFaceSize();

        public int[] getSeatViewPosition();

        public static interface OnSeatItemListener
        extends ICalculatorCallback {
            public void onAvatarClick(SeatItem var1);

            default public void onAvatarLongClick(SeatItem item, int index, View avatar2) {
            }

            public void onOpenInviteList(SeatItem var1);

            public void onLockClick(SeatItem var1);

            public void onUnLockClick(SeatItem var1);

            public void onStandUp();

            public boolean onSitDown(int var1, Callback<Integer> var2);
        }
    }
}

