/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import java.util.List;

public class SeatDiffCallback
extends DiffUtil.Callback {
    private List<SeatItem> from;
    private List<SeatItem> seatItems;

    public SeatDiffCallback(List<SeatItem> from, List<SeatItem> to) {
        this.from = from;
        this.seatItems = to;
    }

    public int getOldListSize() {
        return FP.size(this.from);
    }

    public int getNewListSize() {
        return FP.size(this.seatItems);
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        SeatItem old = this.from.get(oldItemPosition);
        SeatItem item = this.seatItems.get(newItemPosition);
        if (old.uid == 0L && item.uid == 0L) {
            return old.index == item.index;
        }
        return old.uid == item.uid;
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        SeatItem old = this.from.get(oldItemPosition);
        SeatItem item = this.seatItems.get(newItemPosition);
        if (old.uid == 0L && item.uid == 0L) {
            return old.statusFlag == item.statusFlag;
        }
        return !item.isSpeaking && SeatItem.isContentSame(old, item);
    }

    @Nullable
    public Object getChangePayload(int oldItemPosition, int newItemPosition) {
        return null;
    }
}

