/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.LanguageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.game.base.DR;
import com.yy.hiyo.mvp.base.ICustomView;

public class DownloadingView
extends YYRelativeLayout
implements ICustomView {
    private ProgressBar mProgressBar;
    private SVGAImageView mProgressBubble;
    private boolean mDestroyed;

    public DownloadingView(Context context) {
        super(context);
        this.createView(null);
    }

    public DownloadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(attrs);
    }

    public DownloadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.createView(attrs);
    }

    public void createView(@Nullable AttributeSet attrs) {
        DownloadingView.inflate((Context)this.getContext(), (int)R.layout.seat_game_downloading_channel, (ViewGroup)this);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.download_progress_bar);
        this.mProgressBubble = (SVGAImageView)this.findViewById(R.id.progress_bubble);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mDestroyed) {
            return;
        }
        if (visibility == 0) {
            DyResLoader.INSTANCE.loadSvga(this.mProgressBubble, DR.download_bubble, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    if (DownloadingView.this.mDestroyed || DownloadingView.this.getVisibility() != 0) {
                        return;
                    }
                    DownloadingView.this.mProgressBubble.startAnimation();
                }

                public void onFailed(Exception e) {
                }
            });
        } else {
            this.mProgressBubble.stopAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mProgressBubble.stopAnimation();
    }

    public void setProgress(@IntRange(from=0L, to=100L) int progress) {
        if (this.mDestroyed) {
            return;
        }
        this.mProgressBubble.startAnimation();
        if (this.mProgressBar.getProgress() != progress) {
            this.mProgressBar.setProgress(progress);
            this.mProgressBubble.setTranslationX((float)((LanguageUtils.isLtr() ? 1 : -1) * this.getWidth() * progress) / 100.0f);
        }
    }

    public void destroy() {
        this.mDestroyed = true;
        if (this.mProgressBubble != null) {
            this.mProgressBubble.stopAnimation();
        }
    }
}

