/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.hiyo.channel.R;
import java.util.List;

public class HorFunctionListView
extends YYLinearLayout {
    private int mDividerColor;
    private int mDividerWidth;
    private int mDividerHeight;

    public HorFunctionListView(Context context) {
        super(context);
        this.initView();
    }

    public HorFunctionListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HorFunctionListView);
        this.mDividerColor = ta.getColor(R.styleable.HorFunctionListView_divider_color, -16777216);
        this.mDividerWidth = ta.getDimensionPixelOffset(R.styleable.HorFunctionListView_divider_width, 0);
        this.mDividerHeight = ta.getDimensionPixelOffset(R.styleable.HorFunctionListView_divider_height, 0);
        ta.recycle();
    }

    private void initView() {
        this.setOrientation(0);
    }

    public void setData(List<ViewItem> viewList) {
        this.removeAllViews();
        if (viewList != null) {
            for (int i = 0; i < viewList.size(); ++i) {
                if (i > 0) {
                    this.addDivider();
                }
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
                lp.weight = 1.0f;
                this.addView(viewList.get(i).getView(), (ViewGroup.LayoutParams)lp);
            }
        }
    }

    public void addView(ViewItem item) {
        this.addDivider();
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.weight = 1.0f;
        this.addView(item.getView(), (ViewGroup.LayoutParams)lp);
    }

    private void addDivider() {
        YYView dividerView = new YYView(this.getContext());
        dividerView.setBackgroundColor(this.mDividerColor);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(this.mDividerWidth, this.mDividerHeight);
        lp.gravity = 16;
        this.addView((View)dividerView, (ViewGroup.LayoutParams)lp);
    }

    public static class ViewItem {
        private YYFrameLayout mContainerView;
        private View mContentView;
        private String tag;

        private ViewItem(Context context) {
            this.mContainerView = new YYFrameLayout(context);
        }

        private void setContentView(View view2, FrameLayout.LayoutParams lp) {
            this.mContentView = view2;
            lp.gravity = 17;
            this.mContainerView.addView(view2, (ViewGroup.LayoutParams)lp);
        }

        public View getView() {
            return this.mContainerView;
        }

        public View getContentView() {
            return this.mContentView;
        }

        public String getTag() {
            return this.tag;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            private ViewItem viewItem;

            private Builder(Context context) {
                this.viewItem = new ViewItem(context);
            }

            public Builder contentView(View view2, int width, int height) {
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(width, height);
                this.viewItem.setContentView(view2, lp);
                return this;
            }

            public Builder contentView(View view2, FrameLayout.LayoutParams lp) {
                this.viewItem.setContentView(view2, lp);
                return this;
            }

            public Builder tag(String tag) {
                this.viewItem.tag = tag;
                return this;
            }

            public ViewItem build() {
                return this.viewItem;
            }
        }
    }
}

